/*
 * Decompiled with CFR 0.152.
 */
package dlock;

import com.gemstone.gemfire.StatisticDescriptor;
import com.gemstone.gemfire.StatisticsType;
import com.gemstone.gemfire.internal.NanoTimer;
import perffmwk.PerformanceStatistics;

public class DLSPerfStats
extends PerformanceStatistics {
    private static final int SCOPE = 0;
    protected static final String LOCKS = "locks";
    protected static final String LOCK_TIME = "lockTime";
    protected static final String UNLOCKS = "unlocks";
    protected static final String UNLOCK_TIME = "unlockTime";

    public static StatisticDescriptor[] getStatisticDescriptors() {
        boolean largerIsBetter = true;
        return new StatisticDescriptor[]{DLSPerfStats.factory().createIntCounter(LOCKS, "Number of locks completed.", "operations", largerIsBetter), DLSPerfStats.factory().createLongCounter(LOCK_TIME, "Total time spent acquiring locks.", "nanoseconds", !largerIsBetter), DLSPerfStats.factory().createIntCounter(UNLOCKS, "Number of unlocks completed.", "operations", largerIsBetter), DLSPerfStats.factory().createLongCounter(UNLOCK_TIME, "Total time spent releasing locks.", "nanoseconds", !largerIsBetter)};
    }

    public static DLSPerfStats getInstance() {
        return (DLSPerfStats)DLSPerfStats.getInstance(DLSPerfStats.class, 0);
    }

    public static DLSPerfStats getInstance(String name) {
        return (DLSPerfStats)DLSPerfStats.getInstance(DLSPerfStats.class, 0, name);
    }

    public static DLSPerfStats getInstance(String name, String trimspecName) {
        return (DLSPerfStats)DLSPerfStats.getInstance(DLSPerfStats.class, 0, name, trimspecName);
    }

    public DLSPerfStats(Class cls, StatisticsType type, int scope, String instanceName, String trimspecName) {
        super(cls, type, scope, instanceName, trimspecName);
    }

    public int getLocks() {
        return this.statistics().getInt(LOCKS);
    }

    public long getLockTime() {
        return this.statistics().getLong(LOCK_TIME);
    }

    public int getUnlocks() {
        return this.statistics().getInt(UNLOCKS);
    }

    public long getUnlockTime() {
        return this.statistics().getLong(UNLOCK_TIME);
    }

    public void incLocks() {
        this.incLocks(1);
    }

    public void incLocks(int amount) {
        this.statistics().incInt(LOCKS, amount);
    }

    public void incLockTime(long amount) {
        this.statistics().incLong(LOCK_TIME, amount);
    }

    public long startLock() {
        return NanoTimer.getTime();
    }

    public void endLock(long start) {
        long ts = NanoTimer.getTime();
        this.statistics().incInt(LOCKS, 1);
        long elapsed = ts - start;
        this.statistics().incLong(LOCK_TIME, elapsed);
    }

    public void incUnlocks() {
        this.incUnlocks(1);
    }

    public void incUnlocks(int amount) {
        this.statistics().incInt(UNLOCKS, amount);
    }

    public void incUnlockTime(long amount) {
        this.statistics().incLong(UNLOCK_TIME, amount);
    }

    public long startUnlock() {
        return NanoTimer.getTime();
    }

    public void endUnlock(long start) {
        long ts = NanoTimer.getTime();
        this.statistics().incInt(UNLOCKS, 1);
        long elapsed = ts - start;
        this.statistics().incLong(UNLOCK_TIME, elapsed);
    }
}

