/*
 * Decompiled with CFR 0.152.
 */
package dlock;

import cacheperf.CachePerfClient;
import cacheperf.CachePerfException;
import com.gemstone.gemfire.cache.Region;
import distcache.gemfire.GemFireCacheTestImpl;
import dlock.DLSPerfPrms;
import dlock.DLSPerfStats;
import hydra.HydraThreadLocal;
import hydra.MasterController;
import java.util.HashMap;
import java.util.concurrent.locks.Lock;
import objects.ObjectHelper;

public class DLSPerfClient
extends CachePerfClient {
    protected static final int LOCKS = 100;
    protected static final int UNLOCKS = 101;
    protected static final String LOCKS_NAME = "locks";
    protected static final String UNLOCKS_NAME = "unlocks";
    public DLSPerfStats dlsstats;
    public HashMap objectlist;
    private static HydraThreadLocal localdlsstats = new HydraThreadLocal();
    private static HydraThreadLocal localobjectlist = new HydraThreadLocal();

    public static void lockTask() {
        DLSPerfClient c = new DLSPerfClient();
        c.initialize(100);
        c.lockObjects();
    }

    private void lockObjects() {
        if (DLSPerfClient.log().fineEnabled()) {
            DLSPerfClient.log().fine("locking objects");
        }
        do {
            int key = this.getNextKey();
            this.executeTaskTerminator();
            this.executeWarmupTerminator();
            this.lock(key);
            ++this.batchCount;
            ++this.count;
            ++this.keyCount;
        } while (!this.executeBatchTerminator());
        if (DLSPerfClient.log().fineEnabled()) {
            DLSPerfClient.log().fine("objects locked");
        }
    }

    private void lock(int i) {
        long start;
        Object key = ObjectHelper.createName(this.keyType, i);
        if (DLSPerfClient.log().finerEnabled()) {
            DLSPerfClient.log().finer("locking key = " + key);
        }
        Region theRegion = ((GemFireCacheTestImpl)this.cache).getRegion();
        Lock entryLock = null;
        try {
            entryLock = theRegion.getDistributedLock(key);
            start = this.dlsstats.startLock();
            entryLock.lock();
        }
        catch (Exception e) {
            throw new CachePerfException("Could not get distributed lock", e);
        }
        this.dlsstats.endLock(start);
        if (DLSPerfClient.log().finerEnabled()) {
            DLSPerfClient.log().finer("locked key = " + key);
        }
        if (DLSPerfPrms.unlockAfterLock()) {
            if (DLSPerfClient.log().finerEnabled()) {
                DLSPerfClient.log().finer("unlocking key = " + key);
            }
            entryLock.unlock();
            if (DLSPerfClient.log().finerEnabled()) {
                DLSPerfClient.log().finer("unlocked key = " + key);
            }
        }
    }

    public static void unlockTask() {
        DLSPerfClient c = new DLSPerfClient();
        c.initialize(101);
        c.unlockObjects();
    }

    private void unlockObjects() {
        if (DLSPerfClient.log().fineEnabled()) {
            DLSPerfClient.log().fine("unlocking objects");
        }
        do {
            int key = this.getNextKey();
            this.executeTaskTerminator();
            this.executeWarmupTerminator();
            this.lock(key);
            this.unlock(key);
            ++this.batchCount;
            ++this.count;
            ++this.keyCount;
        } while (!this.executeBatchTerminator());
        if (DLSPerfClient.log().fineEnabled()) {
            DLSPerfClient.log().fine("objects unlocked");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unlock(int i) {
        Object key = ObjectHelper.createName(this.keyType, i);
        if (DLSPerfClient.log().finerEnabled()) {
            DLSPerfClient.log().finer("unlocking key = " + key);
        }
        Region theRegion = ((GemFireCacheTestImpl)this.cache).getRegion();
        Lock entryLock = null;
        try {
            entryLock = theRegion.getDistributedLock(key);
        }
        finally {
            long start = this.dlsstats.startUnlock();
            entryLock.unlock();
            this.dlsstats.endUnlock(start);
        }
        if (DLSPerfClient.log().finerEnabled()) {
            DLSPerfClient.log().finer("unlocked key = " + key);
        }
    }

    public static void openStatisticsTask() {
        DLSPerfClient c = new DLSPerfClient();
        c.initHydraThreadLocals();
        c.openStatistics();
        c.updateHydraThreadLocals();
    }

    private void openStatistics() {
        if (this.dlsstats == null) {
            DLSPerfClient.log().info("Opening per-thread DLS performance statistics");
            this.dlsstats = DLSPerfStats.getInstance();
            DLSPerfClient.log().info("Opened per-thread DLS performance statistics");
        }
    }

    public static void closeStatisticsTask() {
        DLSPerfClient c = new DLSPerfClient();
        c.initHydraThreadLocals();
        c.closeStatistics();
        c.updateHydraThreadLocals();
    }

    @Override
    protected void closeStatistics() {
        MasterController.sleepForMs(2000);
        if (this.dlsstats != null) {
            DLSPerfClient.log().info("Closing per-thread DLS performance statistics");
            this.dlsstats.close();
            DLSPerfClient.log().info("Closed per-thread DLS performance statistics");
        }
    }

    @Override
    protected void initHydraThreadLocals() {
        super.initHydraThreadLocals();
        this.dlsstats = this.getDLSStats();
        this.objectlist = this.getObjectList();
    }

    @Override
    protected void updateHydraThreadLocals() {
        super.updateHydraThreadLocals();
        this.setDLSStats(this.dlsstats);
        this.setObjectList(this.objectlist);
    }

    protected HashMap getObjectList() {
        HashMap objectList = (HashMap)localobjectlist.get();
        return objectList;
    }

    protected void setObjectList(HashMap objectlist) {
        localobjectlist.set(objectlist);
    }

    protected DLSPerfStats getDLSStats() {
        DLSPerfStats dlsstats = (DLSPerfStats)localdlsstats.get();
        return dlsstats;
    }

    protected void setDLSStats(DLSPerfStats dlsstats) {
        localdlsstats.set(dlsstats);
    }

    @Override
    protected String nameFor(int name) {
        switch (name) {
            case 100: {
                return LOCKS_NAME;
            }
            case 101: {
                return UNLOCKS_NAME;
            }
        }
        return super.nameFor(name);
    }
}

