/*
 * Decompiled with CFR 0.152.
 */
package diskRecovery;

import com.gemstone.gemfire.admin.AdminDistributedSystem;
import com.gemstone.gemfire.admin.AdminException;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.cache.InterestResultPolicy;
import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.PartitionedRegionStorageException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.cache.persistence.PersistentReplicatesOfflineException;
import com.gemstone.gemfire.cache.query.FunctionDomainException;
import com.gemstone.gemfire.cache.query.NameResolutionException;
import com.gemstone.gemfire.cache.query.Query;
import com.gemstone.gemfire.cache.query.QueryInvocationTargetException;
import com.gemstone.gemfire.cache.query.QueryService;
import com.gemstone.gemfire.cache.query.SelectResults;
import com.gemstone.gemfire.cache.query.TypeMismatchException;
import com.gemstone.gemfire.distributed.DistributedSystemDisconnectedException;
import com.gemstone.gemfire.distributed.GatewayCancelledException;
import com.gemstone.gemfire.internal.cache.PartitionedRegionException;
import com.gemstone.gemfire.internal.cache.xmlcache.CacheXmlGenerator;
import com.newedge.account.domain.BackOfficeAccount;
import com.newedge.account.domain.BackOfficeAccountCollection;
import com.newedge.staticdata.domain.Product;
import diskRecovery.RecoveryBB;
import diskRecovery.RecoveryPrms;
import diskRecovery.RecoveryTest;
import hydra.BridgeHelper;
import hydra.BridgePrms;
import hydra.CacheHelper;
import hydra.ClientVmInfo;
import hydra.DistributedSystemHelper;
import hydra.GatewayHubHelper;
import hydra.GsRandom;
import hydra.HydraSubthread;
import hydra.HydraThreadGroup;
import hydra.HydraThreadLocal;
import hydra.Log;
import hydra.MasterController;
import hydra.PartitionDescription;
import hydra.RegionDescription;
import hydra.RegionHelper;
import hydra.RemoteTestModule;
import hydra.StopSchedulingTaskOnClientOrder;
import hydra.TestConfig;
import hydra.blackboard.SharedCounters;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import parReg.ParRegUtil;
import util.AdminHelper;
import util.BaseValueHolder;
import util.NameFactory;
import util.RandomValues;
import util.SilenceListener;
import util.StopStartVMs;
import util.SummaryLogListener;
import util.TestException;
import util.TestHelper;
import util.ValueHolder;
import wan.query.WANQueryPrms;

public class StartupShutdownTest {
    public static StartupShutdownTest testInstance = null;
    private boolean isBridgeConfiguration;
    private boolean isBridgeClient;
    static int maxPRs = -1;
    static int maxReplicates = -1;
    private static HydraThreadLocal currentNumKeys = new HydraThreadLocal();
    private static final String allRegionsSnapshotKey = "allRegions";

    public static synchronized void HydraTask_initializeClient() {
        if (testInstance == null) {
            testInstance = new StartupShutdownTest();
            testInstance.initializeInstance();
            CacheHelper.createCache("cache1");
            StartupShutdownTest.createRegions("clientRegion", "clientRegion", false);
            if (StartupShutdownTest.testInstance.isBridgeConfiguration) {
                StartupShutdownTest.testInstance.isBridgeClient = true;
                boolean registerInterest = RecoveryPrms.getRegisterInterest();
                if (registerInterest) {
                    StartupShutdownTest.registerInterest();
                }
            }
        }
        currentNumKeys.set(new Integer(0));
        Log.getLogWriter().info("currentNumKeys is " + currentNumKeys);
    }

    private static void createRegions(String PRconfigName, String replicateConfigName, boolean colocated) {
        int i;
        for (i = 1; i <= maxPRs; ++i) {
            if (colocated) {
                if (i != 1 && i % 2 == 1) {
                    AttributesFactory aFactory = RegionHelper.getAttributesFactory(PRconfigName);
                    RegionDescription rd = RegionHelper.getRegionDescription(PRconfigName);
                    PartitionDescription pd = rd.getPartitionDescription();
                    PartitionAttributesFactory prFactory = pd.getPartitionAttributesFactory();
                    prFactory.setColocatedWith("PR_1");
                    PartitionAttributes prAttrs = prFactory.create();
                    aFactory.setPartitionAttributes(prAttrs);
                    RegionHelper.createRegion("PR_" + i, aFactory);
                    continue;
                }
                RegionHelper.createRegion("PR_" + i, PRconfigName);
                continue;
            }
            RegionHelper.createRegion("PR_" + i, PRconfigName);
        }
        for (i = 1; i <= maxReplicates; ++i) {
            RegionHelper.createRegion("replicate_" + i, replicateConfigName);
        }
        Log.getLogWriter().info("After creating regions, root regions is " + CacheHelper.getCache().rootRegions());
    }

    public static synchronized void HydraTask_initialize() {
        if (testInstance == null) {
            testInstance = new StartupShutdownTest();
            testInstance.initializeInstance();
            CacheHelper.createCache("cache1");
            StartupShutdownTest.createRegions("persistPR", "persistReplicate", RecoveryPrms.getUseColocatedPRs());
            int myVmId = RemoteTestModule.getMyVmid();
            RecoveryBB.getBB().getSharedMap().put("dataStoreJvm_" + myVmId, new ClientVmInfo(myVmId));
            if (StartupShutdownTest.testInstance.isBridgeConfiguration) {
                StartupShutdownTest.testInstance.isBridgeClient = false;
                BridgeHelper.startBridgeServer("bridge");
            }
        }
        currentNumKeys.set(new Integer(0));
        Log.getLogWriter().info("currentNumKeys is " + currentNumKeys);
    }

    public static synchronized void HydraTask_initializeDuringShutDownAll() {
        try {
            StartupShutdownTest.HydraTask_initialize();
        }
        catch (CacheClosedException e) {
            Log.getLogWriter().info("Caught " + (Object)((Object)e));
        }
        catch (IllegalStateException e) {
            String errStr = e.toString();
            if (errStr.indexOf("Region specified in 'colocated-with' is not present. It should be created before setting 'colocated-with' to this region.") >= 0) {
                Log.getLogWriter().info("Caught " + e);
            }
            throw e;
        }
        catch (NullPointerException e) {
            if (e.getCause() != null) {
                throw e;
            }
            String errStr = TestHelper.getStackTrace(e);
            int index1 = errStr.lastIndexOf(NullPointerException.class.getName());
            if (index1 < 0) {
                throw e;
            }
            int index2 = errStr.indexOf("\n", index1);
            if (index2 < 0) {
                throw e;
            }
            int index3 = errStr.indexOf("\n", index2 + 1);
            if (index3 < 0) {
                throw e;
            }
            String firstLine = errStr.substring(index2, index3);
            if (firstLine.indexOf("hydra.DiskStoreHelper.createDiskStore") >= 0 || firstLine.indexOf("hydra.DiskStoreHelper.getDiskStoreFactory") >= 0) {
                Log.getLogWriter().info("Caught " + errStr + " while initializing during shutDownAll");
            }
            throw e;
        }
        catch (DistributedSystemDisconnectedException e) {
            Log.getLogWriter().info("Caught " + (Object)((Object)e));
        }
    }

    public static void HydraTask_createGatewayHub() {
        String hubConfigName = "gatewayHub";
        Log.getLogWriter().info("Creating gateway hub with hub config: " + hubConfigName);
        GatewayHubHelper.createGatewayHub(hubConfigName);
    }

    public static void HydraTask_addGatewayHub() {
        String gatewayConfigName = "gateway";
        Log.getLogWriter().info("Adding gateway with gateway config: " + gatewayConfigName);
        GatewayHubHelper.addGateways(gatewayConfigName);
    }

    public static void HydraTask_startGatewayHub() {
        Log.getLogWriter().info("Starting gateway hub");
        GatewayHubHelper.startGatewayHub();
    }

    public static void HydraTask_serversAreBack() {
        long counter = RecoveryBB.getBB().getSharedCounters().incrementAndRead(RecoveryBB.serversAreBack);
        Log.getLogWriter().info("serversAreBack counter is " + counter);
    }

    public static synchronized void HydraTask_initializeProxy() {
        if (testInstance == null) {
            testInstance = new StartupShutdownTest();
            testInstance.initializeInstance();
            CacheHelper.createCache("cache1");
            StartupShutdownTest.createRegions("proxyPR", "proxyReplicate", RecoveryPrms.getUseColocatedPRs());
            int myVmId = RemoteTestModule.getMyVmid();
            RecoveryBB.getBB().getSharedMap().put("proxyJvm_" + myVmId, new ClientVmInfo(myVmId));
            if (StartupShutdownTest.testInstance.isBridgeConfiguration) {
                StartupShutdownTest.testInstance.isBridgeClient = false;
                BridgeHelper.startBridgeServer("bridge");
            }
        }
        currentNumKeys.set(new Integer(0));
        Log.getLogWriter().info("currentNumKeys is " + currentNumKeys);
    }

    public static void HydraTask_verifyFromLeaderSnapshot() {
        TestHelper.waitForCounter(RecoveryBB.getBB(), "snapshotWritten", RecoveryBB.snapshotWritten, 1L, true, -1L, 3000L);
        testInstance.verifyFromSnapshot();
    }

    public static synchronized void HydraTask_initializeProxyDuringShutDownAll() {
        try {
            StartupShutdownTest.HydraTask_initializeProxy();
        }
        catch (CacheClosedException e) {
            Log.getLogWriter().info("Caught " + (Object)((Object)e));
        }
        catch (IllegalStateException e) {
            String errStr = e.toString();
            if (errStr.indexOf("Region specified in 'colocated-with' is not present. It should be created before setting 'colocated-with' to this region.") >= 0) {
                Log.getLogWriter().info("Caught " + e);
            }
            throw e;
        }
        catch (DistributedSystemDisconnectedException e) {
            Log.getLogWriter().info("Caught " + (Object)((Object)e));
        }
        catch (PartitionedRegionException e) {
            Throwable causedBy = e.getCause();
            if (causedBy instanceof CacheClosedException) {
                Log.getLogWriter().info("Caught " + (Object)((Object)e) + " caused by " + causedBy);
            }
            throw e;
        }
    }

    private void initializeInstance() {
        this.isBridgeConfiguration = TestConfig.tab().vecAt(BridgePrms.names, null) != null;
        maxPRs = RecoveryPrms.getMaxPRs();
        maxReplicates = RecoveryPrms.getMaxReplicates();
    }

    public static void createLocatorTask() {
        DistributedSystemHelper.createLocator();
    }

    public static void startAndConnectLocatorTask() {
        DistributedSystemHelper.startLocatorAndAdminDS();
    }

    protected static void registerInterest() {
        Set rootRegions = CacheHelper.getCache().rootRegions();
        for (Region aRegion : rootRegions) {
            Log.getLogWriter().info("Calling registerInterest for all keys, result interest policy KEYS_VALUES for region " + aRegion.getFullPath());
            aRegion.registerInterest((Object)"ALL_KEYS", InterestResultPolicy.KEYS_VALUES);
            Log.getLogWriter().info("Done calling registerInterest for all keys, result interest policy KEYS_VALUES, " + aRegion.getFullPath() + " size is " + aRegion.size());
        }
    }

    public static void HydraTask_load() {
        int numToLoad = RecoveryPrms.getNumToLoad();
        int CHUNK_SIZE = 50;
        RandomValues rv = new RandomValues();
        HashSet regionSet = new HashSet(CacheHelper.getCache().rootRegions());
        HashSet rootRegions = new HashSet(regionSet);
        for (Region aRegion : rootRegions) {
            regionSet.addAll(aRegion.subregions(true));
        }
        int currentNumber = (Integer)currentNumKeys.get();
        HashMap<String, ValueHolder> putAllMap = new HashMap<String, ValueHolder>();
        int putAllMapSize = Math.min(CHUNK_SIZE, numToLoad - currentNumber);
        for (int i = 1; i <= putAllMapSize; ++i) {
            String key = NameFactory.getNextPositiveObjectName();
            ValueHolder value = new ValueHolder(key, rv);
            putAllMap.put(key, value);
        }
        currentNumKeys.set(new Integer(currentNumber += putAllMapSize));
        Log.getLogWriter().info("Created putAll map of size " + putAllMap.size() + ", loading " + currentNumber + " entries out of " + numToLoad + " for this load thread");
        for (Region aRegion : regionSet) {
            Log.getLogWriter().info("Calling putAll with map of size " + putAllMap.size() + " with region " + aRegion.getFullPath());
            aRegion.putAll(putAllMap);
        }
        if (currentNumber >= numToLoad) {
            throw new StopSchedulingTaskOnClientOrder("All " + numToLoad + " entries created in all regions by this load thread");
        }
    }

    public static void HydraTask_loadXmlRegions() {
        Serializable value;
        int numToLoad = RecoveryPrms.getNumToLoad();
        int CHUNK_SIZE = 50;
        RandomValues rv = new RandomValues();
        Set regionSet = CacheHelper.getCache().rootRegions();
        int currentNumber = (Integer)currentNumKeys.get();
        HashMap<String, Serializable> putAllMap = new HashMap<String, Serializable>();
        int putAllMapSize = Math.min(CHUNK_SIZE, numToLoad - currentNumber);
        for (int i = 1; i <= putAllMapSize; ++i) {
            String key = NameFactory.getNextPositiveObjectName();
            ValueHolder value2 = new ValueHolder(key, rv);
            putAllMap.put(key, value2);
        }
        currentNumKeys.set(new Integer(currentNumber += putAllMapSize));
        Log.getLogWriter().info("Created putAll map of size " + putAllMap.size() + ", loading " + currentNumber + " entries out of " + numToLoad + " for this load thread");
        for (Region aRegion : regionSet) {
            String regName = aRegion.getName();
            if (regName.equals("product") || regName.equals("backOfficeAccount") || regName.equals("backOfficeAccountCollection")) continue;
            Log.getLogWriter().info("Calling putAll with map of size " + putAllMap.size() + " with region " + aRegion.getFullPath());
            aRegion.putAll(putAllMap);
        }
        Region aRegion = CacheHelper.getCache().getRegion("product");
        for (Object key : putAllMap.keySet()) {
            value = new Product();
            value.productCode = (String)key;
            value.instrumentId = (String)key;
            putAllMap.put((String)key, value);
        }
        aRegion.putAll(putAllMap);
        aRegion = CacheHelper.getCache().getRegion("backOfficeAccount");
        for (Object key : putAllMap.keySet()) {
            value = new BackOfficeAccount();
            ((BackOfficeAccount)value).account = (String)key;
            putAllMap.put((String)key, value);
        }
        aRegion.putAll(putAllMap);
        aRegion = CacheHelper.getCache().getRegion("backOfficeAccountCollection");
        for (Object key : putAllMap.keySet()) {
            value = new BackOfficeAccountCollection();
            putAllMap.put((String)key, value);
        }
        aRegion.putAll(putAllMap);
        Log.getLogWriter().info("Printing current region hierarchy with sizes");
        Log.getLogWriter().info(RecoveryTest.regionHierarchyToString());
        if (currentNumber >= numToLoad) {
            Log.getLogWriter().info("All regions loaded ");
            Log.getLogWriter().info(RecoveryTest.regionHierarchyToString());
            throw new StopSchedulingTaskOnClientOrder("All " + numToLoad + " entries created in all regions by this load thread");
        }
    }

    public static void HydraTask_doContinuousUpdates() {
        int PUT_ALL_SIZE = 50;
        RandomValues rv = new RandomValues();
        GsRandom rand = TestConfig.tab().getRandGen();
        Cache theCache = CacheHelper.getCache();
        if (theCache == null) {
            return;
        }
        try {
            Set regionSet = theCache.rootRegions();
            long maxKey = NameFactory.getPositiveNameCounter();
            HashMap<String, ValueHolder> putAllMap = new HashMap<String, ValueHolder>();
            for (int i = 1; i <= PUT_ALL_SIZE; ++i) {
                long randInt = rand.nextLong(1L, maxKey);
                String key = NameFactory.getObjectNameForCounter(randInt);
                ValueHolder value = new ValueHolder(key, rv);
                putAllMap.put(key, value);
            }
            Log.getLogWriter().info("Created putAll map of size " + putAllMap.size() + ", updating all regions with putAll...);");
            for (Region aRegion : regionSet) {
                Log.getLogWriter().info("Calling putAll with map of size " + putAllMap.size() + " with region " + aRegion.getFullPath());
                aRegion.putAll(putAllMap);
            }
        }
        catch (CacheClosedException e) {
            Log.getLogWriter().info("HydraTask_doContinuousUpdates caught " + (Object)((Object)e));
        }
        catch (RegionDestroyedException e) {
            Log.getLogWriter().info("HydraTask_doContinuousUpdates caught " + (Object)((Object)e));
        }
        catch (DistributedSystemDisconnectedException e) {
            Log.getLogWriter().info("HydraTask_doContinuousUpdates caught " + (Object)((Object)e));
        }
        catch (PartitionedRegionStorageException e) {
            String errStr = e.getMessage().toString();
            if (errStr.indexOf("Unable to find any members to host a bucket") >= 0) {
                Log.getLogWriter().info("HydraTask_doContinuousUpdates caught " + (Object)((Object)e));
            }
            throw e;
        }
        catch (PersistentReplicatesOfflineException e) {
            Log.getLogWriter().info("HydraTask_doContinuousUpdates caught " + (Object)((Object)e));
        }
    }

    public static void HydraTask_doWanUpdates() {
        long threadBaseIndex;
        long maxKey = NameFactory.getPositiveNameCounter();
        int firstLimit = (int)(maxKey / 3L);
        int secondLimit = firstLimit * 2;
        String tgname = RemoteTestModule.getCurrentThread().getThreadGroupName();
        HydraThreadGroup tg = TestConfig.getInstance().getThreadGroup(tgname);
        int numThreads = tg.getTotalThreads() * 2;
        Log.getLogWriter().info("maxKey is " + maxKey + ", firstLimit is " + firstLimit + ", secondLimit is " + secondLimit);
        SharedCounters sc = RecoveryBB.getBB().getSharedCounters();
        long keyIndex = threadBaseIndex = sc.incrementAndRead(RecoveryBB.currValue);
        RandomValues rv = new RandomValues();
        Set regionSet = CacheHelper.getCache().rootRegions();
        Log.getLogWriter().info("Doing updates before/during shutDownAll with threadBaseIndex " + threadBaseIndex + " and key increment " + numThreads);
        while (sc.read(RecoveryBB.shutDownAllCompleted) == 0L) {
            String key = NameFactory.getObjectNameForCounter(keyIndex);
            for (Region aRegion : regionSet) {
                BaseValueHolder currValue = (BaseValueHolder)aRegion.get((Object)key);
                ValueHolder updatedValue = new ValueHolder(key, rv);
                updatedValue.myValue = (Long)currValue.myValue + 1L;
                Log.getLogWriter().info("Putting " + key + ", " + TestHelper.toString(updatedValue) + " in region " + aRegion.getFullPath());
                aRegion.put((Object)key, (Object)updatedValue);
            }
            if ((keyIndex += (long)numThreads) <= (long)firstLimit) continue;
            keyIndex = threadBaseIndex;
        }
        while (keyIndex < (long)firstLimit) {
            keyIndex += (long)numThreads;
        }
        threadBaseIndex = keyIndex;
        Log.getLogWriter().info("Doing updates during recovery with threadBaseIndex " + threadBaseIndex + " and key increment " + numThreads);
        int numThreadsPerSite = tg.getTotalThreads();
        while (sc.read(RecoveryBB.serversAreBack) != (long)numThreadsPerSite) {
            String key = NameFactory.getObjectNameForCounter(keyIndex);
            for (Region aRegion : regionSet) {
                BaseValueHolder currValue = (BaseValueHolder)aRegion.get((Object)key);
                ValueHolder updatedValue = new ValueHolder(key, rv);
                updatedValue.myValue = (Long)currValue.myValue + 1L;
                Log.getLogWriter().info("Putting " + key + ", " + TestHelper.toString(updatedValue) + " in region " + aRegion.getFullPath());
                aRegion.put((Object)key, (Object)updatedValue);
            }
            if ((keyIndex += (long)numThreads) <= (long)secondLimit) continue;
            keyIndex = threadBaseIndex;
        }
        Log.getLogWriter().info("Signaling pause...");
        sc.incrementAndRead(RecoveryBB.pausing);
        TestHelper.waitForCounter(RecoveryBB.getBB(), "pausing", RecoveryBB.pausing, numThreadsPerSite, true, -1L, 3000L);
        SilenceListener.waitForSilence(30L, 2000L);
        long leader = sc.incrementAndRead(RecoveryBB.leader);
        if (leader == 1L) {
            Log.getLogWriter().info("This thread is the leader, writing snapshot...");
            StartupShutdownTest.writeSnapshot();
            sc.incrementAndRead(RecoveryBB.snapshotWritten);
        } else {
            TestHelper.waitForCounter(RecoveryBB.getBB(), "snapshotWritten", RecoveryBB.snapshotWritten, 1L, true, -1L, 3000L);
            testInstance.verifyFromSnapshot();
        }
        throw new StopSchedulingTaskOnClientOrder();
    }

    public static void HydraTask_doWanUpdatesDuringShutDownAll() {
        long threadBaseIndex;
        SharedCounters sc = RecoveryBB.getBB().getSharedCounters();
        if (sc.read(RecoveryBB.shutDownAllCompleted) >= 1L) {
            throw new StopSchedulingTaskOnClientOrder();
        }
        long maxKey = NameFactory.getPositiveNameCounter();
        int lowerLimit = (int)(maxKey / 3L * 2L) + 1;
        String tgname = RemoteTestModule.getCurrentThread().getThreadGroupName();
        HydraThreadGroup tg = TestConfig.getInstance().getThreadGroup(tgname);
        int numThreads = tg.getTotalThreads() * 2;
        Log.getLogWriter().info("maxKey is " + maxKey + ", lowerLimit is " + lowerLimit);
        long keyIndex = threadBaseIndex = sc.incrementAndRead(RecoveryBB.currValue);
        RandomValues rv = new RandomValues();
        Set regionSet = CacheHelper.getCache().rootRegions();
        Log.getLogWriter().info("Doing ops until this jvm is stopped with shutDownAll, threadBaseIndex is  " + threadBaseIndex + " and key increment " + numThreads);
        try {
            while (true) {
                String key = NameFactory.getObjectNameForCounter(keyIndex);
                for (Region aRegion : regionSet) {
                    BaseValueHolder currValue = (BaseValueHolder)aRegion.get((Object)key);
                    ValueHolder updatedValue = new ValueHolder(key, rv);
                    updatedValue.myValue = (Long)currValue.myValue + 1L;
                    Log.getLogWriter().info("Putting " + key + ", " + TestHelper.toString(updatedValue) + " in region " + aRegion.getFullPath());
                    aRegion.put((Object)key, (Object)updatedValue);
                }
                if ((keyIndex += (long)numThreads) <= maxKey) continue;
                keyIndex = threadBaseIndex;
            }
        }
        catch (CacheClosedException e) {
            Log.getLogWriter().info("Caught expected " + (Object)((Object)e));
            MasterController.sleepForMs(3600000);
        }
        catch (RegionDestroyedException e) {
            Log.getLogWriter().info("Caught expected " + (Object)((Object)e));
            MasterController.sleepForMs(3600000);
        }
        catch (GatewayCancelledException e) {
            Log.getLogWriter().info("Caught expected " + (Object)((Object)e));
            MasterController.sleepForMs(3600000);
        }
    }

    public static void HydraTask_doQueries() {
        String[] queries;
        long maxKeyIndex = NameFactory.getPositiveNameCounter();
        long midPointKeyIndex = maxKeyIndex / 2L;
        String maxKey = NameFactory.getObjectNameForCounter(maxKeyIndex);
        String midPointKey = NameFactory.getObjectNameForCounter(midPointKeyIndex);
        QueryService qs = CacheHelper.getCache().getQueryService();
        for (String qStr : queries = new String[]{"select * from /product", "select * from /product where productCode <= '" + midPointKey + "'", "select * from /product where productCode > '" + midPointKey + "'", "select * from /product where productCode = '" + midPointKey + "'", "select * from /product where productCode <> '" + midPointKey + "'", "select * from /product where productCode < '" + maxKey + "'", "select * from /product where productCode >= '" + maxKey + "'", "select * from /product where productCode = '" + maxKey + "'", "select * from /product where productCode <> '" + maxKey + "'", "select * from /product where productCode < 'Object_1'", "select * from /product where productCode >= 'Object_1'", "select * from /product where productCode = 'Object_1'", "select * from /product where productCode <> 'Object_1'", "select * from /backOfficeAccount", "select * from /backOfficeAccount where account <= '" + midPointKey + "'", "select * from /backOfficeAccount where account > '" + midPointKey + "'", "select * from /backOfficeAccount where account = '" + midPointKey + "'", "select * from /backOfficeAccount where account <> '" + midPointKey + "'", "select * from /backOfficeAccount where account < '" + maxKey + "'", "select * from /backOfficeAccount where account >= '" + maxKey + "'", "select * from /backOfficeAccount where account = '" + maxKey + "'", "select * from /backOfficeAccount where account <> '" + maxKey + "'", "select * from /backOfficeAccount where account < 'Object_1'", "select * from /backOfficeAccount where account >= 'Object_1'", "select * from /backOfficeAccount where account = 'Object_1'", "select * from /backOfficeAccount where account <> 'Object_1'"}) {
            Log.getLogWriter().info("Executing query: " + qStr);
            Query aQuery = qs.newQuery(qStr);
            try {
                SelectResults results = (SelectResults)aQuery.execute();
                Log.getLogWriter().info("Result size is " + results.size());
            }
            catch (FunctionDomainException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            catch (TypeMismatchException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            catch (NameResolutionException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            catch (QueryInvocationTargetException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
        }
    }

    public static void HydraTask_doQueriesDuringShutdown() {
        StartupShutdownTest.HydraTask_doQueries();
    }

    private static void writeSnapshot() {
        Set regionSet = CacheHelper.getCache().rootRegions();
        Log.getLogWriter().info("Preparing to write snapshot for " + regionSet.size() + " regions");
        HashMap allRegionsSnapshot = new HashMap();
        for (Region aRegion : regionSet) {
            HashMap regionSnapshot = new HashMap();
            if (aRegion.getAttributes().getDataPolicy().withPersistence()) {
                for (Object key : aRegion.keySet()) {
                    Object value = null;
                    if (aRegion.containsValueForKey(key)) {
                        value = aRegion.get(key);
                    }
                    if (value instanceof BaseValueHolder) {
                        regionSnapshot.put(key, ((BaseValueHolder)value).myValue);
                        continue;
                    }
                    regionSnapshot.put(key, value);
                }
            } else {
                Log.getLogWriter().info(aRegion.getFullPath() + " is size " + aRegion.size() + " but it is not persistent, so snapshot size is " + regionSnapshot.size() + " (the region will be empty after stop/restart)");
            }
            allRegionsSnapshot.put(aRegion.getFullPath(), regionSnapshot);
            Log.getLogWriter().info("Region snapshot for " + aRegion.getFullPath() + " is size " + regionSnapshot.size() + " and contains keys " + regionSnapshot.keySet());
        }
        RecoveryBB.getBB().getSharedMap().put(allRegionsSnapshotKey, allRegionsSnapshot);
        Log.getLogWriter().info("Put snapshot for " + regionSet.size() + " regions into blackboard at key " + allRegionsSnapshotKey);
    }

    private void verifyFromSnapshot() {
        Map allRegionsSnapshot = (Map)RecoveryBB.getBB().getSharedMap().get(allRegionsSnapshotKey);
        Set snapshotRegionNames = allRegionsSnapshot.keySet();
        HashSet<String> definedRegionNames = new HashSet<String>();
        Set regionSet = CacheHelper.getCache().rootRegions();
        for (Region aRegion : regionSet) {
            definedRegionNames.add(aRegion.getFullPath());
            Set subRegSet = aRegion.subregions(true);
            for (Region subReg : subRegSet) {
                definedRegionNames.add(subReg.getFullPath());
            }
        }
        HashSet missingRegionsInCache = new HashSet(snapshotRegionNames);
        missingRegionsInCache.removeAll(definedRegionNames);
        HashSet extraRegionsInCache = new HashSet(definedRegionNames);
        extraRegionsInCache.removeAll(snapshotRegionNames);
        if (missingRegionsInCache.size() != 0) {
            throw new TestException("Expected to find regions " + missingRegionsInCache + " defined in cache");
        }
        if (extraRegionsInCache.size() != 0) {
            throw new TestException("Found unexpected regions defined in cache: " + extraRegionsInCache);
        }
        Cache theCache = CacheHelper.getCache();
        for (String regionName : allRegionsSnapshot.keySet()) {
            Map regionSnapshot = (Map)allRegionsSnapshot.get(regionName);
            Region aRegion = theCache.getRegion(regionName);
            if (aRegion == null) {
                throw new TestException("Region " + regionName + " could not be found in cache");
            }
            this.verifyFromSnapshot(aRegion, regionSnapshot);
        }
    }

    public void verifyFromSnapshot(Region aRegion, Map regionSnapshot) {
        StringBuffer errStr = new StringBuffer();
        int snapshotSize = regionSnapshot.size();
        int regionSize = aRegion.size();
        long startVerifyTime = System.currentTimeMillis();
        Log.getLogWriter().info("Verifying " + aRegion.getFullPath() + "  of size " + aRegion.size() + " against snapshot containing " + regionSnapshot.size() + " entries...");
        if (snapshotSize != regionSize) {
            errStr.append("Expected region " + aRegion.getFullPath() + " to be size " + snapshotSize + ", but it is " + regionSize + "\n");
        }
        for (Object key : regionSnapshot.keySet()) {
            try {
                ParRegUtil.verifyContainsKey(aRegion, key, true);
            }
            catch (TestException e) {
                errStr.append(e.getMessage() + "\n");
            }
            boolean containsValueForKey = aRegion.containsValueForKey(key);
            Object expectedValue = regionSnapshot.get(key);
            try {
                ParRegUtil.verifyContainsValueForKey(aRegion, key, expectedValue != null);
            }
            catch (TestException e) {
                errStr.append(e.getMessage() + "\n");
            }
            if (!containsValueForKey) continue;
            try {
                Object actualValue = aRegion.get(key);
                if (actualValue instanceof BaseValueHolder) {
                    ParRegUtil.verifyMyValue(key, expectedValue, actualValue, ParRegUtil.EQUAL);
                    continue;
                }
                if (actualValue instanceof byte[] && expectedValue instanceof byte[]) {
                    byte[] actual = (byte[])actualValue;
                    byte[] expected = (byte[])expectedValue;
                    if (actual.length == expected.length) continue;
                    throw new TestException("Expected value for key " + key + " to be " + TestHelper.toString(expectedValue) + ", but it is " + TestHelper.toString(actualValue) + " in " + aRegion.getFullPath());
                }
                throw new TestException("Expected value for key " + key + " to be " + TestHelper.toString(expectedValue) + ", but it is " + TestHelper.toString(actualValue) + " in " + aRegion.getFullPath());
            }
            catch (TestException e) {
                errStr.append(e.getMessage() + "\n");
            }
        }
        HashSet aRegionKeySet = new HashSet(aRegion.keySet());
        Set snapshotKeySet = regionSnapshot.keySet();
        aRegionKeySet.removeAll(snapshotKeySet);
        if (aRegionKeySet.size() != 0) {
            errStr.append("Found the following unexpected keys in " + aRegion.getFullPath() + ": " + aRegionKeySet + "\n");
        }
        if (errStr.length() > 0) {
            throw new TestException(errStr.toString());
        }
        Log.getLogWriter().info("Done verifying " + aRegion.getFullPath() + " from snapshot containing " + snapshotSize + " entries, verification took " + (System.currentTimeMillis() - startVerifyTime) + "ms");
    }

    public static void HydraTask_shutDownAll() {
        StartupShutdownTest.logExecutionNumber();
        AdminDistributedSystem adminDS = AdminHelper.getAdminDistributedSystem();
        if (adminDS == null) {
            throw new TestException("Test is configured to use shutDownAllMembers, but this vm must be an admin vm to use it");
        }
        List vmList = StopStartVMs.getAllVMs();
        List locators = StopStartVMs.getMatchVMs(vmList, "locator");
        ArrayList vmListExcludeLocators = new ArrayList();
        vmListExcludeLocators.addAll(vmList);
        vmListExcludeLocators.removeAll(locators);
        List dataStoreList = StopStartVMs.getMatchVMs(vmList, "dataStore");
        List accessorList = StopStartVMs.getMatchVMs(vmList, "accessor");
        ArrayList<String> stopModes = new ArrayList<String>();
        stopModes.add("mean_kill");
        Object[] tmp = StopStartVMs.shutDownAllMembers(adminDS, stopModes);
        List shutDownAllVMs = (List)tmp[0];
        Set shutDownAllResults = (Set)tmp[1];
        if (shutDownAllResults.size() != vmListExcludeLocators.size()) {
            throw new TestException("Expected shutDownAllMembers to return " + vmListExcludeLocators.size() + " members in its result, but it returned " + shutDownAllResults.size() + ": " + shutDownAllResults);
        }
        StopStartVMs.startVMs(accessorList);
        MasterController.sleepForMs(10000);
        StopStartVMs.startVMs(dataStoreList);
    }

    public static void HydraTask_wanShutDownAll() {
        StartupShutdownTest.logExecutionNumber();
        int msToSleep = 30000;
        Log.getLogWriter().info("Sleeping for " + msToSleep + " ms to allow ops to run before shutDownAll");
        MasterController.sleepForMs(msToSleep);
        AdminDistributedSystem adminDS = AdminHelper.getAdminDistributedSystem();
        if (adminDS == null) {
            throw new TestException("Test is configured to use shutDownAllMembers, but this vm must be an admin vm to use it");
        }
        List vmList = StopStartVMs.getAllVMs();
        ArrayList<String> stopModes = new ArrayList<String>();
        stopModes.add("mean_kill");
        Object[] tmp = StopStartVMs.shutDownAllMembers(adminDS, stopModes);
        List shutDownAllVMs = (List)tmp[0];
        Set shutDownAllResults = (Set)tmp[1];
        if (shutDownAllResults.size() != vmList.size()) {
            throw new TestException("Expected shutDownAllMembers to return " + vmList.size() + " members in its result, but it returned " + shutDownAllResults.size() + ": " + shutDownAllResults);
        }
        msToSleep = 30000;
        Log.getLogWriter().info("Sleeping for " + msToSleep + " ms to let wan queue grow after shutDownAll");
        MasterController.sleepForMs(msToSleep);
        RecoveryBB.getBB().getSharedCounters().increment(RecoveryBB.shutDownAllCompleted);
        StopStartVMs.startVMs(shutDownAllVMs);
        throw new StopSchedulingTaskOnClientOrder();
    }

    public static void HydraTask_shutDownAllDuringRecovery() {
        StartupShutdownTest.logExecutionNumber();
        AdminDistributedSystem adminDS = AdminHelper.getAdminDistributedSystem();
        if (adminDS == null) {
            throw new TestException("Test is configured to use shutDownAllMembers, but this vm must be an admin vm to use it");
        }
        List vmList = StopStartVMs.getAllVMs();
        List locators = StopStartVMs.getMatchVMs(vmList, "locator");
        ArrayList vmListExcludeLocators = new ArrayList();
        vmListExcludeLocators.addAll(vmList);
        vmListExcludeLocators.removeAll(locators);
        Log.getLogWriter().info("vmList is " + vmListExcludeLocators);
        ArrayList<String> stopModes = new ArrayList<String>();
        for (int i = 0; i < vmListExcludeLocators.size(); ++i) {
            stopModes.add("mean_kill");
        }
        Object[] tmp = StopStartVMs.shutDownAllMembers(adminDS, stopModes);
        List shutDownAllVMs = (List)tmp[0];
        Set shutDownAllResults = (Set)tmp[1];
        if (shutDownAllResults.size() != vmListExcludeLocators.size()) {
            throw new TestException("Expected shutDownAllMembers to return " + vmListExcludeLocators.size() + " members in its result, but it returned " + shutDownAllResults.size() + ": " + shutDownAllResults);
        }
        List threads = StopStartVMs.startAsync(shutDownAllVMs);
        int msToSleep = TestConfig.tab().getRandGen().nextInt(10, 60) * 1000;
        Log.getLogWriter().info("Sleeping for " + msToSleep + " ms before running shutDownAll again");
        MasterController.sleepForMs(msToSleep);
        Log.getLogWriter().info("AdminDS " + adminDS + " is shutting down all members again...");
        HashSet memberSet = new HashSet();
        while (memberSet.size() < vmListExcludeLocators.size()) {
            MasterController.sleepForMs(1000);
            try {
                long startTime = System.currentTimeMillis();
                memberSet.addAll(adminDS.shutDownAllMembers());
                long duration = System.currentTimeMillis() - startTime;
                Log.getLogWriter().info("AdminDS " + adminDS + " shut down (disconnected) the following members (vms remain up): " + memberSet + "; shutDownAll duration " + duration + "ms");
                Log.getLogWriter().info(memberSet.size() + " members shut down during recovery phase: " + memberSet + ", target number is " + vmList.size());
            }
            catch (AdminException e1) {
                throw new TestException(TestHelper.getStackTrace(e1));
            }
        }
        for (Thread aThread : threads) {
            try {
                aThread.join();
            }
            catch (InterruptedException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
        }
        StopStartVMs.stopStartVMs(vmListExcludeLocators, stopModes);
    }

    public static void HydraTask_verifyRegionSizes() {
        Log.getLogWriter().info(RecoveryTest.regionHierarchyToString());
        long expectedSize = NameFactory.getPositiveNameCounter();
        long expectedNumRegions = maxPRs + maxReplicates;
        Set regionSet = CacheHelper.getCache().rootRegions();
        if ((long)regionSet.size() != expectedNumRegions) {
            throw new TestException("Expected " + expectedNumRegions + " but have " + regionSet.size() + regionSet);
        }
        StringBuffer regSizeStr = new StringBuffer();
        for (Region aRegion : regionSet) {
            int size = aRegion.size();
            if (aRegion.getAttributes().getDataPolicy().isEmpty()) {
                if (size != 0) {
                    throw new TestException("Expected " + aRegion.getFullPath() + " to be size 0 but it is " + size);
                }
            } else if ((long)size != expectedSize) {
                throw new TestException("Expected " + aRegion.getFullPath() + " to be size " + expectedSize + " but it is " + size);
            }
            regSizeStr.append(aRegion.getFullPath() + " is size " + size + "\n");
        }
        Log.getLogWriter().info("Verified that regions have correct sizes: " + regSizeStr);
    }

    public static void HydraTask_verifyXmlRegionSizes() {
        StartupShutdownTest.verifyXmlRegionSizes(false);
    }

    public static void HydraTask_verifyXmlRegionSizesForWAN() {
        StartupShutdownTest.verifyXmlRegionSizes(true);
    }

    static void verifyXmlRegionSizes(boolean isWANSetup) {
        Log.getLogWriter().info(RecoveryTest.regionHierarchyToString());
        long expectedSize = NameFactory.getPositiveNameCounter();
        long expectedNumRegions = 30L;
        Set rootRegions = CacheHelper.getCache().rootRegions();
        HashSet regionSet = new HashSet(rootRegions);
        Log.getLogWriter().info("Printing region hierarchy with sizes on Server side: ");
        Log.getLogWriter().info(RecoveryTest.regionHierarchyToString());
        for (Region aRegion : rootRegions) {
            regionSet.addAll(aRegion.subregions(true));
        }
        if ((long)regionSet.size() != 30L) {
            throw new TestException("Expected 30 but have " + regionSet.size() + regionSet);
        }
        String[] regionsWithFullSize = new String[]{"/matchRule", "/allocationRules", "/resequence", "/break", "/product", "/routingEndpoint", "/ldn_applianceAllocation", "/chi_applianceAllocation", "/cacheAdmin", "/backOfficeAccount", "/kpiRuleMetric", "/backOfficeAccountCollection", "/routingRule", "/tradeInstructionCommand", "/latencyMetric", "/adapterAmqpState", "/chi_audit", "/adapterState", "/tradeInstruction", "/cacheResponsibility", "/ldn_audit"};
        List<String> regionsWithFullSizeList = Arrays.asList(regionsWithFullSize);
        StringBuffer regSizeStr = new StringBuffer();
        for (Region aRegion : regionSet) {
            if (!regionsWithFullSizeList.contains(aRegion.getFullPath())) continue;
            int size = aRegion.size();
            if (isWANSetup) {
                StartupShutdownTest.verifyXmlRegionSizeForWAN(aRegion, size, expectedSize);
            } else {
                StartupShutdownTest.verifyXmlRegionSize(aRegion, size, expectedSize);
            }
            regSizeStr.append(aRegion.getFullPath() + " is size " + size + "\n");
        }
        Log.getLogWriter().info("Verified that regions have correct sizes: " + regSizeStr);
    }

    public static void verifyXmlRegionSize(Region aRegion, int size, long expectedSize) {
        if (aRegion.getAttributes().getDataPolicy().isEmpty()) {
            if (size != 0) {
                throw new TestException("Expected " + aRegion.getFullPath() + " to be size 0 but it is " + size);
            }
        } else if ((long)size != expectedSize) {
            throw new TestException("Expected " + aRegion.getFullPath() + " to be size " + expectedSize + " but it is " + size);
        }
    }

    public static void verifyXmlRegionSizeForWAN(Region aRegion, int size, long expectedSize) {
        Log.getLogWriter().info("Region size verfication for region: " + aRegion.getName());
        Log.getLogWriter().info("Region's size = " + size);
        Log.getLogWriter().info("Expected region Size = " + expectedSize);
        if (aRegion.getAttributes().getDataPolicy().isEmpty()) {
            if (size != 0) {
                throw new TestException("Expected " + aRegion.getFullPath() + " to be size 0 but it is " + size);
            }
        } else if (aRegion.getAttributes().getEntryTimeToLive().getTimeout() != 0) {
            int timeOut = aRegion.getAttributes().getEntryTimeToLive().getTimeout();
            if (timeOut > 0 && timeOut <= 30 && size != 0) {
                throw new TestException("Expected " + aRegion.getFullPath() + " to be size 0 because ttl = " + aRegion.getAttributes().getEntryTimeToLive().getTimeout() + "  But it is " + size);
            }
        } else if (!aRegion.getAttributes().getEnableGateway()) {
            boolean singleSitePopulation = TestConfig.tab().booleanAt(WANQueryPrms.populateDataSingleSite, false);
            if (singleSitePopulation) {
                if ((long)size != expectedSize && size != 0) {
                    throw new TestException("Expected " + aRegion.getFullPath() + " size to be either 0 or " + expectedSize + " but it is " + size);
                }
            } else if ((long)size != expectedSize / 2L) {
                throw new TestException("Expected " + aRegion.getFullPath() + " to be size " + expectedSize / 2L + " but it is " + size);
            }
        } else {
            if ((long)size != expectedSize) {
                throw new TestException("Expected " + aRegion.getFullPath() + " to be size " + expectedSize + " but it is " + size);
            }
            Log.getLogWriter().info("Region size matched expected: for region " + aRegion + " Size: " + size + " expectedSize" + expectedSize);
        }
    }

    public static void HydraTask_verifyXmlRegionSizesAfterRecovery() {
        Log.getLogWriter().info(RecoveryTest.regionHierarchyToString());
        long expectedSize = NameFactory.getPositiveNameCounter();
        long expectedNumRegions = 30L;
        Set rootRegions = CacheHelper.getCache().rootRegions();
        HashSet regionSet = new HashSet(rootRegions);
        for (Region aRegion : rootRegions) {
            regionSet.addAll(aRegion.subregions(true));
        }
        if ((long)regionSet.size() != 30L) {
            throw new TestException("Expected 30 but have " + regionSet.size() + regionSet);
        }
        String[] regionsWithFullSize = new String[]{"/matchRule", "/allocationRules", "/break", "/product", "/routingEndpoint", "/backOfficeAccount", "/backOfficeAccountCollection", "/routingRule", "/tradeInstructionCommand", "/chi_audit", "/adapterState", "/tradeInstruction", "/ldn_audit"};
        List<String> regionsWithFullSizeList = Arrays.asList(regionsWithFullSize);
        StringBuffer regSizeStr = new StringBuffer();
        for (Region aRegion : regionSet) {
            if (!regionsWithFullSizeList.contains(aRegion.getFullPath())) continue;
            int size = aRegion.size();
            if (aRegion.getAttributes().getDataPolicy().isEmpty()) {
                if (size != 0) {
                    throw new TestException("Expected " + aRegion.getFullPath() + " to be size 0 but it is " + size);
                }
            } else if ((long)size != expectedSize) {
                throw new TestException("Expected " + aRegion.getFullPath() + " to be size " + expectedSize + " but it is " + size);
            }
            regSizeStr.append(aRegion.getFullPath() + " is size " + size + "\n");
        }
        Log.getLogWriter().info("Verified that regions have correct sizes: " + regSizeStr);
    }

    protected static long logExecutionNumber() {
        long exeNum = RecoveryBB.getBB().getSharedCounters().incrementAndRead(RecoveryBB.executionNumber);
        Log.getLogWriter().info("Beginning task with execution number " + exeNum);
        return exeNum;
    }

    public static void HydraTask_waitForSilence() {
        SummaryLogListener.waitForSilence(30L, 1000L);
    }

    public static void HydraTask_waitLongerForSilence() {
        SummaryLogListener.waitForSilence(240L, 1000L);
    }

    public static void HydraTask_startupShutdown() {
        StartupShutdownTest.logExecutionNumber();
        long sleepSecBeforeShutDownAll = RecoveryPrms.getSleepSecBeforeShutDownAll();
        if (sleepSecBeforeShutDownAll > 0L) {
            Log.getLogWriter().info("Sleeping for " + sleepSecBeforeShutDownAll + " seconds");
            MasterController.sleepForMs((int)sleepSecBeforeShutDownAll * 1000);
        }
        List vmList = StopStartVMs.getAllVMs();
        List locators = StopStartVMs.getMatchVMs(vmList, "locator");
        ArrayList vmListExcludeLocators = new ArrayList();
        vmListExcludeLocators.addAll(vmList);
        vmListExcludeLocators.removeAll(locators);
        Log.getLogWriter().info("vmList is " + vmListExcludeLocators);
        AdminDistributedSystem adminDS = AdminHelper.getAdminDistributedSystem();
        Cache theCache = CacheHelper.getCache();
        if (adminDS == null) {
            throw new TestException("Test is configured to use shutDownAllMembers, but this vm must be an admin vm to use it");
        }
        ArrayList<String> stopModes = new ArrayList<String>();
        stopModes.add("mean_kill");
        Object[] tmp = StopStartVMs.shutDownAllMembers(adminDS, stopModes);
        List shutDownAllVMs = (List)tmp[0];
        Set shutdownAllResults = (Set)tmp[1];
        if (shutdownAllResults.size() != vmListExcludeLocators.size()) {
            throw new TestException("Expected shutDownAllMembers to return " + vmListExcludeLocators.size() + " members in its result, but it returned " + shutdownAllResults.size() + ": " + shutdownAllResults);
        }
        if (shutdownAllResults.size() > shutDownAllVMs.size()) {
            boolean cacheClosed = theCache.isClosed();
            if (cacheClosed) {
                Log.getLogWriter().info("shutDownAllMembers disconnected this vm");
                testInstance = null;
            } else {
                throw new TestException("shutDownAllMembers should have disconnected this vm, but the cache " + theCache + " isClosed is " + cacheClosed);
            }
        }
        Log.getLogWriter().info("Restarting the vms");
        ArrayList dataStoreVMs = new ArrayList();
        ArrayList proxyVMs = new ArrayList();
        Map sharedMap = RecoveryBB.getBB().getSharedMap().getMap();
        for (Object key : sharedMap.keySet()) {
            if (!(key instanceof String)) continue;
            if (((String)key).startsWith("proxy")) {
                proxyVMs.add(sharedMap.get(key));
                continue;
            }
            if (!((String)key).startsWith("dataStore")) continue;
            dataStoreVMs.add(sharedMap.get(key));
        }
        Log.getLogWriter().info("Restarting the vms, dataStoreVMS: " + dataStoreVMs + ", proxyVMs: " + proxyVMs);
        StopStartVMs.startVMs(dataStoreVMs);
        if (proxyVMs.size() > 0) {
            StopStartVMs.startVMs(proxyVMs);
        }
        long serversAreBack = RecoveryBB.getBB().getSharedCounters().incrementAndRead(RecoveryBB.serversAreBack);
        Log.getLogWriter().info("serversAreBack counter is " + serversAreBack);
    }

    public static void HydraTask_startupShutdownWithKill() {
        StartupShutdownTest.logExecutionNumber();
        final List vmList = StopStartVMs.getAllVMs();
        Log.getLogWriter().info("vmList is " + vmList);
        AdminDistributedSystem adminDS = AdminHelper.getAdminDistributedSystem();
        if (adminDS == null) {
            throw new TestException("Test is configured to use shutDownAllMembers, but this vm must be an admin vm to use it");
        }
        final ArrayList<String> stopModes = new ArrayList<String>();
        for (int i = 0; i < vmList.size(); ++i) {
            stopModes.add("mean_kill");
        }
        boolean killDuringShutDownAll = RecoveryPrms.getKillDuringShutDownAll();
        Thread killThread = null;
        if (killDuringShutDownAll) {
            killThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    int msToSleep = TestConfig.tab().getRandGen().nextInt(5, 35);
                    Log.getLogWriter().info("Sleeping for " + (msToSleep *= 1000) + " ms before killing");
                    MasterController.sleepForMs(msToSleep);
                    StopStartVMs.stopVMs(vmList, stopModes);
                    Log.getLogWriter().info("killThread is terminating");
                }
            });
            killThread = new HydraSubthread(killThread);
            killThread.start();
        }
        Log.getLogWriter().info("AdminDS " + adminDS + " is shutting down all members...");
        try {
            long startTime = System.currentTimeMillis();
            Set memberSet = adminDS.shutDownAllMembers();
            long duration = System.currentTimeMillis() - startTime;
            Log.getLogWriter().info("AdminDS " + adminDS + " shut down (disconnected) the following members (vms remain up): " + memberSet + "; shutDownAll duration " + duration + "ms");
        }
        catch (AdminException e1) {
            throw new TestException(TestHelper.getStackTrace(e1));
        }
        if (killThread == null) {
            StopStartVMs.stopVMs(vmList, stopModes);
        } else {
            Log.getLogWriter().info("Waiting for killThread to terminate");
            try {
                killThread.join();
            }
            catch (InterruptedException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
        }
        StopStartVMs.startVMs(vmList);
    }

    public static synchronized void HydraTask_initWithXml() {
        if (testInstance == null) {
            testInstance = new StartupShutdownTest();
            testInstance.initializeInstance();
            String newXmlFile = "VmId_" + RemoteTestModule.getMyVmid() + ".xml";
            File aFile = new File(newXmlFile);
            if (!aFile.exists()) {
                String JTESTS = System.getProperty("JTESTS");
                String xmlTemplate = JTESTS + File.separator + "largeScale" + File.separator + "newedge" + File.separator + "gemfire-server.xml.template";
                StartupShutdownTest.modifyXml(xmlTemplate, newXmlFile);
            }
            CacheHelper.createCacheFromXml(newXmlFile);
            Log.getLogWriter().info(RecoveryTest.regionHierarchyToString());
            int myVmId = RemoteTestModule.getMyVmid();
            RecoveryBB.getBB().getSharedMap().put("dataStoreJvm_" + myVmId, new ClientVmInfo(myVmId));
        }
    }

    public static synchronized void HydraTask_initClientWithXml() {
        if (testInstance == null) {
            testInstance = new StartupShutdownTest();
            testInstance.initializeInstance();
            String newXmlFile = "VmId_" + RemoteTestModule.getMyVmid() + ".xml";
            File aFile = new File(newXmlFile);
            if (!aFile.exists()) {
                CacheHelper.createCache("cache1");
                RegionHelper.createRegion("clientRegion");
                CacheHelper.generateCacheXmlFile("cache1", "clientRegion", null, "clientPool", newXmlFile);
                DistributedSystemHelper.disconnect();
                String JTESTS = System.getProperty("JTESTS");
                String xmlTemplate = JTESTS + File.separator + "largeScale" + File.separator + "newedge" + File.separator + "gemfire-client.xml.template";
                StartupShutdownTest.modifyClientXml(xmlTemplate, newXmlFile);
            }
            CacheHelper.createCacheFromXml(newXmlFile);
            Log.getLogWriter().info(RecoveryTest.regionHierarchyToString());
        }
        currentNumKeys.set(new Integer(0));
        Log.getLogWriter().info("currentNumKeys is " + currentNumKeys);
    }

    private static void modifyClientXml(String xmlTemplate, String newXmlFile) {
        StringBuffer newXml = new StringBuffer();
        try {
            File aFile = new File(newXmlFile);
            BufferedReader reader = new BufferedReader(new FileReader(aFile.getAbsoluteFile()));
            String line = reader.readLine();
            while (line != null) {
                String searchStr = "region name=";
                int index = line.indexOf(searchStr);
                if (index >= 0) {
                    File templateFile = new File(xmlTemplate);
                    BufferedReader templateReader = new BufferedReader(new FileReader(templateFile.getAbsoluteFile()));
                    String templateLine = templateReader.readLine();
                    while (templateLine != null) {
                        newXml.append(templateLine + "\n");
                        templateLine = templateReader.readLine();
                    }
                    newXml.append("</cache>");
                    break;
                }
                newXml.append(line + "\n");
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        try {
            PrintWriter outFile = new PrintWriter(new FileOutputStream(new File(newXmlFile)));
            outFile.print(newXml.toString());
            outFile.flush();
            outFile.close();
        }
        catch (FileNotFoundException e) {
            Log.getLogWriter().info("Unable to create " + newXmlFile + " due to " + e.toString());
        }
    }

    private static void modifyXml(String xmlFilePath, String newXmlFilePath) {
        StringBuffer newXml = new StringBuffer();
        try {
            File aFile = new File(xmlFilePath);
            BufferedReader reader = new BufferedReader(new FileReader(aFile.getAbsoluteFile()));
            String line = reader.readLine();
            String currDir = System.getProperty("user.dir");
            String diskDirStr = currDir + File.separator + "vm_" + RemoteTestModule.getMyVmid() + "_disk_1";
            File diskDir = new File(diskDirStr);
            diskDir.mkdirs();
            String osName = System.getProperty("os.name");
            Log.getLogWriter().info("diskDirStr before = " + diskDirStr);
            if (osName.indexOf("Win") != -1 || osName.indexOf("win") != -1) {
                diskDirStr = StartupShutdownTest.replaceSingleBackSlashWithDoublBackSlash(diskDirStr).toString();
            }
            Log.getLogWriter().info("diskDirStr after = " + diskDirStr);
            while (line != null) {
                String searchStr = "%DISK_DIR%";
                int index = line.indexOf(searchStr);
                if (index >= 0) {
                    line = line.replaceAll("%DISK_DIR%", diskDirStr);
                }
                newXml.append(line + "\n");
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        try {
            PrintWriter outFile = new PrintWriter(new FileOutputStream(new File(newXmlFilePath)));
            outFile.print(newXml.toString());
            outFile.flush();
            outFile.close();
        }
        catch (FileNotFoundException e) {
            Log.getLogWriter().info("Unable to create " + newXmlFilePath + " due to " + e.toString());
        }
    }

    static StringBuffer replaceSingleBackSlashWithDoublBackSlash(String input) {
        StringBuffer output = new StringBuffer();
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c == '\\') {
                output.append('\\');
                output.append('\\');
                continue;
            }
            output.append(c);
        }
        return output;
    }

    private static void generateCacheXmlFile(String fileName) {
        File aFile = new File(fileName);
        if (aFile.exists()) {
            return;
        }
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(new FileWriter(new File(fileName)));
        }
        catch (IOException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        CacheXmlGenerator.generate((Cache)CacheHelper.getCache(), (PrintWriter)pw);
        pw.close();
        Log.getLogWriter().info("Generated XML file: " + fileName);
    }
}

