/*
 * Decompiled with CFR 0.152.
 */
package delta;

import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.util.CacheListenerAdapter;
import com.gemstone.gemfire.distributed.DistributedSystem;
import delta.DeltaPropagation;
import delta.DeltaPropagationBB;
import delta.DeltaTestObj;
import delta.Validator;
import hydra.DistributedSystemHelper;
import hydra.Log;
import hydra.blackboard.SharedMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import util.TestException;
import util.TestHelper;

public class DeltaClientValidationListener
extends CacheListenerAdapter {
    private final Map latestValues = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterCreate(EntryEvent event) {
        Map map = this.latestValues;
        synchronized (map) {
            ++Validator.createCount;
            String key = (String)event.getKey();
            if (key.equals("last_key")) {
                DeltaPropagation.lastKeyReceived = true;
                Log.getLogWriter().info("'last_key' received at client");
                return;
            }
            if (event.getNewValue() instanceof Long) {
                return;
            }
            DeltaTestObj value = (DeltaTestObj)((Object)event.getNewValue());
            if (value == null) {
                DeltaClientValidationListener.throwException("value in afterCreate cannot be null: key = " + key);
                return;
            }
            if (value.getIntVar() != 0 && value.getFromDeltaCounter() != 0L) {
                this.validateIncrementByOne(key, value);
            }
            Log.getLogWriter().fine("create entry in Map key " + key + " : value : " + (Object)((Object)value) + " : puting into map : " + value.getIntVar());
            this.latestValues.put(key, value.getIntVar());
            Validator.keyToMap.put(key, value.getFromDeltaCounter());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterUpdate(EntryEvent event) {
        Map map = this.latestValues;
        synchronized (map) {
            ++Validator.updateCount;
            if (event.getNewValue() instanceof Long) {
                return;
            }
            String key = (String)event.getKey();
            DeltaTestObj newValue = (DeltaTestObj)((Object)event.getNewValue());
            DeltaTestObj oldValue = (DeltaTestObj)((Object)event.getOldValue());
            if (newValue == null) {
                DeltaClientValidationListener.throwException("newValue in afterUpdate cannot be null: key = " + key);
                return;
            }
            if (oldValue == null) {
                this.validateIncrementByOne(key, newValue);
            } else {
                long diff = newValue.getIntVar() - (Integer)this.latestValues.get(key);
                if (diff != 1L) {
                    DeltaClientValidationListener.throwException("difference expected in newValue and oldValue is 1, but was not for key = " + key + " & newVal = " + (Object)((Object)newValue) + " oldValue = " + (Integer)this.latestValues.get(key));
                    return;
                }
            }
            Log.getLogWriter().fine("update entry in Map key " + key + " : value : " + (Object)((Object)newValue) + " : puting into map : " + newValue.getIntVar());
            this.latestValues.put(key, newValue.getIntVar());
            boolean isStorageClient = event.getRegion().getAttributes().getDataPolicy().withStorage();
            if (isStorageClient && newValue.getFromDeltaCounter() == 0L) {
                long value = (Long)Validator.keyToMap.get(key);
                long newKeyToMapValue = ++value;
                newValue.setFromDeltaCounter((int)newKeyToMapValue);
                Validator.keyToMap.put(key, newKeyToMapValue);
            } else {
                Validator.keyToMap.put(key, newValue.getFromDeltaCounter());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterInvalidate(EntryEvent event) {
        Map map = this.latestValues;
        synchronized (map) {
            ++Validator.invalidateCount;
            if (event.getOldValue() instanceof Long) {
                return;
            }
            String key = (String)event.getKey();
            DeltaTestObj oldValue = (DeltaTestObj)((Object)event.getOldValue());
            if (oldValue == null) {
                DeltaClientValidationListener.throwException("oldValue in afterInvalidate cannot be null : key = " + key);
                return;
            }
            Log.getLogWriter().fine("invalidate entry in Map key " + key + " : value : " + (Object)((Object)oldValue) + " : puting into map : " + oldValue.getIntVar());
            this.latestValues.put(key, oldValue.getIntVar());
            Validator.keyToMap.put(key, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterDestroy(EntryEvent event) {
        Map map = this.latestValues;
        synchronized (map) {
            ++Validator.destroyCount;
            if (event.getOldValue() instanceof Long) {
                return;
            }
            String key = (String)event.getKey();
            DeltaTestObj value = (DeltaTestObj)((Object)event.getOldValue());
            if (value != null) {
                this.latestValues.put(key, value.getIntVar());
                Log.getLogWriter().info("key " + key + " received at client old value : " + (Object)((Object)value));
            }
            Log.getLogWriter().fine("destroy entry in Map key " + key);
            Validator.keyToMap.remove(key);
        }
    }

    private void validateIncrementByOne(String key, DeltaTestObj newValue) {
        Integer oldValue = (Integer)this.latestValues.get(key);
        if (oldValue == null) {
            DeltaClientValidationListener.throwException("oldValue in latestValues cannot be null: key = " + key + " & newVal = " + (Object)((Object)newValue));
            return;
        }
        long diff = newValue.getIntVar() - oldValue;
        if (diff != 1L) {
            DeltaClientValidationListener.throwException("difference expected in newValue and oldValue is 1, but is was " + diff + " for key = " + key + " & newVal = " + (Object)((Object)newValue));
            return;
        }
    }

    public static void throwException(String reason) {
        ArrayList reasonArray = null;
        DistributedSystem ds = DistributedSystemHelper.getDistributedSystem();
        String clientName = "CLIENT_" + ds.getName();
        SharedMap shMap = DeltaPropagationBB.getBB().getSharedMap();
        reasonArray = !shMap.containsKey(clientName) ? new ArrayList() : (ArrayList)shMap.get(clientName);
        reasonArray.add(reason);
        shMap.put(clientName, reasonArray);
        DeltaPropagationBB.getBB().getSharedCounters().increment(DeltaPropagationBB.NUM_EXCEPTION);
        Log.getLogWriter().info("Exception : " + TestHelper.getStackTrace(new TestException(reason)));
    }
}

