/*
 * Decompiled with CFR 0.152.
 */
package cq.newWan.serial;

import com.gemstone.gemfire.cache.Operation;
import com.gemstone.gemfire.cache.query.CqEvent;
import com.gemstone.gemfire.cache.query.CqListener;
import cq.CQUtilBB;
import hydra.Log;
import hydra.RemoteTestModule;
import hydra.blackboard.SharedMap;
import java.util.HashMap;
import java.util.Map;
import util.AbstractListener;
import util.QueryObject;
import util.TestException;
import util.TestHelper;

public class WANCQListener
extends AbstractListener
implements CqListener {
    private final Map latestValues = new HashMap();

    public void onEvent(CqEvent event) {
        this.logCQEvent("onEvent", event);
        Object key = event.getKey();
        QueryObject newValue = (QueryObject)event.getNewValue();
        String cq = event.getCq().getName();
        Operation op = event.getBaseOperation();
        if (op.equals(Operation.CREATE)) {
            CQUtilBB.incrementCounter("CQUtilBB.NUM_CREATE", CQUtilBB.NUM_CREATE);
            this.latestValues.put(key, newValue);
        } else if (op.equals(Operation.DESTROY)) {
            CQUtilBB.incrementCounter("CQUtilBB.NUM_DESTROY", CQUtilBB.NUM_DESTROY);
        } else if (op.equals(Operation.INVALIDATE)) {
            CQUtilBB.incrementCounter("CQUtilBB.NUM_INVALIDATE", CQUtilBB.NUM_INVALIDATE);
        } else if (op.equals(Operation.UPDATE)) {
            QueryObject oldValue = (QueryObject)this.latestValues.get(key);
            CQUtilBB.incrementCounter("CQUtilBB.NUM_UPDATE", CQUtilBB.NUM_UPDATE);
            this.latestValues.put(key, newValue);
            StringBuffer errMsg = new StringBuffer();
            long diff = newValue.aPrimitiveLong - oldValue.aPrimitiveLong;
            if (diff != 1L) {
                errMsg.append("Cq Update Event did not incrementally increase for " + cq + ": last reported value for Key(" + key + ") = " + oldValue + ", newValue from CqEvent = " + newValue);
                if (diff > 0L) {
                    CQUtilBB.getBB().getSharedCounters().add(CQUtilBB.MISSING_UPDATES, diff - 1L);
                } else {
                    errMsg.append("Late event arrival for key (" + key + "), value = " + newValue);
                    CQUtilBB.getBB().getSharedCounters().increment(CQUtilBB.LATE_UPDATES);
                }
                this.throwException(errMsg.toString());
            }
        }
    }

    public void onError(CqEvent event) {
        this.logCQEvent("onError", event);
        CQUtilBB.incrementCounter("CQUtilBB.NUM_ERRORS", CQUtilBB.NUM_ERRORS);
    }

    public void close() {
    }

    protected void throwException(String errStr) {
        SharedMap aMap = CQUtilBB.getBB().getSharedMap();
        if (aMap.get(TestHelper.EVENT_ERROR_KEY) == null) {
            aMap.put(TestHelper.EVENT_ERROR_KEY, errStr + " in " + WANCQListener.getMyUniqueName() + " " + TestHelper.getStackTrace());
        }
        Log.getLogWriter().info("Listener encountered Exception: " + errStr + ", written to CQUtilBB");
        throw new TestException(errStr);
    }

    public static String getMyUniqueName() {
        StringBuffer buf = new StringBuffer(50);
        buf.append("vm_").append(RemoteTestModule.getMyVmid());
        buf.append("_").append(RemoteTestModule.getMyClientName());
        buf.append("_").append(RemoteTestModule.getMyHost());
        buf.append("_").append(RemoteTestModule.getMyPid());
        return buf.toString();
    }
}

