/*
 * Decompiled with CFR 0.152.
 */
package cq.ha;

import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.util.CacheListenerAdapter;
import com.gemstone.gemfire.distributed.DistributedSystem;
import cq.CQUtilBB;
import durableClients.DurableClientsTest;
import hct.ha.HAClientQueue;
import hct.ha.HAClientQueueBB;
import hct.ha.Validator;
import hydra.DistributedSystemHelper;
import hydra.Log;
import hydra.blackboard.SharedCounters;
import hydra.blackboard.SharedMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import util.TestException;
import util.TestHelper;

public class HANoFailoverClientListener
extends CacheListenerAdapter {
    private final Map latestValues = new HashMap();
    public static long expectedCQCreates = 0L;
    public static long expectedCQDestroys = 0L;
    public static long expectedCQUpdates = 0L;

    public void afterCreate(EntryEvent event) {
        Long value;
        ++Validator.createCount;
        String key = (String)event.getKey();
        if (key.equals("last_key")) {
            HAClientQueue.lastKeyReceived = true;
            Log.getLogWriter().info("'last_key' received at client");
        }
        if (key.equals("last_key")) {
            DurableClientsTest.receivedLastKey = true;
            Log.getLogWriter().info("'last_key' received at client");
        }
        if ((value = (Long)event.getNewValue()) == null) {
            HANoFailoverClientListener.throwException("value in afterCreate cannot be null: key = " + key);
        }
        if (value != 0L) {
            this.validateIncrementByOne(key, value);
            ++expectedCQCreates;
        }
        this.latestValues.put(key, value);
    }

    public void afterUpdate(EntryEvent event) {
        ++Validator.updateCount;
        String key = (String)event.getKey();
        Long newValue = (Long)event.getNewValue();
        Long oldValue = (Long)event.getOldValue();
        if (newValue == null) {
            HANoFailoverClientListener.throwException("newValue in afterUpdate cannot be null: key = " + key);
        }
        if (oldValue == null) {
            this.validateIncrementByOne(key, newValue);
            ++expectedCQCreates;
        } else {
            long diff = newValue - oldValue;
            if (diff != 1L) {
                HANoFailoverClientListener.throwException("difference expected in newValue and oldValue is 1, but was not for key = " + key + " & newVal = " + newValue + " oldValue = " + oldValue);
            }
            ++expectedCQUpdates;
        }
        this.latestValues.put(key, newValue);
    }

    public void afterInvalidate(EntryEvent event) {
        ++Validator.invalidateCount;
        String key = (String)event.getKey();
        Long oldValue = (Long)event.getOldValue();
        if (oldValue == null) {
            HANoFailoverClientListener.throwException("oldValue in afterInvalidate cannot be null : key = " + key);
        }
        ++expectedCQDestroys;
        this.latestValues.put(key, oldValue);
    }

    public void afterDestroy(EntryEvent event) {
        ++Validator.destroyCount;
        String key = (String)event.getKey();
        Long value = (Long)event.getOldValue();
        if (value != null) {
            this.latestValues.put(key, value);
            ++expectedCQDestroys;
        }
    }

    private void validateIncrementByOne(String key, Long newValue) {
        long diff;
        Long oldValue = (Long)this.latestValues.get(key);
        if (oldValue == null) {
            HANoFailoverClientListener.throwException("oldValue in latestValues cannot be null: key = " + key + " & newVal = " + newValue);
        }
        if ((diff = newValue - oldValue) != 1L) {
            HANoFailoverClientListener.throwException("difference expected in newValue and oldValue is 1, but is was " + diff + " for key = " + key + " & newVal = " + newValue);
        }
    }

    public static void throwException(String reason) {
        ArrayList reasonArray = null;
        DistributedSystem ds = DistributedSystemHelper.getDistributedSystem();
        String clientName = "CLIENT_" + ds.getName();
        SharedMap shMap = HAClientQueueBB.getBB().getSharedMap();
        reasonArray = !shMap.containsKey(clientName) ? new ArrayList() : (ArrayList)shMap.get(clientName);
        reasonArray.add(reason);
        shMap.put(clientName, reasonArray);
        HAClientQueueBB.getBB().getSharedCounters().increment(HAClientQueueBB.NUM_EXCEPTION);
        Log.getLogWriter().info("Exception : " + TestHelper.getStackTrace(new TestException(reason)));
    }

    public static void verifyCQEventsReceived() {
        SharedCounters sc = CQUtilBB.getBB().getSharedCounters();
        long actualCQCreates = sc.read(CQUtilBB.NUM_CREATE);
        long actualCQDestroys = sc.read(CQUtilBB.NUM_DESTROY);
        long actualCQUpdates = sc.read(CQUtilBB.NUM_UPDATE);
        while (true) {
            boolean getNewNumbers = false;
            try {
                Thread.sleep(2000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (sc.read(CQUtilBB.NUM_CREATE) != actualCQCreates || sc.read(CQUtilBB.NUM_DESTROY) != actualCQDestroys || sc.read(CQUtilBB.NUM_UPDATE) != actualCQUpdates) {
                getNewNumbers = true;
            }
            if (!getNewNumbers) break;
            actualCQCreates = sc.read(CQUtilBB.NUM_CREATE);
            actualCQDestroys = sc.read(CQUtilBB.NUM_DESTROY);
            actualCQUpdates = sc.read(CQUtilBB.NUM_UPDATE);
            Log.getLogWriter().info("Still receiving the events, will wait to finish...");
        }
        StringBuffer aStr = new StringBuffer();
        aStr.append("CQCreate Events expected: " + expectedCQCreates + ", received " + actualCQCreates + "\n");
        aStr.append("CQDestroy Events expected: " + expectedCQDestroys + ", received " + actualCQDestroys + "\n");
        aStr.append("CQUpdate Events expected: " + expectedCQUpdates + ", received " + actualCQUpdates + "\n");
        Log.getLogWriter().info("CQEvent counts : \n" + aStr.toString());
        aStr = new StringBuffer();
        if (expectedCQCreates != actualCQCreates) {
            aStr.append("Expected " + expectedCQCreates + " CQCreate Events but processed " + actualCQCreates + "\n");
        }
        if (expectedCQDestroys != actualCQDestroys) {
            aStr.append("Expected " + expectedCQDestroys + " CQDestroy Events but processed " + actualCQDestroys + "\n");
        }
        if (expectedCQUpdates != actualCQUpdates) {
            aStr.append("Expected " + expectedCQUpdates + " CQUpdate Events but processed " + actualCQUpdates + "\n");
        }
        if (aStr.length() > 0) {
            String errMsg = "verifyCQEventsReceived validation failure: \n" + aStr.toString();
            Log.getLogWriter().info(errMsg);
            throw new TestException(errMsg + TestHelper.getStackTrace());
        }
        Log.getLogWriter().info("CQEvent counts successfully verified");
    }
}

