/*
 * Decompiled with CFR 0.152.
 */
package cq;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.query.IndexExistsException;
import com.gemstone.gemfire.cache.query.IndexNameConflictException;
import com.gemstone.gemfire.cache.query.IndexType;
import com.gemstone.gemfire.cache.query.QueryException;
import com.gemstone.gemfire.cache.query.QueryService;
import distcache.gemfire.GemFireCachePrms;
import hydra.CacheHelper;
import hydra.Log;
import hydra.RegionHelper;
import hydra.TestConfig;
import query.index.IndexPrms;
import util.TestException;

public class IndexTest {
    protected static IndexTest indexTest;

    public static synchronized void HydraTask_CreateIndex() {
        if (indexTest == null) {
            indexTest = new IndexTest();
        }
        indexTest.createIndex(GemFireCachePrms.getRegionName());
    }

    protected void createIndex(String regionName) {
        try {
            long numOfIndexes = 1L;
            numOfIndexes = TestConfig.tab().longAt(IndexPrms.numOfIndexes, 1L);
            this.createNonExistPrimaryIndex(regionName);
            if (numOfIndexes >= 2L) {
                this.createQtyIndex(regionName);
            }
            if (numOfIndexes >= 3L) {
                this.createMktValueIndex(regionName);
            }
        }
        catch (IndexNameConflictException e) {
            Log.getLogWriter().info("Caught expected IndexNameConflictException, continuing tests");
        }
        catch (IndexExistsException e) {
            Log.getLogWriter().info("Caught expected IndexExistsException, continuing tests");
        }
        catch (QueryException e) {
            throw new TestException("Could not create Index " + e.getStackTrace());
        }
    }

    protected void createNonExistPrimaryIndex(String regionName) throws IndexExistsException, IndexNameConflictException, QueryException {
        QueryService qs = this.getQueryService(regionName);
        qs.createIndex("secIdIndex", IndexType.PRIMARY_KEY, "secIdIndex", "/" + regionName);
    }

    protected void createPrimaryIndex(String regionName) {
        try {
            this.createSecIdIndex(regionName);
        }
        catch (IndexNameConflictException e) {
            Log.getLogWriter().info("Caught expected IndexNameConflictException, continuing tests");
        }
        catch (IndexExistsException e) {
            Log.getLogWriter().info("Caught expected IndexExistsException, continuing tests");
        }
        catch (QueryException e) {
            throw new TestException("Could not create Index " + e.getStackTrace());
        }
    }

    protected void createSecIdIndex(String regionName) throws IndexExistsException, IndexNameConflictException, QueryException {
        QueryService qs = this.getQueryService(regionName);
        qs.createIndex("secIdIndex", IndexType.PRIMARY_KEY, "secId", "/" + regionName);
        Log.getLogWriter().info("Primary index secIdIndex Created successfully");
    }

    protected void createQtyIndex(String regionName) throws IndexExistsException, IndexNameConflictException, QueryException {
        QueryService qs = this.getQueryService(regionName);
        qs.createIndex("qtyIndex", IndexType.FUNCTIONAL, "qty", "/" + regionName);
        Log.getLogWriter().info("Functinal index qtyIndex Created successfully");
    }

    protected void createMktValueIndex(String regionName) throws IndexExistsException, IndexNameConflictException, QueryException {
        QueryService qs = this.getQueryService(regionName);
        qs.createIndex("mktValueIndex", IndexType.FUNCTIONAL, "mktValue", "/" + regionName);
        Log.getLogWriter().info("Functinal index mktValueIndex Created successfully");
    }

    protected QueryService getQueryService(String regionName) {
        QueryService qs = null;
        Region region = RegionHelper.getRegion(regionName);
        if (region == null) {
            Log.getLogWriter().info("The region is not created properly");
        } else {
            Log.getLogWriter().info("Obtained the region with name :" + regionName);
            qs = CacheHelper.getCache().getQueryService();
        }
        return qs;
    }
}

