/*
 * Decompiled with CFR 0.152.
 */
package cq;

import com.gemstone.gemfire.cache.Operation;
import com.gemstone.gemfire.cache.query.CqEvent;
import com.gemstone.gemfire.cache.query.CqListener;
import cq.CQUtilBB;
import hydra.Log;
import hydra.RemoteTestModule;
import util.AbstractListener;

public class ConcCQTestListener
extends AbstractListener
implements CqListener {
    private static CQUtilBB cqBB = CQUtilBB.getBB();

    public void onEvent(CqEvent event) {
        this.logCQEvent("onEvent", event);
        Operation op = event.getBaseOperation();
        if (op.equals(Operation.CREATE)) {
            CQUtilBB.incrementCounter("CQUtilBB.NUM_CREATE", CQUtilBB.NUM_CREATE);
            Object key = event.getKey();
            CQUtilBB.getBB().getSharedMap().put(key + ":" + RemoteTestModule.getMyVmid(), new Integer(1));
        } else if (op.equals(Operation.DESTROY)) {
            CQUtilBB.incrementCounter("CQUtilBB.NUM_DESTROY", CQUtilBB.NUM_DESTROY);
        } else if (op.equals(Operation.INVALIDATE)) {
            CQUtilBB.incrementCounter("CQUtilBB.NUM_INVALIDATE", CQUtilBB.NUM_INVALIDATE);
        } else if (op.equals(Operation.UPDATE)) {
            Log.getLogWriter().info("new value is " + event.getNewValue().toString());
            CQUtilBB.incrementCounter("CQUtilBB.NUM_UPDATE", CQUtilBB.NUM_UPDATE);
        } else if (op.equals(Operation.REGION_CLEAR)) {
            CQUtilBB.incrementCounter("CQUtilBB.NUM_CLEARREGION", CQUtilBB.NUM_CLEARREGION);
            Log.getLogWriter().info("clearRegion Ops");
        } else if (op.equals(Operation.REGION_INVALIDATE)) {
            CQUtilBB.incrementCounter("CQUtilBB.NUM_INVALIDATEREGION", CQUtilBB.NUM_INVALIDATEREGION);
            Log.getLogWriter().info("invalidateRegion Ops");
        }
        cqBB.getSharedMap().put("lastEventReceived", new Long(System.currentTimeMillis()));
    }

    public void onError(CqEvent event) {
        cqBB.getSharedMap().put("lastEventReceived", new Long(System.currentTimeMillis()));
        this.logCQEvent("onError", event);
        CQUtilBB.incrementCounter("CQUtilBB.NUM_ERRORS", CQUtilBB.NUM_ERRORS);
    }

    public void close() {
        Log.getLogWriter().info("CQListener close() is invoked.");
        CQUtilBB.getBB().getSharedCounters().increment(CQUtilBB.NUM_CLOSE);
    }
}

