/*
 * Decompiled with CFR 0.152.
 */
package cq;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.client.Pool;
import com.gemstone.gemfire.cache.query.CqAttributes;
import com.gemstone.gemfire.cache.query.CqAttributesFactory;
import com.gemstone.gemfire.cache.query.CqClosedException;
import com.gemstone.gemfire.cache.query.CqException;
import com.gemstone.gemfire.cache.query.CqExistsException;
import com.gemstone.gemfire.cache.query.CqQuery;
import com.gemstone.gemfire.cache.query.CqResults;
import com.gemstone.gemfire.cache.query.CqStatistics;
import com.gemstone.gemfire.cache.query.Query;
import com.gemstone.gemfire.cache.query.QueryService;
import com.gemstone.gemfire.cache.query.RegionNotFoundException;
import com.gemstone.gemfire.cache.query.SelectResults;
import com.gemstone.gemfire.cache.query.Struct;
import com.gemstone.gemfire.cache.query.internal.QueryUtils;
import com.gemstone.gemfire.cache.query.internal.types.TypeUtils;
import com.gemstone.gemfire.cache.query.types.ObjectType;
import cq.CQExecuteVersionHelper;
import cq.CQUtilBB;
import cq.CQUtilPrms;
import hydra.CacheHelper;
import hydra.ClientCacheHelper;
import hydra.Log;
import hydra.MasterController;
import hydra.PoolHelper;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import hydra.blackboard.SharedCounters;
import java.util.Iterator;
import util.TestException;
import util.TestHelper;

public class CQUtil {
    private static QueryService cqService = null;
    private static boolean useCQ;
    private static boolean logCQOperations;
    protected static final String cqPrefix = "cq";
    protected static final int GET_CQ_ATTRIBUTES = 0;
    protected static final int GET_CQ_NAME = 1;
    protected static final int GET_CQ_RESULTS = 2;
    protected static final int GET_QUERY = 3;
    protected static final int GET_QUERY_STRING = 4;
    protected static final int GET_STATISTICS = 5;
    protected static final int[] cqOperations;
    protected static final String[] cqOperationMethods;

    public static synchronized void initialize() {
        useCQ = TestConfig.tab().booleanAt(CQUtilPrms.useCQ, false);
        Log.getLogWriter().info("CQUtil: useCQ = " + useCQ);
        logCQOperations = TestConfig.tab().booleanAt(CQUtilPrms.logCQOperations, true);
        Log.getLogWriter().info("CQUtil: logCQOperations = " + logCQOperations);
    }

    public static synchronized void initializeCQService() {
        CQUtil.initializeCQService(false);
    }

    public static synchronized void initializeCQService(boolean useClientCache) {
        if (!useCQ) {
            return;
        }
        try {
            Log.getLogWriter().info("Creating CQService.");
            String usingPool = TestConfig.tab().stringAt(CQUtilPrms.QueryServiceUsingPool, "false");
            boolean queryServiceUsingPool = Boolean.valueOf(usingPool);
            if (useClientCache) {
                Pool pool = PoolHelper.createPool(CQUtilPrms.getQueryServicePoolName());
                cqService = ClientCacheHelper.getCache().getQueryService(pool.getName());
                Log.getLogWriter().info("Initializing QueryService with ClientCache using Pool. PoolName: " + pool.getName());
            } else if (queryServiceUsingPool) {
                Pool pool = PoolHelper.createPool(CQUtilPrms.getQueryServicePoolName());
                cqService = pool.getQueryService();
                Log.getLogWriter().info("Initializing QueryService using Pool. PoolName: " + pool.getName());
            } else {
                cqService = CacheHelper.getCache().getQueryService();
                Log.getLogWriter().info("Initializing QueryService using Cache.");
            }
        }
        catch (Exception e) {
            throw new TestException("Failed to create CQService " + TestHelper.getStackTrace(e));
        }
    }

    public static SelectResults registerCQ(Region aRegion) {
        String query = "SELECT * FROM " + aRegion.getFullPath();
        return CQUtil.registerCQ(CQUtil.getCqName(), query, aRegion);
    }

    public static SelectResults registerDurableCQ(Region aRegion) {
        String query = "SELECT * FROM " + aRegion.getFullPath();
        String cqName = aRegion.getFullPath() + RemoteTestModule.getCurrentThread().getThreadId();
        return CQUtil.registerDurableCQ(cqName, query, aRegion);
    }

    public static SelectResults registerCQ(String cqName, String query, Region aRegion) {
        SelectResults results = null;
        if (useCQ) {
            if (cqName == null) {
                cqName = CQUtil.getCqName();
            }
            if (query == null) {
                query = "SELECT * FROM " + aRegion.getFullPath();
            }
            CqAttributes cqAttrs = CQUtil.getCQAttributes();
            CqQuery cq = null;
            try {
                Log.getLogWriter().info("Creating CQ named " + cqName + " with query: " + query + " and cqAttrs: " + CQUtil.cqAttributesToString(cqAttrs));
                cq = cqService.newCq(cqName, query, cqAttrs);
                Log.getLogWriter().info("Successfully created CQ named " + cqName);
                results = new CQExecuteVersionHelper().executeWithInitialResults(cq);
            }
            catch (CqClosedException eClosed) {
                throw new TestException(TestHelper.getStackTrace(eClosed));
            }
            catch (RegionNotFoundException regionNotFound) {
                throw new TestException(TestHelper.getStackTrace(regionNotFound));
            }
            catch (CqExistsException cqe) {
                throw new TestException(TestHelper.getStackTrace(cqe));
            }
            catch (CqException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            catch (IllegalStateException ue) {
                throw new TestException(TestHelper.getStackTrace(ue));
            }
        }
        return results;
    }

    public static SelectResults registerDurableCQ(String cqName, String query, Region aRegion) {
        SelectResults results = null;
        if (useCQ) {
            if (cqName == null) {
                cqName = CQUtil.getCqName();
            }
            if (query == null) {
                query = "SELECT * FROM " + aRegion.getFullPath();
            }
            CqAttributes cqAttrs = CQUtil.getCQAttributes();
            CqQuery cq = null;
            try {
                Log.getLogWriter().info("Creating CQ named " + cqName + " with query: " + query + " and cqAttrs: " + CQUtil.cqAttributesToString(cqAttrs));
                cq = cqService.newCq(cqName, query, cqAttrs, true);
                Log.getLogWriter().info("Successfully created CQ named " + cqName);
                results = new CQExecuteVersionHelper().executeWithInitialResults(cq);
            }
            catch (CqClosedException eClosed) {
                throw new TestException(TestHelper.getStackTrace(eClosed));
            }
            catch (RegionNotFoundException regionNotFound) {
                throw new TestException(TestHelper.getStackTrace(regionNotFound));
            }
            catch (CqExistsException cqe) {
                throw new TestException(TestHelper.getStackTrace(cqe));
            }
            catch (CqException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            catch (IllegalStateException ue) {
                throw new TestException(TestHelper.getStackTrace(ue));
            }
        }
        return results;
    }

    public static SelectResults registerAndCloseCQ(String cqName, String query, Region aRegion) throws CqException {
        SelectResults results = null;
        if (useCQ) {
            if (cqName == null) {
                cqName = CQUtil.getCqName();
            }
            if (query == null) {
                query = "SELECT * FROM " + aRegion.getFullPath();
            }
            CqAttributes cqAttrs = CQUtil.getCQAttributes();
            CqQuery cq = null;
            try {
                Log.getLogWriter().info("Creating CQ named " + cqName + " with query: " + query + " and cqAttrs: " + CQUtil.cqAttributesToString(cqAttrs));
                cq = cqService.newCq(cqName, query, cqAttrs);
                Log.getLogWriter().info("Successfully created CQ named " + cqName);
                results = new CQExecuteVersionHelper().executeWithInitialResults(cq);
                cq.close();
            }
            catch (CqClosedException eClosed) {
                throw new TestException(TestHelper.getStackTrace(eClosed));
            }
            catch (RegionNotFoundException regionNotFound) {
                throw new TestException(TestHelper.getStackTrace(regionNotFound));
            }
            catch (CqExistsException cqe) {
                throw new TestException(TestHelper.getStackTrace(cqe));
            }
            catch (IllegalStateException ue) {
                throw new TestException(TestHelper.getStackTrace(ue));
            }
        }
        return results;
    }

    private static CqAttributes getCQAttributes() {
        CqAttributesFactory factory = new CqAttributesFactory();
        factory.addCqListener(CQUtilPrms.getCQListener());
        CqAttributes cqAttrs = factory.create();
        return cqAttrs;
    }

    private static String cqAttributesToString(CqAttributes attrs) {
        StringBuffer aStr = new StringBuffer();
        aStr.append("cqListener = " + attrs.getCqListener());
        return aStr.toString();
    }

    public static CqQuery getCQ() {
        return CQUtil.getCQ(CQUtil.getCqName());
    }

    public static CqQuery getCQ(String cqName) {
        CqQuery cq = null;
        if (useCQ) {
            cq = cqService.getCq(cqName);
        }
        return cq;
    }

    public static SelectResults getCQResults() {
        SelectResults results = null;
        if (useCQ) {
            results = CQUtil.getCQResults(CQUtil.getCqName());
        }
        return results;
    }

    public static synchronized SelectResults getCQResults(String cqName) {
        SelectResults results = null;
        if (useCQ) {
            CqQuery cq = CQUtil.getCQ(cqName);
            Log.getLogWriter().info("getCq(" + cqName + ") returns " + cq);
            try {
                cq.stop();
                results = new CQExecuteVersionHelper().executeWithInitialResults(cq);
            }
            catch (CqClosedException cqClosedException) {
            }
            catch (RegionNotFoundException regionNotFoundException) {
            }
            catch (CqException cqException) {
                // empty catch block
            }
        }
        return results;
    }

    public static SelectResults getSelectResults(CqResults cqResults) {
        SelectResults sr = QueryUtils.getEmptySelectResults((ObjectType)TypeUtils.OBJECT_TYPE, null);
        Struct s = null;
        for (Object result : cqResults.asList()) {
            s = (Struct)result;
            sr.add(s.get("value"));
        }
        return sr;
    }

    public static void displaySelectResults() {
        CQUtil.displaySelectResults(CQUtil.getCqName());
    }

    public static synchronized void displaySelectResults(String cqName) {
        if (!useCQ) {
            return;
        }
        CqQuery cq = CQUtil.getCQ(cqName);
        SelectResults results = CQUtil.getCQResults(cqName);
        Iterator i = results.iterator();
        StringBuffer aStr = new StringBuffer("ResultSet (size " + results.size() + ") = \n");
        while (i.hasNext()) {
            Object o = i.next();
            aStr.append(o.toString() + "\n");
        }
        Log.getLogWriter().info(aStr.toString());
    }

    public static String getCqName() {
        return cqPrefix + RemoteTestModule.getCurrentThread().getThreadId();
    }

    public static void HydraTask_doCQOperations() {
        if (!useCQ) {
            return;
        }
        long startTime = System.currentTimeMillis();
        block8: do {
            CqQuery[] cqs = cqService.getCqs();
            Log.getLogWriter().info("CQs = " + cqs);
            int randInt = TestConfig.tab().getRandGen().nextInt(0, cqs.length - 1);
            CqQuery cq = cqs[randInt];
            String cqName = cq.getName();
            randInt = TestConfig.tab().getRandGen().nextInt(0, cqOperations.length - 1);
            int whichOp = cqOperations[randInt];
            if (logCQOperations) {
                Log.getLogWriter().info("Performing " + cqOperationMethods[whichOp] + " on CQ named " + cqName);
            }
            switch (whichOp) {
                case 0: {
                    CqAttributes attrs = cq.getCqAttributes();
                    if (!logCQOperations) continue block8;
                    Log.getLogWriter().info("CQ Attrs = " + CQUtil.cqAttributesToString(attrs));
                    break;
                }
                case 1: {
                    String name = cq.getName();
                    if (!logCQOperations) continue block8;
                    Log.getLogWriter().info("cqName = " + name);
                    break;
                }
                case 2: {
                    if (!logCQOperations) continue block8;
                    CQUtil.displaySelectResults(cqName);
                    break;
                }
                case 3: {
                    Query query = cq.getQuery();
                    if (!logCQOperations) continue block8;
                    Log.getLogWriter().info("Query = " + query);
                    break;
                }
                case 4: {
                    String queryString = cq.getQueryString();
                    if (!logCQOperations) continue block8;
                    Log.getLogWriter().info("QueryString = " + queryString);
                    break;
                }
                case 5: {
                    CqStatistics cqStats = cq.getStatistics();
                    if (!logCQOperations) continue block8;
                    Log.getLogWriter().info("QueryStatistics = " + cqStats.toString());
                    break;
                }
                default: {
                    throw new TestException("Unrecognized cqOperation (" + randInt + ")");
                }
            }
        } while (System.currentTimeMillis() - startTime < 30000L);
    }

    public static void HydraTask_verifyCQListenerInvoked() {
        if (!useCQ) {
            return;
        }
        CQUtilBB.printBB();
        SharedCounters sc = CQUtilBB.getBB().getSharedCounters();
        long[] counterValues = sc.getCounterValues();
        boolean nonZeroValue = false;
        for (int i = 0; i < counterValues.length; ++i) {
            if (counterValues[i] <= 0L) continue;
            nonZeroValue = true;
        }
        if (!nonZeroValue) {
            throw new TestException("CQListener not invoked: CQUtilBB.counterValues = " + counterValues.toString());
        }
        long numErrors = sc.read(CQUtilBB.NUM_ERRORS);
        if (numErrors != 0L) {
            throw new TestException("CQListener onError() invoked " + numErrors + " errors, check logs for details");
        }
    }

    public static void HydraTask_verifyCQListenerProcessedServerInitiatedEvents() {
        if (!useCQ) {
            return;
        }
        MasterController.sleepForMs(5000);
        CQUtilBB.printBB();
        String errMsg = new String();
        SharedCounters sc = CQUtilBB.getBB().getSharedCounters();
        long localLoadCreates = sc.read(CQUtilBB.NUM_LOCAL_LOAD_CREATE);
        Log.getLogWriter().info("Server afterCreate() LOCAL_LOAD_CREATE = " + localLoadCreates);
        long numCQsCreated = (long)TestHelper.getNumCQsCreated();
        Log.getLogWriter().info("Combined CqServiceStats.getNumCQsCreated = " + numCQsCreated);
        long numCQCreateEvents = sc.read(CQUtilBB.NUM_CREATE);
        long loadsCompleted = (long)TestHelper.getNumLoadsCompleted();
        Log.getLogWriter().info("Server side load operations = " + loadsCompleted);
        if (loadsCompleted > 0L && localLoadCreates == 0L) {
            errMsg = "Expected Server side afterCreate (LOCAL_LOAD_CREATE) invocations, but none processed\n";
            throw new TestException(errMsg + TestHelper.getStackTrace());
        }
        Log.getLogWriter().info("Expecting " + loadsCompleted * numCQsCreated + " (" + loadsCompleted + " server loadsCompleted * " + numCQsCreated + " CQs) CQ Create Events");
        boolean exactCounterValue = TestConfig.tab().booleanAt(CQUtilPrms.exactCounterValue, true);
        TestHelper.waitForCounter(CQUtilBB.getBB(), "NUM_CREATE", CQUtilBB.NUM_CREATE, loadsCompleted * numCQsCreated, exactCounterValue, 120000L);
        long numErrors = sc.read(CQUtilBB.NUM_ERRORS);
        if (numErrors != 0L) {
            errMsg = "CQListener onError() invoked " + numErrors + " errors, check logs for details";
            Log.getLogWriter().info(errMsg);
            throw new TestException(errMsg + TestHelper.getStackTrace());
        }
    }

    static {
        cqOperations = new int[]{0, 1, 2, 3, 4, 5};
        cqOperationMethods = new String[]{"getCQAttributes()", "getCQName()", "getCQResults()", "getQuery()", "getQueryString()", "getStatistics()"};
    }
}

