/*
 * Decompiled with CFR 0.152.
 */
package cq;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.cache.CacheLoaderException;
import com.gemstone.gemfire.cache.ClientHelper;
import com.gemstone.gemfire.cache.EntryExistsException;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.GemFireCache;
import com.gemstone.gemfire.cache.InterestResultPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.TimeoutException;
import com.gemstone.gemfire.cache.control.RebalanceFactory;
import com.gemstone.gemfire.cache.control.RebalanceOperation;
import com.gemstone.gemfire.cache.control.RebalanceResults;
import com.gemstone.gemfire.cache.query.CqAttributes;
import com.gemstone.gemfire.cache.query.CqAttributesFactory;
import com.gemstone.gemfire.cache.query.CqClosedException;
import com.gemstone.gemfire.cache.query.CqException;
import com.gemstone.gemfire.cache.query.CqExistsException;
import com.gemstone.gemfire.cache.query.CqListener;
import com.gemstone.gemfire.cache.query.CqQuery;
import com.gemstone.gemfire.cache.query.QueryService;
import com.gemstone.gemfire.cache.query.RegionNotFoundException;
import com.gemstone.gemfire.cache.query.SelectResults;
import com.gemstone.gemfire.cache.util.BridgeWriterException;
import com.gemstone.gemfire.internal.GemFireVersion;
import cq.CQExecuteVersionHelper;
import cq.CQGatherListener;
import cq.CQTestVersionHelper;
import cq.CQUtilBB;
import cq.CQUtilPrms;
import delta.DeltaObject;
import getInitialImage.InitImagePrms;
import hydra.BridgeHelper;
import hydra.BridgePrms;
import hydra.DistributedSystemHelper;
import hydra.GsRandom;
import hydra.HydraThreadLocal;
import hydra.HydraVector;
import hydra.Log;
import hydra.Prms;
import hydra.ProcessMgr;
import hydra.RemoteTestModule;
import hydra.StopSchedulingOrder;
import hydra.StopSchedulingTaskOnClientOrder;
import hydra.TestConfig;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import pdx.PdxTest;
import pdx.PdxTestVersionHelper;
import rebalance.RebalanceUtil;
import util.MethodCoordinator;
import util.NameFactory;
import util.QueryObject;
import util.RandomValues;
import util.SilenceListener;
import util.StopStartPrms;
import util.StopStartVMs;
import util.TestException;
import util.TestHelper;
import util.TestHelperPrms;

public class CQTest {
    public static CQTest testInstance;
    public static CQTestVersionHelper versionHelperInstance;
    protected static final String VmIDStr = "VmId_";
    protected static final String ThreadIDStr = "ThreadId_";
    protected long minTaskGranularitySec;
    protected long minTaskGranularityMS;
    protected int numOpsPerTask;
    public boolean isBridgeConfiguration;
    public boolean isBridgeClient;
    protected int numThreadsInClients;
    public Region aRegion;
    protected QueryService qService;
    public HydraThreadLocal uniqueKeyIndex = new HydraThreadLocal();
    protected boolean isSerialExecution;
    protected boolean highAvailability;
    protected int upperThreshold;
    protected int lowerThreshold;
    protected boolean uniqueKeys = false;
    public int queryDepth;
    protected int numQueriesPerClientVM;
    public Map queryMap;
    protected int secondsToRun;
    protected boolean cacheIsClosed;
    protected boolean disconnected;
    protected int numThreadsInThisVM = 0;
    protected static boolean CQsOn;
    protected boolean useDeltaObjects = false;
    protected boolean isOldClient = false;
    protected Map regionSnapshot;
    protected Map txRegionSnapshot;
    protected static final int ENTRY_ADD_OPERATION = 1;
    protected static final int ENTRY_DESTROY_OPERATION = 2;
    protected static final int ENTRY_INVALIDATE_OPERATION = 3;
    protected static final int ENTRY_LOCAL_DESTROY_OPERATION = 4;
    protected static final int ENTRY_LOCAL_INVALIDATE_OPERATION = 5;
    protected static final int ENTRY_UPDATE_OPERATION = 6;
    protected static final int ENTRY_GET_OPERATION = 7;
    protected static final int ENTRY_GET_NEW_OPERATION = 8;
    protected static final int ENTRY_MODIFY_VALUE = 9;
    protected static final String getCallbackPrefix = "Get originated in pid ";
    protected static final String createCallbackPrefix = "Create event originated in pid ";
    protected static final String updateCallbackPrefix = "Update event originated in pid ";
    protected static final String invalidateCallbackPrefix = "Invalidate event originated in pid ";
    protected static final String destroyCallbackPrefix = "Destroy event originated in pid ";
    protected static final String regionInvalidateCallbackPrefix = "Region invalidate event originated in pid ";
    protected static final String regionDestroyCallbackPrefix = "Region destroy event originated in pid ";
    protected static volatile MethodCoordinator concVerifyCoordinator;

    public static synchronized void HydraTask_initializeClient() {
        if (testInstance == null) {
            testInstance = new CQTest();
            testInstance.initializeInstance();
            if (CQTest.testInstance.isBridgeConfiguration) {
                CQTest.testInstance.isBridgeClient = true;
                CQTest.testInstance.isOldClient = GemFireVersion.getGemFireVersion().equals("6.1.2");
            }
            CQTest.testInstance.aRegion = testInstance.initializeRegion("clientRegion");
            if (CQTest.testInstance.isBridgeConfiguration) {
                CQTest.registerInterest(CQTest.testInstance.aRegion);
                if (CQsOn) {
                    testInstance.initializeQueryService();
                    CQTest.testInstance.queryMap = testInstance.generateQueries(CQTest.testInstance.queryDepth);
                    testInstance.initializeCQs();
                } else {
                    Log.getLogWriter().info("Not creating CQs because CQUtilPrms.CQsOn is " + CQsOn);
                }
            }
        }
        CQTest.testInstance.uniqueKeyIndex.set(new Integer(RemoteTestModule.getCurrentThread().getThreadId()));
    }

    public static synchronized void HydraTask_initializeClient1() {
        if (testInstance == null) {
            testInstance = new CQTest();
            testInstance.initializeInstance();
            CQTest.testInstance.aRegion = testInstance.initializeRegion("clientRegion1");
            if (CQTest.testInstance.isBridgeConfiguration) {
                CQTest.testInstance.isBridgeClient = true;
                CQTest.registerInterest(CQTest.testInstance.aRegion);
                if (CQsOn) {
                    testInstance.initializeQueryService();
                    CQTest.testInstance.queryMap = testInstance.generateQueries(CQTest.testInstance.queryDepth);
                    testInstance.initializeCQs();
                } else {
                    Log.getLogWriter().info("Not creating CQs because CQUtilPrms.CQsOn is " + CQsOn);
                }
            }
        }
        CQTest.testInstance.uniqueKeyIndex.set(new Integer(RemoteTestModule.getCurrentThread().getThreadId()));
    }

    public static synchronized void HydraTask_initializeClient2() {
        if (testInstance == null) {
            testInstance = new CQTest();
            testInstance.initializeInstance();
            CQTest.testInstance.aRegion = testInstance.initializeRegion("clientRegion2");
            if (CQTest.testInstance.isBridgeConfiguration) {
                CQTest.testInstance.isBridgeClient = true;
                CQTest.registerInterest(CQTest.testInstance.aRegion);
                if (CQsOn) {
                    testInstance.initializeQueryService();
                    CQTest.testInstance.queryMap = testInstance.generateQueries(CQTest.testInstance.queryDepth);
                    testInstance.initializeCQs();
                } else {
                    Log.getLogWriter().info("Not creating CQs because CQUtilPrms.CQsOn is " + CQsOn);
                }
            }
        }
        CQTest.testInstance.uniqueKeyIndex.set(new Integer(RemoteTestModule.getCurrentThread().getThreadId()));
    }

    public static synchronized void HydraTask_initializeBridgeServer() {
        if (testInstance == null) {
            testInstance = new CQTest();
            testInstance.initializeInstance();
            CQTest.testInstance.aRegion = testInstance.initializeRegion("serverRegion");
            BridgeHelper.startBridgeServer("bridge");
            CQTest.testInstance.isBridgeClient = false;
        }
        CQTest.testInstance.uniqueKeyIndex.set(new Integer(RemoteTestModule.getCurrentThread().getThreadId()));
    }

    public static synchronized void HydraTask_initializeAccessorServer1() {
        if (testInstance == null) {
            testInstance = new CQTest();
            testInstance.initializeInstance();
            CQTest.testInstance.aRegion = testInstance.initializeRegion("serverAccessor");
            BridgeHelper.startBridgeServer("bridge1");
            CQTest.testInstance.isBridgeClient = false;
        }
        CQTest.testInstance.uniqueKeyIndex.set(new Integer(RemoteTestModule.getCurrentThread().getThreadId()));
    }

    public static synchronized void HydraTask_initializeAccessorServer2() {
        if (testInstance == null) {
            testInstance = new CQTest();
            testInstance.initializeInstance();
            CQTest.testInstance.aRegion = testInstance.initializeRegion("serverAccessor");
            BridgeHelper.startBridgeServer("bridge2");
            CQTest.testInstance.isBridgeClient = false;
        }
        CQTest.testInstance.uniqueKeyIndex.set(new Integer(RemoteTestModule.getCurrentThread().getThreadId()));
    }

    public static synchronized void HydraTask_initializeServer1() {
        if (testInstance == null) {
            testInstance = new CQTest();
            testInstance.initializeInstance();
            CQTest.testInstance.aRegion = testInstance.initializeRegion("serverDataHost");
            BridgeHelper.startBridgeServer("bridge1");
            CQTest.testInstance.isBridgeClient = false;
        }
        CQTest.testInstance.uniqueKeyIndex.set(new Integer(RemoteTestModule.getCurrentThread().getThreadId()));
    }

    public static synchronized void HydraTask_initializeServer2() {
        if (testInstance == null) {
            testInstance = new CQTest();
            testInstance.initializeInstance();
            CQTest.testInstance.aRegion = testInstance.initializeRegion("serverDataHost");
            BridgeHelper.startBridgeServer("bridge2");
            CQTest.testInstance.isBridgeClient = false;
        }
        CQTest.testInstance.uniqueKeyIndex.set(new Integer(RemoteTestModule.getCurrentThread().getThreadId()));
    }

    public static synchronized void HydraTask_initializeDataHostServer() {
        if (testInstance == null) {
            testInstance = new CQTest();
            testInstance.initializeInstance();
            CQTest.testInstance.aRegion = testInstance.initializeRegion("serverDataHost");
            BridgeHelper.startBridgeServer("bridge3");
            CQTest.testInstance.isBridgeClient = false;
        }
        CQTest.testInstance.uniqueKeyIndex.set(new Integer(RemoteTestModule.getCurrentThread().getThreadId()));
    }

    public static void HydraTask_missingJarTest() {
        try {
            CQTest.HydraTask_initializeClient();
            Log.getLogWriter().info("Expected NoClassDefFoundError due to missing antlr jar on CLASSPATH " + TestHelper.getStackTrace());
            throw new TestException(TestHelper.getStackTrace("Expected NoClassDefFoundError due to missing antlr jar on CLASSPATH"));
        }
        catch (NoClassDefFoundError e) {
            if (e.toString().indexOf("antlr/TokenStream") >= 0 || e.toString().indexOf("antlr.TokenStream") >= 0) {
                Log.getLogWriter().info("Caught expected exception " + e);
            }
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (Exception e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
    }

    public Region initializeRegion(String regDescriptName) {
        Region aRegion = versionHelperInstance.initializeRegion(regDescriptName);
        CQTestVersionHelper.setTxMgr();
        return aRegion;
    }

    public void initializeQueryService() {
        Log.getLogWriter().info("Creating QueryService.");
        versionHelperInstance.initializeQueryService();
    }

    public void initializeInstance() {
        Integer anInt = Integer.getInteger("numThreads");
        if (anInt != null) {
            this.numThreadsInThisVM = anInt;
        }
        this.numThreadsInClients = TestHelper.getNumThreads();
        CQsOn = TestConfig.tab().booleanAt(CQUtilPrms.CQsOn, true);
        this.isSerialExecution = TestConfig.tab().booleanAt(Prms.serialExecution);
        this.highAvailability = TestConfig.tab().booleanAt(CQUtilPrms.highAvailability, false);
        this.upperThreshold = TestConfig.tab().intAt(CQUtilPrms.upperThreshold, Integer.MAX_VALUE);
        this.lowerThreshold = TestConfig.tab().intAt(CQUtilPrms.lowerThreshold, -1);
        this.numOpsPerTask = TestConfig.tab().intAt(CQUtilPrms.numOpsPerTask, Integer.MAX_VALUE);
        this.queryDepth = TestConfig.tab().intAt(CQUtilPrms.queryDepth, 1);
        this.numQueriesPerClientVM = TestConfig.tab().intAt(CQUtilPrms.numQueriesPerClientVM, 10);
        this.uniqueKeys = TestConfig.tab().booleanAt(CQUtilPrms.useUniqueKeys, false);
        this.useDeltaObjects = TestConfig.tab().booleanAt(CQUtilPrms.useDeltaObjects, false);
        this.secondsToRun = TestConfig.tab().intAt(CQUtilPrms.secondsToRun, 1800);
        this.minTaskGranularitySec = TestConfig.tab().longAt(TestHelperPrms.minTaskGranularitySec, Long.MAX_VALUE);
        this.minTaskGranularityMS = this.minTaskGranularitySec == Long.MAX_VALUE ? Long.MAX_VALUE : this.minTaskGranularitySec * 1000L;
        HydraVector bridgeNames = TestConfig.tab().vecAt(BridgePrms.names, null);
        this.isBridgeConfiguration = bridgeNames != null;
        this.regionSnapshot = new HashMap();
        CQUtilBB.getBB().getSharedMap().put("RegionSnapshot", this.regionSnapshot);
        versionHelperInstance = new CQTestVersionHelper(this);
    }

    public void initializeCQs() {
        CqAttributesFactory cqFac = new CqAttributesFactory();
        cqFac.addCqListener((CqListener)new CQGatherListener());
        CqAttributes cqAttr = cqFac.create();
        for (String queryName : this.queryMap.keySet()) {
            String query = (String)this.queryMap.get(queryName);
            try {
                Log.getLogWriter().info("Creating CQ with name " + queryName + ": " + query + ", cq attributes: " + cqAttr);
                CqQuery cq = this.qService.newCq(queryName, query, cqAttr);
                Log.getLogWriter().info("Calling executeWithInitialResults on " + cq);
                SelectResults sr = new CQExecuteVersionHelper().executeWithInitialResults(cq);
                if (sr != null) continue;
                throw new TestException("For cq " + cq + " with name " + cq.getName() + " executeWithInitialResults returned " + sr);
            }
            catch (CqExistsException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            catch (RegionNotFoundException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            catch (CqException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
        }
    }

    public static void HydraTask_doRROpsAndVerify() {
        PdxTest.initClassLoader();
        testInstance.doRROpsAndVerify();
    }

    public static void HydraTask_load() {
        for (int i = 1; i <= 10; ++i) {
            CQTest.testInstance.aRegion.put((Object)("Object_" + i), (Object)new Integer(i));
        }
    }

    public static void HydraTask_doConcOpsAndVerify() {
        testInstance.doConcOpsAndVerify();
    }

    public static synchronized void HydraTask_executeCQsAndVerify() {
        if (CQsOn) {
            testInstance.verifyQueryResults();
        } else {
            Log.getLogWriter().info("Skipping verification of queries because CQUtilPrms.CQsOn is " + CQsOn);
        }
    }

    public static void HydraTask_HADoEntryOps() {
        PdxTest.initClassLoader();
        testInstance.HADoEntryOps();
    }

    public static void HydraTask_HAController() {
        testInstance.HAController();
    }

    public static void HydraTask_loadToUpperThreshold() {
        testInstance.loadToUpperThreshold();
    }

    public static void HydraTask_recordLoadToBB() {
        testInstance.recordLoadToBB();
    }

    protected Map generateNumericQueries(String fieldName, long minValue, long maxValue, int maxPathLength) {
        GsRandom rand = TestConfig.tab().getRandGen();
        HashMap<String, String> queryMap = new HashMap<String, String>();
        queryMap.put(this.getNextQueryName(), "select * from /testRegion where " + this.getQueryPath(fieldName, maxPathLength) + " < 0");
        queryMap.put(this.getNextQueryName(), "select * from /testRegion where " + this.getQueryPath(fieldName, maxPathLength) + " <= 0");
        queryMap.put(this.getNextQueryName(), "select * from /testRegion where " + this.getQueryPath(fieldName, maxPathLength) + " > 0");
        queryMap.put(this.getNextQueryName(), "select * from /testRegion where " + this.getQueryPath(fieldName, maxPathLength) + " >= 0");
        queryMap.put(this.getNextQueryName(), "select * from /testRegion where " + this.getQueryPath(fieldName, maxPathLength) + " = 0");
        queryMap.put(this.getNextQueryName(), "select * from /testRegion where " + this.getQueryPath(fieldName, maxPathLength) + " <> 0");
        queryMap.put(this.getNextQueryName(), "select * from /testRegion where " + this.getQueryPath(fieldName, maxPathLength) + " < " + rand.nextLong(minValue, maxValue));
        queryMap.put(this.getNextQueryName(), "select * from /testRegion where " + this.getQueryPath(fieldName, maxPathLength) + " <= " + rand.nextLong(minValue, maxValue));
        queryMap.put(this.getNextQueryName(), "select * from /testRegion where " + this.getQueryPath(fieldName, maxPathLength) + " > " + rand.nextLong(minValue, maxValue));
        queryMap.put(this.getNextQueryName(), "select * from /testRegion where " + this.getQueryPath(fieldName, maxPathLength) + " >= " + rand.nextLong(minValue, maxValue));
        queryMap.put(this.getNextQueryName(), "select * from /testRegion where " + this.getQueryPath(fieldName, maxPathLength) + " = " + rand.nextLong(minValue, maxValue));
        queryMap.put(this.getNextQueryName(), "select * from /testRegion where " + this.getQueryPath(fieldName, maxPathLength) + " <> " + rand.nextLong(minValue, maxValue));
        return queryMap;
    }

    protected Map generateStringQueries(String fieldName, int maxPathLength) {
        GsRandom rand = TestConfig.tab().getRandGen();
        HashMap<String, String> queryMap = new HashMap<String, String>();
        RandomValues rv = new RandomValues();
        queryMap.put(this.getNextQueryName(), "select * from /testRegion where " + this.getQueryPath(fieldName, maxPathLength) + " < ''");
        queryMap.put(this.getNextQueryName(), "select * from /testRegion where " + this.getQueryPath(fieldName, maxPathLength) + " <= ''");
        queryMap.put(this.getNextQueryName(), "select * from /testRegion where " + this.getQueryPath(fieldName, maxPathLength) + " > ''");
        queryMap.put(this.getNextQueryName(), "select * from /testRegion where " + this.getQueryPath(fieldName, maxPathLength) + " >= ''");
        queryMap.put(this.getNextQueryName(), "select * from /testRegion where " + this.getQueryPath(fieldName, maxPathLength) + " = ''");
        queryMap.put(this.getNextQueryName(), "select * from /testRegion where " + this.getQueryPath(fieldName, maxPathLength) + " <> ''");
        queryMap.put(this.getNextQueryName(), "select * from /testRegion where " + this.getQueryPath(fieldName, maxPathLength) + " < '" + rv.getRandom_String('\'', -1) + "'");
        queryMap.put(this.getNextQueryName(), "select * from /testRegion where " + this.getQueryPath(fieldName, maxPathLength) + " <= '" + rv.getRandom_String('\'', -1) + "'");
        queryMap.put(this.getNextQueryName(), "select * from /testRegion where " + this.getQueryPath(fieldName, maxPathLength) + " > '" + rv.getRandom_String('\'', -1) + "'");
        queryMap.put(this.getNextQueryName(), "select * from /testRegion where " + this.getQueryPath(fieldName, maxPathLength) + " >= '" + rv.getRandom_String('\'', -1) + "'");
        queryMap.put(this.getNextQueryName(), "select * from /testRegion where " + this.getQueryPath(fieldName, maxPathLength) + " = '" + rv.getRandom_String('\'', -1) + "'");
        queryMap.put(this.getNextQueryName(), "select * from /testRegion where " + this.getQueryPath(fieldName, maxPathLength) + " <> '" + rv.getRandom_String('\'', -1) + "'");
        return queryMap;
    }

    protected Map generateCharacterQueries(String fieldName, int maxPathLength) {
        GsRandom rand = TestConfig.tab().getRandGen();
        HashMap<String, String> queryMap = new HashMap<String, String>();
        RandomValues rv = new RandomValues();
        queryMap.put(this.getNextQueryName(), "select * from /testRegion where " + this.getQueryPath(fieldName, maxPathLength) + " < CHAR '" + rv.getRandom_String('\'', 1) + "'");
        queryMap.put(this.getNextQueryName(), "select * from /testRegion where " + this.getQueryPath(fieldName, maxPathLength) + " <= CHAR '" + rv.getRandom_String('\'', 1) + "'");
        queryMap.put(this.getNextQueryName(), "select * from /testRegion where " + this.getQueryPath(fieldName, maxPathLength) + " > CHAR '" + rv.getRandom_String('\'', 1) + "'");
        queryMap.put(this.getNextQueryName(), "select * from /testRegion where " + this.getQueryPath(fieldName, maxPathLength) + " >= CHAR '" + rv.getRandom_String('\'', 1) + "'");
        queryMap.put(this.getNextQueryName(), "select * from /testRegion where " + this.getQueryPath(fieldName, maxPathLength) + " = CHAR '" + rv.getRandom_String('\'', 1) + "'");
        queryMap.put(this.getNextQueryName(), "select * from /testRegion where " + this.getQueryPath(fieldName, maxPathLength) + " <> CHAR '" + rv.getRandom_String('\'', 1) + "'");
        return queryMap;
    }

    protected Map generateBorderCaseQueries(int maxPathLength) {
        GsRandom rand = TestConfig.tab().getRandGen();
        HashMap<String, String> queryMap = new HashMap<String, String>();
        RandomValues rv = new RandomValues();
        String[] ops = new String[]{"=", "<", ">", "<=", ">=", "<>", "!="};
        for (int i = 0; i < ops.length; ++i) {
            String op = ops[i];
            queryMap.put(this.getNextQueryName(), "select * from /testRegion where " + this.getQueryPath("aPrimitiveLong", maxPathLength) + " " + op + " L" + rv.getRandom_longBorderCase());
            queryMap.put(this.getNextQueryName(), "select * from /testRegion where " + this.getQueryPath("aLong", maxPathLength) + " " + op + " L" + rv.getRandom_longBorderCase());
            queryMap.put(this.getNextQueryName(), "select * from /testRegion where " + this.getQueryPath("aPrimitiveInt", maxPathLength) + " " + op + " " + rv.getRandom_intBorderCase());
            queryMap.put(this.getNextQueryName(), "select * from /testRegion where " + this.getQueryPath("anInteger", maxPathLength) + " " + op + " " + rv.getRandom_intBorderCase());
            queryMap.put(this.getNextQueryName(), "select * from /testRegion where " + this.getQueryPath("aPrimitiveShort", maxPathLength) + " " + op + " " + rv.getRandom_shortBorderCase());
            queryMap.put(this.getNextQueryName(), "select * from /testRegion where " + this.getQueryPath("aShort", maxPathLength) + " " + op + " " + rv.getRandom_shortBorderCase());
            queryMap.put(this.getNextQueryName(), "select * from /testRegion where " + this.getQueryPath("aPrimitiveFloat", maxPathLength) + " " + op + " " + rv.getRandom_floatBorderCase());
            queryMap.put(this.getNextQueryName(), "select * from /testRegion where " + this.getQueryPath("aFloat", maxPathLength) + " " + op + " " + rv.getRandom_floatBorderCase());
            queryMap.put(this.getNextQueryName(), "select * from /testRegion where " + this.getQueryPath("aPrimitiveDouble", maxPathLength) + " " + op + " " + rv.getRandom_doubleBorderCase());
            queryMap.put(this.getNextQueryName(), "select * from /testRegion where " + this.getQueryPath("aDouble", maxPathLength) + " " + op + " " + rv.getRandom_doubleBorderCase());
            queryMap.put(this.getNextQueryName(), "select * from /testRegion where " + this.getQueryPath("aPrimitiveByte", maxPathLength) + " " + op + " " + rv.getRandom_byteBorderCase());
            queryMap.put(this.getNextQueryName(), "select * from /testRegion where " + this.getQueryPath("aByte", maxPathLength) + " " + op + " " + rv.getRandom_byteBorderCase());
            queryMap.put(this.getNextQueryName(), "select * from /testRegion where " + this.getQueryPath("aPrimitiveChar", maxPathLength) + " " + op + " CHAR '" + rv.getRandom_charBorderCase() + "'");
            queryMap.put(this.getNextQueryName(), "select * from /testRegion where " + this.getQueryPath("aCharacter", maxPathLength) + " " + op + " CHAR '" + rv.getRandom_charBorderCase() + "'");
            queryMap.put(this.getNextQueryName(), "select * from /testRegion where " + this.getQueryPath("aString", maxPathLength) + " " + op + " '" + rv.getRandom_StringBorderCase() + "'");
            queryMap.put(this.getNextQueryName(), "select * from /testRegion where " + this.getQueryPath("aString", maxPathLength) + " " + op + " '" + rv.getRandom_StringBorderCase() + "'");
        }
        return queryMap;
    }

    protected Map generateNullQueries(int maxPathLength) {
        HashMap<String, String> queryMap = new HashMap<String, String>();
        String[] nonPrimFields = new String[]{"aLong", "anInteger", "aShort", "aFloat", "aDouble", "aByte", "aCharacter", "aString", "aQueryObject"};
        for (int i = 0; i < nonPrimFields.length; ++i) {
            String fieldName = nonPrimFields[i];
            queryMap.put(this.getNextQueryName(), "select * from /testRegion where " + this.getQueryPath(fieldName, maxPathLength) + " < NULL");
            queryMap.put(this.getNextQueryName(), "select * from /testRegion where " + this.getQueryPath(fieldName, maxPathLength) + " <= NULL");
            queryMap.put(this.getNextQueryName(), "select * from /testRegion where " + this.getQueryPath(fieldName, maxPathLength) + " > NULL");
            queryMap.put(this.getNextQueryName(), "select * from /testRegion where " + this.getQueryPath(fieldName, maxPathLength) + " >= NULL");
            queryMap.put(this.getNextQueryName(), "select * from /testRegion where " + this.getQueryPath(fieldName, maxPathLength) + " = NULL");
            queryMap.put(this.getNextQueryName(), "select * from /testRegion where " + this.getQueryPath(fieldName, maxPathLength) + " <> NULL");
        }
        return queryMap;
    }

    public Map generateQueries(int maxQueryDepth) {
        HashMap<String, String> aMap = new HashMap<String, String>();
        aMap.putAll(this.generateNumericQueries("aPrimitiveLong", -500L, 500L, maxQueryDepth));
        aMap.putAll(this.generateNumericQueries("aLong", -500L, 500L, maxQueryDepth));
        aMap.putAll(this.generateNumericQueries("aPrimitiveInt", -500L, 500L, maxQueryDepth));
        aMap.putAll(this.generateNumericQueries("anInteger", -500L, 500L, maxQueryDepth));
        aMap.putAll(this.generateNumericQueries("aPrimitiveShort", -500L, 500L, maxQueryDepth));
        aMap.putAll(this.generateNumericQueries("aShort", -500L, 500L, maxQueryDepth));
        aMap.putAll(this.generateNumericQueries("aPrimitiveFloat", -500L, 500L, maxQueryDepth));
        aMap.putAll(this.generateNumericQueries("aFloat", -500L, 500L, maxQueryDepth));
        aMap.putAll(this.generateNumericQueries("aPrimitiveDouble", -500L, 500L, maxQueryDepth));
        aMap.putAll(this.generateNumericQueries("aDouble", -500L, 500L, maxQueryDepth));
        aMap.putAll(this.generateNumericQueries("aPrimitiveByte", -128L, 127L, maxQueryDepth));
        aMap.putAll(this.generateNumericQueries("aByte", -128L, 127L, maxQueryDepth));
        aMap.putAll(this.generateStringQueries("aString", maxQueryDepth));
        aMap.putAll(this.generateCharacterQueries("aCharacter", maxQueryDepth));
        aMap.putAll(this.generateCharacterQueries("aPrimitiveChar", maxQueryDepth));
        aMap.put(this.getNextQueryName(), "select * from /testRegion");
        aMap.put(this.getNextQueryName(), "select * from /testRegion entry where entry = NULL");
        aMap.putAll(this.generateNullQueries(maxQueryDepth));
        HashMap<String, String> queryMap = aMap;
        if (this.numQueriesPerClientVM >= 0) {
            GsRandom rand = TestConfig.tab().getRandGen();
            ArrayList aList = new ArrayList(queryMap.keySet());
            queryMap = new HashMap();
            while (queryMap.size() < this.numQueriesPerClientVM && aList.size() > 0) {
                int randInt = rand.nextInt(0, aList.size() - 1);
                Object key = aList.get(randInt);
                queryMap.put((String)key, (String)aMap.get(key));
                aList.remove(randInt);
            }
            Log.getLogWriter().info("Randomly selected " + queryMap.size() + " queries, " + aList.size() + " queries were rejected");
        }
        StringBuffer aStr = new StringBuffer();
        aStr.append("Selected " + queryMap.size() + " queries\n");
        for (Object key : queryMap.keySet()) {
            String value = (String)queryMap.get(key);
            aStr.append("Query name: " + key + ", query: " + CQTest.getReadableQueryString(value) + "\n");
        }
        Log.getLogWriter().info(aStr.toString());
        return queryMap;
    }

    protected String getQueryPath(String fieldName, int maxPathLength) {
        int pathLength = TestConfig.tab().getRandGen().nextInt(1, maxPathLength);
        String queryPath = fieldName;
        for (int i = 2; i <= pathLength; ++i) {
            queryPath = "aQueryObject." + queryPath;
        }
        return queryPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRROpsAndVerify() {
        try {
            CQTest.logExecutionNumber();
            long roundPosition = CQUtilBB.getBB().getSharedCounters().incrementAndRead(CQUtilBB.RoundPosition);
            Log.getLogWriter().info("In doRROpsAndVerify, roundPosition is " + roundPosition);
            this.regionSnapshot = CQUtilBB.getSnapshot();
            if (roundPosition == (long)this.numThreadsInClients) {
                Log.getLogWriter().info("In doRROpsAndVerify, last in round");
                this.verifyRegionContents();
                if (this.isBridgeClient) {
                    if (CQsOn) {
                        this.verifyQueryResults();
                    } else {
                        Log.getLogWriter().info("Skipping verification of queries because CQUtilPrms.CQsOn is " + CQsOn);
                    }
                } else {
                    Log.getLogWriter().info("No queries to verify in bridge server, region size is " + this.aRegion.size());
                }
                CQUtilBB.getBB().getSharedCounters().zero(CQUtilBB.RoundPosition);
                roundPosition = CQUtilBB.getBB().getSharedCounters().incrementAndRead(CQUtilBB.RoundPosition);
            }
            if (roundPosition == 1L) {
                long roundNumber = CQUtilBB.getBB().getSharedCounters().incrementAndRead(CQUtilBB.RoundNumber);
                Log.getLogWriter().info("In doRROpsAndVerify, first in round, round number " + roundNumber);
                List threads = null;
                List vmList = null;
                if (this.highAvailability) {
                    int numVMsToStop = TestConfig.tab().intAt(StopStartPrms.numVMsToStop);
                    Object[] tmpArr = StopStartVMs.getOtherVMs(numVMsToStop, "bridge");
                    vmList = (List)tmpArr[0];
                    List stopModeList = (List)tmpArr[1];
                    threads = StopStartVMs.stopStartAsync(vmList, stopModeList);
                }
                this.doEntryOperations(this.aRegion);
                if (this.highAvailability) {
                    StopStartVMs.joinStopStart(vmList, threads);
                }
                if (this.isBridgeConfiguration) {
                    SilenceListener.waitForSilence(30L, 5000L);
                }
                Log.getLogWriter().info("Writing regionSnapshot to blackboard, snapshot size is " + this.regionSnapshot.size() + ": " + this.regionSnapshot);
                CQUtilBB.putSnapshot(this.regionSnapshot);
            } else if (roundPosition != (long)this.numThreadsInClients) {
                this.regionSnapshot = CQUtilBB.getSnapshot();
                Log.getLogWriter().info("In doRROpsAndVerify, neither first nor last");
                this.verifyRegionContents();
                if (this.isBridgeClient) {
                    if (CQsOn) {
                        this.verifyQueryResults();
                    } else {
                        Log.getLogWriter().info("Skipping verification of queries because CQUtilPrms.CQsOn is " + CQsOn);
                    }
                } else {
                    Log.getLogWriter().info("No queries to verify in bridge server");
                }
            }
        }
        finally {
            if (this.isBridgeClient) {
                ClientHelper.release(CQTest.testInstance.aRegion);
            }
        }
    }

    protected void doConcOpsAndVerify() {
        PdxTest.initClassLoader();
        long counter = CQUtilBB.getBB().getSharedCounters().incrementAndRead(CQUtilBB.ReadyToBegin);
        if (counter == 1L) {
            CQTest.logExecutionNumber();
        }
        concVerifyCoordinator = new MethodCoordinator(CQTest.class.getName(), "concVerify");
        CQUtilBB.getBB().getSharedCounters().zero(CQUtilBB.ConcurrentLeader);
        TestHelper.waitForCounter(CQUtilBB.getBB(), "CQUtilBB.ReadyToBegin", CQUtilBB.ReadyToBegin, this.numThreadsInClients, true, -1L, 1000L);
        this.checkForLastIteration();
        Log.getLogWriter().info("Zeroing ShapshotWritten");
        CQUtilBB.getBB().getSharedCounters().zero(CQUtilBB.SnapshotWritten);
        this.doEntryOperations(this.aRegion);
        GemFireCache cache = versionHelperInstance.getCache();
        RebalanceFactory factory = cache.getResourceManager().createRebalanceFactory();
        RebalanceOperation rop = factory.start();
        RebalanceResults results = null;
        try {
            results = rop.getResults();
        }
        catch (InterruptedException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        Log.getLogWriter().info(RebalanceUtil.RebalanceResultsToString(results, "rebalance"));
        Log.getLogWriter().info("Zeroing FinishedVerify");
        CQUtilBB.getBB().getSharedCounters().zero(CQUtilBB.FinishedVerify);
        CQUtilBB.getBB().getSharedCounters().increment(CQUtilBB.Pausing);
        TestHelper.waitForCounter(CQUtilBB.getBB(), "CQUtilBB.Pausing", CQUtilBB.Pausing, this.numThreadsInClients, true, -1L, 5000L);
        Log.getLogWriter().info("Zeroing ReadyToBegin");
        CQUtilBB.getBB().getSharedCounters().zero(CQUtilBB.ReadyToBegin);
        if (this.isBridgeConfiguration) {
            SilenceListener.waitForSilence(30L, 5000L);
        }
        concVerifyCoordinator.executeOnce(this, new Object[0]);
        if (!concVerifyCoordinator.methodWasExecuted()) {
            throw new TestException("Test problem: concVerify did not execute");
        }
        CQUtilBB.getBB().getSharedCounters().increment(CQUtilBB.FinishedVerify);
        TestHelper.waitForCounter(CQUtilBB.getBB(), "CQUtilBB.FinishedVerify", CQUtilBB.FinishedVerify, this.numThreadsInClients, true, -1L, 5000L);
        Log.getLogWriter().info("Zeroing Pausing");
        CQUtilBB.getBB().getSharedCounters().zero(CQUtilBB.Pausing);
        counter = CQUtilBB.getBB().getSharedCounters().read(CQUtilBB.TimeToStop);
        if (counter >= 1L) {
            throw new StopSchedulingOrder("Num executions is " + CQUtilBB.getBB().getSharedCounters().read(CQUtilBB.ExecutionNumber));
        }
    }

    protected void HAController() {
        boolean stopServers;
        CQTest.logExecutionNumber();
        concVerifyCoordinator = new MethodCoordinator(CQTest.class.getName(), "concVerify");
        this.checkForLastIteration();
        CQUtilBB.getBB().getSharedCounters().zero(CQUtilBB.ExceptionCounter);
        CQUtilBB.getBB().getSharedCounters().zero(CQUtilBB.ConcurrentLeader);
        CQUtilBB.getBB().getSharedCounters().zero(CQUtilBB.Reinitialized);
        boolean bl = stopServers = this.isBridgeClient || !this.isBridgeClient && TestConfig.tab().getRandGen().nextInt(1, 100) <= 60;
        if (stopServers) {
            int numVMsToStop = TestConfig.tab().intAt(StopStartPrms.numVMsToStop);
            Object[] tmpArr = StopStartVMs.getOtherVMs(numVMsToStop, "bridge");
            List vmList = (List)tmpArr[0];
            List stopModeList = (List)tmpArr[1];
            StopStartVMs.stopStartVMs(vmList, stopModeList);
        } else {
            if (TestConfig.tab().getRandGen().nextBoolean()) {
                Log.getLogWriter().info("Closing the cache...");
                this.cacheIsClosed = true;
                versionHelperInstance.closeCache();
            } else {
                Log.getLogWriter().info("Disconnecting from the distributed system...");
                this.disconnected = true;
                DistributedSystemHelper.disconnect();
            }
            TestHelper.waitForCounter(CQUtilBB.getBB(), "CQUtilBB.ExceptionCounter", CQUtilBB.ExceptionCounter, this.numThreadsInThisVM - 1, true, -1L, 1000L);
            Log.getLogWriter().info("Recreating the region...");
            CQTest.testInstance.aRegion = testInstance.initializeRegion("serverRegion");
            Log.getLogWriter().info("Done recreating the region...");
            BridgeHelper.startBridgeServer("bridge");
            CQUtilBB.getBB().getSharedCounters().increment(CQUtilBB.Reinitialized);
        }
        CQUtilBB.getBB().getSharedCounters().zero(CQUtilBB.SnapshotWritten);
        CQUtilBB.getBB().getSharedCounters().zero(CQUtilBB.FinishedVerify);
        this.cacheIsClosed = false;
        this.disconnected = false;
        CQUtilBB.getBB().getSharedCounters().increment(CQUtilBB.Pausing);
        TestHelper.waitForCounter(CQUtilBB.getBB(), "CQUtilBB.Pausing", CQUtilBB.Pausing, this.numThreadsInClients, true, -1L, 5000L);
        CQUtilBB.getBB().getSharedCounters().zero(CQUtilBB.SyncUp);
        if (this.isBridgeConfiguration) {
            SilenceListener.waitForSilence(30L, 5000L);
        }
        PdxTest.initClassLoader();
        concVerifyCoordinator.executeOnce(this, new Object[0]);
        if (!concVerifyCoordinator.methodWasExecuted()) {
            throw new TestException("Test problem: concVerify did not execute");
        }
        CQUtilBB.getBB().getSharedCounters().increment(CQUtilBB.FinishedVerify);
        TestHelper.waitForCounter(CQUtilBB.getBB(), "CQUtilBB.FinishedVerify", CQUtilBB.FinishedVerify, this.numThreadsInClients, true, -1L, 5000L);
        CQUtilBB.getBB().getSharedCounters().zero(CQUtilBB.Pausing);
        CQUtilBB.getBB().getSharedCounters().increment(CQUtilBB.SyncUp);
        TestHelper.waitForCounter(CQUtilBB.getBB(), "CQUtilBB.SyncUp", CQUtilBB.SyncUp, this.numThreadsInClients, true, -1L, 1000L);
        long counter = CQUtilBB.getBB().getSharedCounters().read(CQUtilBB.TimeToStop);
        if (counter >= 1L) {
            throw new StopSchedulingOrder("Num HAController executions is " + CQUtilBB.getBB().getSharedCounters().read(CQUtilBB.ExecutionNumber));
        }
    }

    protected void HADoEntryOps() {
        this.checkForLastIteration();
        try {
            testInstance.doEntryOperations(CQTest.testInstance.aRegion);
            if (CQUtilBB.getBB().getSharedCounters().read(CQUtilBB.Pausing) > 0L) {
                CQUtilBB.getBB().getSharedCounters().increment(CQUtilBB.Pausing);
                TestHelper.waitForCounter(CQUtilBB.getBB(), "CQUtilBB.Pausing", CQUtilBB.Pausing, this.numThreadsInClients, true, -1L, 5000L);
                if (this.isBridgeConfiguration) {
                    SilenceListener.waitForSilence(30L, 5000L);
                }
                concVerifyCoordinator.executeOnce(this, new Object[0]);
                if (!concVerifyCoordinator.methodWasExecuted()) {
                    throw new TestException("Test problem: concVerify did not execute");
                }
                CQUtilBB.getBB().getSharedCounters().increment(CQUtilBB.FinishedVerify);
                TestHelper.waitForCounter(CQUtilBB.getBB(), "CQUtilBB.FinishedVerify", CQUtilBB.FinishedVerify, this.numThreadsInClients, true, -1L, 5000L);
                CQUtilBB.getBB().getSharedCounters().zero(CQUtilBB.Pausing);
                concVerifyCoordinator = new MethodCoordinator(CQTest.class.getName(), "concVerify");
                CQUtilBB.getBB().getSharedCounters().increment(CQUtilBB.SyncUp);
                TestHelper.waitForCounter(CQUtilBB.getBB(), "CQUtilBB.SyncUp", CQUtilBB.SyncUp, this.numThreadsInClients, true, -1L, 1000L);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    protected void doEntryOperations(Region aRegion) {
        versionHelperInstance.doEntryOperations(aRegion);
    }

    protected void doRandomOp(Region aRegion) {
        int whichOp = this.getOperation(aRegion);
        switch (whichOp) {
            case 1: {
                this.addEntry(aRegion);
                break;
            }
            case 3: {
                this.invalidateEntry(aRegion, false);
                break;
            }
            case 2: {
                this.destroyEntry(aRegion, false);
                break;
            }
            case 6: {
                this.updateEntry(aRegion);
                break;
            }
            case 7: {
                this.getKey(aRegion);
                break;
            }
            case 8: {
                this.getNewKey(aRegion);
                break;
            }
            case 5: {
                this.invalidateEntry(aRegion, true);
                break;
            }
            case 4: {
                this.destroyEntry(aRegion, true);
                break;
            }
            case 9: {
                this.modifyValue(aRegion);
                break;
            }
            default: {
                throw new TestException("Unknown operation " + whichOp);
            }
        }
    }

    protected int getOperation(Region reg) {
        int op = -1;
        int size = this.aRegion.size();
        op = this.isBridgeConfiguration ? (this.isBridgeClient ? (size >= this.upperThreshold ? this.getOperation(CQUtilPrms.upperThresholdClientOperations) : (size <= this.lowerThreshold ? this.getOperation(CQUtilPrms.lowerThresholdClientOperations) : this.getOperation(CQUtilPrms.clientEntryOperations))) : (size >= this.upperThreshold ? this.getOperation(CQUtilPrms.upperThresholdServerOperations) : (size <= this.lowerThreshold ? this.getOperation(CQUtilPrms.lowerThresholdServerOperations) : this.getOperation(CQUtilPrms.serverEntryOperations)))) : (size >= this.upperThreshold ? this.getOperation(CQUtilPrms.upperThresholdOperations) : (size <= this.lowerThreshold ? this.getOperation(CQUtilPrms.lowerThresholdOperations) : this.getOperation(CQUtilPrms.entryOperations)));
        return op;
    }

    protected void loadToUpperThreshold() {
        int logIntervalMS = 10000;
        long startTime = System.currentTimeMillis();
        long lastLogTime = System.currentTimeMillis();
        int upperThreshold = TestConfig.tab().intAt(CQUtilPrms.upperThreshold);
        Log.getLogWriter().info("Loading region to size " + upperThreshold + ", current region size is " + this.aRegion.size());
        while (this.aRegion.size() < upperThreshold) {
            if (System.currentTimeMillis() - lastLogTime >= (long)logIntervalMS) {
                Log.getLogWriter().info("Loading region to size " + upperThreshold + ", current region size is " + this.aRegion.size());
                lastLogTime = System.currentTimeMillis();
            }
            this.addEntry(this.aRegion);
            if (System.currentTimeMillis() - startTime < this.minTaskGranularityMS) continue;
        }
        if (this.aRegion.size() >= upperThreshold) {
            String aStr = "Finished loadToUpperThreshold, " + this.aRegion.getFullPath() + " is size " + this.aRegion.size();
            Log.getLogWriter().info(aStr);
            throw new StopSchedulingTaskOnClientOrder(aStr);
        }
    }

    protected void recordLoadToBB() {
        long concurrentLeader = CQUtilBB.getBB().getSharedCounters().incrementAndRead(CQUtilBB.ConcurrentLeader);
        if (concurrentLeader == 1L) {
            Log.getLogWriter().info("Recording region to blackbloard...");
            this.regionSnapshot = new HashMap();
            for (Object key : this.aRegion.keys()) {
                Object value = this.aRegion.get(key);
                this.regionSnapshot.put(key, PdxTestVersionHelper.toBaseObject(value));
            }
            Log.getLogWriter().info("Writing regionSnapshot to blackboard, snapshot size is " + this.regionSnapshot.size() + ": " + this.regionSnapshot);
            CQUtilBB.putSnapshot(this.regionSnapshot);
        }
    }

    protected Object addEntry(Region aRegion) {
        Object existingKey;
        Object key = this.getNewKey();
        QueryObject anObj = null;
        int randInt = TestConfig.tab().getRandGen().nextInt(1, 100);
        boolean useTransactions = InitImagePrms.useTransactions();
        if (!useTransactions && randInt <= 20 && (existingKey = CQTest.getExistingKey(aRegion, this.uniqueKeys, this.numThreadsInClients)) != null && (anObj = this.toQueryObject(aRegion.get(existingKey))) != null) {
            Log.getLogWriter().info("Object to put is from existing key " + existingKey + ": " + anObj.toStringFull());
            try {
                anObj = (QueryObject)anObj.clone();
                if (anObj instanceof DeltaObject) {
                    ((DeltaObject)anObj).extra = key;
                }
            }
            catch (CloneNotSupportedException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
        }
        if (anObj == null) {
            anObj = this.getValueForKey(key);
        }
        String callback = createCallbackPrefix + ProcessMgr.getProcessId();
        int beforeSize = aRegion.size();
        randInt = TestConfig.tab().getRandGen().nextInt(1, 100);
        if (this.isOldClient) {
            randInt = TestConfig.tab().getRandGen().nextInt(1, 66);
        }
        if (randInt <= 33) {
            if (TestConfig.tab().getRandGen().nextBoolean()) {
                try {
                    Log.getLogWriter().info("operation for " + key + ", addEntry: calling create for key " + key + ", object " + anObj.toStringFull() + " cacheWriterParam is " + callback + ", region is " + aRegion.getFullPath());
                    aRegion.create(key, (Object)anObj, (Object)callback);
                    Log.getLogWriter().info("operation for " + key + ", addEntry: done creating key " + key);
                }
                catch (EntryExistsException e) {
                    if (this.isSerialExecution) {
                        throw new TestException(TestHelper.getStackTrace(e));
                    }
                    Log.getLogWriter().info("Caught " + (Object)((Object)e) + " (expected with concurrent execution); continuing with test");
                }
            } else {
                try {
                    Log.getLogWriter().info("operation for " + key + ", addEntry: calling create for key " + key + ", object " + anObj.toStringFull() + ", region is " + aRegion.getFullPath());
                    aRegion.create(key, (Object)anObj);
                    Log.getLogWriter().info("operation for " + key + ", addEntry: done creating key " + key);
                }
                catch (EntryExistsException e) {
                    if (this.isSerialExecution) {
                        throw new TestException(TestHelper.getStackTrace(e));
                    }
                    Log.getLogWriter().info("Caught " + (Object)((Object)e) + " (expected with concurrent execution); continuing with test");
                }
            }
        } else if (randInt <= 66) {
            Object returnVal = null;
            if (TestConfig.tab().getRandGen().nextBoolean()) {
                Log.getLogWriter().info("operation for " + key + ", addEntry: calling put for key " + key + ", object " + anObj.toStringFull() + " callback is " + callback + ", region is " + aRegion.getFullPath());
                returnVal = aRegion.put(key, (Object)anObj, (Object)callback);
                Log.getLogWriter().info("operation for " + key + ", addEntry: done putting key " + key + ", returnVal is " + returnVal);
            } else {
                Log.getLogWriter().info("operation for " + key + ", addEntry: calling put for key " + key + ", object " + anObj.toStringFull() + ", region is " + aRegion.getFullPath());
                returnVal = aRegion.put(key, (Object)anObj);
                Log.getLogWriter().info("operation for " + key + ", addEntry: done putting key " + key + ", returnVal is " + returnVal);
            }
        } else {
            Log.getLogWriter().info("operation for " + key + ", addEntry: calling putIfAbsent for key " + key + ", object " + anObj.toStringFull() + ", region is " + aRegion.getFullPath());
            Object returnValue = aRegion.putIfAbsent(key, (Object)anObj);
            Log.getLogWriter().info("operation for " + key + ", addEntry: done creating key with putIfAbsent" + key + ", return value is " + returnValue);
        }
        if (this.isSerialExecution) {
            this.regionSnapshot.put(key, PdxTestVersionHelper.toBaseObject(anObj));
        }
        return key;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private QueryObject getValueForKey(Object key) {
        void var2_10;
        Object var2_2 = null;
        if (TestConfig.tab().getRandGen().nextBoolean()) {
            if (this.useDeltaObjects) {
                DeltaObject deltaObject = new DeltaObject(NameFactory.getCounterForName(key), 2, 0, TestConfig.tab().getRandGen().nextInt(1, this.queryDepth));
                deltaObject.extra = key;
                return var2_10;
            } else {
                String className = TestConfig.tab().stringAt(CQUtilPrms.objectType, null);
                if (className == null) {
                    QueryObject queryObject = new QueryObject(NameFactory.getCounterForName(key), 2, 0, TestConfig.tab().getRandGen().nextInt(1, this.queryDepth));
                    return var2_10;
                } else {
                    if (!className.equals("util.PdxVersionedQueryObject") && !className.equals("util.VersionedQueryObject")) throw new TestException("Unknown value of CQUtilPrms.objectType: " + className);
                    QueryObject queryObject = PdxTest.getVersionedQueryObject(className, NameFactory.getCounterForName(key), 2, 0, TestConfig.tab().getRandGen().nextInt(1, this.queryDepth));
                }
            }
            return var2_10;
        } else if (this.useDeltaObjects) {
            DeltaObject deltaObject = new DeltaObject(NameFactory.getCounterForName(key), 3, 0, TestConfig.tab().getRandGen().nextInt(1, this.queryDepth));
            deltaObject.extra = key;
            return var2_10;
        } else {
            String className = TestConfig.tab().stringAt(CQUtilPrms.objectType, null);
            if (className == null) {
                QueryObject queryObject = new QueryObject(NameFactory.getCounterForName(key), 3, 0, TestConfig.tab().getRandGen().nextInt(1, this.queryDepth));
                return var2_10;
            } else {
                if (!className.equals("util.PdxVersionedQueryObject") && !className.equals("util.VersionedQueryObject")) throw new TestException("Unknown value of CQUtilPrms.objectType: " + className);
                QueryObject queryObject = PdxTest.getVersionedQueryObject(className, NameFactory.getCounterForName(key), 3, 0, TestConfig.tab().getRandGen().nextInt(1, this.queryDepth));
            }
        }
        return var2_10;
    }

    protected void invalidateEntry(Region aRegion, boolean isLocalInvalidate) {
        Object key = null;
        if (!this.isOldClient && TestConfig.tab().getRandGen().nextInt(1, 100) <= 50) {
            key = this.getNewKey();
            Log.getLogWriter().info("operation for " + key + ", invalidateEntry: putIfAbsent with null");
            Object returnValue = aRegion.putIfAbsent(key, null);
            Log.getLogWriter().info("operation for " + key + ", invalidateEntry: done with putIfAbsent with null, return value is " + TestHelper.toString(returnValue));
        } else {
            int beforeSize = aRegion.size();
            key = CQTest.getExistingKey(aRegion, this.uniqueKeys, this.numThreadsInClients);
            if (key == null) {
                if (this.isSerialExecution && beforeSize != 0) {
                    throw new TestException("getExistingKey returned " + key + ", but region size is " + beforeSize);
                }
                Log.getLogWriter().info("invalidateEntry: No keys in region");
                return;
            }
            boolean containsKey = aRegion.containsKey(key);
            boolean containsValueForKey = aRegion.containsValueForKey(key);
            Log.getLogWriter().info("containsKey for " + key + ": " + containsKey);
            Log.getLogWriter().info("containsValueForKey for " + key + ": " + containsValueForKey);
            try {
                String callback = invalidateCallbackPrefix + ProcessMgr.getProcessId();
                if (isLocalInvalidate) {
                    if (TestConfig.tab().getRandGen().nextBoolean()) {
                        Log.getLogWriter().info("operation for " + key + ", invalidateEntry: local invalidate for " + key + " callback is " + callback);
                        aRegion.localInvalidate(key, (Object)callback);
                        Log.getLogWriter().info("operation for " + key + ", invalidateEntry: done with local invalidate for " + key);
                    } else {
                        Log.getLogWriter().info("operation for " + key + ", invalidateEntry: local invalidate for " + key);
                        aRegion.localInvalidate(key);
                        Log.getLogWriter().info("operation for " + key + ", invalidateEntry: done with local invalidate for " + key);
                    }
                } else if (TestConfig.tab().getRandGen().nextBoolean()) {
                    Log.getLogWriter().info("operation for " + key + ", invalidateEntry: invalidating key " + key + " callback is " + callback);
                    aRegion.invalidate(key, (Object)callback);
                    Log.getLogWriter().info("operation for " + key + ", invalidateEntry: done invalidating key " + key);
                } else {
                    Log.getLogWriter().info("operation for " + key + ", invalidateEntry: invalidating key " + key);
                    aRegion.invalidate(key);
                    Log.getLogWriter().info("operation for " + key + ", invalidateEntry: done invalidating key " + key);
                }
            }
            catch (EntryNotFoundException e) {
                if (this.isSerialExecution) {
                    throw new TestException(TestHelper.getStackTrace(e));
                }
                Log.getLogWriter().info("Caught " + (Object)((Object)e) + " (expected with concurrent execution); continuing with test");
                return;
            }
        }
        if (this.isSerialExecution) {
            this.regionSnapshot.put(key, null);
        }
    }

    protected void destroyEntry(Region aRegion, boolean isLocalDestroy) {
        Object key = CQTest.getExistingKey(aRegion, this.uniqueKeys, this.numThreadsInClients);
        if (key == null) {
            int size = aRegion.size();
            if (this.isSerialExecution && size != 0) {
                throw new TestException("getExistingKey returned " + key + ", but region size is " + size);
            }
            Log.getLogWriter().info("destroyEntry: No keys in region");
            return;
        }
        if (!this.isOldClient && TestConfig.tab().getRandGen().nextInt(1, 100) <= 50) {
            Object value = aRegion.get(key);
            Log.getLogWriter().info("operation for " + key + ", destroyEntry: remove with value " + TestHelper.toString(value));
            boolean returnValue = false;
            try {
                returnValue = aRegion.remove(key, value);
            }
            catch (RuntimeException e) {
                PdxTestVersionHelper.handleException(e);
                return;
            }
            if (this.isSerialExecution && !returnValue) {
                throw new TestException("aRegion.remove(" + key + ", " + value + ") returned " + returnValue + ".  Expected to be successful in serialExecution mode.");
            }
            Log.getLogWriter().info("operation for " + key + ", destroyEntry: done with remove, return value is " + returnValue);
        } else {
            try {
                String callback = destroyCallbackPrefix + ProcessMgr.getProcessId();
                if (isLocalDestroy) {
                    if (TestConfig.tab().getRandGen().nextBoolean()) {
                        Log.getLogWriter().info("operation for " + key + ", destroyEntry: local destroy for " + key + " callback is " + callback);
                        aRegion.localDestroy(key, (Object)callback);
                        Log.getLogWriter().info("operation for " + key + ", destroyEntry: done with local destroy for " + key);
                    } else {
                        Log.getLogWriter().info("operation for " + key + ", destroyEntry: local destroy for " + key);
                        aRegion.localDestroy(key);
                        Log.getLogWriter().info("operation for " + key + ", destroyEntry: done with local destroy for " + key);
                    }
                } else if (TestConfig.tab().getRandGen().nextBoolean()) {
                    Log.getLogWriter().info("operation for " + key + ", destroyEntry: destroying key " + key + " callback is " + callback);
                    aRegion.destroy(key, (Object)callback);
                    Log.getLogWriter().info("operation for " + key + ", destroyEntry: done destroying key " + key);
                } else {
                    Log.getLogWriter().info("operation for " + key + ", destroyEntry: destroying key " + key);
                    aRegion.destroy(key);
                    Log.getLogWriter().info("operation for " + key + ", destroyEntry: done destroying key " + key);
                }
            }
            catch (EntryNotFoundException e) {
                if (this.isSerialExecution) {
                    throw new TestException(TestHelper.getStackTrace(e));
                }
                Log.getLogWriter().info("Caught " + (Object)((Object)e) + " (expected with concurrent execution); continuing with test");
                return;
            }
        }
        if (this.isSerialExecution) {
            this.regionSnapshot.remove(key);
        }
    }

    protected void updateEntry(Region aRegion) {
        int randInt;
        Object key = CQTest.getExistingKey(aRegion, this.uniqueKeys, this.numThreadsInClients);
        if (key == null) {
            int size = aRegion.size();
            if (this.isSerialExecution && size != 0) {
                throw new TestException("getExistingKey returned " + key + ", but region size is " + size);
            }
            Log.getLogWriter().info("updateEntry: No keys in region");
            return;
        }
        int beforeSize = aRegion.size();
        QueryObject previousObj = this.toQueryObject(aRegion.get(key));
        QueryObject anObj = null;
        anObj = previousObj == null ? this.getValueForKey(key) : ((randInt = TestConfig.tab().getRandGen().nextInt(1, 100)) <= 33 ? previousObj.modifyWithNewInstance(previousObj.depth(), 4, 1, true, true) : (randInt <= 66 ? previousObj.modifyWithNewInstance(previousObj.depth(), 5, 0, true, true) : previousObj.modifyWithNewInstance(previousObj.depth(), 5, 0, true, true)));
        String callback = updateCallbackPrefix + ProcessMgr.getProcessId();
        Object returnVal = null;
        int randInt2 = TestConfig.tab().getRandGen().nextInt(1, 100);
        if (!this.isOldClient && randInt2 <= 50) {
            randInt2 = TestConfig.tab().getRandGen().nextInt(1, 100);
            if (randInt2 <= 50) {
                Log.getLogWriter().info("operation for " + key + ", updateEntry: replace(K,V) key " + key + " value " + anObj.toStringFull());
                QueryObject returnValue = this.toQueryObject(aRegion.replace(key, (Object)anObj));
                Log.getLogWriter().info("operation for " + key + ", updateEntry: done with replace(K,V) key " + key + " value " + anObj.toStringFull() + ", return value is " + (returnValue == null ? "null" : returnValue.toStringFull()));
            } else {
                QueryObject oldValue = this.toQueryObject(aRegion.get(key));
                Log.getLogWriter().info("operation for " + key + ", updateEntry: replace(K,V,V) key " + key + " old value " + (oldValue == null ? "null" : oldValue.toStringFull()) + ", new value " + anObj.toStringFull());
                boolean returnValue = false;
                try {
                    returnValue = aRegion.replace(key, (Object)oldValue, (Object)anObj);
                }
                catch (RuntimeException e) {
                    PdxTestVersionHelper.handleException(e);
                    return;
                }
                Log.getLogWriter().info("operation for " + key + ", updateEntry: done with replace(K,V,V) key " + key + " old value " + (oldValue == null ? "null" : oldValue.toStringFull()) + ", new value " + anObj.toStringFull() + ", return value is " + returnValue);
                if (this.isSerialExecution && !returnValue) {
                    throw new TestException("Expected replace(K,V,V) to return true, but it returned " + returnValue);
                }
            }
        } else if (TestConfig.tab().getRandGen().nextBoolean()) {
            Log.getLogWriter().info("operation for " + key + ", updateEntry: putting key " + key + " with " + anObj.toStringFull() + ", callback is " + callback);
            returnVal = aRegion.put(key, (Object)anObj, (Object)callback);
            Log.getLogWriter().info("operation for " + key + ", updateEntry: Done with call to put (update), returnVal is " + returnVal);
        } else {
            Log.getLogWriter().info("operation for " + key + ", updateEntry: putting key " + key + " with " + anObj.toStringFull());
            returnVal = aRegion.put(key, (Object)anObj);
            Log.getLogWriter().info("operation for " + key + ", updateEntry: Done with call to put (update), returnVal is " + returnVal);
        }
        if (this.isSerialExecution) {
            this.regionSnapshot.put(key, PdxTestVersionHelper.toBaseObject(anObj));
        }
    }

    protected void modifyValue(Region aRegion) {
        Object key = CQTest.getExistingKey(aRegion, this.uniqueKeys, this.numThreadsInClients);
        if (key == null) {
            int size = aRegion.size();
            if (this.isSerialExecution && size != 0) {
                throw new TestException("getExistingKey returned " + key + ", but region size is " + size);
            }
            Log.getLogWriter().info("modifyEntry: No keys in region");
            return;
        }
        QueryObject anObj = this.toQueryObject(aRegion.get(key));
        Log.getLogWriter().info("operation for " + key + ", modifyEntry: Modifying " + anObj + "  directly");
        if (TestConfig.tab().getRandGen().nextBoolean()) {
            anObj.modify(anObj.depth(), 4, 1, true, true);
        } else {
            anObj.modify(anObj.depth(), 5, 0, true, true);
        }
        if (this.isSerialExecution) {
            this.regionSnapshot.put(key, PdxTestVersionHelper.toBaseObject(anObj));
        }
    }

    protected void getKey(Region aRegion) {
        Object key = CQTest.getExistingKey(aRegion, this.uniqueKeys, this.numThreadsInClients);
        if (key == null) {
            int size = aRegion.size();
            if (this.isSerialExecution && size != 0) {
                throw new TestException("getExistingKey returned " + key + ", but region size is " + size);
            }
            this.getNewKey(aRegion);
            return;
        }
        String callback = getCallbackPrefix + ProcessMgr.getProcessId();
        int beforeSize = aRegion.size();
        boolean beforeContainsValueForKey = aRegion.containsValueForKey(key);
        try {
            Object anObj;
            if (TestConfig.tab().getRandGen().nextBoolean()) {
                Log.getLogWriter().info("operation for " + key + ", getKey: getting key " + key + ", callback is " + callback);
                anObj = aRegion.get(key, (Object)callback);
                Log.getLogWriter().info("operation for " + key + ", getKey: got value for key " + key + ": " + (anObj == null ? "null" : this.toQueryObject(anObj).toStringFull()));
            } else {
                Log.getLogWriter().info("operation for " + key + ", getKey: getting key " + key);
                anObj = aRegion.get(key);
                Log.getLogWriter().info("operation for " + key + ", getKey: got value for key " + key + ": " + (anObj == null ? "null" : this.toQueryObject(anObj).toStringFull()));
            }
            if (this.isSerialExecution) {
                if (anObj == null) {
                    this.regionSnapshot.put(key, null);
                } else {
                    this.regionSnapshot.put(key, PdxTestVersionHelper.toBaseObject(anObj));
                }
            }
        }
        catch (CacheLoaderException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (TimeoutException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
    }

    protected void getNewKey(Region aRegion) {
        Object key = this.getNewKey();
        String callback = getCallbackPrefix + ProcessMgr.getProcessId();
        try {
            Object anObj;
            if (TestConfig.tab().getRandGen().nextBoolean()) {
                Log.getLogWriter().info("operation for " + key + ", getNewKey: getting new key " + key + ", callback is " + callback);
                anObj = aRegion.get(key, (Object)callback);
            } else {
                Log.getLogWriter().info("operation for " + key + ", getNewKey: getting new key " + key);
                anObj = aRegion.get(key);
            }
            if (anObj == null) {
                Log.getLogWriter().info("operation for " + key + ", getNewKey: done getting value for new key " + key + ": " + anObj);
            } else {
                Log.getLogWriter().info("operation for " + key + ", getNewKey: done getting value for new key " + key + ": " + this.toQueryObject(anObj).toStringFull());
            }
            if (this.isSerialExecution) {
                if (anObj == null) {
                    this.regionSnapshot.put(key, null);
                } else {
                    this.regionSnapshot.put(key, PdxTestVersionHelper.toBaseObject(anObj));
                }
            }
        }
        catch (CacheLoaderException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (TimeoutException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
    }

    protected Object getNewKey() {
        if (this.uniqueKeys) {
            int anInt = (Integer)this.uniqueKeyIndex.get();
            this.uniqueKeyIndex.set(new Integer(anInt += this.numThreadsInClients));
            return NameFactory.getObjectNameForCounter(anInt);
        }
        return NameFactory.getNextPositiveObjectName();
    }

    protected static void logExecutionNumber() {
        long exeNum = CQUtilBB.getBB().getSharedCounters().incrementAndRead(CQUtilBB.ExecutionNumber);
        Log.getLogWriter().info("Beginning task with execution number " + exeNum);
    }

    protected static void registerInterest(Region aRegion) {
        Log.getLogWriter().info("Calling registerInterest for all keys, result interest policy KEYS_VALUES");
        aRegion.registerInterest((Object)"ALL_KEYS", InterestResultPolicy.KEYS_VALUES);
        Log.getLogWriter().info("Done calling registerInterest for all keys, result interest policy KEYS_VALUES, " + aRegion.getFullPath() + " size is " + aRegion.size());
    }

    protected void concVerify() {
        if (CQUtilBB.getBB().getSharedCounters().incrementAndRead(CQUtilBB.ConcurrentLeader) == 1L) {
            Log.getLogWriter().info("In concVerify, this thread is the concurrent leader");
            this.regionSnapshot = new HashMap();
            Log.getLogWriter().info("This thread is the concurrentLeader, creating region snapshot...");
            Set keySet = this.aRegion.keySet();
            for (Object key : keySet) {
                Object value = null;
                if (this.aRegion.containsValueForKey(key)) {
                    value = this.aRegion.get(key);
                }
                this.regionSnapshot.put(key, PdxTestVersionHelper.toBaseObject(value));
            }
            Log.getLogWriter().info("Done creating region snapshot with " + this.regionSnapshot.size() + " entries; " + QueryObject.toStringAbbreviated(this.regionSnapshot));
            CQUtilBB.putSnapshot(this.regionSnapshot);
            long snapshotWritten = CQUtilBB.getBB().getSharedCounters().incrementAndRead(CQUtilBB.SnapshotWritten);
            Log.getLogWriter().info("Incremented SnapshotWritten, now is " + snapshotWritten);
        } else {
            Log.getLogWriter().info("In concVerify, this thread is waiting for the concurrent leader to write the snapshot");
            TestHelper.waitForCounter(CQUtilBB.getBB(), "CQUtilBB.SnapshotWritten", CQUtilBB.SnapshotWritten, 1L, true, -1L, 2000L);
            this.regionSnapshot = CQUtilBB.getSnapshot();
            this.verifyRegionContents();
            if (this.isBridgeClient) {
                if (CQsOn) {
                    this.verifyQueryResults();
                } else {
                    Log.getLogWriter().info("Skipping verification of queries because CQUtilPrms.CQsOn is " + CQsOn);
                }
            } else {
                Log.getLogWriter().info("No queries to verify in bridge server, region size is " + this.aRegion.size());
            }
        }
    }

    protected void verify(CqQuery cq, SelectResults sr) {
        String tmpStr;
        String cqName = cq.getName();
        String queryStr = cq.getQueryString();
        String readableQueryStr = CQTest.getReadableQueryString(queryStr);
        List expectedResults = this.getExpectedResults(queryStr);
        List srList = sr.asList();
        int srListSize = srList.size();
        int srSize = sr.size();
        Log.getLogWriter().info("Verifying query results for " + cqName + ": " + readableQueryStr + ", SelectResults is size " + sr.size());
        if (srListSize != srSize) {
            throw new TestException("selectResults.size() is " + srSize + ", but selectResults.asList.size() is " + srListSize);
        }
        HashMap gatherMap = new HashMap(CQGatherListener.getGatherMap(cqName));
        Iterator it = gatherMap.keySet().iterator();
        while (it.hasNext()) {
            Object key = it.next();
            if (gatherMap.get(key) != null) continue;
            it.remove();
        }
        Object[] tmp = CQTest.getInconsistencies(expectedResults, srList);
        List unexpectedInSelectResults = (List)tmp[0];
        List missingInSelectResults = (List)tmp[1];
        tmp = CQTest.getInconsistencies(expectedResults, new ArrayList(gatherMap.values()));
        List unexpectedInGatherMap = (List)tmp[0];
        List missingInGatherMap = (List)tmp[1];
        StringBuffer aStr = new StringBuffer();
        if (unexpectedInSelectResults.size() > 0) {
            tmpStr = this.getLocationString(unexpectedInSelectResults, expectedResults, sr, gatherMap) + "\nFound the following " + unexpectedInSelectResults.size() + " unexpected elements in SelectResults for cq " + cqName + ", " + readableQueryStr + ": " + QueryObject.toStringFull(unexpectedInSelectResults);
            Log.getLogWriter().info(tmpStr);
            aStr.append(tmpStr);
        }
        if (missingInSelectResults.size() > 0) {
            tmpStr = this.getLocationString(missingInSelectResults, expectedResults, sr, gatherMap) + "\nThe following " + missingInSelectResults.size() + " elements were missing from SelectResults for cq " + cqName + ", " + readableQueryStr + ": " + QueryObject.toStringFull(missingInSelectResults);
            Log.getLogWriter().info(tmpStr);
            aStr.append(tmpStr);
        }
        if (unexpectedInGatherMap.size() > 0) {
            tmpStr = this.getLocationString(unexpectedInGatherMap, expectedResults, sr, gatherMap) + "\nFound the following " + unexpectedInGatherMap.size() + " unexpected elements in gatherMap for cq " + cqName + ", " + readableQueryStr + ": " + QueryObject.toStringFull(unexpectedInGatherMap);
            Log.getLogWriter().info(tmpStr);
            aStr.append(tmpStr);
        }
        if (missingInGatherMap.size() > 0) {
            tmpStr = this.getLocationString(missingInGatherMap, expectedResults, sr, gatherMap) + "\nThe following " + missingInGatherMap.size() + " elements were missing from gatherMap for cq " + cqName + ", " + readableQueryStr + ": " + QueryObject.toStringFull(missingInGatherMap);
            Log.getLogWriter().info(tmpStr);
            aStr.append(tmpStr);
        }
        int SR_sizeLimitForVerify = 600;
        if (srListSize <= 600) {
            String tmpStr2;
            ArrayList srAsSet_inListForm = new ArrayList(sr.asSet());
            tmp = CQTest.getInconsistencies(expectedResults, srAsSet_inListForm);
            List unexpectedInSet = (List)tmp[0];
            List missingInSet = (List)tmp[1];
            if (unexpectedInSet.size() > 0) {
                tmpStr2 = this.getLocationString(unexpectedInSet, expectedResults, sr, gatherMap) + "\nFound the following " + unexpectedInSet.size() + " unexpected elements in SelectResults.asSet() for cq " + cqName + ", " + readableQueryStr + ": " + QueryObject.toStringFull(unexpectedInSet);
                Log.getLogWriter().info(tmpStr2);
                aStr.append(tmpStr2);
            }
            if (missingInSet.size() > 0) {
                tmpStr2 = this.getLocationString(missingInSet, expectedResults, sr, gatherMap) + "\nThe following " + missingInSet.size() + " elements were missing from SelectResults.asSet for cq " + cqName + ", " + readableQueryStr + ": " + QueryObject.toStringFull(missingInSet);
                Log.getLogWriter().info(tmpStr2);
                aStr.append(tmpStr2);
            }
        } else {
            Log.getLogWriter().info("Skipping validation of SelectResults as a Set because the size is " + srListSize);
        }
        if (aStr.length() > 0) {
            throw new TestException("For cq " + cqName + ", " + readableQueryStr + "\n" + aStr.toString());
        }
        Log.getLogWriter().info("Done verifying query results for " + cqName);
    }

    private static Object[] getInconsistencies(List expected, List listToCheck) {
        ArrayList<Object> aList = new ArrayList<Object>();
        for (Object element : listToCheck) {
            aList.add(PdxTestVersionHelper.toBaseObject(element));
        }
        ArrayList unexpected = new ArrayList(aList);
        ArrayList missing = new ArrayList(expected);
        unexpected.removeAll(expected);
        missing.removeAll(aList);
        return new Object[]{unexpected, missing};
    }

    private String getLocationString(List inconsistencies, List expected, SelectResults selResults, Map gatherMap) {
        StringBuffer aStr = new StringBuffer();
        for (int i = 0; i < inconsistencies.size(); ++i) {
            QueryObject qo;
            QueryObject qo2;
            QueryObject suspect = this.toQueryObject(inconsistencies.get(i));
            boolean found = false;
            for (Object key : this.aRegion.keySet()) {
                Region.Entry entry = this.aRegion.getEntry(key);
                QueryObject qo3 = this.toQueryObject(entry.getValue());
                if (qo3 == null || !qo3.equals(suspect)) continue;
                found = true;
                aStr.append(qo3.toStringAbbreviated() + " was found in " + this.aRegion.getFullPath() + " at key " + key + "\n");
            }
            if (!found) {
                Log.getLogWriter().info("suspect is: " + suspect + " at (i) :" + i + " inconsistencies.size : " + inconsistencies.size());
                aStr.append(suspect.toStringAbbreviated() + " was NOT found in " + this.aRegion.getFullPath() + "\n");
            }
            found = false;
            for (Object key : this.regionSnapshot.keySet()) {
                qo2 = this.toQueryObject(this.regionSnapshot.get(key));
                if (qo2 == null || !qo2.equals(suspect)) continue;
                found = true;
                aStr.append(qo2.toStringAbbreviated() + " was found in regionSnapshot at key " + key + "\n");
            }
            if (!found) {
                aStr.append(suspect.toStringAbbreviated() + " was NOT found in regionSnapshot\n");
            }
            found = false;
            Iterator<Object> it = expected.iterator();
            while (it.hasNext()) {
                qo = this.toQueryObject(it.next());
                if (!qo.equals(suspect)) continue;
                found = true;
                aStr.append(qo.toStringAbbreviated() + " was found in expected results\n");
            }
            if (!found) {
                aStr.append(suspect.toStringAbbreviated() + " was NOT found in expected results\n");
            }
            found = false;
            it = selResults.iterator();
            while (it.hasNext()) {
                qo = this.toQueryObject(it.next());
                if (!qo.equals(suspect)) continue;
                found = true;
                aStr.append(qo.toStringAbbreviated() + " was found in SelectResults\n");
            }
            if (!found) {
                aStr.append(suspect.toStringAbbreviated() + " was NOT found in SelectResults\n");
            }
            found = false;
            for (Object key : gatherMap.keySet()) {
                qo2 = this.toQueryObject(gatherMap.get(key));
                if (!qo2.equals(suspect)) continue;
                found = true;
                aStr.append(qo2.toStringAbbreviated() + " was found in gatherMap at key " + key + "\n");
            }
            if (found) continue;
            aStr.append(suspect.toStringAbbreviated() + " was NOT found in gatherMap\n");
        }
        return aStr.toString();
    }

    protected void verifyRegionContents() {
        String tmpStr;
        Log.getLogWriter().info("Verifying contents of " + this.aRegion.getFullPath() + ", size is " + this.aRegion.size());
        Set regionKeySet = this.aRegion.keySet();
        int regionSize = this.aRegion.size();
        int regionKeySetSize = regionKeySet.size();
        Log.getLogWriter().info("regionSize is " + regionSize + " regionKeySetSize is " + regionKeySetSize);
        if (regionSize != regionKeySetSize) {
            throw new TestException("Inconsistent sizes: regionSize is " + regionSize + " regionKeySetSize is " + regionKeySetSize);
        }
        Set snapshotKeySet = this.regionSnapshot.keySet();
        ArrayList unexpectedInRegion = new ArrayList(regionKeySet);
        ArrayList missingInRegion = new ArrayList(snapshotKeySet);
        Log.getLogWriter().info("Finding any unexpected entries in region...");
        unexpectedInRegion.removeAll(snapshotKeySet);
        Log.getLogWriter().info("Finding any missing entries in region...");
        missingInRegion.removeAll(regionKeySet);
        Log.getLogWriter().info("Found " + unexpectedInRegion.size() + " unexpected entries and " + missingInRegion.size() + " missing entries");
        Set inDoubtOps = CQUtilBB.getBB().getFailedOps(CQUtilBB.INDOUBT_TXOPS);
        if (inDoubtOps.size() > 0) {
            Log.getLogWriter().info(inDoubtOps.size() + " TransactionInDoubtExceptions occurred on the following keys:" + inDoubtOps);
        }
        StringBuffer aStr = new StringBuffer();
        if (this.aRegion.size() != this.regionSnapshot.size()) {
            aStr.append("Expected " + this.aRegion.getFullPath() + " to be size " + this.regionSnapshot.size() + ", but it is size " + this.aRegion.size());
            Log.getLogWriter().info(aStr.toString());
        }
        if (unexpectedInRegion.size() > 0) {
            tmpStr = "Found the following " + unexpectedInRegion.size() + " unexpected keys in " + this.aRegion.getFullPath() + ": " + unexpectedInRegion;
            Log.getLogWriter().info(tmpStr.toString());
            if (aStr.length() > 0) {
                aStr.append("\n");
            }
            aStr.append(tmpStr);
        }
        if (missingInRegion.size() > 0) {
            tmpStr = "The following " + missingInRegion.size() + " keys were missing from " + this.aRegion.getFullPath() + ": " + missingInRegion;
            Log.getLogWriter().info(tmpStr);
            if (aStr.length() > 0) {
                aStr.append("\n");
            }
            aStr.append(tmpStr);
        }
        if (aStr.length() > 0) {
            throw new TestException(aStr.toString());
        }
        Log.getLogWriter().info("Done verifying contents of " + this.aRegion.getFullPath() + ", size is " + this.aRegion.size());
    }

    protected void verifyQueryResults() {
        Log.getLogWriter().info("In verifyQueryResults");
        Iterator it = this.queryMap.keySet().iterator();
        int count = 0;
        while (it.hasNext()) {
            String cqName = (String)it.next();
            Log.getLogWriter().info("Verifying query " + ++count + " out of " + this.queryMap.size() + " with name " + cqName);
            this.verifyQuery(cqName);
        }
        Log.getLogWriter().info("Done verifying " + count + " queries");
    }

    protected void verifyQuery(String cqName) {
        Log.getLogWriter().info("Verifying query " + cqName);
        CqQuery cq = this.qService.getCq(cqName);
        try {
            long startTime;
            if (cq.isRunning()) {
                Log.getLogWriter().info("Stopping " + cq);
                startTime = System.currentTimeMillis();
                try {
                    cq.stop();
                }
                catch (IllegalStateException e) {
                    throw new TestException("cq with name " + cqName + " isRunning: " + cq.isRunning() + ", caught " + TestHelper.getStackTrace(e));
                }
                long endTime = System.currentTimeMillis();
                long duration = endTime - startTime;
                Log.getLogWriter().info("Done stopping " + cq + ", stop completed in " + duration + " millis");
            }
            Log.getLogWriter().info("Calling executeWithInitialResults on " + cq.getName());
            startTime = System.currentTimeMillis();
            SelectResults sr = null;
            try {
                sr = new CQExecuteVersionHelper().executeWithInitialResults(cq);
            }
            catch (IllegalStateException e) {
                throw new TestException("cq with name " + cqName + " isRunning: " + cq.isRunning() + ", caught " + TestHelper.getStackTrace(e));
            }
            long endTime = System.currentTimeMillis();
            long duration = endTime - startTime;
            Log.getLogWriter().info("Done calling executeWithInitialResults on " + cq.getName() + ", completed in " + duration + " millis, select results size is " + sr.size());
            if (sr == null) {
                throw new TestException("Bug 37060 detected: For cq " + cq + " with name " + cqName + " executeWithInitialResults returned " + sr);
            }
            this.verify(cq, sr);
        }
        catch (CqException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (RegionNotFoundException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (CqClosedException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
    }

    protected static String getPathInQuery(String queryStr) {
        String[] tokens = queryStr.split("\\s");
        for (int i = 0; i < tokens.length; ++i) {
            if (!tokens[i].equals("where")) continue;
            if (tokens[i + 1].equals("entry")) {
                return null;
            }
            return tokens[i + 1];
        }
        return null;
    }

    protected static String getFieldInQuery(String queryStr) {
        String path = CQTest.getPathInQuery(queryStr);
        if (path == null) {
            return null;
        }
        int index = path.lastIndexOf(".");
        String fieldName = path.substring(index + 1, path.length());
        fieldName = fieldName.trim();
        return fieldName;
    }

    protected static String getComparatorInQuery(String queryStr) {
        String[] tokens = queryStr.split("\\s");
        for (int i = 0; i < tokens.length; ++i) {
            if (tokens[i].equals("<>")) {
                return "<>";
            }
            if (tokens[i].equals("!=")) {
                return "!=";
            }
            if (tokens[i].equals(">=")) {
                return ">=";
            }
            if (tokens[i].equals(">")) {
                return ">";
            }
            if (tokens[i].equals("<=")) {
                return "<=";
            }
            if (tokens[i].equals("<")) {
                return "<";
            }
            if (!tokens[i].equals("=")) continue;
            return "=";
        }
        return null;
    }

    protected static String getValueToCompareInQuery(String queryStr) {
        if (queryStr.indexOf("where") < 0) {
            return null;
        }
        String[] tokens = queryStr.split("\\s");
        String aStr = tokens[tokens.length - 1];
        if (aStr.startsWith("'")) {
            aStr = aStr.substring(1, aStr.length());
        }
        if (aStr.endsWith("'")) {
            aStr = aStr.substring(0, aStr.length() - 1);
        }
        StringBuffer returnStr = new StringBuffer(aStr);
        for (int i = 0; i < returnStr.length(); ++i) {
            int next;
            if (returnStr.charAt(i) != '\'' || (next = i + 1) >= returnStr.length() || returnStr.charAt(next) != '\'') continue;
            returnStr.deleteCharAt(next);
        }
        return returnStr.toString();
    }

    protected static int getDepthInQuery(String queryStr) {
        int depth = 1;
        String field = CQTest.getPathInQuery(queryStr);
        if (field == null) {
            return depth;
        }
        int index = field.indexOf(".");
        while (index > 0) {
            ++depth;
            index = field.indexOf(".", index + 1);
        }
        return depth;
    }

    protected List getExpectedResults(String queryStr) {
        String fieldName = CQTest.getFieldInQuery(queryStr);
        String comparator = CQTest.getComparatorInQuery(queryStr);
        String valueToCompare = CQTest.getValueToCompareInQuery(queryStr);
        int queryDepth = CQTest.getDepthInQuery(queryStr);
        Log.getLogWriter().info("In getExpectedResults, queryStr = " + queryStr + ", fieldName = " + fieldName + ", comparator = " + comparator + ", valueToCompare = " + valueToCompare);
        Field aField = null;
        if (fieldName != null) {
            try {
                aField = QueryObject.class.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException e) {
                throw new TestException("Test problem " + TestHelper.getStackTrace(e));
            }
        }
        ArrayList<QueryObject> expectedResults = new ArrayList<QueryObject>();
        Iterator it = this.regionSnapshot.keySet().iterator();
        Log.getLogWriter().info("regionSnapShot is size " + this.regionSnapshot.size());
        while (it.hasNext()) {
            Object key = it.next();
            QueryObject originalQO = this.toQueryObject(this.regionSnapshot.get(key));
            if (!CQTest.satisfiesQuery(queryStr, originalQO)) continue;
            expectedResults.add(originalQO);
        }
        Log.getLogWriter().info("Expected result size is " + expectedResults.size());
        return expectedResults;
    }

    public static boolean satisfiesQuery(String queryStr, QueryObject qo) {
        String fieldName = CQTest.getFieldInQuery(queryStr);
        String comparator = CQTest.getComparatorInQuery(queryStr);
        String valueToCompare = CQTest.getValueToCompareInQuery(queryStr);
        int queryDepth = CQTest.getDepthInQuery(queryStr);
        Field aField = null;
        if (fieldName != null) {
            try {
                aField = QueryObject.class.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException e) {
                throw new TestException("Test problem " + TestHelper.getStackTrace(e));
            }
        }
        if (qo == null) {
            return false;
        }
        QueryObject qoAtDepth = qo.getAtDepth(queryDepth);
        if (qoAtDepth == null) {
            return false;
        }
        if (comparator == null) {
            return true;
        }
        Object fieldValue = null;
        if (aField != null) {
            try {
                fieldValue = aField.get(qoAtDepth);
            }
            catch (IllegalAccessException e) {
                throw new TestException("Test problem " + TestHelper.getStackTrace(e));
            }
        } else {
            fieldValue = qo;
        }
        if (valueToCompare.equalsIgnoreCase("null")) {
            if (comparator.equals("=") && fieldValue == null || comparator.equals("<>") && fieldValue != null || comparator.equals("!=") && fieldValue != null) {
                return true;
            }
        } else if (fieldName.equals("aString") || fieldName.equals("aPrimitiveChar") || fieldName.equals("aCharacter")) {
            int compare = fieldValue.toString().compareTo(valueToCompare);
            if (comparator.equals(">") && compare > 0 || comparator.equals(">=") && compare >= 0 || comparator.equals("<") && compare < 0 || comparator.equals("<=") && compare <= 0 || comparator.equals("=") && compare == 0 || comparator.equals("<>") && compare != 0 || comparator.equals("!=") && compare != 0) {
                return true;
            }
        } else if (fieldName.equals("aPrimitiveFloat") || fieldName.equals("aFloat") || fieldName.equals("aPrimitiveDouble") || fieldName.equals("aDouble")) {
            Double doubleFieldValue = Double.valueOf(fieldValue.toString());
            Double doubleValueToCompare = Double.valueOf(valueToCompare);
            int compare = doubleFieldValue.compareTo(doubleValueToCompare);
            if (comparator.equals(">") && compare > 0 || comparator.equals(">=") && compare >= 0 || comparator.equals("<") && compare < 0 || comparator.equals("<=") && compare <= 0 || comparator.equals("=") && compare == 0 || comparator.equals("<>") && compare != 0 || comparator.equals("!=") && compare != 0) {
                return true;
            }
        } else {
            long longFieldValue = new Long(fieldValue.toString());
            long longValueToCompare = new Long(valueToCompare);
            if (comparator.equals(">") && longFieldValue > longValueToCompare || comparator.equals(">=") && longFieldValue >= longValueToCompare || comparator.equals("<") && longFieldValue < longValueToCompare || comparator.equals("<=") && longFieldValue <= longValueToCompare || comparator.equals("=") && longFieldValue == longValueToCompare || comparator.equals("<>") && longFieldValue != longValueToCompare || comparator.equals("!=") && longFieldValue != longValueToCompare) {
                return true;
            }
        }
        return false;
    }

    protected int getOperation(Long whichPrm) {
        long limit = 60000L;
        long startTime = System.currentTimeMillis();
        int op = 0;
        String operation = TestConfig.tab().stringAt(whichPrm);
        if (operation.equals("add")) {
            op = 1;
        } else if (operation.equals("update")) {
            op = 6;
        } else if (operation.equals("invalidate")) {
            op = 3;
        } else if (operation.equals("destroy")) {
            op = 2;
        } else if (operation.equals("get")) {
            op = 7;
        } else if (operation.equals("getNew")) {
            op = 8;
        } else if (operation.equals("localInvalidate")) {
            op = 5;
        } else if (operation.equals("localDestroy")) {
            op = 4;
        } else if (operation.equals("modifyValue")) {
            op = 9;
        } else {
            throw new TestException("Unknown entry operation: " + operation);
        }
        return op;
    }

    public static Object getExistingKey(Region aRegion, boolean uniqueKeys, int numThreads) {
        Set aSet = aRegion.keySet();
        Iterator it = aSet.iterator();
        int myTid = RemoteTestModule.getCurrentThread().getThreadId();
        while (it.hasNext()) {
            Object key = it.next();
            if (uniqueKeys) {
                long keyIndex = NameFactory.getCounterForName(key);
                if (keyIndex % (long)numThreads != (long)myTid) continue;
                return key;
            }
            return key;
        }
        return null;
    }

    protected String getNextQueryName() {
        long counter = CQUtilBB.getBB().getSharedCounters().incrementAndRead(CQUtilBB.QueryNumber);
        return "Query_" + counter;
    }

    public static String getReadableQueryString(String queryStr) {
        String value;
        if (queryStr.indexOf("aChar") >= 0 && !(value = CQTest.getValueToCompareInQuery(queryStr)).equals("NULL")) {
            if (value.length() != 1) {
                throw new TestException("Test problem; expected value in query string to be length() 1 but it is " + value.length());
            }
            char aChar = value.charAt(0);
            byte byteValue = (byte)aChar;
            queryStr = queryStr + " (char byte value: " + byteValue + ")";
        }
        return queryStr;
    }

    protected void checkForLastIteration() {
        long taskStartTime = 0L;
        String bbKey = "TaskStartTime";
        Object anObj = CQUtilBB.getBB().getSharedMap().get("TaskStartTime");
        if (anObj == null) {
            taskStartTime = System.currentTimeMillis();
            CQUtilBB.getBB().getSharedMap().put("TaskStartTime", new Long(taskStartTime));
            Log.getLogWriter().info("Initialized taskStartTime to " + taskStartTime);
        } else {
            taskStartTime = (Long)anObj;
        }
        if (System.currentTimeMillis() - taskStartTime >= (long)(this.secondsToRun * 1000)) {
            Log.getLogWriter().info("This is the last iteration of this task");
            CQUtilBB.getBB().getSharedCounters().increment(CQUtilBB.TimeToStop);
        } else {
            Log.getLogWriter().info("Running for " + this.secondsToRun + " seconds; time remaining is " + ((long)this.secondsToRun - (System.currentTimeMillis() - taskStartTime) / 1000L) + " seconds");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void handleException(Exception anExcept) {
        boolean disconnectError;
        boolean thisVMReceivedNiceKill = StopStartVMs.niceKillInProgress();
        String errStr = anExcept.toString();
        Throwable causedBy = anExcept.getCause();
        if (causedBy != null) {
            errStr = errStr + causedBy.toString();
        }
        boolean bl = disconnectError = errStr.indexOf("This connection to a distributed system has been disconnected") >= 0 || errStr.indexOf("System is disconnecting") >= 0;
        if (anExcept instanceof CancelException) {
            if (!(thisVMReceivedNiceKill || this.cacheIsClosed || this.disconnected)) {
                throw new TestException(TestHelper.getStackTrace(anExcept));
            }
        } else if (anExcept instanceof IllegalStateException) {
            if (disconnectError) {
                if (!this.disconnected && !thisVMReceivedNiceKill) {
                    throw new TestException(TestHelper.getStackTrace(anExcept));
                }
            } else {
                if (!this.isBridgeConfiguration || !thisVMReceivedNiceKill) throw new TestException(TestHelper.getStackTrace(anExcept));
                if (errStr.indexOf("Proxy not properly initialized") < 0) {
                    throw new TestException(TestHelper.getStackTrace(anExcept));
                }
            }
        } else if (anExcept instanceof CacheLoaderException) {
            if (!this.isBridgeConfiguration || !thisVMReceivedNiceKill) throw new TestException(TestHelper.getStackTrace(anExcept));
            if (anExcept.toString().indexOf("The BridgeLoader has been closed") < 0) {
                throw new TestException(TestHelper.getStackTrace(anExcept));
            }
        } else if (anExcept instanceof BridgeWriterException) {
            if (!this.isBridgeConfiguration || !thisVMReceivedNiceKill) throw new TestException(TestHelper.getStackTrace(anExcept));
            if (anExcept.toString().indexOf("The BridgeWriter has been closed") < 0) {
                throw new TestException(TestHelper.getStackTrace(anExcept));
            }
        } else {
            if (!(anExcept instanceof NullPointerException)) throw new TestException("Got unexpected exception " + TestHelper.getStackTrace(anExcept));
            String stackStr = TestHelper.getStackTrace(anExcept);
            if (stackStr.indexOf("QueryObject.<init>") < 0) {
                throw new TestException(stackStr);
            }
        }
        Log.getLogWriter().info("Caught " + anExcept + "; expected, continuing test");
        CQUtilBB.getBB().getSharedCounters().increment(CQUtilBB.ExceptionCounter);
        TestHelper.waitForCounter(CQUtilBB.getBB(), "CQUtilBB.Reinitialized", CQUtilBB.Reinitialized, 1L, true, -1L, 1000L);
    }

    protected void saveRegionSnapshot() {
        this.txRegionSnapshot = new HashMap(this.regionSnapshot);
    }

    private QueryObject toQueryObject(Object anObj) {
        return (QueryObject)PdxTestVersionHelper.toBaseObject(anObj);
    }

    protected void restoreRegionSnapshot() {
        this.regionSnapshot = this.txRegionSnapshot;
        this.txRegionSnapshot = null;
    }

    static {
        CQsOn = true;
        concVerifyCoordinator = new MethodCoordinator(CQTest.class.getName(), "concVerify");
    }
}

