/*
 * Decompiled with CFR 0.152.
 */
package cq;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.client.Pool;
import com.gemstone.gemfire.cache.query.CqAttributes;
import com.gemstone.gemfire.cache.query.CqAttributesFactory;
import com.gemstone.gemfire.cache.query.CqQuery;
import com.gemstone.gemfire.cache.query.CqResults;
import com.gemstone.gemfire.cache.query.FunctionDomainException;
import com.gemstone.gemfire.cache.query.NameResolutionException;
import com.gemstone.gemfire.cache.query.Query;
import com.gemstone.gemfire.cache.query.QueryInvalidException;
import com.gemstone.gemfire.cache.query.QueryInvocationTargetException;
import com.gemstone.gemfire.cache.query.QueryService;
import com.gemstone.gemfire.cache.query.SelectResults;
import com.gemstone.gemfire.cache.query.TypeMismatchException;
import cq.CQUtil;
import cq.CQUtilBB;
import cq.CQUtilPrms;
import hydra.BridgeHelper;
import hydra.BridgePrms;
import hydra.CacheHelper;
import hydra.HydraVector;
import hydra.Log;
import hydra.PoolHelper;
import hydra.RegionHelper;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import java.util.ArrayList;
import java.util.Iterator;
import objects.Portfolio;
import util.QueryObject;
import util.TestException;
import util.TestHelper;

public class CQSimpleTest {
    protected static CQSimpleTest testInstance;
    protected static final String VmIDStr = "VmId_";
    protected boolean isBridgeConfiguration;
    protected boolean isBridgeClient;
    protected QueryService qService;
    protected Region aRegion;
    protected static String KnownErrorsKey;
    protected static String UnknownErrorsKey;

    public static synchronized void HydraTask_initializeClient() {
        if (testInstance == null) {
            testInstance = new CQSimpleTest();
            testInstance.initializeRegion("clientRegion");
            testInstance.initializeInstance();
            if (CQSimpleTest.testInstance.isBridgeConfiguration) {
                CQSimpleTest.testInstance.isBridgeClient = true;
                testInstance.initializeQueryService();
                CQUtilBB.getBB().getSharedMap().put(KnownErrorsKey, "");
                CQUtilBB.getBB().getSharedMap().put(UnknownErrorsKey, "");
            }
        }
    }

    public static synchronized void HydraTask_initializeBridgeServer() {
        if (testInstance == null) {
            testInstance = new CQSimpleTest();
            testInstance.initializeRegion("serverRegion");
            testInstance.initializeInstance();
            BridgeHelper.startBridgeServer("bridge");
            CQSimpleTest.testInstance.isBridgeClient = false;
        }
    }

    protected void initializeRegion(String regDescriptName) {
        CacheHelper.createCache("cache1");
        String key = VmIDStr + RemoteTestModule.getMyVmid();
        String xmlFile = key + ".xml";
        CacheHelper.generateCacheXmlFile("cache1", regDescriptName, xmlFile);
        this.aRegion = RegionHelper.createRegion(regDescriptName);
    }

    protected void initializeQueryService() {
        try {
            Log.getLogWriter().info("Creating QueryService.");
            String usingPool = TestConfig.tab().stringAt(CQUtilPrms.QueryServiceUsingPool, "false");
            boolean queryServiceUsingPool = Boolean.valueOf(usingPool);
            if (queryServiceUsingPool) {
                Pool pool = PoolHelper.createPool(CQUtilPrms.getQueryServicePoolName());
                this.qService = pool.getQueryService();
                Log.getLogWriter().info("Initializing QueryService using Pool. PoolName: " + pool.getName());
            } else {
                this.qService = CacheHelper.getCache().getQueryService();
                Log.getLogWriter().info("Initializing QueryService using Cache.");
            }
            Log.getLogWriter().info("Done creating QueryService");
        }
        catch (Exception e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
    }

    protected void initializeInstance() {
        HydraVector bridgeNames = TestConfig.tab().vecAt(BridgePrms.names, null);
        this.isBridgeConfiguration = bridgeNames != null;
    }

    public static void HydraTask_testMinMaxLongs() {
        StringBuffer errStr = new StringBuffer();
        String[] fieldNames = new String[]{"aPrimitiveLong", "aLong"};
        Object[] values = new Object[]{new Long(Long.MIN_VALUE), new Long(0L), new Long(Long.MAX_VALUE)};
        ArrayList<QueryObject> valuesToPutList = new ArrayList<QueryObject>();
        for (int i = 0; i < values.length; ++i) {
            QueryObject qo = new QueryObject(10L, 1, -1, 1);
            qo.aLong = (Long)values[i];
            valuesToPutList.add(qo);
            qo = new QueryObject(10L, 1, -1, 1);
            qo.aPrimitiveLong = (Long)values[i];
            valuesToPutList.add(qo);
        }
        Object[] valuesToPut = valuesToPutList.toArray();
        for (int i = 0; i < fieldNames.length; ++i) {
            String fieldName = fieldNames[i];
            testInstance.testQuery(fieldName, ">", "L", valuesToPut, values, new int[]{5, 4, 0});
            testInstance.testQuery(fieldName, "<", "L", valuesToPut, values, new int[]{0, 1, 5});
            testInstance.testQuery(fieldName, ">=", "L", valuesToPut, values, new int[]{6, 5, 1});
            testInstance.testQuery(fieldName, "<=", "L", valuesToPut, values, new int[]{1, 2, 6});
            testInstance.testQuery(fieldName, "=", "L", valuesToPut, values, new int[]{1, 1, 1});
            testInstance.testQuery(fieldName, "<>", "L", valuesToPut, values, new int[]{5, 5, 5});
            testInstance.testQuery(fieldName, "!=", "L", valuesToPut, values, new int[]{5, 5, 5});
        }
    }

    public static void HydraTask_testMinMaxIntegers() {
        StringBuffer errStr = new StringBuffer();
        String[] fieldNames = new String[]{"aPrimitiveInt", "anInteger"};
        Object[] values = new Object[]{new Integer(Integer.MIN_VALUE), new Integer(0), new Integer(Integer.MAX_VALUE)};
        ArrayList<QueryObject> valuesToPutList = new ArrayList<QueryObject>();
        for (int i = 0; i < values.length; ++i) {
            QueryObject qo = new QueryObject(10L, 1, -1, 1);
            qo.anInteger = (Integer)values[i];
            valuesToPutList.add(qo);
            qo = new QueryObject(10L, 1, -1, 1);
            qo.aPrimitiveInt = (Integer)values[i];
            valuesToPutList.add(qo);
        }
        Object[] valuesToPut = valuesToPutList.toArray();
        for (int i = 0; i < fieldNames.length; ++i) {
            String fieldName = fieldNames[i];
            testInstance.testQuery(fieldName, ">", "", valuesToPut, values, new int[]{5, 4, 0});
            testInstance.testQuery(fieldName, "<", "", valuesToPut, values, new int[]{0, 1, 5});
            testInstance.testQuery(fieldName, ">=", "", valuesToPut, values, new int[]{6, 5, 1});
            testInstance.testQuery(fieldName, "<=", "", valuesToPut, values, new int[]{1, 2, 6});
            testInstance.testQuery(fieldName, "=", "", valuesToPut, values, new int[]{1, 1, 1});
            testInstance.testQuery(fieldName, "<>", "", valuesToPut, values, new int[]{5, 5, 5});
            testInstance.testQuery(fieldName, "!=", "", valuesToPut, values, new int[]{5, 5, 5});
        }
    }

    public static void HydraTask_testMinMaxShorts() {
        StringBuffer errStr = new StringBuffer();
        String[] fieldNames = new String[]{"aPrimitiveShort", "aShort"};
        Object[] values = new Object[]{new Short(Short.MIN_VALUE), new Short(0), new Short(Short.MAX_VALUE)};
        ArrayList<QueryObject> valuesToPutList = new ArrayList<QueryObject>();
        for (int i = 0; i < values.length; ++i) {
            QueryObject qo = new QueryObject(10L, 1, -1, 1);
            qo.aShort = (Short)values[i];
            valuesToPutList.add(qo);
            qo = new QueryObject(10L, 1, -1, 1);
            qo.aPrimitiveShort = (Short)values[i];
            valuesToPutList.add(qo);
        }
        Object[] valuesToPut = valuesToPutList.toArray();
        for (int i = 0; i < fieldNames.length; ++i) {
            String fieldName = fieldNames[i];
            testInstance.testQuery(fieldName, ">", "", valuesToPut, values, new int[]{5, 4, 0});
            testInstance.testQuery(fieldName, "<", "", valuesToPut, values, new int[]{0, 1, 5});
            testInstance.testQuery(fieldName, ">=", "", valuesToPut, values, new int[]{6, 5, 1});
            testInstance.testQuery(fieldName, "<=", "", valuesToPut, values, new int[]{1, 2, 6});
            testInstance.testQuery(fieldName, "=", "", valuesToPut, values, new int[]{1, 1, 1});
            testInstance.testQuery(fieldName, "<>", "", valuesToPut, values, new int[]{5, 5, 5});
            testInstance.testQuery(fieldName, "!=", "", valuesToPut, values, new int[]{5, 5, 5});
        }
    }

    public static void HydraTask_testMinMaxBytes() {
        StringBuffer errStr = new StringBuffer();
        String[] fieldNames = new String[]{"aPrimitiveByte", "aByte"};
        Object[] values = new Object[]{new Byte(-128), new Byte(0), new Byte(127)};
        ArrayList<QueryObject> valuesToPutList = new ArrayList<QueryObject>();
        for (int i = 0; i < values.length; ++i) {
            QueryObject qo = new QueryObject(10L, 1, -1, 1);
            qo.aByte = (Byte)values[i];
            valuesToPutList.add(qo);
            qo = new QueryObject(10L, 1, -1, 1);
            qo.aPrimitiveByte = (Byte)values[i];
            valuesToPutList.add(qo);
        }
        Object[] valuesToPut = valuesToPutList.toArray();
        for (int i = 0; i < fieldNames.length; ++i) {
            String fieldName = fieldNames[i];
            testInstance.testQuery(fieldName, ">", "", valuesToPut, values, new int[]{5, 4, 0});
            testInstance.testQuery(fieldName, "<", "", valuesToPut, values, new int[]{0, 1, 5});
            testInstance.testQuery(fieldName, ">=", "", valuesToPut, values, new int[]{6, 5, 1});
            testInstance.testQuery(fieldName, "<=", "", valuesToPut, values, new int[]{1, 2, 6});
            testInstance.testQuery(fieldName, "=", "", valuesToPut, values, new int[]{1, 1, 1});
            testInstance.testQuery(fieldName, "<>", "", valuesToPut, values, new int[]{5, 5, 5});
            testInstance.testQuery(fieldName, "!=", "", valuesToPut, values, new int[]{5, 5, 5});
        }
    }

    public static void HydraTask_testMinMaxFloats() {
        StringBuffer errStr = new StringBuffer();
        String[] fieldNames = new String[]{"aPrimitiveFloat", "aFloat"};
        Object[] values = new Object[]{new Float(-3.4028235E38f), new Float(0.0), new Float(Float.MAX_VALUE), new Float(Float.NEGATIVE_INFINITY), new Float(Float.POSITIVE_INFINITY), new Float(Float.NaN)};
        ArrayList<QueryObject> valuesToPutList = new ArrayList<QueryObject>();
        for (int i = 0; i < values.length; ++i) {
            QueryObject qo = new QueryObject(10L, 1, -1, 1);
            qo.aFloat = (Float)values[i];
            qo.aPrimitiveFloat = ((Float)values[i]).floatValue();
            valuesToPutList.add(qo);
        }
        Object[] valuesToPut = valuesToPutList.toArray();
        Object[] valuesToQueryWith = new Object[]{"-3.4028234663852886E38", new Float(0.0), "3.4028234663852886E38"};
        for (int i = 0; i < fieldNames.length; ++i) {
            String fieldName = fieldNames[i];
            testInstance.testQuery(fieldName, ">", "F", valuesToPut, valuesToQueryWith, new int[]{4, 3, 2});
            testInstance.testQuery(fieldName, "<", "F", valuesToPut, valuesToQueryWith, new int[]{1, 2, 3});
            testInstance.testQuery(fieldName, ">=", "F", valuesToPut, valuesToQueryWith, new int[]{5, 4, 3});
            testInstance.testQuery(fieldName, "<=", "F", valuesToPut, valuesToQueryWith, new int[]{2, 3, 4});
            testInstance.testQuery(fieldName, "=", "F", valuesToPut, valuesToQueryWith, new int[]{1, 1, 1});
            testInstance.testQuery(fieldName, "<>", "F", valuesToPut, valuesToQueryWith, new int[]{5, 5, 5});
            testInstance.testQuery(fieldName, "!=", "F", valuesToPut, valuesToQueryWith, new int[]{5, 5, 5});
        }
    }

    public static void HydraTask_testMinMaxDoubles() {
        StringBuffer errStr = new StringBuffer();
        String[] fieldNames = new String[]{"aPrimitiveDouble", "aDouble"};
        Object[] values = new Object[]{new Double(-1.7976931348623157E308), new Double(0.0), new Double(Double.MAX_VALUE), new Double(Double.NEGATIVE_INFINITY), new Double(Double.POSITIVE_INFINITY), new Double(Double.NaN)};
        ArrayList<QueryObject> valuesToPutList = new ArrayList<QueryObject>();
        for (int i = 0; i < values.length; ++i) {
            QueryObject qo = new QueryObject(10L, 1, -1, 1);
            qo.aDouble = (Double)values[i];
            qo.aPrimitiveDouble = (Double)values[i];
            valuesToPutList.add(qo);
        }
        Object[] valuesToPut = valuesToPutList.toArray();
        Object[] valuesToQueryWith = new Object[]{"-1.7976931348623157E308", new Double(0.0), "1.7976931348623157E308"};
        for (int i = 0; i < fieldNames.length; ++i) {
            String fieldName = fieldNames[i];
            testInstance.testQuery(fieldName, ">", "D", valuesToPut, valuesToQueryWith, new int[]{4, 3, 2});
            testInstance.testQuery(fieldName, "<", "D", valuesToPut, valuesToQueryWith, new int[]{1, 2, 3});
            testInstance.testQuery(fieldName, ">=", "D", valuesToPut, valuesToQueryWith, new int[]{5, 4, 3});
            testInstance.testQuery(fieldName, "<=", "D", valuesToPut, valuesToQueryWith, new int[]{2, 3, 4});
            testInstance.testQuery(fieldName, "=", "D", valuesToPut, valuesToQueryWith, new int[]{1, 1, 1});
            testInstance.testQuery(fieldName, "<>", "D", valuesToPut, valuesToQueryWith, new int[]{5, 5, 5});
            testInstance.testQuery(fieldName, "!=", "D", valuesToPut, valuesToQueryWith, new int[]{5, 5, 5});
        }
    }

    public static void HydraTask_testMinMaxCharacters() {
        StringBuffer errStr = new StringBuffer();
        String[] fieldNames = new String[]{"aPrimitiveChar", "aCharacter"};
        Object[] values = new Object[]{new Character('\u0000'), new Character('\u0000'), new Character('\ufffe')};
        ArrayList<QueryObject> valuesToPutList = new ArrayList<QueryObject>();
        for (int i = 0; i < values.length; ++i) {
            QueryObject qo = new QueryObject(10L, 1, -1, 1);
            qo.aCharacter = (Character)values[i];
            qo.aPrimitiveChar = ((Character)values[i]).charValue();
            valuesToPutList.add(qo);
        }
        Object[] valuesToPut = valuesToPutList.toArray();
        Object[] valuesToQueryWith = new Object[]{"CHAR '" + new Character('\u0000') + "'", "CHAR '" + new Character('\u0000') + "'", "CHAR '" + new Character('\ufffe') + "'"};
        for (int i = 0; i < fieldNames.length; ++i) {
            String fieldName = fieldNames[i];
            testInstance.testQuery(fieldName, ">", "", valuesToPut, valuesToQueryWith, new int[]{1, 1, 0});
            testInstance.testQuery(fieldName, "<", "", valuesToPut, valuesToQueryWith, new int[]{0, 0, 2});
            testInstance.testQuery(fieldName, ">=", "", valuesToPut, valuesToQueryWith, new int[]{3, 3, 1});
            testInstance.testQuery(fieldName, "<=", "", valuesToPut, valuesToQueryWith, new int[]{2, 2, 3});
            testInstance.testQuery(fieldName, "=", "", valuesToPut, valuesToQueryWith, new int[]{2, 2, 1});
            testInstance.testQuery(fieldName, "<>", "", valuesToPut, valuesToQueryWith, new int[]{1, 1, 2});
            testInstance.testQuery(fieldName, "!=", "", valuesToPut, valuesToQueryWith, new int[]{1, 1, 2});
        }
    }

    public static void HydraTask_testMinMaxStrings() {
        StringBuffer errStr = new StringBuffer();
        String[] fieldNames = new String[]{"aString"};
        String minStr = "";
        for (int i = 1; i <= 10; ++i) {
            minStr = minStr + new Character('\u0000');
        }
        String maxStr = "";
        for (int i = 1; i <= 10; ++i) {
            maxStr = maxStr + new Character('\ufffe');
        }
        Object[] values = new Object[]{minStr, "", maxStr};
        ArrayList<QueryObject> valuesToPutList = new ArrayList<QueryObject>();
        for (int i = 0; i < values.length; ++i) {
            QueryObject qo = new QueryObject(10L, 1, -1, 1);
            qo.aString = (String)values[i];
            valuesToPutList.add(qo);
        }
        Object[] valuesToPut = valuesToPutList.toArray();
        Object[] valuesToQueryWith = new Object[]{"''", "'" + minStr + "'", "'" + maxStr + "'"};
        for (int i = 0; i < fieldNames.length; ++i) {
            String fieldName = fieldNames[i];
            testInstance.testQuery(fieldName, ">", "", valuesToPut, valuesToQueryWith, new int[]{2, 1, 0});
            testInstance.testQuery(fieldName, "<", "", valuesToPut, valuesToQueryWith, new int[]{0, 1, 2});
            testInstance.testQuery(fieldName, ">=", "", valuesToPut, valuesToQueryWith, new int[]{3, 2, 1});
            testInstance.testQuery(fieldName, "<=", "", valuesToPut, valuesToQueryWith, new int[]{1, 2, 3});
            testInstance.testQuery(fieldName, "=", "", valuesToPut, valuesToQueryWith, new int[]{1, 1, 1});
            testInstance.testQuery(fieldName, "<>", "", valuesToPut, valuesToQueryWith, new int[]{2, 2, 2});
            testInstance.testQuery(fieldName, "!=", "", valuesToPut, valuesToQueryWith, new int[]{2, 2, 2});
        }
    }

    public static void HydraTask_checkForErrors() {
        String knownErrors;
        String errStr = "";
        String unknownErrors = (String)CQUtilBB.getBB().getSharedMap().get(UnknownErrorsKey);
        if (unknownErrors.length() > 0) {
            errStr = "Unknown errors:\n:" + unknownErrors;
        }
        if ((knownErrors = (String)CQUtilBB.getBB().getSharedMap().get(KnownErrorsKey)).length() > 0) {
            if (errStr.length() != 0) {
                errStr = errStr + "\n";
            }
            errStr = errStr + "Known errors with bug numbers: " + knownErrors;
        }
        if (errStr.length() > 0) {
            throw new TestException(errStr);
        }
    }

    public static void HydraTask_testDistinctQuery() {
        testInstance.testDistinctQuery();
    }

    protected void testDistinctQuery() {
        this.aRegion.clear();
        Log.getLogWriter().info("Putting 5 portfolios in region");
        int NUMBER_OF_KEYS = 5;
        for (int i = 0; i < NUMBER_OF_KEYS; ++i) {
            this.aRegion.put((Object)("Key" + i), (Object)new Portfolio(i));
        }
        Query q = this.qService.newQuery("SELECT DISTINCT ID from " + this.aRegion.getFullPath());
        try {
            SelectResults results = (SelectResults)q.execute();
            int i = 0;
            Iterator it = results.iterator();
            while (it.hasNext()) {
                int id = (Integer)it.next();
                Log.getLogWriter().info("SWAP:p:" + id);
                ++i;
            }
            if (i != NUMBER_OF_KEYS) {
                throw new TestException("Size mismatch: expected " + NUMBER_OF_KEYS + " found " + i);
            }
        }
        catch (FunctionDomainException e) {
            e.printStackTrace();
        }
        catch (TypeMismatchException e) {
            e.printStackTrace();
        }
        catch (NameResolutionException e) {
            e.printStackTrace();
        }
        catch (QueryInvocationTargetException e) {
            e.printStackTrace();
        }
    }

    protected void testQuery(String fieldName, String comparator, String suffix, Object[] valuesToPut, Object[] valuesToQueryWith, int[] resultSizes) {
        int i;
        if (resultSizes.length != valuesToQueryWith.length) {
            throw new TestException("Test problem, resultSizes is length " + resultSizes.length + " but valuesToQueryWith is length " + valuesToQueryWith.length);
        }
        CqAttributesFactory cqFac = new CqAttributesFactory();
        CqAttributes cqAttr = cqFac.create();
        this.aRegion.clear();
        for (i = 0; i < valuesToPut.length; ++i) {
            this.aRegion.put((Object)("key" + (i + 1)), valuesToPut[i]);
        }
        for (i = 0; i < valuesToQueryWith.length; ++i) {
            String aStr;
            String bbStr;
            String aStr2;
            String queryStr = "select * from /testRegion where " + fieldName + " " + comparator + " " + valuesToQueryWith[i] + suffix;
            CqQuery cq = null;
            try {
                Log.getLogWriter().info("Creating cq for query: " + queryStr);
                cq = this.qService.newCq(queryStr, cqAttr);
            }
            catch (Exception e) {
                Throwable cause = TestHelper.findCause(e, NumberFormatException.class);
                if (e instanceof QueryInvalidException && e.getMessage().indexOf("Unable to parse float  9223372036854775808") >= 0 || cause != null && cause.getMessage().indexOf("For input string: \"2147483648\"") >= 0) {
                    aStr2 = "Bug 37119 detected: For query " + queryStr + " got " + e + "\n";
                    bbStr = (String)CQUtilBB.getBB().getSharedMap().get(KnownErrorsKey);
                    bbStr = bbStr + aStr2;
                    CQUtilBB.getBB().getSharedMap().put(KnownErrorsKey, bbStr);
                } else {
                    aStr2 = "For query " + queryStr + " got " + e + "\n";
                    bbStr = (String)CQUtilBB.getBB().getSharedMap().get(UnknownErrorsKey);
                    bbStr = bbStr + aStr2;
                    CQUtilBB.getBB().getSharedMap().put(UnknownErrorsKey, bbStr);
                }
                Log.getLogWriter().info(aStr2 + " " + TestHelper.getStackTrace(e));
                continue;
            }
            Log.getLogWriter().info("Calling executeWithInitialResults on " + cq + " with query: " + queryStr);
            SelectResults sr = null;
            try {
                CqResults rs = cq.executeWithInitialResults();
                sr = CQUtil.getSelectResults(rs);
            }
            catch (Exception e) {
                aStr = "For query " + queryStr + " got " + e + "\n";
                Log.getLogWriter().info(aStr + " " + TestHelper.getStackTrace(e));
                bbStr = (String)CQUtilBB.getBB().getSharedMap().get(UnknownErrorsKey);
                bbStr = bbStr + aStr;
                CQUtilBB.getBB().getSharedMap().put(UnknownErrorsKey, bbStr);
                continue;
            }
            if (sr == null) {
                aStr2 = "Bug 37060 detected: For cq " + cq + ", query string: " + queryStr + ", executeWithInitialResults returned " + sr + "\n";
                Log.getLogWriter().info(aStr2);
                String bbStr2 = (String)CQUtilBB.getBB().getSharedMap().get(KnownErrorsKey);
                bbStr2 = bbStr2 + aStr2;
                CQUtilBB.getBB().getSharedMap().put(KnownErrorsKey, bbStr2);
                continue;
            }
            String srAsString = QueryObject.toStringFull(sr.asList());
            Log.getLogWriter().info("Executed cq for query: \"" + queryStr + "\", result size is " + sr.size() + ": " + srAsString);
            if (sr.size() == resultSizes[i]) continue;
            if (sr.size() == resultSizes[i] + 1 && (srAsString.indexOf("aPrimitiveFloat: NaN, aFloat: NaN") > 0 || srAsString.indexOf("aPrimitiveDouble: NaN, aDouble: NaN") > 0)) {
                aStr = "Bug 37716 detected: Expected query \"" + queryStr + "\" to return " + resultSizes[i] + " elements from executeWithInitialResults, but it returned " + sr.size() + " " + sr + "\n";
                bbStr = (String)CQUtilBB.getBB().getSharedMap().get(KnownErrorsKey);
                bbStr = bbStr + aStr;
                CQUtilBB.getBB().getSharedMap().put(KnownErrorsKey, bbStr);
            } else {
                aStr = "Expected query \"" + queryStr + "\" to return " + resultSizes[i] + " elements from executeWithInitialResults, but it returned " + sr.size() + " " + sr + "\n";
                bbStr = (String)CQUtilBB.getBB().getSharedMap().get(UnknownErrorsKey);
                bbStr = bbStr + aStr;
                CQUtilBB.getBB().getSharedMap().put(UnknownErrorsKey, bbStr);
            }
            Log.getLogWriter().info(aStr);
        }
    }

    static {
        KnownErrorsKey = "KnownErrors";
        UnknownErrorsKey = "UnknownErrorsKey";
    }
}

