/*
 * Decompiled with CFR 0.152.
 */
package cq;

import com.gemstone.gemfire.cache.ClientHelper;
import com.gemstone.gemfire.cache.EntryExistsException;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.InterestResultPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.query.CqClosedException;
import com.gemstone.gemfire.cache.query.CqException;
import com.gemstone.gemfire.cache.query.RegionNotFoundException;
import cq.CQUtil;
import cq.CQUtilBB;
import cq.CQUtilPrms;
import cq.ListenerBB;
import event.EventBB;
import getInitialImage.InitImagePrms;
import hydra.BridgeHelper;
import hydra.CacheHelper;
import hydra.Log;
import hydra.Prms;
import hydra.RegionHelper;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import hydra.blackboard.SharedCounters;
import java.util.ArrayList;
import java.util.Set;
import util.EventCountersBB;
import util.NameFactory;
import util.TestException;
import util.TestHelper;
import util.TestHelperPrms;
import util.TxHelper;
import vsphere.vijava.VIJavaPrms;
import vsphere.vijava.VMotionTestBase;

public class CQEventTest {
    protected static CQEventTest testInstance;
    protected static final String VmIDStr = "VmId_";
    protected boolean isBridgeClient;
    protected boolean isSerialExecution;
    protected boolean useTransactions;
    protected long minTaskGranularitySec;
    protected long minTaskGranularityMS;
    protected int upperThreshold;
    protected int lowerThreshold;
    protected Region aRegion;
    protected static boolean isVMotionEnabled;
    protected static final int ENTRY_ADD_OPERATION = 1;
    protected static final int ENTRY_DESTROY_OPERATION = 2;
    protected static final int ENTRY_INVALIDATE_OPERATION = 3;
    protected static final int ENTRY_UPDATE_OPERATION = 6;

    public static synchronized void HydraTask_initializeClient() throws CqClosedException, RegionNotFoundException {
        if (testInstance == null) {
            testInstance = new CQEventTest();
            CQEventTest.testInstance.isBridgeClient = true;
            testInstance.initializeRegion("clientRegion");
            boolean registerInterest = TestConfig.tab().booleanAt(CQUtilPrms.registerInterest, false);
            if (registerInterest) {
                CQEventTest.testInstance.aRegion.registerInterest((Object)"ALL_KEYS", InterestResultPolicy.KEYS_VALUES);
                CQUtilBB.incrementCounter("CQUtilBB.NUM_RI_VMS", CQUtilBB.NUM_RI_VMS);
            }
        }
        testInstance.initializeCQ();
        testInstance.initializePrms();
        CQUtilBB.incrementCounter("CQUtilBB.NUM_CQS", CQUtilBB.NUM_CQS);
    }

    protected void initializePrms() {
        this.isSerialExecution = TestConfig.tab().booleanAt(Prms.serialExecution, false);
        this.useTransactions = InitImagePrms.useTransactions();
        this.upperThreshold = TestConfig.tab().intAt(CQUtilPrms.upperThreshold, Integer.MAX_VALUE);
        this.lowerThreshold = TestConfig.tab().intAt(CQUtilPrms.lowerThreshold, -1);
        this.minTaskGranularitySec = TestConfig.tab().longAt(TestHelperPrms.minTaskGranularitySec, Long.MAX_VALUE);
        this.minTaskGranularityMS = this.minTaskGranularitySec == Long.MAX_VALUE ? Long.MAX_VALUE : this.minTaskGranularitySec * 1000L;
    }

    public static synchronized void HydraTask_initializeBridgeServer() {
        isVMotionEnabled = TestConfig.tab().booleanAt(VIJavaPrms.vMotionEnabled, false);
        if (isVMotionEnabled) {
            VMotionTestBase.setvMotionDuringCQRegistartion();
        }
        if (testInstance == null) {
            testInstance = new CQEventTest();
            CQEventTest.testInstance.isBridgeClient = false;
            testInstance.initializeRegion("serverRegion");
            BridgeHelper.startBridgeServer("bridge");
        }
    }

    public static synchronized void HydraTask_initializeFeed() {
        if (testInstance == null) {
            testInstance = new CQEventTest();
            CQEventTest.testInstance.isBridgeClient = false;
            testInstance.initializeRegion("feedRegion");
        }
    }

    public static synchronized void HydraTask_getAllEntries() {
        if (testInstance == null) {
            testInstance = new CQEventTest();
        }
        testInstance.getAllEntries("clientRegion");
    }

    protected void initializeRegion(String regDescriptName) {
        CacheHelper.createCache("cache1");
        String key = VmIDStr + RemoteTestModule.getMyVmid();
        String xmlFile = key + ".xml";
        CacheHelper.generateCacheXmlFile("cache1", regDescriptName, xmlFile);
        this.aRegion = RegionHelper.createRegion(regDescriptName);
    }

    protected void getAllEntries(String regionConfig) {
        String regionName = RegionHelper.getRegionDescription(regionConfig).getRegionName();
        Region aRegion = RegionHelper.getRegion(regionName);
        for (int i = 1; i <= 10; ++i) {
            Log.getLogWriter().info("getting entry Object" + i);
            Object o = aRegion.get((Object)(NameFactory.OBJECT_NAME_PREFIX + i));
            Log.getLogWriter().info("done getting entry Object" + i + " = " + o.toString());
        }
    }

    protected void initializeCQ() throws CqClosedException, RegionNotFoundException {
        CQUtil.initialize();
        CQUtil.initializeCQService();
        CQUtil.registerCQ(this.aRegion);
    }

    public static void HydraTask_loadRegion() {
        testInstance.loadRegion();
    }

    public void loadRegion() {
        Log.getLogWriter().info("creating entries");
        for (int i = 1; i <= 10; ++i) {
            if (this.useTransactions) {
                TxHelper.begin();
            }
            this.aRegion.put((Object)(NameFactory.OBJECT_NAME_PREFIX + i), (Object)new Integer(i));
            EventBB.getBB().getSharedCounters().increment(EventBB.NUM_CREATE);
            if (this.useTransactions) {
                TxHelper.commit();
            }
            this.checkEventCounters();
        }
    }

    public static void HydraTask_doUpdates() {
        testInstance.doUpdates();
    }

    public void doUpdates() {
        Log.getLogWriter().info("updating entries");
        for (int i = 1; i <= 10; ++i) {
            if (this.useTransactions) {
                TxHelper.begin();
            }
            Object o = this.aRegion.get((Object)(NameFactory.OBJECT_NAME_PREFIX + i));
            int n = (Integer)o + 1;
            this.aRegion.put((Object)(NameFactory.OBJECT_NAME_PREFIX + i), (Object)new Integer(n));
            EventBB.getBB().getSharedCounters().increment(EventBB.NUM_UPDATE);
            if (this.useTransactions) {
                TxHelper.commit();
            }
            this.checkEventCounters();
        }
    }

    public static void HydraTask_doUpdatesSameValues() {
        testInstance.doUpdatesSameValues();
    }

    public void doUpdatesSameValues() {
        Log.getLogWriter().info("updating entries with same value");
        for (int i = 1; i <= 10; ++i) {
            if (this.useTransactions) {
                TxHelper.begin();
            }
            Object o = this.aRegion.get((Object)(NameFactory.OBJECT_NAME_PREFIX + i));
            int n = (Integer)o + 1;
            this.aRegion.put((Object)(NameFactory.OBJECT_NAME_PREFIX + i), o);
            EventBB.getBB().getSharedCounters().increment(EventBB.NUM_UPDATE);
            if (this.useTransactions) {
                TxHelper.commit();
            }
            this.checkEventCounters();
        }
    }

    public static void HydraTask_doDestroys() {
        testInstance.doDestroys();
    }

    public void doDestroys() {
        Log.getLogWriter().info("destroying entries");
        for (int i = 1; i <= 10; ++i) {
            if (this.useTransactions) {
                TxHelper.begin();
            }
            try {
                this.aRegion.destroy((Object)(NameFactory.OBJECT_NAME_PREFIX + i));
            }
            catch (Exception e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            EventBB.getBB().getSharedCounters().increment(EventBB.NUM_DESTROY);
            if (this.useTransactions) {
                TxHelper.commit();
            }
            this.checkEventCounters();
        }
    }

    public static void HydraTask_doInvalidates() {
        testInstance.doInvalidates();
    }

    public void doInvalidates() {
        Log.getLogWriter().info("invalidating entries");
        for (int i = 1; i <= 10; ++i) {
            if (this.useTransactions) {
                TxHelper.begin();
            }
            try {
                this.aRegion.invalidate((Object)(NameFactory.OBJECT_NAME_PREFIX + i));
            }
            catch (Exception e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            EventBB.getBB().getSharedCounters().increment(EventBB.NUM_INVALIDATE);
            if (this.useTransactions) {
                TxHelper.commit();
            }
            this.checkEventCounters();
        }
    }

    public static void HydraTask_doOperations() {
        testInstance.loadRegion();
        testInstance.doUpdates();
        testInstance.doUpdatesSameValues();
        testInstance.doDestroys();
    }

    public static void HydraTask_doEntryOperations() {
        testInstance.doEntryOperations(CQEventTest.testInstance.aRegion);
    }

    protected void doEntryOperations(Region aRegion) {
        Log.getLogWriter().info("In doEntryOperations with " + aRegion.getFullPath());
        long startTime = System.currentTimeMillis();
        int numOps = 0;
        do {
            TestHelper.checkForEventError(ListenerBB.getBB());
            int whichOp = 0;
            whichOp = this.getOperation(CQUtilPrms.entryOperations);
            int size = aRegion.size();
            if (size >= this.upperThreshold) {
                whichOp = this.getOperation(CQUtilPrms.upperThresholdOperations);
            } else if (size <= this.lowerThreshold) {
                whichOp = this.getOperation(CQUtilPrms.lowerThresholdOperations);
            }
            switch (whichOp) {
                case 1: {
                    this.addEntry(aRegion);
                    break;
                }
                case 3: {
                    this.invalidateEntry(aRegion);
                    break;
                }
                case 2: {
                    this.destroyEntry(aRegion);
                    break;
                }
                case 6: {
                    this.updateEntry(aRegion);
                    break;
                }
                default: {
                    throw new TestException("Unknown operation " + whichOp);
                }
            }
            Log.getLogWriter().info("Completed op " + ++numOps + " for this task, region size is " + aRegion.size());
        } while (System.currentTimeMillis() - startTime < this.minTaskGranularityMS);
        Log.getLogWriter().info("Done in doEntryOperations with " + aRegion.getFullPath() + ", completed " + numOps + " ops in " + (System.currentTimeMillis() - startTime) + " millis");
        ClientHelper.release(CQEventTest.testInstance.aRegion);
    }

    protected int getOperation(Long whichPrm) {
        long limit = 60000L;
        long startTime = System.currentTimeMillis();
        int op = 0;
        String operation = TestConfig.tab().stringAt(whichPrm);
        if (operation.equals("add")) {
            op = 1;
        } else if (operation.equals("update")) {
            op = 6;
        } else if (operation.equals("invalidate")) {
            op = 3;
        } else if (operation.equals("destroy")) {
            op = 2;
        } else {
            throw new TestException("Unknown entry operation: " + operation);
        }
        return op;
    }

    public static Object getExistingKey(Region aRegion) {
        Object key = null;
        Object[] keys = aRegion.keySet().toArray();
        int numEntries = keys.length;
        if (numEntries <= 0) {
            Log.getLogWriter().info("getExistingKey(): No keys in region " + aRegion.getFullPath());
            return key;
        }
        key = keys[TestConfig.tab().getRandGen().nextInt(0, numEntries - 1)];
        return key;
    }

    protected void addEntry(Region aRegion) {
        String key = NameFactory.getNextPositiveObjectName();
        try {
            Log.getLogWriter().info("addEntry: creating key " + key + " in region  " + aRegion.getFullPath());
            aRegion.create((Object)key, (Object)new Integer((int)NameFactory.getCounterForName(key)));
            Log.getLogWriter().info("addEntry: done creating key " + key);
        }
        catch (EntryExistsException e) {
            if (this.isSerialExecution) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            Log.getLogWriter().info("Caught " + (Object)((Object)e) + " (expected with concurrent execution); continuing with test");
        }
    }

    protected void invalidateEntry(Region aRegion) {
        Object key = CQEventTest.getExistingKey(aRegion);
        if (key == null) {
            Log.getLogWriter().info("invalidateEntry: No keys in region");
            return;
        }
        boolean containsKey = aRegion.containsKey(key);
        boolean containsValueForKey = aRegion.containsValueForKey(key);
        Log.getLogWriter().info("containsKey for " + key + ": " + containsKey);
        Log.getLogWriter().info("containsValueForKey for " + key + ": " + containsValueForKey);
        try {
            Log.getLogWriter().info("invalidateEntry: invalidating key " + key);
            aRegion.invalidate(key);
            Log.getLogWriter().info("invalidateEntry: done invalidating key " + key);
        }
        catch (EntryNotFoundException e) {
            if (this.isSerialExecution) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            Log.getLogWriter().info("Caught " + (Object)((Object)e) + " (expected with concurrent execution); continuing with test");
            return;
        }
    }

    protected void destroyEntry(Region aRegion) {
        Object key = CQEventTest.getExistingKey(aRegion);
        if (key == null) {
            Log.getLogWriter().info("destroyEntry: No keys in region");
            return;
        }
        try {
            Log.getLogWriter().info("destroyEntry: destroying key " + key);
            aRegion.destroy(key);
            Log.getLogWriter().info("destroyEntry: done destroying key " + key);
        }
        catch (EntryNotFoundException e) {
            if (this.isSerialExecution) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            Log.getLogWriter().info("Caught " + (Object)((Object)e) + " (expected with concurrent execution); continuing with test");
            return;
        }
    }

    protected void updateEntry(Region aRegion) {
        Object key = CQEventTest.getExistingKey(aRegion);
        if (key == null) {
            Log.getLogWriter().info("updateEntry: No keys in region");
            return;
        }
        Log.getLogWriter().info("updateEntry: replacing key " + key);
        Object val = aRegion.get((Object)aRegion, key);
        if (val == null) {
            val = new Integer((int)NameFactory.getCounterForName(key));
        }
        Object returnVal = aRegion.put(key, (Object)new Integer((Integer)val + 1));
        Log.getLogWriter().info("updateEntry: replaced (put) key " + key + " returnVal is " + returnVal);
    }

    public static void HydraTask_checkCQ() throws CqException {
        testInstance.checkCQ();
    }

    public void checkCQ() {
        CQUtil.displaySelectResults();
        Set regions = CacheHelper.getCache().rootRegions();
        StringBuffer aStr = new StringBuffer("rootRegions = \n");
        for (Region aRegion : regions) {
            aStr.append("   " + aRegion.getFullPath() + " named " + aRegion.getName() + "\n");
        }
        Log.getLogWriter().info(aStr.toString());
    }

    public static void HydraTask_printEventCounts() {
        EventBB.getBB().printSharedCounters();
        EventCountersBB.getBB().printSharedCounters();
        CQUtilBB.printBB();
    }

    private void checkEventCounters() {
        SharedCounters counters = EventBB.getBB().getSharedCounters();
        EventBB.getBB().printSharedCounters();
        long numCreate = counters.read(EventBB.NUM_CREATE);
        long numUpdate = counters.read(EventBB.NUM_UPDATE);
        long numDestroy = counters.read(EventBB.NUM_DESTROY);
        long numInvalidate = counters.read(EventBB.NUM_INVALIDATE);
        StringBuffer errMsg = new StringBuffer();
        long numCQListeners = CQUtilBB.getBB().getSharedCounters().read(CQUtilBB.NUM_CQS);
        Log.getLogWriter().info("num threads with registered CQs = " + numCQListeners);
        boolean registerInterest = TestConfig.tab().booleanAt(CQUtilPrms.registerInterest, false);
        boolean clientInFeederVm = TestConfig.tab().booleanAt(CQUtilPrms.clientInFeederVm, false);
        long numRIListeners = CQUtilBB.getBB().getSharedCounters().read(CQUtilBB.NUM_RI_VMS);
        if (!registerInterest) {
            numRIListeners = clientInFeederVm ? 0L : 1L;
        }
        Log.getLogWriter().info("num VMs with cacheListeners = " + numRIListeners);
        ArrayList al = new ArrayList();
        TestHelper.waitForCounter(CQUtilBB.getBB(), "NUM_CREATE", CQUtilBB.NUM_CREATE, numCreate * numCQListeners, true, 60000L);
        TestHelper.waitForCounter(CQUtilBB.getBB(), "NUM_UPDATE", CQUtilBB.NUM_UPDATE, numUpdate * numCQListeners, true, 60000L);
        TestHelper.waitForCounter(CQUtilBB.getBB(), "NUM_DESTROY", CQUtilBB.NUM_DESTROY, numDestroy * numCQListeners, true, 60000L);
        TestHelper.waitForCounter(CQUtilBB.getBB(), "NUM_INVALIDATE", CQUtilBB.NUM_INVALIDATE, numInvalidate * numCQListeners, true, 60000L);
        TestHelper.waitForCounterSum(EventCountersBB.getBB(), "numAfterCreateEvents_isDist", "numAfterCreateEvents_isNotDist", numCreate * numRIListeners, true, 60000L);
        TestHelper.waitForCounterSum(EventCountersBB.getBB(), "numAfterUpdateEvents_isDist", "numAfterUpdateEvents_isNotDist", numUpdate * numRIListeners, true, 60000L);
        TestHelper.waitForCounterSum(EventCountersBB.getBB(), "numAfterDestroyEvents_isDist", "numAfterDestroyEvents_isNotDist", numDestroy * numRIListeners, true, 60000L);
        TestHelper.waitForCounterSum(EventCountersBB.getBB(), "numAfterInvalidateEvents_isDist", "numAfterInvalidateEvents_isNotDist", numInvalidate * numRIListeners, true, 60000L);
    }
}

