/*
 * Decompiled with CFR 0.152.
 */
package container.app.util;

import container.app.util.ArrayUtils;
import container.app.util.StringUtils;
import java.text.MessageFormat;

public final class Assert {
    private static String formatMessage(String message, Object ... args) {
        return ArrayUtils.isEmpty(args) ? message : MessageFormat.format(message, args);
    }

    public static void hasValue(String value, String message, Object ... args) {
        Assert.hasValue(value, new IllegalArgumentException(Assert.formatMessage(message, args)));
    }

    public static void hasValue(String value, RuntimeException e) {
        if (StringUtils.isWorthless(value)) {
            throw e;
        }
    }

    public static void instanceOf(Object obj, Class<?> clazz, String message, Object ... args) {
        Assert.instanceOf(obj, clazz, new IllegalArgumentException(Assert.formatMessage(message, args)));
    }

    public static void instanceOf(Object obj, Class<?> clazz, RuntimeException e) {
        if (!clazz.isAssignableFrom(obj.getClass())) {
            throw e;
        }
    }

    public static void notNull(Object obj, String message, Object ... args) {
        Assert.notNull(obj, new NullPointerException(Assert.formatMessage(message, args)));
    }

    public static void notNull(Object obj, RuntimeException e) {
        if (obj == null) {
            throw e;
        }
    }

    public static void state(Boolean condition, String message, Object ... args) {
        Assert.state(condition, new IllegalStateException(Assert.formatMessage(message, args)));
    }

    public static void state(Boolean condition, RuntimeException e) {
        if (!Boolean.TRUE.equals(condition)) {
            throw e;
        }
    }
}

