/*
 * Decompiled with CFR 0.152.
 */
package container.app.remoting.rmi;

import container.app.remoting.rmi.service.Pingable;
import container.app.util.ArrayUtils;
import container.app.util.Assert;
import container.app.util.StringUtils;
import container.app.util.SystemUtils;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;

public class RmiRegistryConsole {
    private static final StringBuilder menu = new StringBuilder("\nRMI Registry Console - Please enter one of the following commands:\n");

    private static void locateRegistry(ConsoleContext context) throws RemoteException {
        context.setRegistry(LocateRegistry.getRegistry(context.getHost(), context.getPort()));
    }

    private static ConsoleContext parseCommandLineArguments(String ... args) {
        String host = null;
        int port = -1;
        for (String arg : args) {
            if ("-help".equalsIgnoreCase(arg.trim())) {
                SystemUtils.printToStandardOut("> java container.app.remoting.rmi.RmiRegistryConsole [host] [port]", new Object[0]);
                System.exit(0);
                continue;
            }
            try {
                port = Integer.parseInt(arg);
            }
            catch (NumberFormatException e) {
                host = arg;
            }
        }
        return new ConsoleContext(host, port);
    }

    private static String promptForUserInput(Scanner in) {
        System.out.print("> ");
        System.out.flush();
        return in.nextLine();
    }

    public static void main(String[] args) throws Exception {
        ConsoleContext context = RmiRegistryConsole.parseCommandLineArguments(args);
        Scanner in = new Scanner(System.in);
        String userInput = null;
        RmiRegistryConsole.locateRegistry(context);
        System.out.println(menu.toString());
        while (true) {
            userInput = RmiRegistryConsole.promptForUserInput(in);
            AbstractCommand.parseCommandLine(userInput).execute(context);
        }
    }

    static {
        menu.append("1. list - lists all available remote object services in the registry.\n");
        menu.append("2. ping <service-name> - determines if the specified remote object service is responding to remote calls.\n");
        menu.append("3. mirror <service-name> <argument> - reverses the characters in the specified argument.\n");
        menu.append("4. echo <service-name> <argument> - echos the given argument.\n");
        menu.append("5. help - print the menu.\n");
        menu.append("6. exit - exits from the RMI Registry Console.\n\n");
    }

    protected static final class UnknownCommand
    extends AbstractRegistryCommand {
        protected UnknownCommand() {
        }

        @Override
        protected CommandKeyword getKeyword() {
            return CommandKeyword.UNKNOWN;
        }

        @Override
        public void executeImpl(ConsoleContext context) {
        }
    }

    protected static class PingCommand
    extends AbstractServiceCallCommand {
        protected PingCommand() {
        }

        @Override
        protected CommandKeyword getKeyword() {
            return CommandKeyword.PING;
        }

        @Override
        protected void executeImpl(ConsoleContext context) throws Exception {
            try {
                Assert.state(this.getPingableService(context).isAlive(), "", new Object[0]);
                SystemUtils.printToStandardOut("{0} is alive!", this.getServiceName());
            }
            catch (Exception e) {
                SystemUtils.printToStandardOut("{0} is unavailable!", this.getServiceName());
                e.printStackTrace(System.err);
                System.err.flush();
                for (Throwable t = e.getCause(); t != null; t = t.getCause()) {
                    System.err.print("Caused by: ");
                    t.printStackTrace(System.err);
                    System.err.flush();
                }
            }
        }
    }

    protected static class MirrorCommand
    extends AbstractServiceCallCommand {
        protected MirrorCommand() {
        }

        @Override
        protected CommandKeyword getKeyword() {
            return CommandKeyword.MIRROR;
        }

        @Override
        protected void executeImpl(ConsoleContext context) throws Exception {
            SystemUtils.printToStandardOut(this.getPingableService(context).mirror(this.getMessage()), new Object[0]);
        }
    }

    protected static class ListCommand
    extends AbstractRegistryCommand {
        protected ListCommand() {
        }

        @Override
        protected CommandKeyword getKeyword() {
            return CommandKeyword.LIST;
        }

        @Override
        public void executeImpl(ConsoleContext context) throws Exception {
            SystemUtils.printToStandardOut("Available services for host ({0}) listening on port ({1}): {2}", context.getHost(), context.getPort(), Arrays.asList(context.getRegistry().list()));
        }
    }

    protected static class HelpCommand
    extends AbstractRegistryCommand {
        protected HelpCommand() {
        }

        @Override
        protected CommandKeyword getKeyword() {
            return CommandKeyword.HELP;
        }

        @Override
        protected void executeImpl(ConsoleContext context) throws Exception {
            SystemUtils.printToStandardOut(menu.toString(), new Object[0]);
        }
    }

    protected static class ExitCommand
    extends AbstractRegistryCommand {
        protected ExitCommand() {
        }

        @Override
        protected CommandKeyword getKeyword() {
            return CommandKeyword.EXIT;
        }

        @Override
        protected void executeImpl(ConsoleContext context) throws Exception {
            SystemUtils.printToStandardOut("Exiting the RMI Registry Console...", new Object[0]);
            System.exit(0);
        }
    }

    protected static class EchoCommand
    extends AbstractServiceCallCommand {
        protected EchoCommand() {
        }

        @Override
        protected CommandKeyword getKeyword() {
            return CommandKeyword.ECHO;
        }

        @Override
        protected void executeImpl(ConsoleContext context) throws Exception {
            SystemUtils.printToStandardOut(this.getPingableService(context).echo(this.getMessage()), new Object[0]);
        }
    }

    protected static abstract class AbstractServiceCallCommand
    extends AbstractCommand {
        private String message;
        private String serviceName;

        protected AbstractServiceCallCommand() {
        }

        protected String getMessage() {
            return this.message;
        }

        protected Pingable getPingableService(ConsoleContext context) throws NotBoundException, RemoteException {
            Registry registry = context.getRegistry();
            Remote remoteObject = registry.lookup(this.getServiceName());
            Assert.notNull(remoteObject, "The remote object was null!", new Object[0]);
            Assert.instanceOf(remoteObject, Pingable.class, "The remote object must be an instance of Pingable to invoke this command!", new Object[0]);
            return (Pingable)remoteObject;
        }

        protected String getServiceName() {
            return this.serviceName;
        }

        @Override
        public void parseArguments(String[] arguments) {
            this.serviceName = ArrayUtils.elementAt(arguments, 0, null);
            Assert.notNull(this.serviceName, "The service name cannot be null!", new Object[0]);
            this.message = ArrayUtils.elementAt(arguments, 1, "null");
        }
    }

    protected static abstract class AbstractRegistryCommand
    extends AbstractCommand {
        protected AbstractRegistryCommand() {
        }

        @Override
        public void parseArguments(String[] arguments) {
        }
    }

    protected static abstract class AbstractCommand
    implements Command {
        private static final Map<CommandKeyword, Command> COMMAND_MAP = new HashMap<CommandKeyword, Command>();

        protected AbstractCommand() {
        }

        protected abstract CommandKeyword getKeyword();

        @Override
        public void execute(ConsoleContext context) {
            try {
                this.executeImpl(context);
            }
            catch (Exception e) {
                SystemUtils.printToStandardError("The execution of command ({0}) failed with the following error: {1}", this, e.getMessage());
            }
        }

        protected abstract void executeImpl(ConsoleContext var1) throws Exception;

        public static Command lookupCommand(CommandKeyword cmdKey) {
            return COMMAND_MAP.get((Object)cmdKey);
        }

        public static Command parseCommandLine(String commandLine) {
            Scanner scanner = new Scanner(commandLine);
            if (scanner.hasNext()) {
                String commandName = scanner.next();
                StringBuilder commandArguments = new StringBuilder(" ");
                while (scanner.hasNext()) {
                    commandArguments.append(scanner.next());
                    commandArguments.append(" ");
                }
                Command command = AbstractCommand.lookupCommand(CommandKeyword.getByName(commandName));
                command.parseArguments(StringUtils.split(commandArguments.toString().trim()));
                return command;
            }
            return AbstractCommand.lookupCommand(CommandKeyword.UNKNOWN);
        }

        public String toString() {
            return this.getKeyword().toString();
        }

        static {
            COMMAND_MAP.put(CommandKeyword.ECHO, new EchoCommand());
            COMMAND_MAP.put(CommandKeyword.EXIT, new ExitCommand());
            COMMAND_MAP.put(CommandKeyword.HELP, new HelpCommand());
            COMMAND_MAP.put(CommandKeyword.LIST, new ListCommand());
            COMMAND_MAP.put(CommandKeyword.MIRROR, new MirrorCommand());
            COMMAND_MAP.put(CommandKeyword.PING, new PingCommand());
            COMMAND_MAP.put(CommandKeyword.UNKNOWN, new UnknownCommand());
        }
    }

    protected static interface Command {
        public void execute(ConsoleContext var1);

        public void parseArguments(String[] var1);
    }

    protected static enum CommandKeyword {
        ECHO,
        EXIT,
        HELP,
        LIST,
        MIRROR,
        PING,
        UNKNOWN;


        public static CommandKeyword getByName(String commandName) {
            for (CommandKeyword cmd : CommandKeyword.values()) {
                if (!cmd.name().equalsIgnoreCase(StringUtils.trim(commandName))) continue;
                return cmd;
            }
            return UNKNOWN;
        }

        public String toString() {
            return this.name().toLowerCase();
        }
    }

    protected static class ConsoleContext {
        protected static final String DEFAULT_HOST = "localhost";
        protected static final int DEFAULT_PORT = 1099;
        private final int port;
        private Registry registry;
        private final String host;

        public ConsoleContext() {
            this(DEFAULT_HOST, 1099);
        }

        public ConsoleContext(String host, int port) {
            this.host = StringUtils.defaultIfNoValue(host, DEFAULT_HOST);
            this.port = port > 0 ? port : 1099;
        }

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }

        public Registry getRegistry() {
            Assert.state(this.registry != null, "The RMI Registry service was not properly located!", new Object[0]);
            return this.registry;
        }

        public void setRegistry(Registry registry) {
            Assert.notNull(registry, "The reference to the RMI Registry cannot be null!", new Object[0]);
            this.registry = registry;
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder(this.getClass().getName());
            buffer.append("{host = ").append(this.getHost());
            buffer.append(", port = ").append(this.getPort());
            buffer.append("}");
            return buffer.toString();
        }
    }
}

