/*
 * Decompiled with CFR 0.152.
 */
package container.app.phonedirectory.dao.factory;

import container.app.phonedirectory.dao.PhoneDirectoryDao;
import container.app.phonedirectory.dao.provider.CachingPhoneDirectoryDao;

public abstract class PhoneDirectoryDaoFactory {
    private static PhoneDirectoryDaoFactory daoFactory;

    public static synchronized PhoneDirectoryDaoFactory getInstance() {
        if (daoFactory == null) {
            daoFactory = new DefaultPhoneDirectoryDaoFactory();
        }
        return daoFactory;
    }

    public static PhoneDirectoryDao getPhoneDirectoryDao() {
        return PhoneDirectoryDaoFactory.getInstance().createPhoneDirectoryDao();
    }

    public static PhoneDirectoryDao getPhoneDirectoryDao(boolean lazyInit) {
        return PhoneDirectoryDaoFactory.getInstance().createPhoneDirectoryDao(lazyInit);
    }

    public PhoneDirectoryDao createPhoneDirectoryDao() {
        return this.createPhoneDirectoryDao(false);
    }

    public abstract PhoneDirectoryDao createPhoneDirectoryDao(boolean var1);

    protected static class DefaultPhoneDirectoryDaoFactory
    extends PhoneDirectoryDaoFactory {
        protected DefaultPhoneDirectoryDaoFactory() {
        }

        @Override
        public PhoneDirectoryDao createPhoneDirectoryDao(boolean lazyInit) {
            return new CachingPhoneDirectoryDao(lazyInit);
        }
    }
}

