/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.sequence.gemfire;

import com.gemstone.gemfire.internal.sequencelog.GraphType;
import com.gemstone.gemfire.internal.sequencelog.io.Filter;
import com.gemstone.gemfire.internal.sequencelog.io.GraphReader;
import com.gemstone.gemfire.internal.sequencelog.model.Edge;
import com.gemstone.gemfire.internal.sequencelog.model.Graph;
import com.gemstone.gemfire.internal.sequencelog.model.GraphID;
import com.gemstone.gemfire.internal.sequencelog.model.GraphSet;
import com.gemstone.gemfire.internal.sequencelog.model.Vertex;
import com.gemstone.sequence.Arrow;
import com.gemstone.sequence.Lifeline;
import com.gemstone.sequence.LifelineState;
import com.gemstone.sequence.LineMapper;
import com.gemstone.sequence.SequenceDiagram;
import com.gemstone.sequence.SequencePanel;
import com.gemstone.sequence.gemfire.DefaultLineMapper;
import com.gemstone.sequence.gemfire.HydraLineMapper;
import com.gemstone.sequence.gemfire.SelectGraphDialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class GemfireSequenceDisplay {
    private JLabel selectedGraphsLabel;
    private SelectGraphDialog selectGraphDialog;
    private Map<GraphID, Map<String, Lifeline>> lineMap = new HashMap<GraphID, Map<String, Lifeline>>();
    private Map<GraphID, List<Arrow>> arrowMap = new HashMap<GraphID, List<Arrow>>();
    private SequenceDiagram sequenceDiagram;
    private JFrame frame;
    private SequencePanel sequencePanel;

    private void createAndShowGUI(GraphSet graphs, LineMapper lineMapper) {
        this.frame = new JFrame("SequenceDiagram");
        this.frame.setDefaultCloseOperation(3);
        this.createMenu();
        this.createSequenceDiagram(graphs, lineMapper);
        this.createSequenceMaps(graphs);
        this.createSelectGraphDialog(graphs);
        this.sequencePanel = new SequencePanel(this.sequenceDiagram);
        this.frame.getContentPane().add(this.sequencePanel);
        this.frame.pack();
        this.frame.setVisible(true);
        this.showGraphSelector();
    }

    private void createMenu() {
        JMenuBar menuBar = new JMenuBar();
        JMenu sequenceMenu = new JMenu("Sequence");
        sequenceMenu.setMnemonic(83);
        sequenceMenu.getAccessibleContext().setAccessibleDescription("The only menu in this program that has menu items");
        menuBar.add(sequenceMenu);
        JMenuItem selectGraphs = new JMenuItem("Choose Graphs", 71);
        selectGraphs.setAccelerator(KeyStroke.getKeyStroke(71, 8));
        selectGraphs.getAccessibleContext().setAccessibleDescription("Select what graphs to display");
        selectGraphs.setActionCommand("selectgraphs");
        selectGraphs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GemfireSequenceDisplay.this.showGraphSelector();
            }
        });
        sequenceMenu.add(selectGraphs);
        this.frame.setJMenuBar(menuBar);
    }

    private void createSelectGraphDialog(GraphSet graphs) {
        this.selectGraphDialog = new SelectGraphDialog(graphs);
        this.selectGraphDialog.addSelectionListener(new SelectGraphDialog.SelectionListener(){

            @Override
            public void selectionChanged(List<GraphID> selectedIds) {
                GemfireSequenceDisplay.this.updateGraphs(selectedIds);
            }
        });
        this.selectGraphDialog.pack();
    }

    private void updateGraphs(List<GraphID> selectedIds) {
        List<Comparable> existingDiagrams = this.sequenceDiagram.getSubDiagramsNames();
        for (GraphID graphID : selectedIds) {
            this.showSubDiagram(graphID);
            existingDiagrams.remove(graphID);
        }
        for (GraphID graphID : existingDiagrams) {
            this.hideSubDiagram(graphID);
        }
        this.sequenceDiagram.resizeMe(this.sequenceDiagram.getWidth(), this.sequenceDiagram.getHeight());
        this.sequencePanel.revalidate();
        this.sequencePanel.repaint();
    }

    private void showGraphSelector() {
        this.selectGraphDialog.setVisible(true);
    }

    private void hideGraphSelector() {
        this.selectGraphDialog.setVisible(false);
    }

    private void createSequenceMaps(GraphSet graphs) {
        Map map = graphs.getMap();
        for (Map.Entry entry : map.entrySet()) {
            GraphID graphId = (GraphID)entry.getKey();
            Graph graph = (Graph)entry.getValue();
            LinkedHashMap<String, Lifeline> lines = new LinkedHashMap<String, Lifeline>(graphs.getLocations().size());
            ArrayList<Arrow> arrows = new ArrayList<Arrow>();
            HashMap<Vertex, LifelineState> states = new HashMap<Vertex, LifelineState>();
            for (String location : graphs.getLocations()) {
                lines.put(location, new Lifeline((Comparable)graphId, location));
            }
            Collection edges = graph.getEdges();
            for (Edge edge : edges) {
                LifelineState sourceState;
                LifelineState destState;
                Vertex dest = edge.getDest();
                Vertex source = edge.getSource();
                if (dest == null) {
                    dest = source;
                }
                if (source == null) {
                    source = dest;
                }
                if ((destState = (LifelineState)states.get(dest)) == null) {
                    Lifeline lifeline = (Lifeline)lines.get(dest.getName());
                    destState = GemfireSequenceDisplay.createState(lifeline, graphs, dest);
                    lifeline.addState(destState);
                    states.put(dest, destState);
                }
                if ((sourceState = (LifelineState)states.get(source)) == null) {
                    Lifeline lifeline = (Lifeline)lines.get(source.getName());
                    sourceState = GemfireSequenceDisplay.createState(lifeline, graphs, source);
                    lifeline.addState(sourceState);
                    states.put(source, sourceState);
                }
                Arrow arrow = new Arrow(edge.getName(), sourceState, destState);
                arrows.add(arrow);
                destState.addInboundArrow(arrow);
            }
            this.lineMap.put(graphId, lines);
            this.arrowMap.put(graphId, arrows);
        }
    }

    public void showSubDiagram(GraphID id) {
        this.sequenceDiagram.addSubDiagram((Comparable)id, this.lineMap.get(id), this.arrowMap.get(id));
    }

    public void hideSubDiagram(GraphID id) {
        this.sequenceDiagram.removeSubDiagram((Comparable)id);
    }

    private SequenceDiagram createSequenceDiagram(GraphSet graphs, LineMapper lineMapper) {
        this.sequenceDiagram = new SequenceDiagram(graphs.getMinTime(), graphs.getMaxTime(), graphs.getLocations(), lineMapper);
        return this.sequenceDiagram;
    }

    private static LifelineState createState(Lifeline lifeline, GraphSet graphs, Vertex dest) {
        long start = dest.getTimestamp();
        long end = dest.getNextVertexOnDest() == null ? graphs.getMaxTime() : dest.getNextVertexOnDest().getTimestamp();
        return new LifelineState(lifeline, dest.getState(), start, end);
    }

    public static void main(String[] args) throws IOException {
        ArrayList<File> fileList;
        HashSet<String> keyFilters = new HashSet<String>();
        boolean areGemfireLogs = false;
        if (args.length > 0) {
            fileList = new ArrayList<File>();
            for (int i = 0; i < args.length; ++i) {
                String arg = args[i];
                if (arg.equals("-filterkey")) {
                    keyFilters.add(args[i + 1]);
                    ++i;
                    continue;
                }
                if (arg.equals("-logs")) {
                    areGemfireLogs = true;
                    continue;
                }
                fileList.add(new File(args[i]));
            }
        } else {
            System.err.println("Usage: java -jar sequence.jar (-logs) (-filterkey key)* <file>+\n\n\t-logs (expiremental) instead of using .graph files, parse the gemfire logs to generate the sequence display\t-filterkey a java regular expression to match against key names. If specified\nThe list of key sequence diagrams will only contain matching keys");
            System.exit(1);
            return;
        }
        File[] files = fileList.toArray(new File[0]);
        final GraphSet graphs = GemfireSequenceDisplay.getGraphs(areGemfireLogs, keyFilters, files);
        final LineMapper lineMapper = GemfireSequenceDisplay.getLineMapper(files);
        final GemfireSequenceDisplay display = new GemfireSequenceDisplay();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                display.createAndShowGUI(graphs, lineMapper);
            }
        });
    }

    private static GraphSet getGraphs(boolean useLogFiles, Set<String> keyFilters, File[] files) throws IOException {
        KeyFilter graphFilter = new KeyFilter(keyFilters);
        GraphReader reader = new GraphReader(files);
        GraphSet graphs = keyFilters.isEmpty() ? reader.readGraphs(useLogFiles) : reader.readGraphs((Filter)graphFilter, useLogFiles);
        return graphs;
    }

    private static LineMapper getLineMapper(File[] files) {
        if (HydraLineMapper.isInHydraRun(files)) {
            return new HydraLineMapper(files);
        }
        return new DefaultLineMapper();
    }

    private static class KeyFilter
    implements Filter {
        Set<Pattern> patterns = new HashSet<Pattern>();

        public KeyFilter(Set<String> keyFilters) {
            for (String filterString : keyFilters) {
                this.patterns.add(Pattern.compile(filterString));
            }
        }

        public boolean accept(GraphType graphType, String name, String edgeName, String source, String dest) {
            if (graphType.equals((Object)GraphType.KEY)) {
                for (Pattern pattern : this.patterns) {
                    if (!pattern.matcher(name).find()) continue;
                    return true;
                }
                return false;
            }
            return true;
        }

        public boolean acceptPattern(GraphType graphType, Pattern pattern, String edgeName, String source, String dest) {
            return true;
        }
    }
}

