/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.sequence;

import com.gemstone.sequence.Lifeline;
import com.gemstone.sequence.LifelineState;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;

public class Arrow {
    private static int ARROW_WIDTH = 10;
    private static int CIRCLE_WIDTH = 6;
    private static int LABEL_OFFSET = 10;
    private final String label;
    private final LifelineState startingState;
    private final LifelineState endingState;

    public Arrow(String label, LifelineState startingState, LifelineState endingState) {
        this.label = label;
        this.startingState = startingState;
        this.endingState = endingState;
    }

    public void paint(Graphics2D g) {
        boolean isReflexsive;
        Rectangle boundary = g.getClipBounds();
        int y = this.endingState.getStartY();
        if ((double)(y + ARROW_WIDTH) < boundary.getMinY() || (double)(y - ARROW_WIDTH) > boundary.getMaxY()) {
            return;
        }
        boolean bl = isReflexsive = this.getStartingLine() == this.getEndingLine();
        if (isReflexsive) {
            this.paintReflexive(g);
        } else {
            this.paintNormal(g);
        }
    }

    private Lifeline getStartingLine() {
        return this.startingState.getLine();
    }

    private Lifeline getEndingLine() {
        return this.endingState.getLine();
    }

    private void paintReflexive(Graphics2D g) {
        Lifeline startingLine = this.getStartingLine();
        int x = startingLine.getX();
        int y = this.endingState.getStartY();
        g.drawArc(x + startingLine.getWidth() - ARROW_WIDTH / 2, y - ARROW_WIDTH, ARROW_WIDTH, ARROW_WIDTH, 90, -180);
        g.drawString(this.label, x + startingLine.getWidth() + LABEL_OFFSET, y);
    }

    private void paintNormal(Graphics2D g) {
        Lifeline startingLine = this.getStartingLine();
        Lifeline endingLine = this.getEndingLine();
        int x1 = startingLine.getX();
        int x2 = endingLine.getX();
        int y = this.endingState.getStartY();
        if (x2 > x1) {
            int startX = x1 + startingLine.getWidth();
            int endX = x2;
            GeneralPath path = new GeneralPath();
            path.moveTo(startX, y);
            path.lineTo(endX, y);
            path.lineTo(endX - ARROW_WIDTH, y - ARROW_WIDTH);
            path.moveTo(endX, y);
            path.lineTo(endX - ARROW_WIDTH, y + ARROW_WIDTH);
            g.draw(path);
            g.fillArc(startX, y - CIRCLE_WIDTH / 2, CIRCLE_WIDTH, CIRCLE_WIDTH, 0, 360);
            g.drawString(this.label, startX + LABEL_OFFSET, y - LABEL_OFFSET);
        } else {
            int startX = x1;
            int endX = x2 + endingLine.getWidth();
            GeneralPath path = new GeneralPath();
            path.moveTo(startX, y);
            path.lineTo(endX, y);
            path.lineTo(endX + ARROW_WIDTH, y - ARROW_WIDTH);
            path.moveTo(endX, y);
            path.lineTo(endX + ARROW_WIDTH, y + ARROW_WIDTH);
            g.draw(path);
            int labelWidth = g.getFontMetrics().stringWidth(this.label);
            g.fillArc(startX - CIRCLE_WIDTH / 2, y - CIRCLE_WIDTH / 2, CIRCLE_WIDTH, CIRCLE_WIDTH, 0, 360);
            g.drawString(this.label, startX - LABEL_OFFSET - labelWidth, y - LABEL_OFFSET);
        }
    }

    public LifelineState getStartingState() {
        return this.startingState;
    }
}

