/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.persistence.admin;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.BreakIterator;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class Logger {
    private static final PrintWriter logWriter;
    private static final int LOGWIDTH = Integer.MAX_VALUE;
    private static final SimpleDateFormat timeFormatter;

    private static void formatText(PrintWriter writer, String target, int maxLength, int initialLength) {
        BreakIterator boundary = BreakIterator.getLineInstance();
        boundary.setText(target);
        int start = boundary.first();
        int end = boundary.next();
        int lineLength = initialLength;
        while (end != -1) {
            char endChar = target.charAt(end - 1);
            while (!Character.isWhitespace(endChar)) {
                int lastEnd = end;
                end = boundary.next();
                if (end == -1) {
                    end = lastEnd;
                    break;
                }
                endChar = target.charAt(end - 1);
            }
            int wordEnd = end;
            if (endChar == '\n') {
                --wordEnd;
            } else if (endChar == '\t') {
                lineLength += 7;
            }
            String word = target.substring(start, wordEnd);
            if (lineLength + word.length() >= maxLength && lineLength != 0) {
                writer.println();
                writer.print("  ");
                lineLength = 2;
            }
            lineLength += word.length();
            writer.print(word);
            if (endChar == '\n') {
                writer.println();
                writer.print("  ");
                lineLength = 2;
            }
            start = end;
            end = boundary.next();
        }
        if (lineLength != 0) {
            writer.println();
        }
    }

    public static String getTimeStamp() {
        return Logger.formatDate(new Date());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatDate(Date d) {
        if (timeFormatter == null) {
            try {
                return Long.toString(d.getTime());
            }
            catch (Exception ignore) {
                return "timestampFormatFailed";
            }
        }
        try {
            SimpleDateFormat ignore = timeFormatter;
            synchronized (ignore) {
                return timeFormatter.format(d);
            }
        }
        catch (Exception e1) {
            try {
                return d.toString();
            }
            catch (Exception e2) {
                try {
                    return Long.toString(d.getTime());
                }
                catch (Exception e3) {
                    return "timestampFormatFailed";
                }
            }
        }
    }

    public static void put(String msg) {
        Logger.put(msg, (Throwable)null);
    }

    public static void put(PrintWriter log, String msg) {
        Logger.put(log, msg, null);
    }

    public static void put(Throwable exception) {
        Logger.put((String)null, exception);
    }

    public static void put(PrintWriter log, Throwable exception) {
        Logger.put(log, null, exception);
    }

    public static void put(String msg, Throwable exception) {
        Logger.put(logWriter, msg, exception);
    }

    public static void put(PrintWriter log, String msg, Throwable exception) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println();
        String header = '[' + Logger.getTimeStamp() + ' ' + Thread.currentThread().getName() + "] ";
        pw.print(header);
        if (msg != null) {
            try {
                Logger.formatText(pw, msg, Integer.MAX_VALUE, header.length());
            }
            catch (RuntimeException e) {
                pw.println(msg);
                pw.println("Ignoring exception:");
                e.printStackTrace(pw);
            }
        } else {
            pw.println();
        }
        if (exception != null) {
            exception.printStackTrace(pw);
        }
        pw.close();
        try {
            sw.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (log == null) {
            log = logWriter;
        }
        log.print(sw.toString());
        log.flush();
    }

    public static String format(String format, Object[] objs) {
        String[] strings = new String[objs.length];
        for (int i = 0; i < objs.length; ++i) {
            Object obj = objs[i];
            if (obj == null) {
                strings[i] = "null";
                continue;
            }
            try {
                strings[i] = obj.toString();
                continue;
            }
            catch (Exception ex) {
                strings[i] = obj.getClass().getName() + "@" + System.identityHashCode(obj);
            }
        }
        return MessageFormat.format(format, strings);
    }

    static {
        SimpleDateFormat sdf;
        logWriter = new PrintWriter(System.out, true);
        String defaultFormatPattern = "MM/dd/yy HH:mm:ss.SSS z";
        String resourceName = "com.gemstone.persistence.admin.LoggerResources";
        String keyName = "logger.timeStampFormat";
        String formatPattern = "MM/dd/yy HH:mm:ss.SSS z";
        try {
            ResourceBundle messageRB = ResourceBundle.getBundle("com.gemstone.persistence.admin.LoggerResources");
            try {
                formatPattern = messageRB.getString("logger.timeStampFormat");
            }
            catch (MissingResourceException e) {
                System.out.println("NOTICE: Logger using default timestamp format. Could not get resource key \"logger.timeStampFormat\" because: " + e);
            }
        }
        catch (MissingResourceException e) {
            System.out.println("NOTICE: Logger using default timestamp format. Could not load resource bundle \"com.gemstone.persistence.admin.LoggerResources\" because: " + e);
        }
        if (formatPattern.length() == 0) {
            sdf = null;
        } else {
            try {
                sdf = new SimpleDateFormat(formatPattern);
            }
            catch (RuntimeException e) {
                System.out.println("NOTICE: ignoring timestamp pattern \"" + formatPattern + "\" because: " + e.toString());
                System.out.println("  Using default pattern: \"MM/dd/yy HH:mm:ss.SSS z\".");
                formatPattern = "MM/dd/yy HH:mm:ss.SSS z";
                sdf = new SimpleDateFormat(formatPattern);
            }
        }
        timeFormatter = sdf;
    }
}

