/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.security;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.Locator;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.membership.jgroup.JGroupMembershipManager;
import com.gemstone.gemfire.distributed.internal.membership.jgroup.MembershipManagerHelper;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.security.AuthenticationFailedException;
import com.gemstone.gemfire.security.AuthenticationRequiredException;
import com.gemstone.gemfire.security.GemFireSecurityException;
import com.gemstone.gemfire.security.SecurityTestUtil;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.RMIException;
import dunit.VM;
import java.io.File;
import java.util.Map;
import java.util.Properties;
import javax.net.ssl.SSLHandshakeException;
import security.CredentialGenerator;
import security.DummyCredentialGenerator;
import security.LdapUserCredentialGenerator;

public class P2PAuthenticationDUnitTest
extends DistributedTestCase {
    private static VM locatorVM = null;
    public static final String USER_NAME = "security-username";
    public static final String PASSWORD = "security-password";
    private static final String[] expectedExceptions = new String[]{AuthenticationRequiredException.class.getName(), AuthenticationFailedException.class.getName(), GemFireSecurityException.class.getName(), SSLHandshakeException.class.getName(), ClassNotFoundException.class.getName()};

    public P2PAuthenticationDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        Host host = Host.getHost(0);
        locatorVM = host.getVM(0);
    }

    private void setProperty(Properties props, String key, String value) {
        if (key != null && value != null) {
            props.setProperty(key, value);
        }
    }

    public void testIllegalPropertyCombos() throws Exception {
        int port = AvailablePort.getRandomAvailablePort((int)0);
        File stateFile = new File("locator" + port + "state.dat");
        if (stateFile.exists()) {
            stateFile.delete();
        }
        int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
        File logFile = new File(this.getUniqueName() + "-locator" + port + ".log");
        Properties props = new Properties();
        props.setProperty("mcast-port", "" + mcastPort);
        props.setProperty("locators", DistributedTestCase.getIPLiteral() + "[" + port + "]");
        props.setProperty("security-peer-auth-init", "templates.security.UserPasswordAuthInit.create");
        try {
            Locator.startLocatorAndDS((int)port, (File)logFile, null, (Properties)props);
            P2PAuthenticationDUnitTest.fail((String)"Expected an IllegalArgumentException while starting locator");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        props = new Properties();
        props.setProperty("mcast-port", "" + mcastPort);
        props.setProperty("locators", DistributedTestCase.getIPLiteral() + "[" + port + "]");
        props.setProperty("security-peer-authenticator", "templates.security.LdapUserAuthenticator.create");
        try {
            Locator.startLocatorAndDS((int)port, (File)logFile, null, (Properties)props);
            P2PAuthenticationDUnitTest.fail((String)"Expected an IllegalArgumentException while starting locator");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        props = new Properties();
        props.setProperty("mcast-port", "" + mcastPort);
        props.setProperty("security-peer-auth-init", "templates.security.UserPasswordAuthInit.create");
        try {
            this.getSystem(props);
            P2PAuthenticationDUnitTest.fail((String)"Expected an IllegalArgumentException while connection to DS");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        props = new Properties();
        props.setProperty("mcast-port", "" + mcastPort);
        props.setProperty("security-peer-authenticator", "templates.security.LdapUserAuthenticator.create");
        try {
            this.getSystem(props);
            P2PAuthenticationDUnitTest.fail((String)"Expected an IllegalArgumentException while connection to DS");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void testP2PAuthenticationWithInvalidAuthInitialize() throws Exception {
        P2PAuthenticationDUnitTest.disconnectAllFromDS();
        for (CredentialGenerator gen : SecurityTestUtil.getAllGenerators()) {
            Properties props = gen.getSystemProperties();
            Properties javaProps = gen.getJavaProperties();
            String authenticator = gen.getAuthenticator();
            if (props == null) {
                props = new Properties();
            }
            String authInit = " Incorrect_AuthInitialize";
            int port = AvailablePort.getRandomAvailablePort((int)0);
            File stateFile = new File("locator" + port + "state.dat");
            if (stateFile.exists()) {
                stateFile.delete();
            }
            String locators = DistributedTestCase.getIPLiteral() + "[" + port + "]";
            props.setProperty("mcast-port", "0");
            props.setProperty("locators", locators);
            this.setProperty(props, "security-peer-auth-init", authInit);
            this.setProperty(props, "security-peer-authenticator", authenticator);
            Properties locProps = new Properties();
            locProps.putAll((Map<?, ?>)props);
            LogWriter dsLogger = P2PAuthenticationDUnitTest.createLogWriter(props);
            try {
                locatorVM.invoke(SecurityTestUtil.class, "startLocator", new Object[]{this.getUniqueName(), new Integer(port), locProps, javaProps, expectedExceptions});
                SecurityTestUtil.addExpectedExceptions(expectedExceptions, dsLogger);
                new SecurityTestUtil("tmp").createSystem(props, null);
                P2PAuthenticationDUnitTest.fail((String)"AuthenticationFailedException was expected as the AuthInitialize object passed is incorrect");
            }
            catch (RMIException remoteEx) {
                block9: {
                    if (remoteEx.getCause() instanceof AuthenticationFailedException) break block9;
                    throw remoteEx;
                }
                SecurityTestUtil.removeExpectedExceptions(expectedExceptions, dsLogger);
                locatorVM.invoke(SecurityTestUtil.class, "stopLocator", new Object[]{new Integer(port), expectedExceptions});
                continue;
            }
            catch (AuthenticationFailedException authenticationFailedException) {
                SecurityTestUtil.removeExpectedExceptions(expectedExceptions, dsLogger);
                locatorVM.invoke(SecurityTestUtil.class, "stopLocator", new Object[]{new Integer(port), expectedExceptions});
                continue;
                {
                    catch (Throwable throwable) {
                        SecurityTestUtil.removeExpectedExceptions(expectedExceptions, dsLogger);
                        locatorVM.invoke(SecurityTestUtil.class, "stopLocator", new Object[]{new Integer(port), expectedExceptions});
                        throw throwable;
                    }
                }
            }
            SecurityTestUtil.removeExpectedExceptions(expectedExceptions, dsLogger);
            locatorVM.invoke(SecurityTestUtil.class, "stopLocator", new Object[]{new Integer(port), expectedExceptions});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void testP2PAuthenticationWithInvalidAuthenticator() throws Exception {
        P2PAuthenticationDUnitTest.disconnectAllFromDS();
        for (CredentialGenerator gen : SecurityTestUtil.getAllGenerators()) {
            Properties props = gen.getSystemProperties();
            Properties javaProps = gen.getJavaProperties();
            String authenticator = "xyz";
            String authInit = gen.getAuthInit();
            if (props == null) {
                props = new Properties();
            }
            int port = AvailablePort.getRandomAvailablePort((int)0);
            File stateFile = new File("locator" + port + "state.dat");
            if (stateFile.exists()) {
                stateFile.delete();
            }
            String locators = DistributedTestCase.getIPLiteral() + "[" + port + "]";
            props.setProperty("mcast-port", "0");
            props.setProperty("locators", locators);
            this.setProperty(props, "security-peer-auth-init", authInit);
            this.setProperty(props, "security-peer-authenticator", authenticator);
            Properties locProps = new Properties();
            locProps.putAll((Map<?, ?>)props);
            LogWriter dsLogger = P2PAuthenticationDUnitTest.createLogWriter(props);
            try {
                locatorVM.invoke(SecurityTestUtil.class, "startLocator", new Object[]{this.getUniqueName(), new Integer(port), locProps, javaProps, expectedExceptions});
                SecurityTestUtil.addExpectedExceptions(expectedExceptions, dsLogger);
                new SecurityTestUtil("tmp").createSystem(props, javaProps);
                P2PAuthenticationDUnitTest.fail((String)"AuthenticationFailedException was expected as the Authenticator object passed is incorrect");
            }
            catch (RMIException remoteEx) {
                block9: {
                    if (remoteEx.getCause() instanceof AuthenticationFailedException) break block9;
                    throw remoteEx;
                }
                SecurityTestUtil.removeExpectedExceptions(expectedExceptions, dsLogger);
                locatorVM.invoke(SecurityTestUtil.class, "stopLocator", new Object[]{new Integer(port), expectedExceptions});
                continue;
            }
            catch (AuthenticationFailedException authenticationFailedException) {
                SecurityTestUtil.removeExpectedExceptions(expectedExceptions, dsLogger);
                locatorVM.invoke(SecurityTestUtil.class, "stopLocator", new Object[]{new Integer(port), expectedExceptions});
                continue;
                {
                    catch (Throwable throwable) {
                        SecurityTestUtil.removeExpectedExceptions(expectedExceptions, dsLogger);
                        locatorVM.invoke(SecurityTestUtil.class, "stopLocator", new Object[]{new Integer(port), expectedExceptions});
                        throw throwable;
                    }
                }
            }
            SecurityTestUtil.removeExpectedExceptions(expectedExceptions, dsLogger);
            locatorVM.invoke(SecurityTestUtil.class, "stopLocator", new Object[]{new Integer(port), expectedExceptions});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void testP2PAuthenticationWithNoCredentials() throws Exception {
        P2PAuthenticationDUnitTest.disconnectAllFromDS();
        for (CredentialGenerator gen : SecurityTestUtil.getAllGenerators()) {
            Properties props = gen.getSystemProperties();
            Properties javaProps = gen.getJavaProperties();
            String authenticator = gen.getAuthenticator();
            String authInit = gen.getAuthInit();
            if (props == null) {
                props = new Properties();
            }
            int port = AvailablePort.getRandomAvailablePort((int)0);
            File stateFile = new File("locator" + port + "state.dat");
            if (stateFile.exists()) {
                stateFile.delete();
            }
            String locators = DistributedTestCase.getIPLiteral() + "[" + port + "]";
            props.setProperty("mcast-port", "0");
            props.setProperty("locators", locators);
            this.setProperty(props, "security-peer-auth-init", authInit);
            this.setProperty(props, "security-peer-authenticator", authenticator);
            Properties locProps = new Properties();
            locProps.putAll((Map<?, ?>)props);
            LogWriter dsLogger = P2PAuthenticationDUnitTest.createLogWriter(props);
            try {
                locatorVM.invoke(SecurityTestUtil.class, "startLocator", new Object[]{this.getUniqueName(), new Integer(port), locProps, javaProps, expectedExceptions});
                SecurityTestUtil.addExpectedExceptions(expectedExceptions, dsLogger);
                new SecurityTestUtil("tmp").createSystem(props, null);
                P2PAuthenticationDUnitTest.fail((String)"AuthenticationFailedException was expected as no credentials are set");
            }
            catch (RMIException remoteEx) {
                block9: {
                    if (remoteEx.getCause() instanceof AuthenticationFailedException) break block9;
                    throw remoteEx;
                }
                SecurityTestUtil.removeExpectedExceptions(expectedExceptions, dsLogger);
                locatorVM.invoke(SecurityTestUtil.class, "stopLocator", new Object[]{new Integer(port), expectedExceptions});
                continue;
            }
            catch (AuthenticationFailedException authenticationFailedException) {
                SecurityTestUtil.removeExpectedExceptions(expectedExceptions, dsLogger);
                locatorVM.invoke(SecurityTestUtil.class, "stopLocator", new Object[]{new Integer(port), expectedExceptions});
                continue;
                {
                    catch (Throwable throwable) {
                        SecurityTestUtil.removeExpectedExceptions(expectedExceptions, dsLogger);
                        locatorVM.invoke(SecurityTestUtil.class, "stopLocator", new Object[]{new Integer(port), expectedExceptions});
                        throw throwable;
                    }
                }
            }
            SecurityTestUtil.removeExpectedExceptions(expectedExceptions, dsLogger);
            locatorVM.invoke(SecurityTestUtil.class, "stopLocator", new Object[]{new Integer(port), expectedExceptions});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testP2PAuthenticationWithValidCredentials() throws Exception {
        P2PAuthenticationDUnitTest.disconnectAllFromDS();
        for (CredentialGenerator gen : SecurityTestUtil.getAllGenerators()) {
            Properties props = gen.getSystemProperties();
            String authenticator = gen.getAuthenticator();
            String authInit = gen.getAuthInit();
            if (props == null) {
                props = new Properties();
            }
            int port = AvailablePort.getRandomAvailablePort((int)0);
            File stateFile = new File("locator" + port + "state.dat");
            if (stateFile.exists()) {
                stateFile.delete();
            }
            String locators = DistributedTestCase.getIPLiteral() + "[" + port + "]";
            props.setProperty("mcast-port", "0");
            props.setProperty("locators", locators);
            this.setProperty(props, "security-peer-auth-init", authInit);
            this.setProperty(props, "security-peer-authenticator", authenticator);
            Properties credentials = gen.getValidCredentials(1);
            Properties javaProps = gen.getJavaProperties();
            props.putAll((Map<?, ?>)credentials);
            locatorVM.invoke(SecurityTestUtil.class, "startLocator", new Object[]{this.getUniqueName(), new Integer(port), props, javaProps, expectedExceptions});
            try {
                P2PAuthenticationDUnitTest.createDS(props, javaProps);
                P2PAuthenticationDUnitTest.verifyMembers(new Integer(2));
                P2PAuthenticationDUnitTest.disconnectFromDS();
            }
            catch (Throwable throwable) {
                locatorVM.invoke(SecurityTestUtil.class, "stopLocator", new Object[]{new Integer(port), expectedExceptions});
                throw throwable;
            }
            locatorVM.invoke(SecurityTestUtil.class, "stopLocator", new Object[]{new Integer(port), expectedExceptions});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testP2PAuthenticationWithBothValidAndInValidCredentials() throws Exception {
        P2PAuthenticationDUnitTest.disconnectAllFromDS();
        for (CredentialGenerator gen : SecurityTestUtil.getAllGenerators()) {
            Properties props = gen.getSystemProperties();
            String authenticator = gen.getAuthenticator();
            String authInit = gen.getAuthInit();
            if (props == null) {
                props = new Properties();
            }
            int port = AvailablePort.getRandomAvailablePort((int)0);
            File stateFile = new File("locator" + port + "state.dat");
            if (stateFile.exists()) {
                stateFile.delete();
            }
            String locators = DistributedTestCase.getIPLiteral() + "[" + port + "]";
            props.setProperty("mcast-port", "0");
            props.setProperty("locators", locators);
            this.setProperty(props, "security-peer-auth-init", authInit);
            this.setProperty(props, "security-peer-authenticator", authenticator);
            Properties credentials = gen.getValidCredentials(1);
            Properties javaProps = gen.getJavaProperties();
            props.putAll((Map<?, ?>)credentials);
            locatorVM.invoke(SecurityTestUtil.class, "startLocator", new Object[]{this.getUniqueName(), new Integer(port), props, javaProps, expectedExceptions});
            try {
                credentials = gen.getInvalidCredentials(1);
                javaProps = gen.getJavaProperties();
                props.putAll((Map<?, ?>)credentials);
                LogWriter dsLogger = P2PAuthenticationDUnitTest.createLogWriter(props);
                SecurityTestUtil.addExpectedExceptions(expectedExceptions, dsLogger);
                try {
                    new SecurityTestUtil("tmp").createSystem(props, javaProps);
                    P2PAuthenticationDUnitTest.fail((String)"AuthenticationFailedException was expected as wrong credentials were passed");
                }
                catch (AuthenticationFailedException authenticationFailedException) {
                }
                finally {
                    SecurityTestUtil.removeExpectedExceptions(expectedExceptions, dsLogger);
                }
                credentials = gen.getValidCredentials(3);
                javaProps = gen.getJavaProperties();
                props.putAll((Map<?, ?>)credentials);
                P2PAuthenticationDUnitTest.createDS(props, javaProps);
                P2PAuthenticationDUnitTest.verifyMembers(new Integer(2));
                P2PAuthenticationDUnitTest.disconnectFromDS();
            }
            catch (Throwable throwable) {
                locatorVM.invoke(SecurityTestUtil.class, "stopLocator", new Object[]{new Integer(port), expectedExceptions});
                throw throwable;
            }
            locatorVM.invoke(SecurityTestUtil.class, "stopLocator", new Object[]{new Integer(port), expectedExceptions});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disabled_testP2PViewChangeReject() throws Exception {
        P2PAuthenticationDUnitTest.disconnectAllFromDS();
        Host host = Host.getHost(0);
        VM peer2 = host.getVM(1);
        VM peer3 = host.getVM(2);
        LdapUserCredentialGenerator gen = new LdapUserCredentialGenerator();
        gen.init();
        Properties extraProps = gen.getSystemProperties();
        String authenticator = ((CredentialGenerator)gen).getAuthenticator();
        String authInit = ((CredentialGenerator)gen).getAuthInit();
        if (extraProps == null) {
            extraProps = new Properties();
        }
        DummyCredentialGenerator gen2 = new DummyCredentialGenerator();
        gen2.init();
        Properties extraProps2 = gen2.getSystemProperties();
        String authenticator2 = ((CredentialGenerator)gen2).getAuthenticator();
        if (extraProps2 == null) {
            extraProps2 = new Properties();
        }
        Properties props = new Properties();
        int port = AvailablePort.getRandomAvailablePort((int)0);
        File stateFile = new File("locator" + port + "state.dat");
        if (stateFile.exists()) {
            stateFile.delete();
        }
        String locators = DistributedTestCase.getIPLiteral() + "[" + port + "]";
        this.setProperty(props, "security-peer-auth-init", authInit);
        this.setProperty(props, "security-peer-authenticator", authenticator);
        Properties credentials = ((CredentialGenerator)gen).getValidCredentials(1);
        Properties javaProps = gen.getJavaProperties();
        props.putAll((Map<?, ?>)credentials);
        props.putAll((Map<?, ?>)extraProps);
        locatorVM.invoke(SecurityTestUtil.class, "startLocator", new Object[]{this.getUniqueName(), new Integer(port), props, javaProps, expectedExceptions});
        try {
            props = new Properties();
            props.setProperty("mcast-port", "0");
            props.setProperty("locators", locators);
            this.setProperty(props, "security-peer-auth-init", authInit);
            this.setProperty(props, "security-peer-authenticator", authenticator2);
            credentials = ((CredentialGenerator)gen).getValidCredentials(3);
            Properties javaProps2 = gen2.getJavaProperties();
            props.putAll((Map<?, ?>)credentials);
            props.putAll((Map<?, ?>)extraProps2);
            P2PAuthenticationDUnitTest.createDS(props, javaProps2);
            props = new Properties();
            props.setProperty("mcast-port", "0");
            props.setProperty("locators", locators);
            this.setProperty(props, "security-peer-auth-init", authInit);
            this.setProperty(props, "security-peer-authenticator", authenticator);
            credentials = ((CredentialGenerator)gen).getValidCredentials(7);
            javaProps = gen.getJavaProperties();
            props.putAll((Map<?, ?>)credentials);
            props.putAll((Map<?, ?>)extraProps);
            peer2.invoke(P2PAuthenticationDUnitTest.class, "createDS", new Object[]{props, javaProps});
            peer3.invoke(P2PAuthenticationDUnitTest.class, "createDS", new Object[]{props, javaProps});
            P2PAuthenticationDUnitTest.pause(2000);
            locatorVM.invoke(P2PAuthenticationDUnitTest.class, "verifyMembers", new Object[]{new Integer(4)});
            P2PAuthenticationDUnitTest.verifyMembers(new Integer(2));
            peer2.invoke(P2PAuthenticationDUnitTest.class, "verifyMembers", new Object[]{new Integer(4)});
            peer3.invoke(P2PAuthenticationDUnitTest.class, "verifyMembers", new Object[]{new Integer(4)});
            P2PAuthenticationDUnitTest.disconnectFromDS();
            P2PAuthenticationDUnitTest.pause(2000);
            locatorVM.invoke(P2PAuthenticationDUnitTest.class, "verifyMembers", new Object[]{new Integer(3)});
            peer2.invoke(P2PAuthenticationDUnitTest.class, "verifyMembers", new Object[]{new Integer(3)});
            peer3.invoke(P2PAuthenticationDUnitTest.class, "verifyMembers", new Object[]{new Integer(3)});
            peer2.invoke(DistributedTestCase.class, "disconnectFromDS");
            P2PAuthenticationDUnitTest.pause(2000);
            locatorVM.invoke(P2PAuthenticationDUnitTest.class, "verifyMembers", new Object[]{new Integer(2)});
            peer3.invoke(P2PAuthenticationDUnitTest.class, "verifyMembers", new Object[]{new Integer(2)});
            peer3.invoke(DistributedTestCase.class, "disconnectFromDS");
            P2PAuthenticationDUnitTest.pause(2000);
            locatorVM.invoke(P2PAuthenticationDUnitTest.class, "verifyMembers", new Object[]{new Integer(1)});
        }
        catch (Throwable throwable) {
            locatorVM.invoke(SecurityTestUtil.class, "stopLocator", new Object[]{new Integer(port), expectedExceptions});
            throw throwable;
        }
        locatorVM.invoke(SecurityTestUtil.class, "stopLocator", new Object[]{new Integer(port), expectedExceptions});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testP2PLargeCredentialSucceeds() throws Exception {
        P2PAuthenticationDUnitTest.disconnectAllFromDS();
        Host host = Host.getHost(0);
        VM peer2 = host.getVM(1);
        VM peer3 = host.getVM(2);
        DummyCredentialGenerator gen = new DummyCredentialGenerator();
        gen.init();
        Properties extraProps = gen.getSystemProperties();
        String authenticator = ((CredentialGenerator)gen).getAuthenticator();
        String authInit = "security.UserPasswordWithExtraPropsAuthInit.create";
        if (extraProps == null) {
            extraProps = new Properties();
        }
        Properties props = new Properties();
        int port = AvailablePort.getRandomAvailablePort((int)0);
        File stateFile = new File("locator" + port + "state.dat");
        if (stateFile.exists()) {
            stateFile.delete();
        }
        String locators = DistributedTestCase.getIPLiteral() + "[" + port + "]";
        this.setProperty(props, "security-peer-auth-init", authInit);
        this.setProperty(props, "security-peer-authenticator", authenticator);
        Properties credentials = ((CredentialGenerator)gen).getValidCredentials(1);
        Properties javaProps = gen.getJavaProperties();
        props.putAll((Map<?, ?>)credentials);
        props.putAll((Map<?, ?>)extraProps);
        locatorVM.invoke(SecurityTestUtil.class, "startLocator", new Object[]{this.getUniqueName(), new Integer(port), props, javaProps, expectedExceptions});
        try {
            props = new Properties();
            props.setProperty("mcast-port", "0");
            props.setProperty("locators", locators);
            this.setProperty(props, "security-peer-auth-init", authInit);
            this.setProperty(props, "security-peer-authenticator", authenticator);
            credentials = ((CredentialGenerator)gen).getValidCredentials(3);
            javaProps = gen.getJavaProperties();
            String hugeStr = "20KString";
            for (int i = 0; i <= 20000; ++i) {
                hugeStr = hugeStr + "A";
            }
            credentials.setProperty("security-keep-extra-props", "-");
            credentials.setProperty("security-hugeentryone", hugeStr);
            credentials.setProperty("security-hugeentrytwo", hugeStr);
            credentials.setProperty("security-hugeentrythree", hugeStr);
            props.putAll((Map<?, ?>)credentials);
            props.putAll((Map<?, ?>)extraProps);
            LogWriter dsLogger = P2PAuthenticationDUnitTest.createLogWriter(props);
            SecurityTestUtil.addExpectedExceptions(new String[]{IllegalArgumentException.class.getName()}, dsLogger);
            try {
                P2PAuthenticationDUnitTest.createDS(props, javaProps);
            }
            catch (Throwable throwable) {
                SecurityTestUtil.removeExpectedExceptions(new String[]{IllegalArgumentException.class.getName()}, dsLogger);
                throw throwable;
            }
            SecurityTestUtil.removeExpectedExceptions(new String[]{IllegalArgumentException.class.getName()}, dsLogger);
            props = new Properties();
            props.setProperty("mcast-port", "0");
            props.setProperty("locators", locators);
            this.setProperty(props, "security-peer-auth-init", authInit);
            this.setProperty(props, "security-peer-authenticator", authenticator);
            credentials = ((CredentialGenerator)gen).getValidCredentials(7);
            javaProps = gen.getJavaProperties();
            props.putAll((Map<?, ?>)credentials);
            props.putAll((Map<?, ?>)extraProps);
            peer2.invoke(P2PAuthenticationDUnitTest.class, "createDS", new Object[]{props, javaProps});
            peer3.invoke(P2PAuthenticationDUnitTest.class, "createDS", new Object[]{props, javaProps});
            P2PAuthenticationDUnitTest.pause(2000);
            locatorVM.invoke(P2PAuthenticationDUnitTest.class, "verifyMembers", new Object[]{new Integer(4)});
            peer2.invoke(P2PAuthenticationDUnitTest.class, "verifyMembers", new Object[]{new Integer(4)});
            peer3.invoke(P2PAuthenticationDUnitTest.class, "verifyMembers", new Object[]{new Integer(4)});
            P2PAuthenticationDUnitTest.disconnectFromDS();
            peer2.invoke(DistributedTestCase.class, "disconnectFromDS");
            peer3.invoke(DistributedTestCase.class, "disconnectFromDS");
        }
        catch (Throwable throwable) {
            locatorVM.invoke(SecurityTestUtil.class, "stopLocator", new Object[]{new Integer(port), expectedExceptions});
            throw throwable;
        }
        locatorVM.invoke(SecurityTestUtil.class, "stopLocator", new Object[]{new Integer(port), expectedExceptions});
    }

    public static void createDS(Properties props, Object javaProps) {
        SecurityTestUtil tmpUtil = new SecurityTestUtil("tmp");
        tmpUtil.createSystem(props, (Properties)javaProps);
    }

    public static void verifyMembers(Integer numExpectedMembers) {
        InternalDistributedSystem ds = InternalDistributedSystem.getAnyInstance();
        JGroupMembershipManager mgr = MembershipManagerHelper.getMembershipManager((DistributedSystem)ds);
        P2PAuthenticationDUnitTest.assertEquals((int)numExpectedMembers, (int)mgr.getView().size());
    }
}

