/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.pdx;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionShortcut;
import com.gemstone.gemfire.cache.util.Gateway;
import com.gemstone.gemfire.cache.util.GatewayEvent;
import com.gemstone.gemfire.cache.util.GatewayEventListener;
import com.gemstone.gemfire.cache.util.GatewayHub;
import com.gemstone.gemfire.cache.util.GatewayQueueAttributes;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.internal.AvailablePortHelper;
import com.gemstone.gemfire.internal.NullDataOutputStream;
import com.gemstone.gemfire.pdx.PdxReader;
import com.gemstone.gemfire.pdx.PdxSerializable;
import com.gemstone.gemfire.pdx.PdxWriter;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableRunnable;
import dunit.VM;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;

public class PdxGatewayEventListenerDUnitTest
extends CacheTestCase {
    public PdxGatewayEventListenerDUnitTest(String name) {
        super(name);
    }

    public void testPdxTypesNotPassedToGateway() throws IOException {
        Properties props = new Properties();
        props.setProperty("distributed-system-id", "1");
        props.setProperty("locators", "");
        this.getSystem(props);
        Cache cache = this.getCache();
        GatewayHub hub = cache.addGatewayHub("Test Hub", -1);
        Gateway gateway = hub.addGateway("test gateway");
        gateway.setQueueAttributes(new GatewayQueueAttributes(".", 100, 1, 1, false, false, true, 15));
        final TestGatewayListener listener = new TestGatewayListener();
        gateway.addListener((GatewayEventListener)listener);
        hub.start();
        gateway.start();
        Region region = cache.createRegionFactory(RegionShortcut.REPLICATE).setEnableGateway(true).setGatewayHubId("Test Hub").create("region");
        DataSerializer.writeObject((Object)new TestPdx("a"), (DataOutput)new NullDataOutputStream());
        region.put((Object)new TestPdx("b"), (Object)new TestPdx("c"));
        region.put((Object)new TestPdx("a"), (Object)new TestPdx("d"));
        PdxGatewayEventListenerDUnitTest.waitForCriterion(new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                return listener.seenEvents.size() >= 2;
            }

            @Override
            public String description() {
                return "Waiting for " + listener.seenEvents.size() + " to be 2";
            }
        }, 1000L, 50L, true);
        List events = listener.seenEvents;
        PdxGatewayEventListenerDUnitTest.assertEquals((int)2, (int)events.size());
        PdxGatewayEventListenerDUnitTest.assertEquals((Object)new TestPdx("b"), (Object)((GatewayEvent)events.get(0)).getKey());
        PdxGatewayEventListenerDUnitTest.assertEquals((Object)new TestPdx("c"), (Object)((GatewayEvent)events.get(0)).getDeserializedValue());
        PdxGatewayEventListenerDUnitTest.assertEquals((Object)new TestPdx("a"), (Object)((GatewayEvent)events.get(1)).getKey());
        PdxGatewayEventListenerDUnitTest.assertEquals((Object)new TestPdx("d"), (Object)((GatewayEvent)events.get(1)).getDeserializedValue());
    }

    public void xtestPdxDeserializedInRemoteListener() throws IOException {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        int mcastPort = AvailablePortHelper.getRandomAvailableUDPPort();
        final Properties props = new Properties();
        props.setProperty("distributed-system-id", "1");
        props.setProperty("locators", "");
        props.setProperty("mcast-port", Integer.toString(mcastPort));
        this.getSystem(props);
        Cache cache = this.getCache();
        GatewayHub hub = cache.addGatewayHub("Test Hub", -1);
        Gateway gateway = hub.addGateway("test gateway");
        gateway.setQueueAttributes(new GatewayQueueAttributes(".", 100, 1, 1, false, false, true, 15));
        final TestGatewayListener listener = new TestGatewayListener();
        gateway.addListener((GatewayEventListener)listener);
        hub.start();
        gateway.start();
        Region region = cache.createRegionFactory(RegionShortcut.REPLICATE).setEnableGateway(true).setGatewayHubId("Test Hub").create("region");
        vm0.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                PdxGatewayEventListenerDUnitTest.this.getSystem(props);
                Cache cache = PdxGatewayEventListenerDUnitTest.this.getCache();
                Region region = cache.createRegionFactory(RegionShortcut.REPLICATE).setEnableGateway(true).setGatewayHubId("Test Hub").create("region");
                region.put((Object)new TestPdx("b"), (Object)new TestPdx("c"));
                region.put((Object)new TestPdx("a"), (Object)new TestPdx("d"));
            }
        });
        PdxGatewayEventListenerDUnitTest.waitForCriterion(new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                return listener.seenEvents.size() >= 2;
            }

            @Override
            public String description() {
                return "Waiting for " + listener.seenEvents.size() + " to be 2";
            }
        }, 1000L, 50L, true);
        List events = listener.seenEvents;
        PdxGatewayEventListenerDUnitTest.assertEquals((int)2, (int)events.size());
        PdxGatewayEventListenerDUnitTest.assertEquals((Object)new TestPdx("b"), (Object)((GatewayEvent)events.get(0)).getKey());
        PdxGatewayEventListenerDUnitTest.assertEquals((Object)new TestPdx("c"), (Object)((GatewayEvent)events.get(0)).getDeserializedValue());
        PdxGatewayEventListenerDUnitTest.assertEquals((Object)new TestPdx("a"), (Object)((GatewayEvent)events.get(1)).getKey());
        PdxGatewayEventListenerDUnitTest.assertEquals((Object)new TestPdx("d"), (Object)((GatewayEvent)events.get(1)).getDeserializedValue());
    }

    public static final class TestPdx
    implements PdxSerializable {
        private String value;

        public TestPdx() {
        }

        public TestPdx(String value) {
            this.value = value;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TestPdx other = (TestPdx)obj;
            return !(this.value == null ? other.value != null : !this.value.equals(other.value));
        }

        public void toData(PdxWriter writer) {
            writer.writeString("value", this.value);
        }

        public void fromData(PdxReader reader) {
            this.value = reader.readString("value");
        }
    }

    private static final class TestGatewayListener
    implements GatewayEventListener {
        private List<GatewayEvent> seenEvents = Collections.synchronizedList(new ArrayList());

        private TestGatewayListener() {
        }

        public void close() {
        }

        public boolean processEvents(List<GatewayEvent> events) {
            this.seenEvents.addAll(events);
            return true;
        }
    }
}

