/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.pdx;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.client.ClientCache;
import com.gemstone.gemfire.cache.client.ClientCacheFactory;
import com.gemstone.gemfire.cache.client.ClientRegionShortcut;
import com.gemstone.gemfire.cache.server.CacheServer;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.AvailablePortHelper;
import com.gemstone.gemfire.pdx.JSONFormatter;
import com.gemstone.gemfire.pdx.PdxInstance;
import com.gemstone.gemfire.pdx.internal.json.PdxToJSON;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableCallable;
import dunit.VM;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class JSONPdxClientServerDUnitTest
extends CacheTestCase {
    protected static final int INT_TAB = 9;
    protected static final int INT_LF = 10;
    protected static final int INT_CR = 13;
    protected static final int INT_SPACE = 32;

    public JSONPdxClientServerDUnitTest(String name) {
        super(name);
    }

    public void testSimplePut() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        VM vm3 = host.getVM(3);
        this.createServerRegion(vm0);
        int port = this.createServerRegion(vm3);
        this.createClientRegion(vm1, port);
        this.createClientRegion(vm2, port);
        vm1.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                JSONPdxClientServerDUnitTest.this.JSONAllStringTest();
                return null;
            }
        });
        vm2.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                JSONPdxClientServerDUnitTest.this.JSONAllByteArrayTest();
                return null;
            }
        });
    }

    public void testSimplePut2() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        VM vm3 = host.getVM(3);
        this.createServerRegion(vm0);
        int port = this.createServerRegion(vm3);
        this.createClientRegion(vm1, port);
        this.createClientRegion(vm2, port);
        vm1.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                JSONPdxClientServerDUnitTest.this.JSONUnQuoteFields();
                return null;
            }
        });
    }

    public void JSONUnQuoteFields() {
        System.setProperty("pdxToJson.unqouteFieldNames", "true");
        PdxToJSON.PDXTOJJSON_UNQUOTEFIELDNAMES = true;
        String JTESTS = System.getProperty("JTESTS");
        String jsonStringsDir = JTESTS + File.separator + "com" + File.separator + "gemstone" + File.separator + "gemfire" + File.separator + "pdx" + File.separator + "jsonStrings" + File.separator + "unquoteJsonStrings";
        this.JSONAllStringTest(jsonStringsDir);
    }

    public void JSONAllStringTest() {
        String JTESTS = System.getProperty("JTESTS");
        String jsonStringsDir = JTESTS + File.separator + "com" + File.separator + "gemstone" + File.separator + "gemfire" + File.separator + "pdx" + File.separator + "jsonStrings";
        this.JSONAllStringTest(jsonStringsDir);
    }

    public void JSONAllStringTest(String dirname) {
        JSONData[] allJsons = JSONPdxClientServerDUnitTest.loadAllJSON(dirname);
        int i = 0;
        for (JSONData jsonData : allJsons) {
            if (jsonData == null) continue;
            ++i;
            this.VerifyJSONString(jsonData);
        }
        Assert.assertTrue((i >= 1 ? 1 : 0) != 0, (Object)("Number of files should be more than 10 : " + i));
    }

    public void JSONAllByteArrayTest() {
        String JTESTS = System.getProperty("JTESTS");
        String jsonStringsDir = JTESTS + File.separator + "com" + File.separator + "gemstone" + File.separator + "gemfire" + File.separator + "pdx" + File.separator + "jsonStrings";
        JSONData[] allJsons = JSONPdxClientServerDUnitTest.loadAllJSON(jsonStringsDir);
        int i = 0;
        for (JSONData jsonData : allJsons) {
            if (jsonData == null) continue;
            ++i;
            this.VerifyJSONByteArray(jsonData);
        }
        Assert.assertTrue((i > 10 ? 1 : 0) != 0, (Object)"Number of files should be more than 10");
    }

    public void VerifyJSONString(JSONData jd) {
        Region r = this.getRootRegion("testSimplePdx");
        PdxInstance pdx = JSONFormatter.fromJSON((String)jd.getJsonString());
        r.put((Object)1, (Object)pdx);
        pdx = (PdxInstance)r.get((Object)1);
        String getJsonString = JSONFormatter.toJSON((PdxInstance)pdx);
        String o1 = this.jsonParse(jd.getJsonString());
        String o2 = this.jsonParse(getJsonString);
        junit.framework.Assert.assertEquals((String)("Json Strings are not equal " + jd.getFileName() + " " + Boolean.getBoolean("pdxToJson.unqouteFieldNames")), (String)o1, (String)o2);
        PdxInstance pdx2 = JSONFormatter.fromJSON((String)getJsonString);
        junit.framework.Assert.assertEquals((String)("Pdx are not equal; json filename " + jd.getFileName()), (Object)pdx, (Object)pdx2);
    }

    public String jsonParse(String jsonSting) {
        byte[] ba = jsonSting.getBytes();
        byte[] withoutspace = new byte[ba.length];
        int i = 0;
        int j = 0;
        for (i = 0; i < ba.length; ++i) {
            byte cbyte = ba[i];
            if (cbyte == 9 || cbyte == 10 || cbyte == 13 || cbyte == 32) continue;
            withoutspace[j++] = ba[i];
        }
        return new String(withoutspace, 0, j);
    }

    public void VerifyJSONByteArray(JSONData jd) {
        Region r = this.getRootRegion("testSimplePdx");
        PdxInstance pdx = JSONFormatter.fromJSON((byte[])jd.getJsonByteArray());
        r.put((Object)1, (Object)pdx);
        pdx = (PdxInstance)r.get((Object)1);
        byte[] jsonByteArray = JSONFormatter.toJSONByteArray((PdxInstance)pdx);
        byte[] o1 = this.jsonParse(jd.getJsonByteArray());
        byte[] o2 = this.jsonParse(jsonByteArray);
        this.compareByteArray(o1, o2);
        PdxInstance pdx2 = JSONFormatter.fromJSON((byte[])jsonByteArray);
        boolean pdxequals = pdx.equals((Object)pdx2);
        junit.framework.Assert.assertEquals((String)("Pdx are not equal for byte array ; json filename " + jd.getFileName()), (Object)pdx, (Object)pdx2);
    }

    public void compareByteArray(byte[] b1, byte[] b2) {
        if (b1.length != b2.length) {
            throw new IllegalStateException("Json byte array length are not equal " + b1.length + " ; " + b2.length);
        }
        for (int i = 0; i < b1.length; ++i) {
            if (b1[i] == b2[i]) continue;
            throw new IllegalStateException("Json byte arrays are not equal ");
        }
    }

    public byte[] jsonParse(byte[] jsonBA) {
        byte[] ba = jsonBA;
        byte[] withoutspace = new byte[ba.length];
        int i = 0;
        int j = 0;
        for (i = 0; i < ba.length; ++i) {
            byte cbyte = ba[i];
            if (cbyte == 9 || cbyte == 10 || cbyte == 13 || cbyte == 32) continue;
            withoutspace[j++] = ba[i];
        }
        byte[] retBA = new byte[j];
        for (i = 0; i < j; ++i) {
            retBA[i] = withoutspace[i];
        }
        return retBA;
    }

    public static JSONData[] loadAllJSON(String jsondir) {
        File dir = new File(jsondir);
        JSONData[] JSONDatas = new JSONData[dir.list().length];
        int i = 0;
        for (String jsonFileName : dir.list()) {
            if (!jsonFileName.contains(".txt")) continue;
            try {
                byte[] ba = JSONPdxClientServerDUnitTest.getBytesFromFile(dir.getAbsolutePath() + File.separator + jsonFileName);
                JSONDatas[i++] = new JSONData(jsonFileName, ba);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return JSONDatas;
    }

    public static byte[] getBytesFromFile(String fileName) throws IOException {
        int offset;
        File file = new File(fileName);
        FileInputStream is = new FileInputStream(file);
        long length = file.length();
        byte[] bytes = new byte[(int)length];
        int numRead = 0;
        for (offset = 0; offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
        }
        if (offset < bytes.length) {
            throw new IOException("Could not completely read file " + file.getName());
        }
        ((InputStream)is).close();
        return bytes;
    }

    private void closeCache(VM vm) {
        vm.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                CacheTestCase.closeCache();
                return null;
            }
        });
    }

    private int createServerRegion(VM vm) {
        SerializableCallable createRegion = new SerializableCallable(){

            public Object call() throws Exception {
                AttributesFactory af = new AttributesFactory();
                af.setDataPolicy(DataPolicy.PARTITION);
                JSONPdxClientServerDUnitTest.this.createRootRegion("testSimplePdx", af.create());
                CacheServer server = JSONPdxClientServerDUnitTest.this.getCache().addCacheServer();
                int port = AvailablePortHelper.getRandomAvailableTCPPort();
                server.setPort(port);
                server.start();
                return port;
            }
        };
        return (Integer)vm.invoke(createRegion);
    }

    private int createServerRegionWithPersistence(VM vm, final boolean persistentPdxRegistry) {
        SerializableCallable createRegion = new SerializableCallable(){

            public Object call() throws Exception {
                CacheFactory cf = new CacheFactory();
                if (persistentPdxRegistry) {
                    cf.setPdxPersistent(true).setPdxDiskStore("store");
                }
                Cache cache = JSONPdxClientServerDUnitTest.this.getCache(cf);
                cache.createDiskStoreFactory().setDiskDirs(CacheTestCase.getDiskDirs()).create("store");
                AttributesFactory af = new AttributesFactory();
                af.setScope(Scope.DISTRIBUTED_ACK);
                af.setDataPolicy(DataPolicy.PERSISTENT_REPLICATE);
                af.setDiskStoreName("store");
                JSONPdxClientServerDUnitTest.this.createRootRegion("testSimplePdx", af.create());
                CacheServer server = JSONPdxClientServerDUnitTest.this.getCache().addCacheServer();
                int port = AvailablePortHelper.getRandomAvailableTCPPort();
                server.setPort(port);
                server.start();
                return port;
            }
        };
        return (Integer)vm.invoke(createRegion);
    }

    private int createServerAccessor(VM vm) {
        SerializableCallable createRegion = new SerializableCallable(){

            public Object call() throws Exception {
                AttributesFactory af = new AttributesFactory();
                af.setDataPolicy(DataPolicy.EMPTY);
                JSONPdxClientServerDUnitTest.this.createRootRegion("testSimplePdx", af.create());
                CacheServer server = JSONPdxClientServerDUnitTest.this.getCache().addCacheServer();
                int port = AvailablePortHelper.getRandomAvailableTCPPort();
                server.setPort(port);
                server.start();
                return port;
            }
        };
        return (Integer)vm.invoke(createRegion);
    }

    private int createLonerServerRegion(VM vm, final String regionName, final String dsId) {
        SerializableCallable createRegion = new SerializableCallable(){

            public Object call() throws Exception {
                Properties props = new Properties();
                props.setProperty("locators", "");
                props.setProperty("distributed-system-id", dsId);
                JSONPdxClientServerDUnitTest.this.getSystem(props);
                AttributesFactory af = new AttributesFactory();
                af.setScope(Scope.DISTRIBUTED_ACK);
                af.setDataPolicy(DataPolicy.REPLICATE);
                JSONPdxClientServerDUnitTest.this.createRootRegion(regionName, af.create());
                CacheServer server = JSONPdxClientServerDUnitTest.this.getCache().addCacheServer();
                int port = AvailablePortHelper.getRandomAvailableTCPPort();
                server.setPort(port);
                server.start();
                return port;
            }
        };
        return (Integer)vm.invoke(createRegion);
    }

    private void createClientRegion(VM vm, int port) {
        this.createClientRegion(vm, port, false);
    }

    private void createClientRegion(final VM vm, final int port, final boolean threadLocalConnections) {
        SerializableCallable createRegion = new SerializableCallable(){

            public Object call() throws Exception {
                ClientCacheFactory cf = new ClientCacheFactory();
                cf.addPoolServer(DistributedTestCase.getServerHostName(vm.getHost()), port);
                cf.setPoolThreadLocalConnections(threadLocalConnections);
                ClientCache cache = JSONPdxClientServerDUnitTest.this.getClientCache(cf);
                cache.createClientRegionFactory(ClientRegionShortcut.PROXY).create("testSimplePdx");
                return null;
            }
        };
        vm.invoke(createRegion);
    }

    static class JSONData {
        String jsonFileName;
        byte[] jsonByteArray;

        public JSONData(String fn, byte[] js) {
            this.jsonFileName = fn;
            this.jsonByteArray = js;
        }

        public String getFileName() {
            return this.jsonFileName;
        }

        public String getJsonString() {
            return new String(this.jsonByteArray);
        }

        public byte[] getJsonByteArray() {
            return this.jsonByteArray;
        }
    }
}

