/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.pulse;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.Locator;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.wan.WANTestBase;
import com.gemstone.gemfire.management.DistributedSystemMXBean;
import com.gemstone.gemfire.management.GatewayReceiverMXBean;
import com.gemstone.gemfire.management.GatewaySenderMXBean;
import com.gemstone.gemfire.management.ManagementService;
import com.gemstone.gemfire.management.ManagementTestBase;
import com.gemstone.gemfire.management.RegionMXBean;
import com.gemstone.gemfire.management.internal.MBeanJMXAdapter;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableRunnable;
import dunit.VM;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import junit.framework.TestCase;

public class TestRemoteClusterDUnitTest
extends ManagementTestBase {
    private static final long serialVersionUID = 1L;
    public static MBeanServer mbeanServer = MBeanJMXAdapter.mbeanServer;

    public TestRemoteClusterDUnitTest(String name) throws Exception {
        super(name);
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
    }

    public void testMBeanCallback() throws Exception {
        VM nyLocator = TestRemoteClusterDUnitTest.getManagedNodeList().get(0);
        VM nyReceiver = TestRemoteClusterDUnitTest.getManagedNodeList().get(1);
        VM puneSender = TestRemoteClusterDUnitTest.getManagedNodeList().get(2);
        VM managing = TestRemoteClusterDUnitTest.getManagingNode();
        VM puneLocator = Host.getLocator();
        int punePort = (Integer)puneLocator.invoke(TestRemoteClusterDUnitTest.class, "getLocatorPort");
        Integer nyPort = (Integer)nyLocator.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{12, punePort});
        puneSender.invoke(WANTestBase.class, "createCache", new Object[]{punePort});
        managing.invoke(WANTestBase.class, "createManagementCache", new Object[]{punePort});
        this.startManagingNode(managing);
        puneSender.invoke(WANTestBase.class, "createSender", new Object[]{"pn", 12, true, 100, 300, false, false, null, true});
        managing.invoke(WANTestBase.class, "createSender", new Object[]{"pn", 12, true, 100, 300, false, false, null, true});
        puneSender.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "pn", 1, 100, false});
        managing.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "pn", 1, 100, false});
        nyReceiver.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        nyReceiver.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", null, 1, 100, false});
        puneSender.invoke(WANTestBase.class, "startSender", new Object[]{"pn"});
        managing.invoke(WANTestBase.class, "startSender", new Object[]{"pn"});
        puneSender.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"pn"});
        managing.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"pn"});
        this.checkSenderMBean(puneSender, testName + "_PR");
        this.checkSenderMBean(managing, testName + "_PR");
        this.checkReceiverMBean(nyReceiver);
        this.stopGatewaySender(puneSender);
        this.startGatewaySender(puneSender);
        DistributedMember puneMember = (DistributedMember)puneSender.invoke(TestRemoteClusterDUnitTest.class, "getMember");
        this.checkRemoteClusterStatus(managing, puneMember);
    }

    private static int getLocatorPort() {
        return ((Locator)Locator.getLocators().get(0)).getPort();
    }

    private static DistributedMember getMember() {
        return GemFireCacheImpl.getInstance().getMyId();
    }

    protected void checkRemoteClusterStatus(VM vm, DistributedMember senderMember) {
        SerializableRunnable checkProxySender = new SerializableRunnable("DS Map Size"){

            @Override
            public void run() {
                GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
                DistributedTestCase.WaitCriterion waitCriteria2 = new DistributedTestCase.WaitCriterion(){

                    @Override
                    public boolean done() {
                        GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
                        ManagementService service = ManagementService.getManagementService((Cache)cache);
                        DistributedSystemMXBean dsBean = service.getDistributedSystemMXBean();
                        return dsBean != null;
                    }

                    @Override
                    public String description() {
                        return "wait for getDistributedSystemMXBean to complete and get results";
                    }
                };
                DistributedTestCase.waitForCriterion(waitCriteria2, 120000L, 5000L, true);
                ManagementService service = ManagementService.getManagementService((Cache)cache);
                DistributedSystemMXBean dsBean = service.getDistributedSystemMXBean();
                TestCase.assertNotNull((Object)dsBean);
                Map dsMap = dsBean.viewRemoteClusterStatus();
                DistributedTestCase.getLogWriter().info("Ds Map is: " + dsMap.size());
                TestCase.assertNotNull((Object)dsMap);
                TestCase.assertEquals((boolean)true, (dsMap.size() > 0 ? 1 : 0) != 0);
            }
        };
        vm.invoke(checkProxySender);
    }

    protected void stopGatewaySender(VM vm) {
        SerializableRunnable stopGatewaySender = new SerializableRunnable("Stop Gateway Sender"){

            @Override
            public void run() {
                GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
                ManagementService service = ManagementService.getManagementService((Cache)cache);
                GatewaySenderMXBean bean = service.getLocalGatewaySenderMXBean("pn");
                TestCase.assertNotNull((Object)bean);
                bean.stop();
                TestCase.assertFalse((boolean)bean.isRunning());
            }
        };
        vm.invoke(stopGatewaySender);
    }

    protected void startGatewaySender(VM vm) {
        SerializableRunnable stopGatewaySender = new SerializableRunnable("Start Gateway Sender"){

            @Override
            public void run() {
                GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
                ManagementService service = ManagementService.getManagementService((Cache)cache);
                GatewaySenderMXBean bean = service.getLocalGatewaySenderMXBean("pn");
                TestCase.assertNotNull((Object)bean);
                bean.start();
                TestCase.assertTrue((boolean)bean.isRunning());
            }
        };
        vm.invoke(stopGatewaySender);
    }

    protected void checkReceiverMBean(VM vm) {
        SerializableRunnable checkMBean = new SerializableRunnable("Check Receiver MBean"){

            @Override
            public void run() {
                GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
                ManagementService service = ManagementService.getManagementService((Cache)cache);
                GatewayReceiverMXBean bean = service.getLocalGatewayReceiverMXBean();
                TestCase.assertNotNull((Object)bean);
            }
        };
        vm.invoke(checkMBean);
    }

    protected void checkSenderMBean(VM vm, final String regionPath) {
        SerializableRunnable checkMBean = new SerializableRunnable("Check Sender MBean"){

            @Override
            public void run() {
                GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
                ManagementService service = ManagementService.getManagementService((Cache)cache);
                GatewaySenderMXBean bean = service.getLocalGatewaySenderMXBean("pn");
                TestCase.assertNotNull((Object)bean);
                TestCase.assertTrue((boolean)bean.isConnected());
                ObjectName regionBeanName = service.getRegionMBeanName(cache.getDistributedSystem().getDistributedMember(), "/" + regionPath);
                RegionMXBean rBean = (RegionMXBean)service.getMBeanInstance(regionBeanName, RegionMXBean.class);
                TestCase.assertTrue((boolean)rBean.isGatewayEnabled());
            }
        };
        vm.invoke(checkMBean);
    }
}

