/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.cli.commands;

import com.gemstone.gemfire.internal.FileUtil;
import com.gemstone.gemfire.management.cli.Result;
import com.gemstone.gemfire.management.internal.cli.commands.CliCommandTestBase;
import com.gemstone.gemfire.management.internal.cli.result.CommandResult;
import com.gemstone.gemfire.management.internal.cli.util.CommandStringBuilder;
import dunit.Host;
import dunit.SerializableRunnable;
import dunit.VM;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArrayList;
import util.ClassBuilder;

public class QueueCommandsDUnitTest
extends CliCommandTestBase {
    private static final long serialVersionUID = 1L;
    final List<String> filesToBeDeleted = new CopyOnWriteArrayList<String>();

    public QueueCommandsDUnitTest(String testName) {
        super(testName);
    }

    public void testAsyncEventQueue() throws IOException {
        String queue1Name = "testAsyncEventQueue1";
        String queue2Name = "testAsyncEventQueue2";
        String diskStoreName = "testAsyncEventQueueDiskStore";
        Properties localProps = new Properties();
        localProps.setProperty("groups", "Group0");
        this.createDefaultSetup(localProps);
        CommandResult cmdResult = this.executeCommand("list async-event-queues");
        QueueCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
        QueueCommandsDUnitTest.assertTrue((boolean)this.commandResultToString(cmdResult).contains("No Async Event Queues Found"));
        VM vm1 = Host.getHost(0).getVM(1);
        final String vm1Name = "VM" + vm1.getPid();
        final File diskStoreDir = new File(new File(".").getAbsolutePath(), "testAsyncEventQueueDiskStore");
        this.filesToBeDeleted.add(diskStoreDir.getAbsolutePath());
        vm1.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                diskStoreDir.mkdirs();
                Properties localProps = new Properties();
                localProps.setProperty("name", vm1Name);
                localProps.setProperty("groups", "Group1");
                QueueCommandsDUnitTest.this.getSystem(localProps);
                QueueCommandsDUnitTest.this.getCache();
            }
        });
        VM vm2 = Host.getHost(0).getVM(2);
        final String vm2Name = "VM" + vm2.getPid();
        vm2.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Properties localProps = new Properties();
                localProps.setProperty("name", vm2Name);
                localProps.setProperty("groups", "Group2");
                QueueCommandsDUnitTest.this.getSystem(localProps);
                QueueCommandsDUnitTest.this.getCache();
            }
        });
        File jarFile = new File(new File(".").getAbsolutePath(), "QueueCommandsDUnit.jar");
        this.filesToBeDeleted.add(jarFile.getAbsolutePath());
        ClassBuilder classBuilder = new ClassBuilder();
        byte[] jarBytes = classBuilder.createJarFromClassContent("com/qcdunit/QueueCommandsDUnitTestListener", "package com.qcdunit;import java.util.List; import java.util.Properties;import com.gemstone.gemfire.internal.cache.xmlcache.Declarable2; import com.gemstone.gemfire.cache.asyncqueue.AsyncEvent;import com.gemstone.gemfire.cache.asyncqueue.AsyncEventListener;public class QueueCommandsDUnitTestListener implements Declarable2, AsyncEventListener {Properties props;public boolean processEvents(List events) { return true; }public void close() {}public void init(final Properties props) {this.props = props;}public Properties getConfig() {return this.props;}}");
        this.writeJarBytesToFile(jarFile, jarBytes);
        cmdResult = this.executeCommand("deploy --jar=QueueCommandsDUnit.jar");
        QueueCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
        CommandStringBuilder commandStringBuilder = new CommandStringBuilder("create disk-store");
        commandStringBuilder.addOption("name", "testAsyncEventQueueDiskStore");
        commandStringBuilder.addOption("group", "Group1");
        commandStringBuilder.addOption("dir", diskStoreDir.getAbsolutePath());
        cmdResult = this.executeCommand(commandStringBuilder.toString());
        QueueCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
        String stringResult = this.commandResultToString(cmdResult);
        QueueCommandsDUnitTest.assertEquals((int)3, (int)this.countLinesInString(stringResult, false));
        QueueCommandsDUnitTest.assertEquals((boolean)false, (boolean)stringResult.contains("ERROR"));
        QueueCommandsDUnitTest.assertTrue((boolean)this.stringContainsLine(stringResult, vm1Name + ".*Success"));
        commandStringBuilder = new CommandStringBuilder("create async-event-queue");
        commandStringBuilder.addOption("id", "testAsyncEventQueue1");
        commandStringBuilder.addOption("group", "Group1");
        commandStringBuilder.addOption("batch-size", "514");
        commandStringBuilder.addOption("persistent", "true");
        commandStringBuilder.addOption("disk-store", "testAsyncEventQueueDiskStore");
        commandStringBuilder.addOption("max-queue-memory", "213");
        commandStringBuilder.addOption("listener", "com.qcdunit.QueueCommandsDUnitTestListener");
        commandStringBuilder.addOption("listener-param", "param1");
        commandStringBuilder.addOption("listener-param", "param2#value2");
        cmdResult = this.executeCommand(commandStringBuilder.toString());
        QueueCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
        stringResult = this.commandResultToString(cmdResult);
        QueueCommandsDUnitTest.assertEquals((int)3, (int)this.countLinesInString(stringResult, false));
        QueueCommandsDUnitTest.assertEquals((boolean)false, (boolean)stringResult.contains("ERROR"));
        QueueCommandsDUnitTest.assertTrue((boolean)this.stringContainsLine(stringResult, vm1Name + ".*Success"));
        cmdResult = this.executeCommand("list async-event-queues");
        QueueCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
        stringResult = this.commandResultToString(cmdResult);
        QueueCommandsDUnitTest.assertEquals((int)3, (int)this.countLinesInString(stringResult, false));
        QueueCommandsDUnitTest.assertTrue((boolean)this.stringContainsLine(stringResult, vm1Name + " .*" + "testAsyncEventQueue1" + " .*514 .*true .*" + "testAsyncEventQueueDiskStore" + " .*213 .* .*com.qcdunit.QueueCommandsDUnitTestListener.*"));
        QueueCommandsDUnitTest.assertTrue((boolean)this.stringContainsLine(stringResult, vm1Name + ".*param2=value2.*"));
        QueueCommandsDUnitTest.assertTrue((boolean)this.stringContainsLine(stringResult, vm1Name + ".*param1=[^\\w].*"));
        QueueCommandsDUnitTest.assertFalse((boolean)this.stringContainsLine(stringResult, vm2Name + ".*" + "testAsyncEventQueue1" + ".*"));
        commandStringBuilder = new CommandStringBuilder("create async-event-queue");
        commandStringBuilder.addOption("id", "testAsyncEventQueue2");
        commandStringBuilder.addOption("listener", "com.qcdunit.QueueCommandsDUnitTestListener");
        cmdResult = this.executeCommand(commandStringBuilder.toString());
        QueueCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
        stringResult = this.commandResultToString(cmdResult);
        QueueCommandsDUnitTest.assertEquals((int)5, (int)this.countLinesInString(stringResult, false));
        QueueCommandsDUnitTest.assertTrue((boolean)this.stringContainsLine(stringResult, "Manager.*Success"));
        QueueCommandsDUnitTest.assertTrue((boolean)this.stringContainsLine(stringResult, vm2Name + ".*Success"));
        QueueCommandsDUnitTest.assertTrue((boolean)this.stringContainsLine(stringResult, vm1Name + ".*Success"));
        cmdResult = this.executeCommand("list async-event-queues");
        QueueCommandsDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
        stringResult = this.commandResultToString(cmdResult);
        QueueCommandsDUnitTest.assertEquals((int)6, (int)this.countLinesInString(stringResult, false));
        QueueCommandsDUnitTest.assertTrue((boolean)this.stringContainsLine(stringResult, "Manager .*testAsyncEventQueue2 .*100 .*false .*null .*100 .* .*com.qcdunit.QueueCommandsDUnitTestListener"));
        QueueCommandsDUnitTest.assertTrue((boolean)this.stringContainsLine(stringResult, vm1Name + " .*" + "testAsyncEventQueue1" + " .*514 .*true .*" + "testAsyncEventQueueDiskStore" + " .*213 .* .*com.qcdunit.QueueCommandsDUnitTestListener.*"));
        QueueCommandsDUnitTest.assertTrue((boolean)this.stringContainsLine(stringResult, vm1Name + " .*" + "testAsyncEventQueue2" + " .*100 .*false .*null .*100 .* .*com.qcdunit.QueueCommandsDUnitTestListener"));
        QueueCommandsDUnitTest.assertTrue((boolean)this.stringContainsLine(stringResult, vm2Name + " .*" + "testAsyncEventQueue2" + " .*100 .*false .*null .*100 .* .*com.qcdunit.QueueCommandsDUnitTestListener"));
    }

    @Override
    public void tearDown2() throws Exception {
        for (String path : this.filesToBeDeleted) {
            try {
                File fileToDelete = new File(path);
                FileUtil.delete((File)fileToDelete);
                if (!path.endsWith(".jar")) continue;
                this.executeCommand("undeploy --jar=" + fileToDelete.getName());
            }
            catch (IOException e) {
                QueueCommandsDUnitTest.getLogWriter().error("Unable to delete file", (Throwable)e);
            }
        }
        this.filesToBeDeleted.clear();
        super.tearDown2();
    }

    private void writeJarBytesToFile(File jarFile, byte[] jarBytes) throws IOException {
        FileOutputStream outStream = new FileOutputStream(jarFile);
        ((OutputStream)outStream).write(jarBytes);
        ((OutputStream)outStream).close();
    }
}

