/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.CustomExpiry;
import com.gemstone.gemfire.cache.EvictionAction;
import com.gemstone.gemfire.cache.EvictionAttributes;
import com.gemstone.gemfire.cache.FixedPartitionAttributes;
import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.PartitionResolver;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.query.data.Portfolio;
import com.gemstone.gemfire.cache.util.ObjectSizer;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.TestObjectSizerImpl;
import com.gemstone.gemfire.internal.cache.lru.LRUStatistics;
import com.gemstone.gemfire.internal.cache.partitioned.fixed.SingleHopQuarterPartitionResolver;
import com.gemstone.gemfire.management.DistributedRegionMXBean;
import com.gemstone.gemfire.management.DistributedSystemMXBean;
import com.gemstone.gemfire.management.EvictionAttributesData;
import com.gemstone.gemfire.management.FixedPartitionAttributesData;
import com.gemstone.gemfire.management.MBeanUtil;
import com.gemstone.gemfire.management.ManagementException;
import com.gemstone.gemfire.management.ManagementService;
import com.gemstone.gemfire.management.ManagementTestBase;
import com.gemstone.gemfire.management.MemberMXBean;
import com.gemstone.gemfire.management.MembershipAttributesData;
import com.gemstone.gemfire.management.PartitionAttributesData;
import com.gemstone.gemfire.management.RegionAttributesData;
import com.gemstone.gemfire.management.RegionMXBean;
import com.gemstone.gemfire.management.internal.MBeanJMXAdapter;
import com.gemstone.gemfire.management.internal.SystemManagementService;
import dunit.DistributedTestCase;
import dunit.SerializableRunnable;
import dunit.VM;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import junit.framework.TestCase;

public class RegionManagementDUnitTest
extends ManagementTestBase {
    private static final long serialVersionUID = 1L;
    private final String VERIFY_CONFIG_METHOD = "verifyConfigData";
    private final String VERIFY_REMOTE_CONFIG_METHOD = "verifyConfigDataRemote";
    static final String REGION_NAME = "MANAGEMENT_TEST_REGION";
    static final String PARTITIONED_REGION_NAME = "MANAGEMENT_PAR_REGION";
    static final String FIXED_PR_NAME = "MANAGEMENT_FIXED_PR";
    static final String REGION_PATH = "/MANAGEMENT_TEST_REGION";
    static final String PARTITIONED_REGION_PATH = "/MANAGEMENT_PAR_REGION";
    static final String FIXED_PR_PATH = "/MANAGEMENT_FIXED_PR";
    static final String LOCAL_REGION_NAME = "TEST_LOCAL_REGION";
    static final String LOCAL_SUB_REGION_NAME = "TEST_LOCAL_SUB_REGION";
    static final String LOCAL_REGION_PATH = "/TEST_LOCAL_REGION";
    static final String LOCAL_SUB_REGION_PATH = "/TEST_LOCAL_REGION/TEST_LOCAL_SUB_REGION";
    private static final int MAX_WAIT = 70000;
    protected static final Region DiskRegion = null;
    static List<FixedPartitionAttributes> fpaList = new ArrayList<FixedPartitionAttributes>();
    private static Region fixedPrRegion;

    public RegionManagementDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
    }

    public void testDistributedRegion() throws Exception {
        this.initManagement(false);
        VM[] managedNodes = new VM[RegionManagementDUnitTest.getManagedNodeList().size()];
        RegionManagementDUnitTest.getManagedNodeList().toArray(managedNodes);
        this.addMemberListener(managingNode);
        for (int j = 0; j < managedNodes.length; ++j) {
            VM vm = managedNodes[j];
            this.createDistributedRegion(vm, REGION_NAME);
            this.validateReplicateRegionAfterCreate(vm);
        }
        this.verifyRemoteDistributedRegion(managingNode, 3);
        for (VM vm : RegionManagementDUnitTest.getManagedNodeList()) {
            this.closeRegion(vm, REGION_PATH);
            this.validateReplicatedRegionAfterClose(vm);
        }
        this.ensureProxyCleanup(managingNode);
    }

    public void testPartitionedRegion() throws Exception {
        this.initManagement(false);
        VM managingNode = RegionManagementDUnitTest.getManagingNode();
        VM[] managedNodes = new VM[RegionManagementDUnitTest.getManagedNodeList().size()];
        RegionManagementDUnitTest.getManagedNodeList().toArray(managedNodes);
        this.addMemberListener(managingNode);
        for (int j = 0; j < managedNodes.length; ++j) {
            VM vm = managedNodes[j];
            this.createPartitionRegion(vm, PARTITIONED_REGION_NAME);
            this.validatePartitionRegionAfterCreate(vm);
        }
        this.validateRemotePartitionRegion(managingNode);
        for (VM vm : RegionManagementDUnitTest.getManagedNodeList()) {
            this.closeRegion(vm, PARTITIONED_REGION_PATH);
            this.validatePartitionRegionAfterClose(vm);
        }
    }

    public void testFixedPRRegionMBean() throws Exception {
        this.initManagement(false);
        VM managingNode = RegionManagementDUnitTest.getManagingNode();
        VM[] managedNodes = new VM[RegionManagementDUnitTest.getManagedNodeList().size()];
        RegionManagementDUnitTest.getManagedNodeList().toArray(managedNodes);
        this.addMemberListener(managingNode);
        for (int j = 0; j < managedNodes.length; ++j) {
            VM vm = managedNodes[j];
            RegionManagementDUnitTest.createFixedPartitionList(j + 1);
            Object[] args = new Object[]{fpaList};
            vm.invoke(RegionManagementDUnitTest.class, "createFixedPartitionRegion", args);
        }
        this.validateRemoteFixedPartitionRegion(managingNode);
        for (VM vm : RegionManagementDUnitTest.getManagedNodeList()) {
            this.closeFixedPartitionRegion(vm);
        }
    }

    public void testRegionAggregate() throws Exception {
        VM vm;
        int j;
        this.initManagement(true);
        VM managingNode = RegionManagementDUnitTest.getManagingNode();
        VM[] managedNodes = new VM[RegionManagementDUnitTest.getManagedNodeList().size()];
        RegionManagementDUnitTest.getManagedNodeList().toArray(managedNodes);
        this.addDistrListener(managingNode);
        for (j = 0; j < managedNodes.length; ++j) {
            vm = managedNodes[j];
            this.createDistributedRegion(vm, REGION_NAME);
        }
        this.validateDistributedMBean(managingNode, 3);
        this.createDistributedRegion(managingNode, REGION_NAME);
        this.validateDistributedMBean(managingNode, 4);
        for (j = 0; j < managedNodes.length; ++j) {
            vm = managedNodes[j];
            this.closeRegion(vm, REGION_PATH);
        }
        this.ensureProxyCleanup(managingNode);
        this.validateDistributedMBean(managingNode, 1);
        this.closeRegion(managingNode, REGION_PATH);
        this.validateDistributedMBean(managingNode, 0);
    }

    public void testNavigationAPIS() throws Exception {
        this.initManagement(true);
        for (VM vm : managedNodeList) {
            this.createDistributedRegion(vm, REGION_NAME);
            this.createPartitionRegion(vm, PARTITIONED_REGION_NAME);
        }
        this.createDistributedRegion(managingNode, REGION_NAME);
        this.createPartitionRegion(managingNode, PARTITIONED_REGION_NAME);
        ArrayList<String> memberIds = new ArrayList<String>();
        for (VM vm : managedNodeList) {
            memberIds.add(this.getMemberId(vm));
        }
        this.checkNavigationAPIS(managingNode, memberIds);
        for (VM vm : managedNodeList) {
            this.closeRegion(vm, REGION_PATH);
        }
        this.closeRegion(managingNode, REGION_PATH);
    }

    public void testSubRegions() throws Exception {
        this.initManagement(false);
        for (VM vm : managedNodeList) {
            this.createLocalRegion(vm, LOCAL_REGION_NAME);
            this.createSubRegion(vm, LOCAL_REGION_NAME, LOCAL_SUB_REGION_NAME);
        }
        for (VM vm : managedNodeList) {
            this.checkSubRegions(vm, LOCAL_SUB_REGION_PATH);
        }
        for (VM vm : managedNodeList) {
            this.closeRegion(vm, LOCAL_REGION_NAME);
            this.checkNullRegions(vm, LOCAL_SUB_REGION_NAME);
        }
    }

    public void testSpecialRegions() throws Exception {
        this.initManagement(false);
        this.createSpecialRegion((VM)managedNodeList.get(0));
        DistributedMember member = this.getMember((VM)managedNodeList.get(0));
        this.checkSpecialRegion(managingNode, member);
    }

    public void createSpecialRegion(VM vm1) throws Exception {
        vm1.invoke(new SerializableRunnable("Check Sub Regions"){

            @Override
            public void run() {
                Cache cache = RegionManagementDUnitTest.this.getCache();
                AttributesFactory attributesFactory = new AttributesFactory();
                attributesFactory.setValueConstraint(Portfolio.class);
                RegionAttributes regionAttributes = attributesFactory.create();
                cache.createRegion("p:os", regionAttributes);
                cache.createRegion("p@os", regionAttributes);
                cache.createRegion("p-os", regionAttributes);
                cache.createRegion("p#os", regionAttributes);
                cache.createRegion("p+os", regionAttributes);
                cache.createRegion("p \"ou\"\"inner\"\"ter\"s", regionAttributes);
            }
        });
    }

    public void checkSpecialRegion(VM vm1, DistributedMember member) throws Exception {
        vm1.invoke(new SerializableRunnable("Check Sub Regions"){

            @Override
            public void run() {
                ManagementService service = ManagementTestBase.getManagementService();
                try {
                    MBeanUtil.getDistributedRegionMbean("/p:os", 1);
                    MBeanUtil.getDistributedRegionMbean("/p@os", 1);
                    MBeanUtil.getDistributedRegionMbean("/p-os", 1);
                    MBeanUtil.getDistributedRegionMbean("/p#os", 1);
                    MBeanUtil.getDistributedRegionMbean("/p+os", 1);
                    MBeanUtil.getDistributedRegionMbean("/p@os", 1);
                }
                catch (Exception e) {
                    InternalDistributedSystem.getLoggerI18n().fine("Undesired Result , DistributedRegionMXBean Should not be null" + e);
                }
            }
        });
    }

    public void testLruStats() throws Exception {
        this.initManagement(false);
        for (VM vm : managedNodeList) {
            this.createDiskRegion(vm);
        }
        this.checkEntrySize(managingNode, 3);
    }

    public void createDiskRegion(VM vm1) throws Exception {
        vm1.invoke(new SerializableRunnable("Check Sub Regions"){

            @Override
            public void run() {
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.LOCAL);
                factory.setEvictionAttributes(EvictionAttributes.createLRUMemoryAttributes((int)20, (ObjectSizer)new TestObjectSizerImpl(), (EvictionAction)EvictionAction.LOCAL_DESTROY));
                Region region = RegionManagementDUnitTest.this.getCache().createRegion(RegionManagementDUnitTest.REGION_NAME, factory.create());
                LRUStatistics lruStats = RegionManagementDUnitTest.this.getLRUStats(region);
                TestCase.assertNotNull((Object)lruStats);
                RegionMXBean bean = ManagementTestBase.managementService.getLocalRegionMBean(RegionManagementDUnitTest.REGION_PATH);
                TestCase.assertNotNull((Object)bean);
                for (int total = 0; total < 10000; ++total) {
                    int[] array = new int[250];
                    array[0] = total;
                    region.put((Object)new Integer(total), (Object)array);
                }
                TestCase.assertTrue((bean.getEntrySize() > 0L ? 1 : 0) != 0);
                DistributedTestCase.getLogWriter().info("DEBUG: EntrySize =" + bean.getEntrySize());
            }
        });
    }

    public void checkEntrySize(VM vm1, final int expectedMembers) throws Exception {
        vm1.invoke(new SerializableRunnable("Check Sub Regions"){

            @Override
            public void run() {
                DistributedRegionMXBean bean = null;
                try {
                    bean = MBeanUtil.getDistributedRegionMbean(RegionManagementDUnitTest.REGION_PATH, expectedMembers);
                }
                catch (Exception e) {
                    InternalDistributedSystem.getLoggerI18n().fine("Undesired Result , DistributedRegionMXBean Should not be null" + e);
                }
                TestCase.assertNotNull((Object)bean);
                TestCase.assertTrue((bean.getEntrySize() > 0L ? 1 : 0) != 0);
                DistributedTestCase.getLogWriter().info("DEBUG: EntrySize =" + bean.getEntrySize());
            }
        });
    }

    protected LRUStatistics getLRUStats(Region region) {
        LocalRegion l = (LocalRegion)region;
        return l.getEvictionController().getLRUHelper().getStats();
    }

    public void checkSubRegions(VM vm1, final String subRegionPath) throws Exception {
        vm1.invoke(new SerializableRunnable("Check Sub Regions"){

            @Override
            public void run() {
                RegionMXBean bean = ManagementTestBase.managementService.getLocalRegionMBean(subRegionPath);
                TestCase.assertNotNull((Object)bean);
            }
        });
    }

    public void checkNullRegions(VM vm1, final String subRegionPath) throws Exception {
        vm1.invoke(new SerializableRunnable("Check Sub Regions"){

            @Override
            public void run() {
                RegionMXBean bean = ManagementTestBase.managementService.getLocalRegionMBean(subRegionPath);
                TestCase.assertNull((Object)bean);
            }
        });
    }

    protected void checkNavigationAPIS(VM vm, final List<String> managedNodeMemberIds) {
        SerializableRunnable checkNavigationAPIS = new SerializableRunnable("checkNavigationAPIS"){

            @Override
            public void run() {
                GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
                ManagementService service = ManagementTestBase.getManagementService();
                DistributedSystemMXBean bean = service.getDistributedSystemMXBean();
                TestCase.assertNotNull((Object)service.getDistributedSystemMXBean());
                RegionManagementDUnitTest.this.waitForAllMembers(4);
                TestCase.assertTrue((bean.listDistributedRegionObjectNames().length == 2 ? 1 : 0) != 0);
                try {
                    TestCase.assertNotNull((Object)bean.fetchDistributedRegionObjectName(RegionManagementDUnitTest.PARTITIONED_REGION_PATH));
                    TestCase.assertNotNull((Object)bean.fetchDistributedRegionObjectName(RegionManagementDUnitTest.REGION_PATH));
                    ObjectName actualName = bean.fetchDistributedRegionObjectName(RegionManagementDUnitTest.PARTITIONED_REGION_PATH);
                    ObjectName expectedName = MBeanJMXAdapter.getDistributedRegionMbeanName((String)RegionManagementDUnitTest.PARTITIONED_REGION_PATH);
                    TestCase.assertEquals((Object)expectedName, (Object)actualName);
                    actualName = bean.fetchDistributedRegionObjectName(RegionManagementDUnitTest.REGION_PATH);
                    expectedName = MBeanJMXAdapter.getDistributedRegionMbeanName((String)RegionManagementDUnitTest.REGION_PATH);
                    TestCase.assertEquals((Object)expectedName, (Object)actualName);
                }
                catch (Exception e) {
                    TestCase.fail((String)("fetchDistributedRegionObjectName () Unsuccessful " + e));
                }
                for (String memberId : managedNodeMemberIds) {
                    ObjectName memberMBeanName = MBeanJMXAdapter.getMemberMBeanName((String)memberId);
                    try {
                        RegionManagementDUnitTest.this.waitForProxy(memberMBeanName, MemberMXBean.class);
                        ObjectName[] regionMBeanNames = bean.fetchRegionObjectNames(memberMBeanName);
                        TestCase.assertNotNull((Object)regionMBeanNames);
                        TestCase.assertTrue((regionMBeanNames.length == 2 ? 1 : 0) != 0);
                        List<ObjectName> listOfNames = Arrays.asList(regionMBeanNames);
                        ObjectName expectedName = MBeanJMXAdapter.getRegionMBeanName((String)memberId, (String)RegionManagementDUnitTest.PARTITIONED_REGION_PATH);
                        listOfNames.contains(expectedName);
                        expectedName = MBeanJMXAdapter.getRegionMBeanName((String)memberId, (String)RegionManagementDUnitTest.REGION_PATH);
                        listOfNames.contains(expectedName);
                    }
                    catch (Exception e) {
                        TestCase.fail((String)("fetchRegionObjectNames () Unsuccessful " + e));
                    }
                }
                for (String memberId : managedNodeMemberIds) {
                    ObjectName memberMBeanName = MBeanJMXAdapter.getMemberMBeanName((String)memberId);
                    try {
                        RegionManagementDUnitTest.this.waitForProxy(memberMBeanName, MemberMXBean.class);
                        ObjectName expectedName = MBeanJMXAdapter.getRegionMBeanName((String)memberId, (String)RegionManagementDUnitTest.PARTITIONED_REGION_PATH);
                        RegionManagementDUnitTest.this.waitForProxy(expectedName, RegionMXBean.class);
                        ObjectName actualName = bean.fetchRegionObjectName(memberId, RegionManagementDUnitTest.PARTITIONED_REGION_PATH);
                        TestCase.assertEquals((Object)expectedName, (Object)actualName);
                        expectedName = MBeanJMXAdapter.getRegionMBeanName((String)memberId, (String)RegionManagementDUnitTest.REGION_PATH);
                        RegionManagementDUnitTest.this.waitForProxy(expectedName, RegionMXBean.class);
                        actualName = bean.fetchRegionObjectName(memberId, RegionManagementDUnitTest.REGION_PATH);
                        TestCase.assertEquals((Object)expectedName, (Object)actualName);
                    }
                    catch (Exception e) {
                        TestCase.fail((String)"fetchRegionObjectName () Unsuccessful ");
                    }
                }
            }
        };
        vm.invoke(checkNavigationAPIS);
    }

    protected void putBulkData(VM vm, final int numKeys) {
        SerializableRunnable putBulkData = new SerializableRunnable("putBulkData"){

            @Override
            public void run() {
                GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
                Region region = cache.getRegion(RegionManagementDUnitTest.REGION_PATH);
                for (int i = 0; i < numKeys; ++i) {
                    region.put((Object)i, (Object)(i * i));
                }
            }
        };
        vm.invoke(putBulkData);
    }

    private static void createFixedPartitionList(int primaryIndex) {
        fpaList.clear();
        if (primaryIndex == 1) {
            fpaList.add(FixedPartitionAttributes.createFixedPartition((String)"Q1", (boolean)true, (int)3));
            fpaList.add(FixedPartitionAttributes.createFixedPartition((String)"Q2", (int)3));
            fpaList.add(FixedPartitionAttributes.createFixedPartition((String)"Q3", (int)3));
        }
        if (primaryIndex == 2) {
            fpaList.add(FixedPartitionAttributes.createFixedPartition((String)"Q1", (int)3));
            fpaList.add(FixedPartitionAttributes.createFixedPartition((String)"Q2", (boolean)true, (int)3));
            fpaList.add(FixedPartitionAttributes.createFixedPartition((String)"Q3", (int)3));
        }
        if (primaryIndex == 3) {
            fpaList.add(FixedPartitionAttributes.createFixedPartition((String)"Q1", (int)3));
            fpaList.add(FixedPartitionAttributes.createFixedPartition((String)"Q2", (int)3));
            fpaList.add(FixedPartitionAttributes.createFixedPartition((String)"Q3", (boolean)true, (int)3));
        }
    }

    protected static void createFixedPartitionRegion(List<FixedPartitionAttributes> fpaList) {
        GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
        SystemManagementService service = (SystemManagementService)RegionManagementDUnitTest.getManagementService();
        PartitionAttributesFactory paf = new PartitionAttributesFactory();
        paf.setRedundantCopies(2).setTotalNumBuckets(12);
        for (FixedPartitionAttributes fpa : fpaList) {
            paf.addFixedPartitionAttributes(fpa);
        }
        paf.setPartitionResolver((PartitionResolver)new SingleHopQuarterPartitionResolver());
        AttributesFactory attr = new AttributesFactory();
        attr.setPartitionAttributes(paf.create());
        fixedPrRegion = cache.createRegion(FIXED_PR_NAME, attr.create());
        RegionManagementDUnitTest.assertNotNull((Object)fixedPrRegion);
        RegionManagementDUnitTest.getLogWriter().info("Partitioned Region MANAGEMENT_FIXED_PR created Successfully :" + fixedPrRegion.toString());
        RegionMXBean bean = service.getLocalRegionMBean(FIXED_PR_PATH);
        RegionAttributes regAttrs = fixedPrRegion.getAttributes();
        RegionManagementDUnitTest.getLogWriter().info("FixedPartitionAttribute From GemFire :" + regAttrs.getPartitionAttributes().getFixedPartitionAttributes());
        RegionAttributesData data = bean.listRegionAttributes();
        PartitionAttributesData parData = bean.listPartitionAttributes();
        RegionManagementDUnitTest.assertPartitionData(regAttrs, parData);
        FixedPartitionAttributesData[] fixedPrData = bean.listFixedPartitionAttributes();
        RegionManagementDUnitTest.assertNotNull((Object)fixedPrData);
        RegionManagementDUnitTest.assertEquals((int)3, (int)fixedPrData.length);
        for (int i = 0; i < fixedPrData.length; ++i) {
            RegionManagementDUnitTest.getLogWriter().info("<ExpectedString> Fixed PR Data is " + fixedPrData[i] + "</ExpectedString> ");
        }
    }

    protected void validateRemoteFixedPartitionRegion(VM vm) throws Exception {
        SerializableRunnable verifyFixedRegion = new SerializableRunnable("Verify Partition region"){

            @Override
            public void run() {
                GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
                Set otherMemberSet = cache.getDistributionManager().getOtherNormalDistributionManagerIds();
                for (DistributedMember member : otherMemberSet) {
                    RegionMXBean bean = null;
                    try {
                        bean = MBeanUtil.getRegionMbeanProxy(member, RegionManagementDUnitTest.FIXED_PR_PATH);
                    }
                    catch (Exception e) {
                        InternalDistributedSystem.getLoggerI18n().fine("Undesired Result , RegionMBean Should not be null");
                    }
                    PartitionAttributesData data = bean.listPartitionAttributes();
                    TestCase.assertNotNull((Object)data);
                    FixedPartitionAttributesData[] fixedPrData = bean.listFixedPartitionAttributes();
                    TestCase.assertNotNull((Object)fixedPrData);
                    TestCase.assertEquals((int)3, (int)fixedPrData.length);
                    for (int i = 0; i < fixedPrData.length; ++i) {
                        DistributedTestCase.getLogWriter().info("<ExpectedString> Remote PR Data is " + fixedPrData[i] + "</ExpectedString> ");
                    }
                }
            }
        };
        vm.invoke(verifyFixedRegion);
    }

    protected void addMemberListener(VM vm) {
        SerializableRunnable addMemberListener = new SerializableRunnable("addMemberListener"){

            @Override
            public void run() {
                GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
                SystemManagementService service = (SystemManagementService)ManagementTestBase.getManagementService();
                Set otherMemberSet = cache.getDistributionManager().getOtherNormalDistributionManagerIds();
                for (DistributedMember member : otherMemberSet) {
                    MBeanServer mbeanServer = MBeanJMXAdapter.mbeanServer;
                    RegionNotif regionCreate = new RegionNotif();
                    try {
                        ObjectName memberMBeanName = service.getMemberMBeanName(member);
                        Set names = service.queryMBeanNames(member);
                        if (names != null) {
                            for (ObjectName name : names) {
                                DistributedTestCase.getLogWriter().info("<ExpectedString> ObjectNames arr" + name + "</ExpectedString> ");
                            }
                        }
                        RegionManagementDUnitTest.this.waitForProxy(memberMBeanName, MemberMXBean.class);
                        mbeanServer.addNotificationListener(memberMBeanName, regionCreate, null, null);
                    }
                    catch (NullPointerException e) {
                        DistributedTestCase.fail("FAILED WITH EXCEPION", e);
                    }
                    catch (InstanceNotFoundException e) {
                        DistributedTestCase.fail("FAILED WITH EXCEPION", e);
                    }
                    catch (Exception e) {
                        DistributedTestCase.fail("FAILED WITH EXCEPION", e);
                    }
                }
            }
        };
        vm.invoke(addMemberListener);
    }

    protected void addDistrListener(VM vm) {
        SerializableRunnable addDistrListener = new SerializableRunnable("addDistrListener"){

            @Override
            public void run() {
                MBeanServer mbeanServer = MBeanJMXAdapter.mbeanServer;
                DistrNotif regionCreate = new DistrNotif();
                try {
                    ObjectName systemMBeanName = MBeanJMXAdapter.getDistributedSystemName();
                    mbeanServer.addNotificationListener(systemMBeanName, regionCreate, null, null);
                }
                catch (NullPointerException e) {
                    DistributedTestCase.fail("FAILED WITH EXCEPION", e);
                }
                catch (InstanceNotFoundException e) {
                    DistributedTestCase.fail("FAILED WITH EXCEPION", e);
                }
            }
        };
        vm.invoke(addDistrListener);
    }

    public void ensureProxyCleanup(VM vm) {
        SerializableRunnable ensureProxyCleanup = new SerializableRunnable("Ensure Proxy cleanup"){

            @Override
            public void run() {
                GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
                Set otherMemberSet = cache.getDistributionManager().getOtherNormalDistributionManagerIds();
                final SystemManagementService service = (SystemManagementService)ManagementTestBase.getManagementService();
                for (final DistributedMember member : otherMemberSet) {
                    Object bean = null;
                    try {
                        DistributedTestCase.waitForCriterion(new DistributedTestCase.WaitCriterion(){
                            RegionMXBean bean = null;

                            @Override
                            public String description() {
                                return "Waiting for the proxy to get deleted at managing node";
                            }

                            @Override
                            public boolean done() {
                                ObjectName objectName = service.getRegionMBeanName(member, RegionManagementDUnitTest.REGION_PATH);
                                this.bean = (RegionMXBean)service.getMBeanProxy(objectName, RegionMXBean.class);
                                boolean done = this.bean == null;
                                return done;
                            }
                        }, 70000L, 500L, true);
                    }
                    catch (Exception e) {
                        TestCase.fail((String)"could not remove proxies in required time");
                    }
                    TestCase.assertNull(bean);
                }
            }
        };
        vm.invoke(ensureProxyCleanup);
    }

    protected void verifyRemoteDistributedRegion(VM vm, final int expectedMembers) throws Exception {
        SerializableRunnable verifyRegion = new SerializableRunnable("Verify Distributed region"){

            @Override
            public void run() {
                GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
                Set otherMemberSet = cache.getDistributionManager().getOtherNormalDistributionManagerIds();
                for (DistributedMember member : otherMemberSet) {
                    RegionMXBean bean = null;
                    try {
                        bean = MBeanUtil.getRegionMbeanProxy(member, RegionManagementDUnitTest.REGION_PATH);
                    }
                    catch (Exception e) {
                        InternalDistributedSystem.getLoggerI18n().fine("Undesired Result , RegionMBean Should not be null" + e);
                    }
                    TestCase.assertNotNull((Object)bean);
                    RegionAttributesData data = bean.listRegionAttributes();
                    TestCase.assertNotNull((Object)data);
                    MembershipAttributesData membershipData = bean.listMembershipAttributes();
                    EvictionAttributesData evictionData = bean.listEvictionAttributes();
                    TestCase.assertNotNull((Object)membershipData);
                    TestCase.assertNotNull((Object)evictionData);
                    DistributedTestCase.getLogWriter().info("<ExpectedString> Membership Data is " + membershipData.toString() + "</ExpectedString> ");
                    DistributedTestCase.getLogWriter().info("<ExpectedString> Eviction Data is " + membershipData.toString() + "</ExpectedString> ");
                }
                DistributedRegionMXBean bean = null;
                try {
                    bean = MBeanUtil.getDistributedRegionMbean(RegionManagementDUnitTest.REGION_PATH, expectedMembers);
                }
                catch (Exception e) {
                    InternalDistributedSystem.getLoggerI18n().fine("Undesired Result , DistributedRegionMXBean Should not be null" + e);
                }
                TestCase.assertNotNull((Object)bean);
                TestCase.assertEquals((String)RegionManagementDUnitTest.REGION_PATH, (String)bean.getFullPath());
            }
        };
        vm.invoke(verifyRegion);
    }

    protected void validateDistributedMBean(VM vm, final int expectedMembers) {
        SerializableRunnable verifyRegion = new SerializableRunnable("Verify Distributed region"){

            @Override
            public void run() {
                DistributedRegionMXBean bean = null;
                DistributedSystemMXBean sysMBean = null;
                final ManagementService service = ManagementTestBase.getManagementService();
                if (expectedMembers == 0) {
                    try {
                        DistributedTestCase.waitForCriterion(new DistributedTestCase.WaitCriterion(){
                            RegionMXBean bean = null;

                            @Override
                            public String description() {
                                return "Waiting for the proxy to get deleted at managing node";
                            }

                            @Override
                            public boolean done() {
                                DistributedRegionMXBean bean = service.getDistributedRegionMXBean(RegionManagementDUnitTest.REGION_PATH);
                                boolean done = bean == null;
                                return done;
                            }
                        }, 70000L, 500L, true);
                    }
                    catch (Exception e) {
                        TestCase.fail((String)"could not remove Aggregate Bean in required time");
                    }
                    return;
                }
                try {
                    bean = MBeanUtil.getDistributedRegionMbean(RegionManagementDUnitTest.REGION_PATH, expectedMembers);
                    sysMBean = service.getDistributedSystemMXBean();
                }
                catch (Exception e) {
                    InternalDistributedSystem.getLoggerI18n().fine("Undesired Result , DistributedRegionMXBean Should not be null" + e);
                }
                TestCase.assertNotNull((Object)bean);
                TestCase.assertEquals((String)RegionManagementDUnitTest.REGION_PATH, (String)bean.getFullPath());
                TestCase.assertEquals((int)expectedMembers, (int)bean.getMemberCount());
                TestCase.assertEquals((int)expectedMembers, (int)bean.getMembers().length);
                DistributedTestCase.getLogWriter().info("<ExpectedString> CacheListenerCallsAvgLatency is " + bean.getCacheListenerCallsAvgLatency() + "</ExpectedString> ");
                DistributedTestCase.getLogWriter().info("<ExpectedString> CacheWriterCallsAvgLatency is " + bean.getCacheWriterCallsAvgLatency() + "</ExpectedString> ");
                DistributedTestCase.getLogWriter().info("<ExpectedString> CreatesRate is " + bean.getCreatesRate() + "</ExpectedString> ");
            }
        };
        vm.invoke(verifyRegion);
    }

    protected void validateRemotePartitionRegion(VM vm) throws Exception {
        SerializableRunnable verifyRegion = new SerializableRunnable("Verify Partition region"){

            @Override
            public void run() {
                GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
                Set otherMemberSet = cache.getDistributionManager().getOtherNormalDistributionManagerIds();
                for (DistributedMember member : otherMemberSet) {
                    RegionMXBean bean = null;
                    try {
                        bean = MBeanUtil.getRegionMbeanProxy(member, RegionManagementDUnitTest.PARTITIONED_REGION_PATH);
                    }
                    catch (Exception e) {
                        InternalDistributedSystem.getLoggerI18n().fine("Undesired Result , RegionMBean Should not be null");
                    }
                    PartitionAttributesData data = bean.listPartitionAttributes();
                    TestCase.assertNotNull((Object)data);
                }
                ManagementService service = ManagementTestBase.getManagementService();
                DistributedRegionMXBean bean = service.getDistributedRegionMXBean(RegionManagementDUnitTest.PARTITIONED_REGION_PATH);
                TestCase.assertEquals((int)3, (int)bean.getMembers().length);
            }
        };
        vm.invoke(verifyRegion);
    }

    protected void validateReplicateRegionAfterCreate(VM vm) {
        SerializableRunnable checkDistributedRegion = new SerializableRunnable("Check Distributed region"){

            @Override
            public void run() {
                GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
                SystemManagementService service = (SystemManagementService)ManagementTestBase.getManagementService();
                MBeanServer mbeanServer = MBeanJMXAdapter.mbeanServer;
                RegionNotif test = new RegionNotif();
                String memberId = MBeanJMXAdapter.getMemberNameOrId((DistributedMember)cache.getDistributedSystem().getDistributedMember());
                try {
                    ObjectName memberMBeanName = ObjectName.getInstance("GemFire:type=Member,member=" + memberId);
                    mbeanServer.addNotificationListener(memberMBeanName, test, null, null);
                }
                catch (MalformedObjectNameException e) {
                    DistributedTestCase.fail("FAILED WITH EXCEPION", e);
                }
                catch (NullPointerException e) {
                    DistributedTestCase.fail("FAILED WITH EXCEPION", e);
                }
                catch (InstanceNotFoundException e) {
                    DistributedTestCase.fail("FAILED WITH EXCEPION", e);
                }
                TestCase.assertNotNull((Object)service.getLocalRegionMBean(RegionManagementDUnitTest.REGION_PATH));
                RegionMXBean bean = service.getLocalRegionMBean(RegionManagementDUnitTest.REGION_PATH);
                Region region = cache.getRegion(RegionManagementDUnitTest.REGION_PATH);
                RegionAttributes regAttrs = region.getAttributes();
                RegionAttributesData data = bean.listRegionAttributes();
                RegionManagementDUnitTest.assertRegionAttributes(regAttrs, data);
                MembershipAttributesData membershipData = bean.listMembershipAttributes();
                EvictionAttributesData evictionData = bean.listEvictionAttributes();
                TestCase.assertNotNull((Object)membershipData);
                TestCase.assertNotNull((Object)evictionData);
                DistributedTestCase.getLogWriter().info("<ExpectedString> Membership Data is " + membershipData.toString() + "</ExpectedString> ");
                DistributedTestCase.getLogWriter().info("<ExpectedString> Eviction Data is " + membershipData.toString() + "</ExpectedString> ");
            }
        };
        vm.invoke(checkDistributedRegion);
    }

    protected void validatePartitionRegionAfterCreate(VM vm) {
        SerializableRunnable createParRegion = new SerializableRunnable("Create Partitioned region"){

            @Override
            public void run() {
                GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
                SystemManagementService service = (SystemManagementService)ManagementTestBase.getManagementService();
                TestCase.assertNotNull((Object)service.getLocalRegionMBean(RegionManagementDUnitTest.PARTITIONED_REGION_PATH));
                RegionMXBean bean = service.getLocalRegionMBean(RegionManagementDUnitTest.PARTITIONED_REGION_PATH);
                Region partitionedRegion = cache.getRegion(RegionManagementDUnitTest.PARTITIONED_REGION_PATH);
                RegionAttributes regAttrs = partitionedRegion.getAttributes();
                RegionAttributesData data = bean.listRegionAttributes();
                PartitionAttributesData parData = bean.listPartitionAttributes();
                RegionManagementDUnitTest.assertPartitionData(regAttrs, parData);
            }
        };
        vm.invoke(createParRegion);
    }

    protected void validateReplicatedRegionAfterClose(VM vm) {
        SerializableRunnable closeRegion = new SerializableRunnable("Close Distributed region"){

            @Override
            public void run() {
                GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
                SystemManagementService service = (SystemManagementService)ManagementTestBase.getManagementService();
                RegionMXBean bean = null;
                try {
                    bean = service.getLocalRegionMBean(RegionManagementDUnitTest.REGION_PATH);
                }
                catch (ManagementException mgtEx) {
                    DistributedTestCase.getLogWriter().info("<ExpectedString> Expected Exception  " + mgtEx.getLocalizedMessage() + "</ExpectedString> ");
                }
                TestCase.assertNull((Object)bean);
                ObjectName regionObjectName = service.getRegionMBeanName((DistributedMember)cache.getDistributedSystem().getDistributedMember(), RegionManagementDUnitTest.REGION_PATH);
                TestCase.assertNull((Object)service.getLocalManager().getManagementResourceRepo().getEntryFromLocalMonitoringRegion(regionObjectName));
            }
        };
        vm.invoke(closeRegion);
    }

    protected void validatePartitionRegionAfterClose(VM vm) {
        SerializableRunnable closeParRegion = new SerializableRunnable("Close Partition region"){

            @Override
            public void run() {
                GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
                ManagementService service = ManagementTestBase.getManagementService();
                DistributedTestCase.getLogWriter().info("Closing Par Region");
                RegionMXBean bean = null;
                try {
                    bean = service.getLocalRegionMBean(RegionManagementDUnitTest.PARTITIONED_REGION_PATH);
                }
                catch (ManagementException mgtEx) {
                    DistributedTestCase.getLogWriter().info("<ExpectedString> Expected Exception  " + mgtEx.getLocalizedMessage() + "</ExpectedString> ");
                }
                TestCase.assertNull((Object)bean);
            }
        };
        vm.invoke(closeParRegion);
    }

    protected void closeFixedPartitionRegion(VM vm) {
        SerializableRunnable closeParRegion = new SerializableRunnable("Close Fixed Partition region"){

            @Override
            public void run() {
                GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
                ManagementService service = ManagementTestBase.getManagementService();
                DistributedTestCase.getLogWriter().info("Closing Fixed Par Region");
                Region region = cache.getRegion(RegionManagementDUnitTest.FIXED_PR_PATH);
                region.close();
                RegionMXBean bean = null;
                try {
                    bean = service.getLocalRegionMBean(RegionManagementDUnitTest.FIXED_PR_PATH);
                }
                catch (ManagementException mgtEx) {
                    DistributedTestCase.getLogWriter().info("<ExpectedString> Expected Exception  " + mgtEx.getLocalizedMessage() + "</ExpectedString> ");
                }
                TestCase.assertNull((Object)bean);
            }
        };
        vm.invoke(closeParRegion);
    }

    protected static void assertPartitionData(RegionAttributes regAttrs, PartitionAttributesData partitionAttributesData) {
        PartitionAttributesData data = partitionAttributesData;
        PartitionAttributes partAttrs = regAttrs.getPartitionAttributes();
        int redundantCopies = partAttrs.getRedundantCopies();
        RegionManagementDUnitTest.assertEquals((int)redundantCopies, (int)data.getRedundantCopies());
        long totalMaxMemory = partAttrs.getTotalMaxMemory();
        RegionManagementDUnitTest.assertEquals((long)totalMaxMemory, (long)data.getTotalMaxMemory());
        int totalNumBuckets = partAttrs.getTotalNumBuckets();
        RegionManagementDUnitTest.assertEquals((int)totalNumBuckets, (int)data.getTotalNumBuckets());
        int localMaxMemory = partAttrs.getLocalMaxMemory();
        RegionManagementDUnitTest.assertEquals((int)localMaxMemory, (int)data.getLocalMaxMemory());
        String colocatedWith = partAttrs.getColocatedWith();
        RegionManagementDUnitTest.assertEquals((String)colocatedWith, (String)data.getColocatedWith());
        String partitionResolver = null;
        if (partAttrs.getPartitionResolver() != null) {
            partitionResolver = partAttrs.getPartitionResolver().getName();
        }
        RegionManagementDUnitTest.assertEquals((String)partitionResolver, (String)data.getPartitionResolver());
        long recoveryDelay = partAttrs.getRecoveryDelay();
        RegionManagementDUnitTest.assertEquals((long)recoveryDelay, (long)data.getRecoveryDelay());
        long startupRecoveryDelay = partAttrs.getStartupRecoveryDelay();
        RegionManagementDUnitTest.assertEquals((long)startupRecoveryDelay, (long)data.getStartupRecoveryDelay());
        if (partAttrs.getPartitionListeners() != null) {
            for (int i = 0; i < partAttrs.getPartitionListeners().length; ++i) {
                RegionManagementDUnitTest.assertEquals((String)partAttrs.getPartitionListeners()[i].getClass().getCanonicalName(), (String)data.getPartitionListeners()[i]);
            }
        }
    }

    protected static void assertRegionAttributes(RegionAttributes regAttrs, RegionAttributesData data) {
        String compressorClassName = null;
        if (regAttrs.getCompressor() != null) {
            compressorClassName = regAttrs.getCompressor().getClass().getCanonicalName();
        }
        RegionManagementDUnitTest.assertEquals(compressorClassName, (String)data.getCompressorClassName());
        String cacheLoaderClassName = null;
        if (regAttrs.getCacheLoader() != null) {
            cacheLoaderClassName = regAttrs.getCacheLoader().getClass().getCanonicalName();
        }
        RegionManagementDUnitTest.assertEquals(cacheLoaderClassName, (String)data.getCacheLoaderClassName());
        String cacheWriteClassName = null;
        if (regAttrs.getCacheWriter() != null) {
            cacheWriteClassName = regAttrs.getCacheWriter().getClass().getCanonicalName();
        }
        RegionManagementDUnitTest.assertEquals(cacheWriteClassName, (String)data.getCacheWriterClassName());
        String keyConstraintClassName = null;
        if (regAttrs.getKeyConstraint() != null) {
            keyConstraintClassName = regAttrs.getKeyConstraint().getName();
        }
        RegionManagementDUnitTest.assertEquals((String)keyConstraintClassName, (String)data.getKeyConstraintClassName());
        String valueContstaintClassName = null;
        if (regAttrs.getValueConstraint() != null) {
            valueContstaintClassName = regAttrs.getValueConstraint().getName();
        }
        RegionManagementDUnitTest.assertEquals((String)valueContstaintClassName, (String)data.getValueConstraintClassName());
        CacheListener[] listeners = regAttrs.getCacheListeners();
        if (listeners != null) {
            String[] value = data.getCacheListeners();
            for (int i = 0; i < listeners.length; ++i) {
                RegionManagementDUnitTest.assertEquals((String)value[i], (String)listeners[i].getClass().getName());
            }
        }
        int regionTimeToLive = regAttrs.getRegionTimeToLive().getTimeout();
        RegionManagementDUnitTest.assertEquals((int)regionTimeToLive, (int)data.getRegionTimeToLive());
        int regionIdleTimeout = regAttrs.getRegionIdleTimeout().getTimeout();
        RegionManagementDUnitTest.assertEquals((int)regionIdleTimeout, (int)data.getRegionIdleTimeout());
        int entryTimeToLive = regAttrs.getEntryTimeToLive().getTimeout();
        RegionManagementDUnitTest.assertEquals((int)entryTimeToLive, (int)data.getEntryTimeToLive());
        int entryIdleTimeout = regAttrs.getEntryIdleTimeout().getTimeout();
        RegionManagementDUnitTest.assertEquals((int)entryIdleTimeout, (int)data.getEntryIdleTimeout());
        String customEntryTimeToLive = null;
        CustomExpiry o1 = regAttrs.getCustomEntryTimeToLive();
        if (o1 != null) {
            customEntryTimeToLive = o1.toString();
        }
        RegionManagementDUnitTest.assertEquals((String)customEntryTimeToLive, (String)data.getCustomEntryTimeToLive());
        String customEntryIdleTimeout = null;
        CustomExpiry o2 = regAttrs.getCustomEntryIdleTimeout();
        if (o2 != null) {
            customEntryIdleTimeout = o2.toString();
        }
        RegionManagementDUnitTest.assertEquals((String)customEntryIdleTimeout, (String)data.getCustomEntryIdleTimeout());
        boolean ignoreJTA = regAttrs.getIgnoreJTA();
        RegionManagementDUnitTest.assertEquals((boolean)ignoreJTA, (boolean)data.isIgnoreJTA());
        String dataPolicy = regAttrs.getDataPolicy().toString();
        RegionManagementDUnitTest.assertEquals((String)dataPolicy, (String)data.getDataPolicy());
        String scope = regAttrs.getScope().toString();
        RegionManagementDUnitTest.assertEquals((String)scope, (String)data.getScope());
        int initialCapacity = regAttrs.getInitialCapacity();
        RegionManagementDUnitTest.assertEquals((int)initialCapacity, (int)data.getInitialCapacity());
        float loadFactor = regAttrs.getLoadFactor();
        RegionManagementDUnitTest.assertEquals((Object)Float.valueOf(loadFactor), (Object)Float.valueOf(data.getLoadFactor()));
        boolean lockGrantor = regAttrs.isLockGrantor();
        RegionManagementDUnitTest.assertEquals((boolean)lockGrantor, (boolean)data.isLockGrantor());
        boolean multicastEnabled = regAttrs.getMulticastEnabled();
        RegionManagementDUnitTest.assertEquals((boolean)multicastEnabled, (boolean)data.isMulticastEnabled());
        int concurrencyLevel = regAttrs.getConcurrencyLevel();
        RegionManagementDUnitTest.assertEquals((int)concurrencyLevel, (int)data.getConcurrencyLevel());
        boolean indexMaintenanceSynchronous = regAttrs.getIndexMaintenanceSynchronous();
        RegionManagementDUnitTest.assertEquals((boolean)indexMaintenanceSynchronous, (boolean)data.isIndexMaintenanceSynchronous());
        boolean statisticsEnabled = regAttrs.getStatisticsEnabled();
        RegionManagementDUnitTest.assertEquals((boolean)statisticsEnabled, (boolean)data.isStatisticsEnabled());
        boolean gatewayEnabled = regAttrs.getEnableGateway();
        RegionManagementDUnitTest.assertEquals((boolean)gatewayEnabled, (boolean)data.isGatewayEnabled());
        String gatewayHubId = regAttrs.getGatewayHubId();
        if (!gatewayHubId.equals("")) {
            RegionManagementDUnitTest.assertEquals((String)gatewayHubId, (String)data.getGatewayHubId());
        }
        boolean subsciptionConflationEnabled = regAttrs.getEnableSubscriptionConflation();
        RegionManagementDUnitTest.assertEquals((boolean)subsciptionConflationEnabled, (boolean)data.isSubscriptionConflationEnabled());
        boolean asyncConflationEnabled = regAttrs.getEnableAsyncConflation();
        RegionManagementDUnitTest.assertEquals((boolean)asyncConflationEnabled, (boolean)data.isAsyncConflationEnabled());
        String poolName = regAttrs.getPoolName();
        RegionManagementDUnitTest.assertEquals((String)poolName, (String)data.getPoolName());
        boolean isCloningEnabled = regAttrs.getCloningEnabled();
        RegionManagementDUnitTest.assertEquals((boolean)isCloningEnabled, (boolean)data.isCloningEnabled());
        String diskStoreName = regAttrs.getDiskStoreName();
        RegionManagementDUnitTest.assertEquals((String)diskStoreName, (String)data.getDiskStoreName());
        String interestPolicy = null;
        if (regAttrs.getSubscriptionAttributes() != null) {
            interestPolicy = regAttrs.getSubscriptionAttributes().getInterestPolicy().toString();
        }
        RegionManagementDUnitTest.assertEquals(interestPolicy, (String)data.getInterestPolicy());
        boolean diskSynchronus = regAttrs.isDiskSynchronous();
        RegionManagementDUnitTest.assertEquals((boolean)diskSynchronus, (boolean)data.isDiskSynchronous());
    }

    public void verifyStatistics() {
    }

    private static class DistrNotif
    implements NotificationListener {
        private DistrNotif() {
        }

        @Override
        public void handleNotification(Notification notification, Object handback) {
            TestCase.assertNotNull((Object)notification);
            Notification rn = notification;
            DistributedTestCase.getLogWriter().info("<ExpectedString> Distributed System Notifications" + rn.toString() + "</ExpectedString> ");
        }
    }

    private static class RegionNotif
    implements NotificationListener {
        private RegionNotif() {
        }

        @Override
        public void handleNotification(Notification notification, Object handback) {
            TestCase.assertNotNull((Object)notification);
            Notification rn = notification;
            TestCase.assertTrue((rn.getType().equals("gemfire.distributedsystem.cache.region.created") || rn.getType().equals("gemfire.distributedsystem.cache.region.closed") ? 1 : 0) != 0);
            DistributedTestCase.getLogWriter().info("<ExpectedString> Member Level Notifications" + rn.toString() + "</ExpectedString> ");
        }
    }
}

