/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.jta.dunit;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.distributed.DistributedSystem;
import dunit.AsyncInvocation;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import hydra.ProcessMgr;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.sql.DataSource;

public class MaxPoolSizeDUnitTest
extends DistributedTestCase {
    static DistributedSystem ds;
    static Cache cache;
    private static String tblName;

    private static String readFile(String filename) throws IOException {
        BufferedReader br = new BufferedReader(new FileReader(filename));
        String nextLine = "";
        StringBuffer sb = new StringBuffer();
        while ((nextLine = br.readLine()) != null) {
            sb.append(nextLine);
        }
        MaxPoolSizeDUnitTest.getLogWriter().fine("***********\n " + sb);
        return sb.toString();
    }

    public MaxPoolSizeDUnitTest(String name) {
        super(name);
    }

    private static String modifyFile(String str) throws IOException {
        String search = "<jndi-binding type=\"XAPooledDataSource\"";
        String last_search = "</jndi-binding>";
        String newDB = "newDB_" + ProcessMgr.getProcessId();
        String jndi_str = "<jndi-binding type=\"XAPooledDataSource\" jndi-name=\"XAPooledDataSource\" jdbc-driver-class=\"org.apache.derby.jdbc.EmbeddedDriver\" init-pool-size=\"1\" max-pool-size=\"2\" idle-timeout-seconds=\"600\" blocking-timeout-seconds=\"2\" login-timeout-seconds=\"1\" conn-pooled-datasource-class=\"org.apache.derby.jdbc.EmbeddedConnectionPoolDataSource\" xa-datasource-class=\"org.apache.derby.jdbc.EmbeddedXADataSource\" user-name=\"mitul\" password=\"83f0069202c571faf1ae6c42b4ad46030e4e31c17409e19a\" connection-url=\"jdbc:derby:" + newDB + ";create=true\" >";
        String config_prop = "<config-property><config-property-name>description</config-property-name><config-property-type>java.lang.String</config-property-type><config-property-value>hi</config-property-value></config-property><config-property><config-property-name>user</config-property-name><config-property-type>java.lang.String</config-property-type><config-property-value>mitul</config-property-value></config-property><config-property><config-property-name>password</config-property-name><config-property-type>java.lang.String</config-property-type><config-property-value>83f0069202c571faf1ae6c42b4ad46030e4e31c17409e19a</config-property-value>        </config-property><config-property><config-property-name>databaseName</config-property-name><config-property-type>java.lang.String</config-property-type><config-property-value>" + newDB + "</config-property-value></config-property>\n";
        String new_str = jndi_str + config_prop;
        int n1 = str.indexOf(search);
        MaxPoolSizeDUnitTest.getLogWriter().fine("Start Index = " + n1);
        int n2 = str.indexOf(last_search, n1);
        StringBuffer sbuff = new StringBuffer(str);
        MaxPoolSizeDUnitTest.getLogWriter().fine("END Index = " + n2);
        String modified_str = sbuff.replace(n1, n2, new_str).toString();
        return modified_str;
    }

    public static String init(String className) throws Exception {
        MaxPoolSizeDUnitTest.getLogWriter().fine("PATH11 ");
        Properties props = new Properties();
        String jtest = System.getProperty("JTESTS");
        int pid = ProcessMgr.getProcessId();
        String path = System.getProperty("JTESTS") + "/lib/dunit-cachejta_" + pid + ".xml";
        MaxPoolSizeDUnitTest.getLogWriter().fine("PATH " + path);
        String file_as_str = MaxPoolSizeDUnitTest.readFile(jtest + "/lib/cachejta.xml");
        file_as_str = file_as_str.replaceAll("newDB", "newDB_" + pid);
        String modified_file_str = MaxPoolSizeDUnitTest.modifyFile(file_as_str);
        FileOutputStream fos = new FileOutputStream(path);
        BufferedWriter wr = new BufferedWriter(new OutputStreamWriter(fos));
        wr.write(modified_file_str);
        wr.flush();
        wr.close();
        props.setProperty("cache-xml-file", path);
        String tableName = "";
        try {
            ds = new MaxPoolSizeDUnitTest("temp").getSystem(props);
            cache = CacheFactory.create((DistributedSystem)ds);
            if (className != null && !className.equals("")) {
                String time = new Long(System.currentTimeMillis()).toString();
                tableName = className + time;
                MaxPoolSizeDUnitTest.createTable(tableName);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw new Exception("" + e);
        }
        tblName = tableName;
        return tableName;
    }

    public static void createTable(String tableName) throws NamingException, SQLException {
        Context ctx = cache.getJNDIContext();
        DataSource ds = (DataSource)ctx.lookup("java:/SimpleDataSource");
        String sql = "create table " + tableName + " (id integer NOT NULL, name varchar(50), CONSTRAINT the_key PRIMARY KEY(id))";
        MaxPoolSizeDUnitTest.getLogWriter().fine(sql);
        Connection conn = ds.getConnection();
        Statement sm = conn.createStatement();
        sm.execute(sql);
        sm.close();
        sm = conn.createStatement();
        for (int i = 1; i <= 10; ++i) {
            sql = "insert into " + tableName + " values (" + i + ",'name" + i + "')";
            sm.addBatch(sql);
            MaxPoolSizeDUnitTest.getLogWriter().fine(sql);
        }
        sm.executeBatch();
        conn.close();
    }

    public static void destroyTable() throws NamingException, SQLException {
        try {
            String tableName = tblName;
            Context ctx = cache.getJNDIContext();
            DataSource ds = (DataSource)ctx.lookup("java:/SimpleDataSource");
            Connection conn = ds.getConnection();
            MaxPoolSizeDUnitTest.getLogWriter().fine(" trying to drop table: " + tableName);
            String sql = "drop table " + tableName;
            Statement sm = conn.createStatement();
            sm.execute(sql);
            conn.close();
        }
        catch (NamingException ne) {
            MaxPoolSizeDUnitTest.getLogWriter().fine("destroy table naming exception: " + ne);
            throw ne;
        }
        catch (SQLException se) {
            MaxPoolSizeDUnitTest.getLogWriter().fine("destroy table sql exception: " + se);
            throw se;
        }
        MaxPoolSizeDUnitTest.closeCache();
    }

    public static Cache getCache() {
        return cache;
    }

    public static void startCache() {
        try {
            if (cache.isClosed()) {
                cache = CacheFactory.create((DistributedSystem)ds);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void closeCache() {
        try {
            if (!cache.isClosed()) {
                cache.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            ds.disconnect();
        }
        catch (Exception e) {
            MaxPoolSizeDUnitTest.getLogWriter().fine("Error in disconnecting from Distributed System");
        }
    }

    @Override
    public void setUp() throws Exception {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        Object[] o = new Object[]{"MaxPoolSizeDUnitTest"};
        vm0.invoke(MaxPoolSizeDUnitTest.class, "init", o);
    }

    @Override
    public void tearDown2() throws NamingException, SQLException {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        vm0.invoke(MaxPoolSizeDUnitTest.class, "destroyTable");
    }

    public static void testMaxPoolSize() throws Throwable {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        AsyncInvocation asyncObj = vm0.invokeAsync(MaxPoolSizeDUnitTest.class, "runTest1");
        DistributedTestCase.join(asyncObj, 30000L, MaxPoolSizeDUnitTest.getLogWriter());
        if (asyncObj.exceptionOccurred()) {
            MaxPoolSizeDUnitTest.fail("asyncObj failed", asyncObj.getException());
        }
    }

    public static void runTest1() throws Exception {
        int MAX_CONNECTIONS = 3;
        int count = 0;
        DataSource ds = null;
        try {
            Context ctx = cache.getJNDIContext();
            ds = (DataSource)ctx.lookup("java:/XAPooledDataSource");
        }
        catch (NamingException e) {
            MaxPoolSizeDUnitTest.getLogWriter().fine("Naming Exception caught in lookup: " + e);
            MaxPoolSizeDUnitTest.fail((String)("failed in naming lookup: " + e));
            return;
        }
        catch (Exception e) {
            MaxPoolSizeDUnitTest.getLogWriter().fine("Exception caught during naming lookup: " + e);
            MaxPoolSizeDUnitTest.fail((String)("failed in naming lookup: " + e));
            return;
        }
        try {
            for (count = 0; count < 3; ++count) {
                ds.getConnection();
                MaxPoolSizeDUnitTest.getLogWriter().fine("Thread 1 acquired connection #" + count);
            }
            MaxPoolSizeDUnitTest.fail((String)"expected max connect exception");
        }
        catch (SQLException e) {
            if (count < 2) {
                MaxPoolSizeDUnitTest.fail((String)("runTest1 SQL Exception caught: " + e));
            } else {
                MaxPoolSizeDUnitTest.getLogWriter().fine("Success SQLException caught at connection #" + count);
            }
        }
        catch (Exception e) {
            MaxPoolSizeDUnitTest.getLogWriter().fine("Exception caught in runTest1: " + e);
            MaxPoolSizeDUnitTest.fail((String)("Exception caught in runTest1: " + e));
            e.printStackTrace();
        }
    }
}

