/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.compression;

import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.compression.Compressor;
import com.gemstone.gemfire.compression.SnappyCompressor;
import dunit.Host;
import dunit.SerializableCallable;
import dunit.SerializableRunnable;
import dunit.VM;
import junit.framework.TestCase;

public class CompressionRegionFactoryDUnitTest
extends CacheTestCase {
    protected static final String COMPRESSED_REGION_NAME = "compressedRegion";
    protected static final Compressor compressor = SnappyCompressor.getDefaultInstance();
    protected static final int TEST_VM = 0;

    public CompressionRegionFactoryDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
    }

    public void testRegionFactoryCompressor() {
        SnappyCompressor compressor = null;
        try {
            compressor = SnappyCompressor.getDefaultInstance();
        }
        catch (Throwable t) {
            return;
        }
        CompressionRegionFactoryDUnitTest.assertTrue((boolean)this.createCompressedRegionOnVm(this.getVM(0), COMPRESSED_REGION_NAME, (Compressor)compressor));
        this.assertCompressor(this.getVM(0), COMPRESSED_REGION_NAME, (Compressor)compressor);
        this.cleanup(this.getVM(0));
    }

    private VM getVM(int vm) {
        return Host.getHost(0).getVM(vm);
    }

    private void cleanup(VM vm) {
        vm.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                CompressionRegionFactoryDUnitTest.this.getCache().getRegion(CompressionRegionFactoryDUnitTest.COMPRESSED_REGION_NAME).destroyRegion();
            }
        });
    }

    private void assertCompressor(VM vm, final String name, final Compressor compressor) {
        vm.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Region region = CompressionRegionFactoryDUnitTest.this.getCache().getRegion(name);
                TestCase.assertNotNull((Object)region);
                TestCase.assertNotNull((Object)region.getAttributes().getCompressor());
                TestCase.assertTrue((boolean)compressor.equals(region.getAttributes().getCompressor()));
            }
        });
    }

    private boolean createCompressedRegionOnVm(VM vm, final String name, final Compressor compressor) {
        return (Boolean)vm.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                try {
                    CompressionRegionFactoryDUnitTest.this.createRegion(name, compressor);
                }
                catch (IllegalStateException e) {
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
        });
    }

    private Region createRegion(String name, Compressor compressor) {
        return this.getCache().createRegionFactory().setDataPolicy(DataPolicy.REPLICATE).setCloningEnabled(true).setCompressor(compressor).create(name);
    }
}

