/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.wan.wancommand;

import com.gemstone.gemfire.internal.cache.wan.wancommand.WANCommandTestBase;
import com.gemstone.gemfire.management.cli.Result;
import com.gemstone.gemfire.management.internal.cli.json.GfJsonException;
import com.gemstone.gemfire.management.internal.cli.result.CommandResult;
import com.gemstone.gemfire.management.internal.cli.result.CompositeResultData;
import com.gemstone.gemfire.management.internal.cli.result.TabularResultData;
import dunit.Host;
import dunit.VM;
import hydra.Log;
import java.util.List;
import java.util.Properties;

public class WanCommandListDUnitTest
extends WANCommandTestBase {
    private static final long serialVersionUID = 1L;

    public WanCommandListDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
    }

    public void testListGatewayWithNoSenderReceiver() {
        VM puneLocator = Host.getLocator();
        int punePort = (Integer)puneLocator.invoke(WANCommandTestBase.class, "getLocatorPort");
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "localhost[" + punePort + "]");
        this.createDefaultSetup(props);
        Integer nyPort = (Integer)vm2.invoke(WANCommandTestBase.class, "createFirstRemoteLocator", new Object[]{2, punePort});
        vm3.invoke(WANCommandTestBase.class, "createCache", new Object[]{punePort});
        vm4.invoke(WANCommandTestBase.class, "createCache", new Object[]{punePort});
        vm5.invoke(WANCommandTestBase.class, "createCache", new Object[]{punePort});
        WanCommandListDUnitTest.pause(10000);
        String command = "list gateways";
        CommandResult cmdResult = this.executeCommand(command);
        if (cmdResult != null) {
            String strCmdResult = this.commandResultToString(cmdResult);
            Log.getLogWriter().info("testListGatewaySender : : " + strCmdResult);
            WanCommandListDUnitTest.assertEquals((Object)Result.Status.ERROR, (Object)cmdResult.getStatus());
        } else {
            WanCommandListDUnitTest.fail((String)"testListGatewaySender failed as did not get CommandResult");
        }
    }

    public void testListGatewaySender() {
        VM puneLocator = Host.getLocator();
        int punePort = (Integer)puneLocator.invoke(WANCommandTestBase.class, "getLocatorPort");
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "localhost[" + punePort + "]");
        this.createDefaultSetup(props);
        Integer nyPort = (Integer)vm2.invoke(WANCommandTestBase.class, "createFirstRemoteLocator", new Object[]{2, punePort});
        vm6.invoke(WANCommandTestBase.class, "createAndStartReceiver", new Object[]{nyPort});
        vm7.invoke(WANCommandTestBase.class, "createAndStartReceiver", new Object[]{nyPort});
        vm3.invoke(WANCommandTestBase.class, "createCache", new Object[]{punePort});
        vm3.invoke(WANCommandTestBase.class, "createSender", new Object[]{"ln_Serial", 2, false, 100, 400, false, false, null, false});
        vm3.invoke(WANCommandTestBase.class, "createSender", new Object[]{"ln_Parallel", 2, true, 100, 400, false, false, null, false});
        vm4.invoke(WANCommandTestBase.class, "createCache", new Object[]{punePort});
        vm4.invoke(WANCommandTestBase.class, "createSender", new Object[]{"ln_Parallel", 2, true, 100, 400, false, false, null, false});
        vm4.invoke(WANCommandTestBase.class, "createSender", new Object[]{"ln_Serial", 2, false, 100, 400, false, false, null, false});
        vm5.invoke(WANCommandTestBase.class, "createCache", new Object[]{punePort});
        vm5.invoke(WANCommandTestBase.class, "createSender", new Object[]{"ln_Serial", 2, false, 100, 400, false, false, null, false});
        WanCommandListDUnitTest.pause(10000);
        String command = "list gateways";
        CommandResult cmdResult = this.executeCommand(command);
        if (cmdResult != null) {
            String strCmdResult = this.commandResultToString(cmdResult);
            Log.getLogWriter().info("testListGatewaySender" + strCmdResult);
            WanCommandListDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
            TabularResultData tableResultData = ((CompositeResultData)cmdResult.getResultData()).retrieveSection("GatewaySender Section").retrieveTable("GatewaySender Table");
            List result_senderIds = tableResultData.retrieveAllValues("GatewaySender Id");
            WanCommandListDUnitTest.assertTrue((boolean)result_senderIds.contains("ln_Serial"));
            WanCommandListDUnitTest.assertTrue((boolean)result_senderIds.contains("ln_Parallel"));
            WanCommandListDUnitTest.assertEquals((int)5, (int)result_senderIds.size());
            WanCommandListDUnitTest.assertEquals(null, (Object)((CompositeResultData)cmdResult.getResultData()).retrieveSection("GatewayReceiver Section"));
        } else {
            WanCommandListDUnitTest.fail((String)"testListGatewaySender failed as did not get CommandResult");
        }
    }

    public void testListGatewayReceiver() {
        Integer lnPort = (Integer)vm1.invoke(WANCommandTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "localhost[" + lnPort + "]");
        this.createDefaultSetup(props);
        Integer nyPort = (Integer)vm2.invoke(WANCommandTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        vm3.invoke(WANCommandTestBase.class, "createAndStartReceiver", new Object[]{lnPort});
        vm4.invoke(WANCommandTestBase.class, "createAndStartReceiver", new Object[]{lnPort});
        vm5.invoke(WANCommandTestBase.class, "createCache", new Object[]{nyPort});
        vm5.invoke(WANCommandTestBase.class, "createSender", new Object[]{"ln_Serial", 1, false, 100, 400, false, false, null, false});
        vm6.invoke(WANCommandTestBase.class, "createCache", new Object[]{nyPort});
        vm6.invoke(WANCommandTestBase.class, "createSender", new Object[]{"ln_Serial", 1, false, 100, 400, false, false, null, false});
        vm6.invoke(WANCommandTestBase.class, "createSender", new Object[]{"ln_Parallel", 1, true, 100, 400, false, false, null, false});
        WanCommandListDUnitTest.pause(10000);
        String command = "list gateways";
        CommandResult cmdResult = this.executeCommand(command);
        if (cmdResult != null) {
            String strCmdResult = this.commandResultToString(cmdResult);
            Log.getLogWriter().info("testListGatewayReceiver" + strCmdResult);
            WanCommandListDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
            TabularResultData tableResultData = ((CompositeResultData)cmdResult.getResultData()).retrieveSection("GatewayReceiver Section").retrieveTable("GatewayReceiver Table");
            List ports = tableResultData.retrieveAllValues("Port");
            WanCommandListDUnitTest.assertEquals((int)2, (int)ports.size());
            List hosts = tableResultData.retrieveAllValues("Member");
            WanCommandListDUnitTest.assertEquals((int)2, (int)hosts.size());
            WanCommandListDUnitTest.assertEquals(null, (Object)((CompositeResultData)cmdResult.getResultData()).retrieveSection("GatewaySender Section"));
        } else {
            WanCommandListDUnitTest.fail((String)"testListGatewayReceiver failed as did not get CommandResult");
        }
    }

    public void testListGatewaySenderGatewayReceiver() throws GfJsonException {
        Integer lnPort = (Integer)vm1.invoke(WANCommandTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "localhost[" + lnPort + "]");
        this.createDefaultSetup(props);
        Integer nyPort = (Integer)vm2.invoke(WANCommandTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        vm6.invoke(WANCommandTestBase.class, "createAndStartReceiver", new Object[]{nyPort});
        vm3.invoke(WANCommandTestBase.class, "createCache", new Object[]{lnPort});
        vm3.invoke(WANCommandTestBase.class, "createSender", new Object[]{"ln_Serial", 2, false, 100, 400, false, false, null, false});
        vm3.invoke(WANCommandTestBase.class, "createSender", new Object[]{"ln_Parallel", 2, true, 100, 400, false, false, null, false});
        vm4.invoke(WANCommandTestBase.class, "createCache", new Object[]{lnPort});
        vm4.invoke(WANCommandTestBase.class, "createSender", new Object[]{"ln_Parallel", 2, true, 100, 400, false, false, null, false});
        vm4.invoke(WANCommandTestBase.class, "createSender", new Object[]{"ln_Serial", 2, false, 100, 400, false, false, null, false});
        vm5.invoke(WANCommandTestBase.class, "createAndStartReceiver", new Object[]{lnPort});
        vm7.invoke(WANCommandTestBase.class, "createCache", new Object[]{nyPort});
        vm7.invoke(WANCommandTestBase.class, "createSender", new Object[]{"ln_Serial", 1, false, 100, 400, false, false, null, false});
        vm7.invoke(WANCommandTestBase.class, "createSender", new Object[]{"ln_Parallel", 1, true, 100, 400, false, false, null, false});
        WanCommandListDUnitTest.pause(10000);
        String command = "list gateways";
        CommandResult cmdResult = this.executeCommand(command);
        if (cmdResult != null) {
            String strCmdResult = this.commandResultToString(cmdResult);
            Log.getLogWriter().info("testListGatewaySenderGatewayReceiver : " + strCmdResult);
            WanCommandListDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
            TabularResultData tableSenderResultData = ((CompositeResultData)cmdResult.getResultData()).retrieveSection("GatewaySender Section").retrieveTable("GatewaySender Table");
            List senders = tableSenderResultData.retrieveAllValues("GatewaySender Id");
            WanCommandListDUnitTest.assertEquals((int)4, (int)senders.size());
            List hosts = tableSenderResultData.retrieveAllValues("Member");
            WanCommandListDUnitTest.assertEquals((int)4, (int)hosts.size());
            TabularResultData tableReceiverResultData = ((CompositeResultData)cmdResult.getResultData()).retrieveSection("GatewayReceiver Section").retrieveTable("GatewayReceiver Table");
            List ports = tableReceiverResultData.retrieveAllValues("Port");
            WanCommandListDUnitTest.assertEquals((int)1, (int)ports.size());
            hosts = tableReceiverResultData.retrieveAllValues("Member");
            WanCommandListDUnitTest.assertEquals((int)1, (int)hosts.size());
        } else {
            WanCommandListDUnitTest.fail((String)"testListGatewaySenderGatewayReceiver failed as did not get CommandResult");
        }
    }

    public void testListGatewaySenderGatewayReceiver_group() {
        List ports;
        TabularResultData tableReceiverResultData;
        List senders;
        TabularResultData tableSenderResultData;
        String strCmdResult;
        Integer lnPort = (Integer)vm1.invoke(WANCommandTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "localhost[" + lnPort + "]");
        this.createDefaultSetup(props);
        Integer nyPort = (Integer)vm2.invoke(WANCommandTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        vm6.invoke(WANCommandTestBase.class, "createAndStartReceiver", new Object[]{nyPort});
        vm3.invoke(WANCommandTestBase.class, "createCacheWithGroups", new Object[]{lnPort, "Serial_Sender, Paralle_Sender"});
        vm3.invoke(WANCommandTestBase.class, "createSender", new Object[]{"ln_Serial", 2, false, 100, 400, false, false, null, false});
        vm3.invoke(WANCommandTestBase.class, "createSender", new Object[]{"ln_Parallel", 2, true, 100, 400, false, false, null, false});
        vm4.invoke(WANCommandTestBase.class, "createCacheWithGroups", new Object[]{lnPort, "Serial_Sender, Paralle_Sender"});
        vm4.invoke(WANCommandTestBase.class, "createSender", new Object[]{"ln_Parallel", 2, true, 100, 400, false, false, null, false});
        vm4.invoke(WANCommandTestBase.class, "createSender", new Object[]{"ln_Serial", 2, false, 100, 400, false, false, null, false});
        vm5.invoke(WANCommandTestBase.class, "createAndStartReceiverWithGroup", new Object[]{lnPort, "Paralle_Sender,Receiver_Group"});
        vm5.invoke(WANCommandTestBase.class, "createSender", new Object[]{"ln_Parallel", 2, true, 100, 400, false, false, null, false});
        vm7.invoke(WANCommandTestBase.class, "createCache", new Object[]{nyPort});
        vm7.invoke(WANCommandTestBase.class, "createSender", new Object[]{"ln_Serial", 1, false, 100, 400, false, false, null, false});
        vm7.invoke(WANCommandTestBase.class, "createSender", new Object[]{"ln_Parallel", 1, true, 100, 400, false, false, null, false});
        WanCommandListDUnitTest.pause(10000);
        String command = "list gateways --group=Serial_Sender";
        CommandResult cmdResult = this.executeCommand(command);
        if (cmdResult != null) {
            strCmdResult = this.commandResultToString(cmdResult);
            Log.getLogWriter().info("testListGatewaySenderGatewayReceiver_group : " + strCmdResult);
            WanCommandListDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
            tableSenderResultData = ((CompositeResultData)cmdResult.getResultData()).retrieveSection("GatewaySender Section").retrieveTable("GatewaySender Table");
            senders = tableSenderResultData.retrieveAllValues("GatewaySender Id");
            WanCommandListDUnitTest.assertEquals((int)4, (int)senders.size());
            List hosts = tableSenderResultData.retrieveAllValues("Member");
            WanCommandListDUnitTest.assertEquals((int)4, (int)hosts.size());
        } else {
            WanCommandListDUnitTest.fail((String)"testListGatewaySenderGatewayReceiver_group failed as did not get CommandResult");
        }
        command = "list gateways --group=Paralle_Sender";
        cmdResult = this.executeCommand(command);
        if (cmdResult != null) {
            TabularResultData tableSenderResultData2 = ((CompositeResultData)cmdResult.getResultData()).retrieveSection("GatewaySender Section").retrieveTable("GatewaySender Table");
            List senders2 = tableSenderResultData2.retrieveAllValues("GatewaySender Id");
            WanCommandListDUnitTest.assertEquals((int)5, (int)senders2.size());
            TabularResultData tableReceiverResultData2 = ((CompositeResultData)cmdResult.getResultData()).retrieveSection("GatewayReceiver Section").retrieveTable("GatewayReceiver Table");
            List ports2 = tableReceiverResultData2.retrieveAllValues("Port");
            WanCommandListDUnitTest.assertEquals((int)1, (int)ports2.size());
            String strCmdResult2 = this.commandResultToString(cmdResult);
            Log.getLogWriter().info("testListGatewaySenderGatewayReceiver_group : " + strCmdResult2);
            WanCommandListDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
        } else {
            WanCommandListDUnitTest.fail((String)"testListGatewaySenderGatewayReceiver_group failed as did not get CommandResult");
        }
        command = "list gateways --group=Receiver_Group";
        cmdResult = this.executeCommand(command);
        if (cmdResult != null) {
            strCmdResult = this.commandResultToString(cmdResult);
            Log.getLogWriter().info("testListGatewaySenderGatewayReceiver_group : " + strCmdResult);
            WanCommandListDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
            tableSenderResultData = ((CompositeResultData)cmdResult.getResultData()).retrieveSection("GatewaySender Section").retrieveTable("GatewaySender Table");
            senders = tableSenderResultData.retrieveAllValues("GatewaySender Id");
            WanCommandListDUnitTest.assertEquals((int)1, (int)senders.size());
            tableReceiverResultData = ((CompositeResultData)cmdResult.getResultData()).retrieveSection("GatewayReceiver Section").retrieveTable("GatewayReceiver Table");
            ports = tableReceiverResultData.retrieveAllValues("Port");
            WanCommandListDUnitTest.assertEquals((int)1, (int)ports.size());
        } else {
            WanCommandListDUnitTest.fail((String)"testListGatewaySenderGatewayReceiver_group failed as did not get CommandResult");
        }
        command = "list gateways --group=Serial_Sender,Paralle_Sender";
        cmdResult = this.executeCommand(command);
        if (cmdResult != null) {
            strCmdResult = this.commandResultToString(cmdResult);
            Log.getLogWriter().info("testListGatewaySenderGatewayReceiver_group : " + strCmdResult);
            WanCommandListDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
            tableSenderResultData = ((CompositeResultData)cmdResult.getResultData()).retrieveSection("GatewaySender Section").retrieveTable("GatewaySender Table");
            senders = tableSenderResultData.retrieveAllValues("GatewaySender Id");
            WanCommandListDUnitTest.assertEquals((int)5, (int)senders.size());
            tableReceiverResultData = ((CompositeResultData)cmdResult.getResultData()).retrieveSection("GatewayReceiver Section").retrieveTable("GatewayReceiver Table");
            ports = tableReceiverResultData.retrieveAllValues("Port");
            WanCommandListDUnitTest.assertEquals((int)1, (int)ports.size());
        } else {
            WanCommandListDUnitTest.fail((String)"testListGatewaySenderGatewayReceiver_group failed as did not get CommandResult");
        }
        command = "list gateways --group=Serial_Sender,Paralle_Sender,Receiver_Group";
        cmdResult = this.executeCommand(command);
        if (cmdResult != null) {
            strCmdResult = this.commandResultToString(cmdResult);
            Log.getLogWriter().info("testListGatewaySenderGatewayReceiver_group : " + strCmdResult);
            WanCommandListDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
            tableSenderResultData = ((CompositeResultData)cmdResult.getResultData()).retrieveSection("GatewaySender Section").retrieveTable("GatewaySender Table");
            senders = tableSenderResultData.retrieveAllValues("GatewaySender Id");
            WanCommandListDUnitTest.assertEquals((int)5, (int)senders.size());
            tableReceiverResultData = ((CompositeResultData)cmdResult.getResultData()).retrieveSection("GatewayReceiver Section").retrieveTable("GatewayReceiver Table");
            ports = tableReceiverResultData.retrieveAllValues("Port");
            WanCommandListDUnitTest.assertEquals((int)1, (int)ports.size());
        } else {
            WanCommandListDUnitTest.fail((String)"testListGatewaySenderGatewayReceiver_group failed as did not get CommandResult");
        }
    }
}

