/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.wan.wancommand;

import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.internal.cache.wan.wancommand.WANCommandTestBase;
import com.gemstone.gemfire.management.cli.Result;
import com.gemstone.gemfire.management.internal.cli.result.CommandResult;
import com.gemstone.gemfire.management.internal.cli.result.TabularResultData;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import hydra.Log;
import java.util.List;
import java.util.Properties;

public class WanCommandGatewaySenderStopDUnitTest
extends WANCommandTestBase {
    private static final long serialVersionUID = 1L;

    public WanCommandGatewaySenderStopDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
    }

    private CommandResult executeCommandWithIgnoredExceptions(String command) {
        DistributedTestCase.ExpectedException exln = WanCommandGatewaySenderStopDUnitTest.addExpectedException("Could not connect");
        CommandResult commandResult = this.executeCommand(command);
        exln.remove();
        return commandResult;
    }

    public void testStopGatewaySender_ErrorConditions() {
        VM puneLocator = Host.getLocator();
        int punePort = (Integer)puneLocator.invoke(WANCommandTestBase.class, "getLocatorPort");
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "localhost[" + punePort + "]");
        this.createDefaultSetup(props);
        Integer nyPort = (Integer)vm2.invoke(WANCommandTestBase.class, "createFirstRemoteLocator", new Object[]{2, punePort});
        vm3.invoke(WANCommandTestBase.class, "createCache", new Object[]{punePort});
        vm3.invoke(WANCommandTestBase.class, "createSender", new Object[]{"ln", 2, false, 100, 400, false, false, null, true});
        DistributedMember vm1Member = (DistributedMember)vm3.invoke(WANCommandTestBase.class, "getMember");
        String command = "stop gateway-sender --id=ln --member=" + vm1Member.getId() + " --" + "group" + "=SenderGroup1";
        CommandResult cmdResult = this.executeCommandWithIgnoredExceptions(command);
        if (cmdResult != null) {
            String strCmdResult = this.commandResultToString(cmdResult);
            Log.getLogWriter().info("testStopGatewaySender stringResult : " + strCmdResult + ">>>>");
            WanCommandGatewaySenderStopDUnitTest.assertEquals((Object)Result.Status.ERROR, (Object)cmdResult.getStatus());
            WanCommandGatewaySenderStopDUnitTest.assertTrue((boolean)strCmdResult.contains("Please provide either \"member\" or \"group\" option."));
        } else {
            WanCommandGatewaySenderStopDUnitTest.fail((String)"testStopGatewaySender failed as did not get CommandResult");
        }
    }

    public void testStopGatewaySender() {
        VM puneLocator = Host.getLocator();
        int punePort = (Integer)puneLocator.invoke(WANCommandTestBase.class, "getLocatorPort");
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "localhost[" + punePort + "]");
        this.createDefaultSetup(props);
        Integer nyPort = (Integer)vm2.invoke(WANCommandTestBase.class, "createFirstRemoteLocator", new Object[]{2, punePort});
        vm3.invoke(WANCommandTestBase.class, "createCache", new Object[]{punePort});
        vm3.invoke(WANCommandTestBase.class, "createSender", new Object[]{"ln", 2, false, 100, 400, false, false, null, true});
        vm4.invoke(WANCommandTestBase.class, "createCache", new Object[]{punePort});
        vm4.invoke(WANCommandTestBase.class, "createSender", new Object[]{"ln", 2, false, 100, 400, false, false, null, true});
        vm5.invoke(WANCommandTestBase.class, "createCache", new Object[]{punePort});
        vm5.invoke(WANCommandTestBase.class, "createSender", new Object[]{"ln", 2, false, 100, 400, false, false, null, true});
        vm3.invoke(WANCommandTestBase.class, "startSender", new Object[]{"ln"});
        vm4.invoke(WANCommandTestBase.class, "startSender", new Object[]{"ln"});
        vm5.invoke(WANCommandTestBase.class, "startSender", new Object[]{"ln"});
        vm3.invoke(WANCommandTestBase.class, "verifySenderState", new Object[]{"ln", true, false});
        vm4.invoke(WANCommandTestBase.class, "verifySenderState", new Object[]{"ln", true, false});
        vm5.invoke(WANCommandTestBase.class, "verifySenderState", new Object[]{"ln", true, false});
        WanCommandGatewaySenderStopDUnitTest.pause(10000);
        String command = "stop gateway-sender --id=ln";
        CommandResult cmdResult = this.executeCommandWithIgnoredExceptions(command);
        if (cmdResult != null) {
            String strCmdResult = this.commandResultToString(cmdResult);
            Log.getLogWriter().info("testStopGatewaySender stringResult : " + strCmdResult + ">>>>");
            WanCommandGatewaySenderStopDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
            TabularResultData resultData = (TabularResultData)cmdResult.getResultData();
            List status = resultData.retrieveAllValues("Result");
            WanCommandGatewaySenderStopDUnitTest.assertEquals((int)4, (int)status.size());
            WanCommandGatewaySenderStopDUnitTest.assertTrue((boolean)status.contains("Error"));
            WanCommandGatewaySenderStopDUnitTest.assertTrue((boolean)status.contains("OK"));
        } else {
            WanCommandGatewaySenderStopDUnitTest.fail((String)"testStopGatewaySender failed as did not get CommandResult");
        }
        vm3.invoke(WANCommandTestBase.class, "verifySenderState", new Object[]{"ln", false, false});
        vm4.invoke(WANCommandTestBase.class, "verifySenderState", new Object[]{"ln", false, false});
        vm5.invoke(WANCommandTestBase.class, "verifySenderState", new Object[]{"ln", false, false});
    }

    public void testStopGatewaySender_onMember() {
        VM puneLocator = Host.getLocator();
        int punePort = (Integer)puneLocator.invoke(WANCommandTestBase.class, "getLocatorPort");
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "localhost[" + punePort + "]");
        this.createDefaultSetup(props);
        Integer nyPort = (Integer)vm2.invoke(WANCommandTestBase.class, "createFirstRemoteLocator", new Object[]{2, punePort});
        vm3.invoke(WANCommandTestBase.class, "createCache", new Object[]{punePort});
        vm3.invoke(WANCommandTestBase.class, "createSender", new Object[]{"ln", 2, false, 100, 400, false, false, null, true});
        vm3.invoke(WANCommandTestBase.class, "startSender", new Object[]{"ln"});
        vm3.invoke(WANCommandTestBase.class, "verifySenderState", new Object[]{"ln", true, false});
        DistributedMember vm1Member = (DistributedMember)vm3.invoke(WANCommandTestBase.class, "getMember");
        WanCommandGatewaySenderStopDUnitTest.pause(10000);
        String command = "stop gateway-sender --id=ln --member=" + vm1Member.getId();
        CommandResult cmdResult = this.executeCommandWithIgnoredExceptions(command);
        if (cmdResult != null) {
            String strCmdResult = this.commandResultToString(cmdResult);
            Log.getLogWriter().info("testStopGatewaySender stringResult : " + strCmdResult + ">>>>");
            WanCommandGatewaySenderStopDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
            WanCommandGatewaySenderStopDUnitTest.assertTrue((boolean)strCmdResult.contains("is stopped on member"));
        } else {
            WanCommandGatewaySenderStopDUnitTest.fail((String)"testStopGatewaySender failed as did not get CommandResult");
        }
        vm3.invoke(WANCommandTestBase.class, "verifySenderState", new Object[]{"ln", false, false});
    }

    public void testStopGatewaySender_Group() {
        VM puneLocator = Host.getLocator();
        int punePort = (Integer)puneLocator.invoke(WANCommandTestBase.class, "getLocatorPort");
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "localhost[" + punePort + "]");
        this.createDefaultSetup(props);
        Integer nyPort = (Integer)vm2.invoke(WANCommandTestBase.class, "createFirstRemoteLocator", new Object[]{2, punePort});
        vm3.invoke(WANCommandTestBase.class, "createCacheWithGroups", new Object[]{punePort, "SenderGroup1"});
        vm3.invoke(WANCommandTestBase.class, "createSender", new Object[]{"ln", 2, false, 100, 400, false, false, null, true});
        vm4.invoke(WANCommandTestBase.class, "createCacheWithGroups", new Object[]{punePort, "SenderGroup1"});
        vm4.invoke(WANCommandTestBase.class, "createSender", new Object[]{"ln", 2, false, 100, 400, false, false, null, true});
        vm5.invoke(WANCommandTestBase.class, "createCacheWithGroups", new Object[]{punePort, "SenderGroup1"});
        vm5.invoke(WANCommandTestBase.class, "createSender", new Object[]{"ln", 2, false, 100, 400, false, false, null, true});
        vm3.invoke(WANCommandTestBase.class, "startSender", new Object[]{"ln"});
        vm4.invoke(WANCommandTestBase.class, "startSender", new Object[]{"ln"});
        vm5.invoke(WANCommandTestBase.class, "startSender", new Object[]{"ln"});
        vm3.invoke(WANCommandTestBase.class, "verifySenderState", new Object[]{"ln", true, false});
        vm4.invoke(WANCommandTestBase.class, "verifySenderState", new Object[]{"ln", true, false});
        vm5.invoke(WANCommandTestBase.class, "verifySenderState", new Object[]{"ln", true, false});
        WanCommandGatewaySenderStopDUnitTest.pause(10000);
        String command = "stop gateway-sender --id=ln --group=SenderGroup1";
        CommandResult cmdResult = this.executeCommandWithIgnoredExceptions(command);
        if (cmdResult != null) {
            String strCmdResult = this.commandResultToString(cmdResult);
            Log.getLogWriter().info("testStopGatewaySender_Group stringResult : " + strCmdResult + ">>>>");
            WanCommandGatewaySenderStopDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
            TabularResultData resultData = (TabularResultData)cmdResult.getResultData();
            List status = resultData.retrieveAllValues("Result");
            WanCommandGatewaySenderStopDUnitTest.assertEquals((int)3, (int)status.size());
            WanCommandGatewaySenderStopDUnitTest.assertFalse((boolean)status.contains("Error"));
            WanCommandGatewaySenderStopDUnitTest.assertTrue((boolean)status.contains("OK"));
        } else {
            WanCommandGatewaySenderStopDUnitTest.fail((String)"testStopGatewaySender failed as did not get CommandResult");
        }
        vm3.invoke(WANCommandTestBase.class, "verifySenderState", new Object[]{"ln", false, false});
        vm4.invoke(WANCommandTestBase.class, "verifySenderState", new Object[]{"ln", false, false});
        vm5.invoke(WANCommandTestBase.class, "verifySenderState", new Object[]{"ln", false, false});
    }

    public void testStopGatewaySender_MultipleGroup() {
        VM puneLocator = Host.getLocator();
        int punePort = (Integer)puneLocator.invoke(WANCommandTestBase.class, "getLocatorPort");
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "localhost[" + punePort + "]");
        this.createDefaultSetup(props);
        Integer nyPort = (Integer)vm2.invoke(WANCommandTestBase.class, "createFirstRemoteLocator", new Object[]{2, punePort});
        vm3.invoke(WANCommandTestBase.class, "createCacheWithGroups", new Object[]{punePort, "SenderGroup1"});
        vm3.invoke(WANCommandTestBase.class, "createSender", new Object[]{"ln", 2, false, 100, 400, false, false, null, true});
        vm4.invoke(WANCommandTestBase.class, "createCacheWithGroups", new Object[]{punePort, "SenderGroup1"});
        vm4.invoke(WANCommandTestBase.class, "createSender", new Object[]{"ln", 2, false, 100, 400, false, false, null, true});
        vm5.invoke(WANCommandTestBase.class, "createCacheWithGroups", new Object[]{punePort, "SenderGroup1, SenderGroup2"});
        vm5.invoke(WANCommandTestBase.class, "createSender", new Object[]{"ln", 2, false, 100, 400, false, false, null, true});
        vm6.invoke(WANCommandTestBase.class, "createCacheWithGroups", new Object[]{punePort, "SenderGroup2"});
        vm6.invoke(WANCommandTestBase.class, "createSender", new Object[]{"ln", 2, false, 100, 400, false, false, null, true});
        vm7.invoke(WANCommandTestBase.class, "createCacheWithGroups", new Object[]{punePort, "SenderGroup3"});
        vm7.invoke(WANCommandTestBase.class, "createSender", new Object[]{"ln", 2, false, 100, 400, false, false, null, true});
        vm3.invoke(WANCommandTestBase.class, "startSender", new Object[]{"ln"});
        vm4.invoke(WANCommandTestBase.class, "startSender", new Object[]{"ln"});
        vm5.invoke(WANCommandTestBase.class, "startSender", new Object[]{"ln"});
        vm6.invoke(WANCommandTestBase.class, "startSender", new Object[]{"ln"});
        vm7.invoke(WANCommandTestBase.class, "startSender", new Object[]{"ln"});
        vm3.invoke(WANCommandTestBase.class, "verifySenderState", new Object[]{"ln", true, false});
        vm4.invoke(WANCommandTestBase.class, "verifySenderState", new Object[]{"ln", true, false});
        vm5.invoke(WANCommandTestBase.class, "verifySenderState", new Object[]{"ln", true, false});
        vm6.invoke(WANCommandTestBase.class, "verifySenderState", new Object[]{"ln", true, false});
        vm7.invoke(WANCommandTestBase.class, "verifySenderState", new Object[]{"ln", true, false});
        WanCommandGatewaySenderStopDUnitTest.pause(10000);
        String command = "stop gateway-sender --id=ln --group=SenderGroup1,SenderGroup2";
        CommandResult cmdResult = this.executeCommandWithIgnoredExceptions(command);
        if (cmdResult != null) {
            String strCmdResult = this.commandResultToString(cmdResult);
            Log.getLogWriter().info("testStopGatewaySender_Group stringResult : " + strCmdResult + ">>>>");
            WanCommandGatewaySenderStopDUnitTest.assertEquals((Object)Result.Status.OK, (Object)cmdResult.getStatus());
            TabularResultData resultData = (TabularResultData)cmdResult.getResultData();
            List status = resultData.retrieveAllValues("Result");
            WanCommandGatewaySenderStopDUnitTest.assertEquals((int)4, (int)status.size());
            WanCommandGatewaySenderStopDUnitTest.assertFalse((boolean)status.contains("Error"));
            WanCommandGatewaySenderStopDUnitTest.assertTrue((boolean)status.contains("OK"));
        } else {
            WanCommandGatewaySenderStopDUnitTest.fail((String)"testStopGatewaySender failed as did not get CommandResult");
        }
        vm3.invoke(WANCommandTestBase.class, "verifySenderState", new Object[]{"ln", false, false});
        vm4.invoke(WANCommandTestBase.class, "verifySenderState", new Object[]{"ln", false, false});
        vm5.invoke(WANCommandTestBase.class, "verifySenderState", new Object[]{"ln", false, false});
        vm6.invoke(WANCommandTestBase.class, "verifySenderState", new Object[]{"ln", false, false});
        vm7.invoke(WANCommandTestBase.class, "verifySenderState", new Object[]{"ln", true, false});
    }
}

