/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.wan.concurrent;

import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.EntryExistsException;
import com.gemstone.gemfire.cache.client.ServerOperationException;
import com.gemstone.gemfire.cache.util.Gateway;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.internal.cache.wan.BatchException70;
import com.gemstone.gemfire.internal.cache.wan.WANTestBase;
import dunit.AsyncInvocation;

public class ConcurrentWANPropogation_1_DUnitTest
extends WANTestBase {
    private static final long serialVersionUID = 1L;

    public ConcurrentWANPropogation_1_DUnitTest(String name) {
        super(name);
    }

    public void testReplicatedSerialPropagation_withoutRemoteSite() throws Exception {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm6.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm7.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm4.invoke(WANTestBase.class, "createConcurrentSender", new Object[]{"ln", 2, false, 100, 400, false, false, null, true, 4, Gateway.OrderPolicy.KEY});
        vm5.invoke(WANTestBase.class, "createConcurrentSender", new Object[]{"ln", 2, false, 100, 400, false, false, null, true, 4, Gateway.OrderPolicy.KEY});
        vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm4.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
        vm6.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
        vm7.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
        ConcurrentWANPropogation_1_DUnitTest.addExpectedException(BatchException70.class.getName());
        ConcurrentWANPropogation_1_DUnitTest.addExpectedException(ServerOperationException.class.getName());
        vm4.invoke(WANTestBase.class, "doPuts", new Object[]{testName + "_RR", 1000});
        vm2.invoke(WANTestBase.class, "createCache", new Object[]{nyPort});
        vm3.invoke(WANTestBase.class, "createCache", new Object[]{nyPort});
        vm2.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", null, this.isOffHeap()});
        vm3.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", null, this.isOffHeap()});
        vm2.invoke(WANTestBase.class, "createReceiver2", new Object[]{nyPort});
        vm3.invoke(WANTestBase.class, "createReceiver2", new Object[]{nyPort});
        vm4.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_RR", 1000});
        vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_RR", 1000});
        vm3.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_RR", 1000});
    }

    public void testReplicatedSerialPropagation() throws Exception {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        vm2.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm3.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm6.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm7.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm4.invoke(WANTestBase.class, "createConcurrentSender", new Object[]{"ln", 2, false, 100, 10, false, false, null, true, 5, Gateway.OrderPolicy.THREAD});
        vm5.invoke(WANTestBase.class, "createConcurrentSender", new Object[]{"ln", 2, false, 100, 10, false, false, null, true, 5, Gateway.OrderPolicy.THREAD});
        vm2.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", null, this.isOffHeap()});
        vm3.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", null, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm4.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
        vm6.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
        vm7.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "doPuts", new Object[]{testName + "_RR", 1000});
        vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_RR", 1000});
        vm3.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_RR", 1000});
    }

    public void testReplicatedSerialPropagationWithLocalSiteClosedAndRebuilt() throws Exception {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        vm2.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm3.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm6.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm7.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm4.invoke(WANTestBase.class, "createConcurrentSender", new Object[]{"ln", 2, false, 100, 10, false, false, null, true, 5, Gateway.OrderPolicy.THREAD});
        vm5.invoke(WANTestBase.class, "createConcurrentSender", new Object[]{"ln", 2, false, 100, 10, false, false, null, true, 5, Gateway.OrderPolicy.THREAD});
        vm2.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", null, this.isOffHeap()});
        vm3.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", null, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm4.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
        vm6.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
        vm7.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "doPuts", new Object[]{testName + "_RR", 1000});
        vm4.invoke(WANTestBase.class, "killSender", new Object[0]);
        vm5.invoke(WANTestBase.class, "killSender", new Object[0]);
        vm6.invoke(WANTestBase.class, "killSender", new Object[0]);
        vm7.invoke(WANTestBase.class, "killSender", new Object[0]);
        Integer regionSize = (Integer)vm2.invoke(WANTestBase.class, "getRegionSize", new Object[]{testName + "_RR"});
        ConcurrentWANPropogation_1_DUnitTest.getLogWriter().info("Region size on remote is: " + regionSize);
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm6.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm7.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm4.invoke(WANTestBase.class, "createConcurrentSender", new Object[]{"ln", 2, false, 100, 10, false, false, null, true, 5, Gateway.OrderPolicy.THREAD});
        vm5.invoke(WANTestBase.class, "createConcurrentSender", new Object[]{"ln", 2, false, 100, 10, false, false, null, true, 5, Gateway.OrderPolicy.THREAD});
        vm4.invoke(WANTestBase.class, "setRemoveFromQueueOnException", new Object[]{"ln", true});
        vm5.invoke(WANTestBase.class, "setRemoveFromQueueOnException", new Object[]{"ln", true});
        vm4.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
        vm6.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
        vm7.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR", "ln", this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm4.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        ConcurrentWANPropogation_1_DUnitTest.addExpectedException(EntryExistsException.class.getName());
        ConcurrentWANPropogation_1_DUnitTest.addExpectedException(BatchException70.class.getName());
        ConcurrentWANPropogation_1_DUnitTest.addExpectedException(ServerOperationException.class.getName());
        vm4.invoke(WANTestBase.class, "doPuts", new Object[]{testName + "_RR", 1000});
        vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_RR", 1000});
        vm3.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_RR", 1000});
    }

    public void testReplicatedSerialPropagationWithLocalRegionDestroy() throws Exception {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        vm2.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm3.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm6.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm7.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm4.invoke(WANTestBase.class, "createConcurrentSender", new Object[]{"ln", 2, false, 100, 20, false, false, null, true, 3, Gateway.OrderPolicy.THREAD});
        vm5.invoke(WANTestBase.class, "createConcurrentSender", new Object[]{"ln", 2, false, 100, 20, false, false, null, true, 3, Gateway.OrderPolicy.THREAD});
        vm2.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR_1", null, this.isOffHeap()});
        vm3.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR_1", null, this.isOffHeap()});
        vm2.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR_2", null, this.isOffHeap()});
        vm3.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR_2", null, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm4.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR_1", "ln", this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR_1", "ln", this.isOffHeap()});
        vm6.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR_1", "ln", this.isOffHeap()});
        vm7.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR_1", "ln", this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR_2", "ln", this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR_2", "ln", this.isOffHeap()});
        vm6.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR_2", "ln", this.isOffHeap()});
        vm7.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR_2", "ln", this.isOffHeap()});
        AsyncInvocation inv1 = vm4.invokeAsync(WANTestBase.class, "doPuts", new Object[]{testName + "_RR_1", 1000});
        vm4.invoke(WANTestBase.class, "doPuts", new Object[]{testName + "_RR_2", 500});
        vm4.invoke(WANTestBase.class, "destroyRegion", new Object[]{testName + "_RR_2"});
        try {
            inv1.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            ConcurrentWANPropogation_1_DUnitTest.fail();
        }
        Thread.sleep(20L);
        vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_RR_1", 1000});
        vm3.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_RR_2", 500});
    }

    public void testReplicatedSerialPropagationWithRemoteRegionDestroy() throws Exception {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        vm2.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm3.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm6.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm7.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm4.invoke(WANTestBase.class, "createConcurrentSender", new Object[]{"ln", 2, false, 100, 500, false, false, null, true, 5, Gateway.OrderPolicy.KEY});
        vm5.invoke(WANTestBase.class, "createConcurrentSender", new Object[]{"ln", 2, false, 100, 500, false, false, null, true, 5, Gateway.OrderPolicy.KEY});
        vm2.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR_1", null, this.isOffHeap()});
        vm3.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR_1", null, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm4.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR_1", "ln", this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR_1", "ln", this.isOffHeap()});
        vm6.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR_1", "ln", this.isOffHeap()});
        vm7.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR_1", "ln", this.isOffHeap()});
        ConcurrentWANPropogation_1_DUnitTest.addExpectedException(BatchException70.class.getName());
        ConcurrentWANPropogation_1_DUnitTest.addExpectedException(ServerOperationException.class.getName());
        AsyncInvocation inv1 = vm4.invokeAsync(WANTestBase.class, "doPuts", new Object[]{testName + "_RR_1", 10000});
        vm2.invoke(WANTestBase.class, "destroyRegion", new Object[]{testName + "_RR_1"});
        try {
            inv1.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            ConcurrentWANPropogation_1_DUnitTest.fail();
        }
        vm4.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_RR_1", 10000});
        vm4.invoke(WANTestBase.class, "verifyRegionQueueNotEmptyForConcurrentSender", new Object[]{"ln"});
    }

    public void testReplicatedSerialPropagationWithRemoteRegionDestroy2() throws Exception {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        vm2.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm3.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm6.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm7.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm4.invoke(WANTestBase.class, "createConcurrentSender", new Object[]{"ln", 2, false, 100, 200, false, false, null, true, 5, Gateway.OrderPolicy.THREAD});
        vm5.invoke(WANTestBase.class, "createConcurrentSender", new Object[]{"ln", 2, false, 100, 200, false, false, null, true, 5, Gateway.OrderPolicy.THREAD});
        vm2.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR_1", null, this.isOffHeap()});
        vm3.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR_1", null, this.isOffHeap()});
        vm2.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR_2", null, this.isOffHeap()});
        vm3.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR_2", null, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm4.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR_1", "ln", this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR_1", "ln", this.isOffHeap()});
        vm6.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR_1", "ln", this.isOffHeap()});
        vm7.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR_1", "ln", this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR_2", "ln", this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR_2", "ln", this.isOffHeap()});
        vm6.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR_2", "ln", this.isOffHeap()});
        vm7.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR_2", "ln", this.isOffHeap()});
        vm2.invoke(WANTestBase.class, "destroyRegion", new Object[]{testName + "_RR_2"});
        ConcurrentWANPropogation_1_DUnitTest.addExpectedException(BatchException70.class.getName());
        ConcurrentWANPropogation_1_DUnitTest.addExpectedException(ServerOperationException.class.getName());
        vm4.invoke(WANTestBase.class, "doPuts", new Object[]{testName + "_RR_2", 1000});
        AsyncInvocation inv1 = vm4.invokeAsync(WANTestBase.class, "doPuts", new Object[]{testName + "_RR_1", 1000});
        try {
            inv1.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            ConcurrentWANPropogation_1_DUnitTest.fail();
        }
        vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_RR_1", 1000});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReplicatedSerialPropagationWithRemoteRegionDestroy3() throws Exception {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        vm2.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm3.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm6.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm7.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm4.invoke(WANTestBase.class, "createConcurrentSender", new Object[]{"ln", 2, false, 100, 200, false, false, null, true, 5, Gateway.OrderPolicy.THREAD});
        vm5.invoke(WANTestBase.class, "createConcurrentSender", new Object[]{"ln", 2, false, 100, 200, false, false, null, true, 5, Gateway.OrderPolicy.THREAD});
        vm2.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR_1", null, this.isOffHeap()});
        vm3.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR_1", null, this.isOffHeap()});
        vm2.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR_2", null, this.isOffHeap()});
        vm3.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR_2", null, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "setRemoveFromQueueOnException", new Object[]{"ln", true});
        vm5.invoke(WANTestBase.class, "setRemoveFromQueueOnException", new Object[]{"ln", true});
        vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm4.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR_1", "ln", this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR_1", "ln", this.isOffHeap()});
        vm6.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR_1", "ln", this.isOffHeap()});
        vm7.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR_1", "ln", this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR_2", "ln", this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR_2", "ln", this.isOffHeap()});
        vm6.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR_2", "ln", this.isOffHeap()});
        vm7.invoke(WANTestBase.class, "createReplicatedRegion", new Object[]{testName + "_RR_2", "ln", this.isOffHeap()});
        ConcurrentWANPropogation_1_DUnitTest.addExpectedException(BatchException70.class.getName());
        ConcurrentWANPropogation_1_DUnitTest.addExpectedException(ServerOperationException.class.getName());
        AsyncInvocation inv1 = vm4.invokeAsync(WANTestBase.class, "doPuts", new Object[]{testName + "_RR_1", 1000});
        AsyncInvocation inv2 = vm4.invokeAsync(WANTestBase.class, "doPuts", new Object[]{testName + "_RR_2", 1000});
        vm2.invoke(WANTestBase.class, "destroyRegion", new Object[]{testName + "_RR_2"});
        try {
            inv1.join();
            inv2.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            ConcurrentWANPropogation_1_DUnitTest.fail();
        }
        try {
            vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_RR_1", 1000});
        }
        catch (Throwable throwable) {
            System.setProperty("gemfire.GatewaySender.REMOVE_FROM_QUEUE_ON_EXCEPTION", "False");
            vm4.invoke(new CacheSerializableRunnable("UnSetting system property "){

                @Override
                public void run2() throws CacheException {
                    System.setProperty("gemfire.GatewaySender.REMOVE_FROM_QUEUE_ON_EXCEPTION", "False");
                }
            });
            vm5.invoke(new CacheSerializableRunnable("UnSetting system property "){

                @Override
                public void run2() throws CacheException {
                    System.setProperty("gemfire.GatewaySender.REMOVE_FROM_QUEUE_ON_EXCEPTION", "False");
                }
            });
            throw throwable;
        }
        System.setProperty("gemfire.GatewaySender.REMOVE_FROM_QUEUE_ON_EXCEPTION", "False");
        vm4.invoke(new /* invalid duplicate definition of identical inner class */);
        vm5.invoke(new /* invalid duplicate definition of identical inner class */);
    }
}

