/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.wan.concurrent;

import com.gemstone.gemfire.cache.EntryExistsException;
import com.gemstone.gemfire.cache.client.ServerOperationException;
import com.gemstone.gemfire.cache.util.Gateway;
import com.gemstone.gemfire.cache.wan.GatewaySender;
import com.gemstone.gemfire.internal.cache.wan.BatchException70;
import com.gemstone.gemfire.internal.cache.wan.WANTestBase;
import com.gemstone.gemfire.internal.cache.wan.parallel.ConcurrentParallelGatewaySenderEventProcessor;
import com.gemstone.gemfire.internal.cache.wan.parallel.ParallelGatewaySenderImpl;
import dunit.AsyncInvocation;
import java.util.Set;

public class ConcurrentParallelGatewaySenderDUnitTest
extends WANTestBase {
    public ConcurrentParallelGatewaySenderDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testParallelPropagationConcurrentArtifacts() throws Exception {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        vm2.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm3.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm6.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm7.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm4.invoke(WANTestBase.class, "createConcurrentSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true, 5, Gateway.OrderPolicy.PARTITION});
        vm5.invoke(WANTestBase.class, "createConcurrentSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true, 5, Gateway.OrderPolicy.PARTITION});
        vm6.invoke(WANTestBase.class, "createConcurrentSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true, 5, Gateway.OrderPolicy.PARTITION});
        vm7.invoke(WANTestBase.class, "createConcurrentSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true, 5, Gateway.OrderPolicy.PARTITION});
        vm4.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 100, this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 100, this.isOffHeap()});
        vm6.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 100, this.isOffHeap()});
        vm7.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 100, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm2.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", null, 1, 100, this.isOffHeap()});
        vm3.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", null, 1, 100, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        try {
            vm4.invoke(ConcurrentParallelGatewaySenderDUnitTest.class, "setTestHook", new Object[]{"ln", Boolean.TRUE});
            vm5.invoke(ConcurrentParallelGatewaySenderDUnitTest.class, "setTestHook", new Object[]{"ln", Boolean.TRUE});
            vm6.invoke(ConcurrentParallelGatewaySenderDUnitTest.class, "setTestHook", new Object[]{"ln", Boolean.TRUE});
            vm7.invoke(ConcurrentParallelGatewaySenderDUnitTest.class, "setTestHook", new Object[]{"ln", Boolean.TRUE});
            vm4.invoke(WANTestBase.class, "doPuts", new Object[]{testName + "_PR", 1000});
            vm4.invoke(WANTestBase.class, "validateParallelSenderQueueAllBucketsDrained", new Object[]{"ln"});
            vm5.invoke(WANTestBase.class, "validateParallelSenderQueueAllBucketsDrained", new Object[]{"ln"});
            vm6.invoke(WANTestBase.class, "validateParallelSenderQueueAllBucketsDrained", new Object[]{"ln"});
            vm7.invoke(WANTestBase.class, "validateParallelSenderQueueAllBucketsDrained", new Object[]{"ln"});
            vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 1000});
            int dispatched1 = (Integer)vm4.invoke(WANTestBase.class, "verifyAndGetEventsDispatchedByConcurrentDispatchers", new Object[]{"ln"});
            int dispatched2 = (Integer)vm5.invoke(WANTestBase.class, "verifyAndGetEventsDispatchedByConcurrentDispatchers", new Object[]{"ln"});
            int dispatched3 = (Integer)vm6.invoke(WANTestBase.class, "verifyAndGetEventsDispatchedByConcurrentDispatchers", new Object[]{"ln"});
            int dispatched4 = (Integer)vm7.invoke(WANTestBase.class, "verifyAndGetEventsDispatchedByConcurrentDispatchers", new Object[]{"ln"});
            ConcurrentParallelGatewaySenderDUnitTest.assertEquals((int)1000, (int)(dispatched1 + dispatched2 + dispatched3 + dispatched4));
        }
        catch (Throwable throwable) {
            vm4.invoke(ConcurrentParallelGatewaySenderDUnitTest.class, "setTestHook", new Object[]{"ln", Boolean.FALSE});
            vm5.invoke(ConcurrentParallelGatewaySenderDUnitTest.class, "setTestHook", new Object[]{"ln", Boolean.FALSE});
            vm6.invoke(ConcurrentParallelGatewaySenderDUnitTest.class, "setTestHook", new Object[]{"ln", Boolean.FALSE});
            vm7.invoke(ConcurrentParallelGatewaySenderDUnitTest.class, "setTestHook", new Object[]{"ln", Boolean.FALSE});
            throw throwable;
        }
        vm4.invoke(ConcurrentParallelGatewaySenderDUnitTest.class, "setTestHook", new Object[]{"ln", Boolean.FALSE});
        vm5.invoke(ConcurrentParallelGatewaySenderDUnitTest.class, "setTestHook", new Object[]{"ln", Boolean.FALSE});
        vm6.invoke(ConcurrentParallelGatewaySenderDUnitTest.class, "setTestHook", new Object[]{"ln", Boolean.FALSE});
        vm7.invoke(ConcurrentParallelGatewaySenderDUnitTest.class, "setTestHook", new Object[]{"ln", Boolean.FALSE});
    }

    public void testParallelPropagation() throws Exception {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        vm2.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm3.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm6.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm7.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm4.invoke(WANTestBase.class, "createConcurrentSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true, 5, Gateway.OrderPolicy.PARTITION});
        vm5.invoke(WANTestBase.class, "createConcurrentSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true, 5, Gateway.OrderPolicy.PARTITION});
        vm6.invoke(WANTestBase.class, "createConcurrentSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true, 5, Gateway.OrderPolicy.PARTITION});
        vm7.invoke(WANTestBase.class, "createConcurrentSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true, 5, Gateway.OrderPolicy.PARTITION});
        vm4.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 100, this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 100, this.isOffHeap()});
        vm6.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 100, this.isOffHeap()});
        vm7.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 100, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm2.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", null, 1, 100, this.isOffHeap()});
        vm3.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", null, 1, 100, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm4.invoke(WANTestBase.class, "doPuts", new Object[]{testName + "_PR", 1000});
        vm4.invoke(WANTestBase.class, "validateParallelSenderQueueAllBucketsDrained", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "validateParallelSenderQueueAllBucketsDrained", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "validateParallelSenderQueueAllBucketsDrained", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "validateParallelSenderQueueAllBucketsDrained", new Object[]{"ln"});
        vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 1000});
    }

    public void testParallelPropagationWithUnEqualBucketDivison() throws Exception {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        vm2.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm3.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm6.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm7.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm4.invoke(WANTestBase.class, "createConcurrentSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true, 7, Gateway.OrderPolicy.PARTITION});
        vm5.invoke(WANTestBase.class, "createConcurrentSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true, 7, Gateway.OrderPolicy.PARTITION});
        vm6.invoke(WANTestBase.class, "createConcurrentSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true, 7, Gateway.OrderPolicy.PARTITION});
        vm7.invoke(WANTestBase.class, "createConcurrentSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true, 7, Gateway.OrderPolicy.PARTITION});
        vm4.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 100, this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 100, this.isOffHeap()});
        vm6.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 100, this.isOffHeap()});
        vm7.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 100, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm2.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", null, 1, 100, this.isOffHeap()});
        vm3.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", null, 1, 100, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm4.invoke(WANTestBase.class, "doPuts", new Object[]{testName + "_PR", 1000});
        vm4.invoke(WANTestBase.class, "validateParallelSenderQueueAllBucketsDrained", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "validateParallelSenderQueueAllBucketsDrained", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "validateParallelSenderQueueAllBucketsDrained", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "validateParallelSenderQueueAllBucketsDrained", new Object[]{"ln"});
        vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 1000});
    }

    public void testParallelPropagation_withoutRemoteSite() throws Exception {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm6.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm7.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm4.invoke(WANTestBase.class, "createConcurrentSender", new Object[]{"ln", 2, true, 100, 300, false, false, null, true, 6, Gateway.OrderPolicy.PARTITION});
        vm5.invoke(WANTestBase.class, "createConcurrentSender", new Object[]{"ln", 2, true, 100, 300, false, false, null, true, 6, Gateway.OrderPolicy.PARTITION});
        vm6.invoke(WANTestBase.class, "createConcurrentSender", new Object[]{"ln", 2, true, 100, 300, false, false, null, true, 6, Gateway.OrderPolicy.PARTITION});
        vm7.invoke(WANTestBase.class, "createConcurrentSender", new Object[]{"ln", 2, true, 100, 300, false, false, null, true, 6, Gateway.OrderPolicy.PARTITION});
        vm4.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 100, this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 100, this.isOffHeap()});
        vm6.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 100, this.isOffHeap()});
        vm7.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 100, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm4.invoke(WANTestBase.class, "setRemoveFromQueueOnException", new Object[]{"ln", false});
        vm5.invoke(WANTestBase.class, "setRemoveFromQueueOnException", new Object[]{"ln", false});
        vm6.invoke(WANTestBase.class, "setRemoveFromQueueOnException", new Object[]{"ln", false});
        vm7.invoke(WANTestBase.class, "setRemoveFromQueueOnException", new Object[]{"ln", false});
        vm4.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm4.invoke(WANTestBase.class, "doPuts", new Object[]{testName + "_PR", 1000});
        vm2.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm3.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm2.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", null, 1, 100, this.isOffHeap()});
        vm3.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", null, 1, 100, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "validateParallelSenderQueueAllBucketsDrained", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "validateParallelSenderQueueAllBucketsDrained", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "validateParallelSenderQueueAllBucketsDrained", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "validateParallelSenderQueueAllBucketsDrained", new Object[]{"ln"});
        vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 1000});
    }

    public void testParallelPropogationColocatedPartitionedRegions() {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        vm2.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm3.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm6.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm7.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm4.invoke(WANTestBase.class, "createConcurrentSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true, 5, Gateway.OrderPolicy.PARTITION});
        vm5.invoke(WANTestBase.class, "createConcurrentSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true, 5, Gateway.OrderPolicy.PARTITION});
        vm6.invoke(WANTestBase.class, "createConcurrentSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true, 5, Gateway.OrderPolicy.PARTITION});
        vm7.invoke(WANTestBase.class, "createConcurrentSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true, 5, Gateway.OrderPolicy.PARTITION});
        vm4.invoke(WANTestBase.class, "createCustomerOrderShipmentPartitionedRegion", new Object[]{null, "ln", 1, 100, this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createCustomerOrderShipmentPartitionedRegion", new Object[]{null, "ln", 1, 100, this.isOffHeap()});
        vm6.invoke(WANTestBase.class, "createCustomerOrderShipmentPartitionedRegion", new Object[]{null, "ln", 1, 100, this.isOffHeap()});
        vm7.invoke(WANTestBase.class, "createCustomerOrderShipmentPartitionedRegion", new Object[]{null, "ln", 1, 100, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm2.invoke(WANTestBase.class, "createCustomerOrderShipmentPartitionedRegion", new Object[]{null, "ln", 1, 100, this.isOffHeap()});
        vm3.invoke(WANTestBase.class, "createCustomerOrderShipmentPartitionedRegion", new Object[]{null, "ln", 1, 100, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm4.invoke(WANTestBase.class, "putcolocatedPartitionedRegion", new Object[]{1000});
        vm4.invoke(WANTestBase.class, "validateParallelSenderQueueAllBucketsDrained", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "validateParallelSenderQueueAllBucketsDrained", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "validateParallelSenderQueueAllBucketsDrained", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "validateParallelSenderQueueAllBucketsDrained", new Object[]{"ln"});
        vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{"CUSTOMER", 1000});
        vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{"ORDER", 1000});
        vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{"SHIPMENT", 1000});
    }

    public void testParallelPropagationWithLocalCacheClosedAndRebuilt() throws Exception {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        vm2.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm3.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm6.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm7.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm4.invoke(WANTestBase.class, "createConcurrentSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true, 6, Gateway.OrderPolicy.PARTITION});
        vm5.invoke(WANTestBase.class, "createConcurrentSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true, 6, Gateway.OrderPolicy.PARTITION});
        vm6.invoke(WANTestBase.class, "createConcurrentSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true, 6, Gateway.OrderPolicy.PARTITION});
        vm7.invoke(WANTestBase.class, "createConcurrentSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true, 6, Gateway.OrderPolicy.PARTITION});
        vm4.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 100, this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 100, this.isOffHeap()});
        vm6.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 100, this.isOffHeap()});
        vm7.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 100, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm2.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", null, 1, 100, this.isOffHeap()});
        vm3.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", null, 1, 100, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm4.invoke(WANTestBase.class, "doPuts", new Object[]{testName + "_PR", 1000});
        vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 1000});
        vm4.invoke(WANTestBase.class, "killSender", new Object[0]);
        vm5.invoke(WANTestBase.class, "killSender", new Object[0]);
        vm6.invoke(WANTestBase.class, "killSender", new Object[0]);
        vm7.invoke(WANTestBase.class, "killSender", new Object[0]);
        Integer regionSize = (Integer)vm2.invoke(WANTestBase.class, "getRegionSize", new Object[]{testName + "_PR"});
        ConcurrentParallelGatewaySenderDUnitTest.getLogWriter().info("Region size on remote is: " + regionSize);
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm6.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm7.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm4.invoke(WANTestBase.class, "createConcurrentSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true, 6, Gateway.OrderPolicy.PARTITION});
        vm5.invoke(WANTestBase.class, "createConcurrentSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true, 6, Gateway.OrderPolicy.PARTITION});
        vm6.invoke(WANTestBase.class, "createConcurrentSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true, 6, Gateway.OrderPolicy.PARTITION});
        vm7.invoke(WANTestBase.class, "createConcurrentSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true, 6, Gateway.OrderPolicy.PARTITION});
        vm4.invoke(WANTestBase.class, "setRemoveFromQueueOnException", new Object[]{"ln", true});
        vm5.invoke(WANTestBase.class, "setRemoveFromQueueOnException", new Object[]{"ln", true});
        vm6.invoke(WANTestBase.class, "setRemoveFromQueueOnException", new Object[]{"ln", true});
        vm7.invoke(WANTestBase.class, "setRemoveFromQueueOnException", new Object[]{"ln", true});
        vm4.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 100, this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 100, this.isOffHeap()});
        vm6.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 100, this.isOffHeap()});
        vm7.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 1, 100, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm4.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "waitForSenderRunningState", new Object[]{"ln"});
        ConcurrentParallelGatewaySenderDUnitTest.addExpectedException(EntryExistsException.class.getName());
        ConcurrentParallelGatewaySenderDUnitTest.addExpectedException(BatchException70.class.getName());
        ConcurrentParallelGatewaySenderDUnitTest.addExpectedException(ServerOperationException.class.getName());
        vm4.invoke(WANTestBase.class, "doPuts", new Object[]{testName + "_PR", 10000});
        vm4.invoke(WANTestBase.class, "validateParallelSenderQueueAllBucketsDrained", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "validateParallelSenderQueueAllBucketsDrained", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "validateParallelSenderQueueAllBucketsDrained", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "validateParallelSenderQueueAllBucketsDrained", new Object[]{"ln"});
        vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 10000});
        vm3.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 10000});
    }

    public void testParallelColocatedPropagation() throws Exception {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        vm2.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm3.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm6.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm7.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm4.invoke(WANTestBase.class, "createConcurrentSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true, 7, Gateway.OrderPolicy.KEY});
        vm5.invoke(WANTestBase.class, "createConcurrentSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true, 7, Gateway.OrderPolicy.KEY});
        vm6.invoke(WANTestBase.class, "createConcurrentSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true, 7, Gateway.OrderPolicy.KEY});
        vm7.invoke(WANTestBase.class, "createConcurrentSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true, 7, Gateway.OrderPolicy.KEY});
        vm4.invoke(WANTestBase.class, "createColocatedPartitionedRegions", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createColocatedPartitionedRegions", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        vm6.invoke(WANTestBase.class, "createColocatedPartitionedRegions", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        vm7.invoke(WANTestBase.class, "createColocatedPartitionedRegions", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm2.invoke(WANTestBase.class, "createColocatedPartitionedRegions", new Object[]{testName, null, 1, 100, this.isOffHeap()});
        vm3.invoke(WANTestBase.class, "createColocatedPartitionedRegions", new Object[]{testName, null, 1, 100, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "doPuts", new Object[]{testName, 1000});
        vm4.invoke(WANTestBase.class, "validateParallelSenderQueueAllBucketsDrained", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "validateParallelSenderQueueAllBucketsDrained", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "validateParallelSenderQueueAllBucketsDrained", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "validateParallelSenderQueueAllBucketsDrained", new Object[]{"ln"});
        vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName, 1000});
    }

    public void testParallelColocatedPropagationOrderPolicyPartition() throws Exception {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        vm2.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm3.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm6.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm7.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm4.invoke(WANTestBase.class, "createConcurrentSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true, 7, Gateway.OrderPolicy.PARTITION});
        vm5.invoke(WANTestBase.class, "createConcurrentSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true, 7, Gateway.OrderPolicy.PARTITION});
        vm6.invoke(WANTestBase.class, "createConcurrentSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true, 7, Gateway.OrderPolicy.PARTITION});
        vm7.invoke(WANTestBase.class, "createConcurrentSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true, 7, Gateway.OrderPolicy.PARTITION});
        vm4.invoke(WANTestBase.class, "createColocatedPartitionedRegions", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createColocatedPartitionedRegions", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        vm6.invoke(WANTestBase.class, "createColocatedPartitionedRegions", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        vm7.invoke(WANTestBase.class, "createColocatedPartitionedRegions", new Object[]{testName, "ln", 1, 100, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm2.invoke(WANTestBase.class, "createColocatedPartitionedRegions", new Object[]{testName, null, 1, 100, this.isOffHeap()});
        vm3.invoke(WANTestBase.class, "createColocatedPartitionedRegions", new Object[]{testName, null, 1, 100, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "doPuts", new Object[]{testName, 1000});
        vm4.invoke(WANTestBase.class, "validateParallelSenderQueueAllBucketsDrained", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "validateParallelSenderQueueAllBucketsDrained", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "validateParallelSenderQueueAllBucketsDrained", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "validateParallelSenderQueueAllBucketsDrained", new Object[]{"ln"});
        vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName, 1000});
    }

    public void testPartitionedParallelPropagationHA() throws Exception {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        vm2.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm3.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm5.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm6.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm7.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm4.invoke(WANTestBase.class, "createConcurrentSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true, 6, Gateway.OrderPolicy.KEY});
        vm5.invoke(WANTestBase.class, "createConcurrentSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true, 6, Gateway.OrderPolicy.KEY});
        vm6.invoke(WANTestBase.class, "createConcurrentSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true, 6, Gateway.OrderPolicy.KEY});
        vm7.invoke(WANTestBase.class, "createConcurrentSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true, 6, Gateway.OrderPolicy.KEY});
        vm4.invoke(WANTestBase.class, "setRemoveFromQueueOnException", new Object[]{"ln", true});
        vm5.invoke(WANTestBase.class, "setRemoveFromQueueOnException", new Object[]{"ln", true});
        vm6.invoke(WANTestBase.class, "setRemoveFromQueueOnException", new Object[]{"ln", true});
        vm7.invoke(WANTestBase.class, "setRemoveFromQueueOnException", new Object[]{"ln", true});
        vm4.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 2, 100, this.isOffHeap()});
        vm5.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 2, 100, this.isOffHeap()});
        vm6.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 2, 100, this.isOffHeap()});
        vm7.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 2, 100, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm5.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm6.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm2.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", null, 1, 100, this.isOffHeap()});
        vm3.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", null, 1, 100, this.isOffHeap()});
        AsyncInvocation inv1 = vm7.invokeAsync(WANTestBase.class, "doPuts", new Object[]{testName + "_PR", 5000});
        ConcurrentParallelGatewaySenderDUnitTest.pause(500);
        AsyncInvocation inv2 = vm4.invokeAsync(WANTestBase.class, "killSender");
        AsyncInvocation inv3 = vm6.invokeAsync(WANTestBase.class, "doPuts", new Object[]{testName + "_PR", 10000});
        ConcurrentParallelGatewaySenderDUnitTest.pause(1500);
        AsyncInvocation inv4 = vm5.invokeAsync(WANTestBase.class, "killSender");
        inv1.join();
        inv2.join();
        inv3.join();
        inv4.join();
        vm6.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 10000});
        vm7.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 10000});
        vm6.invoke(WANTestBase.class, "validateParallelSenderQueueAllBucketsDrained", new Object[]{"ln"});
        vm7.invoke(WANTestBase.class, "validateParallelSenderQueueAllBucketsDrained", new Object[]{"ln"});
        vm2.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 10000});
        vm3.invoke(WANTestBase.class, "validateRegionSize", new Object[]{testName + "_PR", 10000});
    }

    public void testWANPDX_PR_MultipleVM_ConcurrentParallelSender() {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        vm2.invoke(WANTestBase.class, "createReceiver", new Object[]{nyPort});
        vm3.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm4.invoke(WANTestBase.class, "createCache", new Object[]{lnPort});
        vm3.invoke(WANTestBase.class, "createConcurrentSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true, 5, Gateway.OrderPolicy.KEY});
        vm4.invoke(WANTestBase.class, "createConcurrentSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true, 5, Gateway.OrderPolicy.KEY});
        vm2.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", null, 0, 2, this.isOffHeap()});
        vm3.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 0, 2, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 0, 2, this.isOffHeap()});
        vm3.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm4.invoke(WANTestBase.class, "startSender", new Object[]{"ln"});
        vm3.invoke(WANTestBase.class, "doPutsPDXSerializable", new Object[]{testName + "_PR", 10});
        vm2.invoke(WANTestBase.class, "validateRegionSize_PDX", new Object[]{testName + "_PR", 10});
    }

    public void testWANPDX_PR_MultipleVM_ConcurrentParallelSender_StartedLater() {
        Integer lnPort = (Integer)vm0.invoke(WANTestBase.class, "createFirstLocatorWithDSId", new Object[]{1});
        Integer nyPort = (Integer)vm1.invoke(WANTestBase.class, "createFirstRemoteLocator", new Object[]{2, lnPort});
        vm2.invoke(WANTestBase.class, "createReceiver_PDX", new Object[]{nyPort});
        vm3.invoke(WANTestBase.class, "createCache_PDX", new Object[]{lnPort});
        vm4.invoke(WANTestBase.class, "createCache_PDX", new Object[]{lnPort});
        vm3.invoke(WANTestBase.class, "createConcurrentSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true, 5, Gateway.OrderPolicy.KEY});
        vm4.invoke(WANTestBase.class, "createConcurrentSender", new Object[]{"ln", 2, true, 100, 10, false, false, null, true, 5, Gateway.OrderPolicy.KEY});
        vm2.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", null, 0, 2, this.isOffHeap()});
        vm3.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 0, 2, this.isOffHeap()});
        vm4.invoke(WANTestBase.class, "createPartitionedRegion", new Object[]{testName + "_PR", "ln", 0, 2, this.isOffHeap()});
        vm3.invoke(WANTestBase.class, "doPutsPDXSerializable", new Object[]{testName + "_PR", 10});
        AsyncInvocation inv1 = vm3.invokeAsync(WANTestBase.class, "startSender", new Object[]{"ln"});
        AsyncInvocation inv2 = vm4.invokeAsync(WANTestBase.class, "startSender", new Object[]{"ln"});
        try {
            inv1.join();
            inv2.join();
        }
        catch (InterruptedException ie) {
            ConcurrentParallelGatewaySenderDUnitTest.fail((String)"Caught interrupted exception");
        }
        vm4.invoke(WANTestBase.class, "doPutsPDXSerializable", new Object[]{testName + "_PR", 40});
        vm2.invoke(WANTestBase.class, "validateRegionSize_PDX", new Object[]{testName + "_PR", 40});
    }

    public static void setTestHook(String senderId, boolean hook) {
        ConcurrentParallelGatewaySenderEventProcessor cProc;
        Set senders = cache.getGatewaySenders();
        GatewaySender sender = null;
        for (GatewaySender s : senders) {
            if (!s.getId().equals(senderId)) continue;
            sender = s;
            break;
        }
        if ((cProc = (ConcurrentParallelGatewaySenderEventProcessor)((ParallelGatewaySenderImpl)sender).getEventProcessor()) == null) {
            return;
        }
        ConcurrentParallelGatewaySenderEventProcessor.TEST_HOOK = hook;
    }
}

