/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.util.Gateway;
import com.gemstone.gemfire.cache.util.GatewayHub;
import com.gemstone.gemfire.cache.util.GatewayQueueAttributes;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.AvailablePort;
import dunit.VM;
import java.io.Serializable;
import java.util.Properties;

public class WanQueueSizeDUnitTest
extends CacheTestCase {
    public static String CLASS_NAME = "WanQueueSizeDUnitTest ";
    VM vm0 = null;
    VM vm1 = null;
    public static final int SERVER_PORT = 22224;
    public static final int CLIENT_PORT = 22225;
    public static final int SOCKET_BUFF_SIZE = 256000;
    public static final String REGION_NAME = "WanQueueSizeDUnitTest";
    public static volatile Cache cache = null;
    public static final int MAX_PUT = 5;
    static final int CACHE_SIZE = 102400;

    public WanQueueSizeDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() {
        WanQueueSizeDUnitTest.disconnectAllFromDS();
        WanQueueSizeDUnitTest.pause(5000);
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
        WanQueueSizeDUnitTest.invokeInEveryVM(WanQueueSizeDUnitTest.class, "closeStaticCache");
        this.vm0 = null;
        this.vm1 = null;
    }

    public void testThisDUnitIsBroken() throws Exception {
    }

    public void _testWanQueueSize() throws Exception {
        this.vm0.invoke(WanQueueSizeDUnitTest.class, "createWanServer", new Object[]{WanQueueSizeDUnitTest.getServerHostName(this.vm0.getHost())});
        this.vm0.invoke(WanQueueSizeDUnitTest.class, "doPutAtServer");
        this.vm1.invoke(WanQueueSizeDUnitTest.class, "createWanClient");
        try {
            Thread.sleep(30000L);
        }
        catch (InterruptedException e) {
            WanQueueSizeDUnitTest.fail("interrupted sleeping", e);
        }
        this.vm1.invoke(WanQueueSizeDUnitTest.class, "getAtClient");
    }

    public static void createWanServer(String host) throws Exception {
        WanQueueSizeDUnitTest test = new WanQueueSizeDUnitTest("name");
        Properties props = new Properties();
        int port = AvailablePort.getRandomAvailablePort((int)1);
        props.setProperty("mcast-port", Integer.toString(port));
        cache = test.createCache(props);
        GatewayHub severHub = cache.setGatewayHub("SERVER_HUB", 22224);
        Gateway serverGateway = severHub.addGateway("SERVER_GATEWAY");
        serverGateway.addEndpoint("SERVER_GATEWAY", host, 22225);
        serverGateway.setSocketBufferSize(256000);
        GatewayQueueAttributes queueAttributes = serverGateway.getQueueAttributes();
        queueAttributes.setMaximumQueueMemory(1);
        queueAttributes.setBatchSize(1);
        severHub.start();
        serverGateway.start();
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setEnableWAN(true);
        RegionAttributes attrs = factory.create();
        cache.createRegion(REGION_NAME, attrs);
        int buffSize = serverGateway.getSocketBufferSize();
        if (buffSize != 256000) {
            throw new Exception("Socket Buffer size not configured correctly for server gateway");
        }
    }

    public static void createWanClient() throws Exception {
        WanQueueSizeDUnitTest test = new WanQueueSizeDUnitTest("name");
        Properties props = new Properties();
        int port = AvailablePort.getRandomAvailablePort((int)1);
        props.setProperty("mcast-port", Integer.toString(port));
        cache = test.createCache(props);
        GatewayHub clientHub = cache.setGatewayHub("CLIENT_HUB", 22225);
        Gateway clientGateway = clientHub.addGateway("CLIENT_GATEWAY");
        clientGateway.setSocketBufferSize(256000);
        GatewayQueueAttributes queueAttributes = clientGateway.getQueueAttributes();
        queueAttributes.setMaximumQueueMemory(1);
        queueAttributes.setBatchSize(1);
        clientHub.start();
        clientGateway.start();
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setEnableWAN(true);
        RegionAttributes attrs = factory.create();
        cache.createRegion(REGION_NAME, attrs);
        int buffSize = clientGateway.getSocketBufferSize();
        if (buffSize != 256000) {
            throw new Exception("Socket Buffer size not configured correctly for the client gateway");
        }
    }

    public static void doPutAtServer() throws Exception {
        Region region = cache.getRegion(REGION_NAME);
        byte[] val = new byte[102400];
        for (int i = 0; i < 102400; ++i) {
            val[i] = 0;
        }
        for (int count = 0; count < 5; ++count) {
            region.put((Object)("key" + count), (Object)val);
            cache.getLogger().fine("Put the key  ===== key" + count);
        }
    }

    public static void closeStaticCache() {
        if (cache != null) {
            if (!cache.isClosed()) {
                cache.close();
            }
            cache = null;
        }
    }

    public static void getAtClient() throws Exception {
        Region region = cache.getRegion(REGION_NAME);
        for (int count = 0; count < 5; ++count) {
            Object val = region.get((Object)("key" + count));
            cache.getLogger().fine(" The key  ===== key" + count + "value = " + val);
            if (val != null) {
                cache.getLogger().fine("Got the  value for the key  ===== key" + count);
            } else {
                WanQueueSizeDUnitTest.fail((String)("Didn't received value at the client side. val =" + val));
            }
            Thread.sleep(100L);
        }
    }

    private Cache createCache(Properties props) throws Exception {
        InternalDistributedSystem ds = this.getSystem(props);
        Cache cache = null;
        cache = CacheFactory.create((DistributedSystem)ds);
        if (cache == null) {
            throw new Exception("CacheFactory.create() returned null ");
        }
        return cache;
    }

    static class LargeObject
    implements Serializable {
        byte[] val;

        LargeObject(int size) {
            this.val = new byte[size];
        }
    }
}

