/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.CacheWriter;
import com.gemstone.gemfire.cache.CacheWriterException;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.util.CacheWriterAdapter;
import com.gemstone.gemfire.cache.util.Gateway;
import com.gemstone.gemfire.cache.util.GatewayHub;
import com.gemstone.gemfire.cache.util.GatewayQueueAttributes;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.cache.tier.ConnectionProxy;
import com.gemstone.gemfire.internal.cache.tier.sockets.HandShake;
import com.gemstone.gemfire.internal.cache.tier.sockets.ServerHandShakeProcessor;
import com.gemstone.gemfire.internal.shared.Version;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import java.util.Properties;

public class WanBackwardCompatibleDUnitTest
extends DistributedTestCase {
    private static final String REGION_NAME = "WanBackwardCompatibleDUnitTest_region";
    private static final String key = "WAN_KEY";
    protected static Cache cache = null;
    VM wan1 = null;
    VM wan2 = null;
    private static Integer ePort1;
    private static Integer ePort2;
    static WanBackwardCompatibleDUnitTest impl;

    public static void createImpl() {
        impl = new WanBackwardCompatibleDUnitTest("temp");
    }

    public WanBackwardCompatibleDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        WanBackwardCompatibleDUnitTest.disconnectAllFromDS();
        WanBackwardCompatibleDUnitTest.pause(5000);
        Host host = Host.getHost(0);
        this.wan1 = host.getVM(0);
        this.wan2 = host.getVM(1);
        this.wan1.invoke(this.getClass(), "createImpl", null);
        this.wan2.invoke(this.getClass(), "createImpl", null);
    }

    public void testGatewayConnectivityWithDifferentVersionedWan() {
        int totalPut = 30;
        ePort2 = AvailablePort.getRandomAvailablePort((int)0);
        ePort1 = AvailablePort.getRandomAvailablePort((int)0);
        this.wan1.invoke(this.getClass(), "setHandshakeVersionForTesting", new Object[]{Version.GFE_57.ordinal()});
        this.wan1.invoke(this.getClass(), "createServerCache", new Object[]{"EU", "1", ePort1, ePort2, WanBackwardCompatibleDUnitTest.getServerHostName(this.wan1.getHost())});
        this.wan2.invoke(this.getClass(), "createServerCache", new Object[]{"NY", "2", ePort2, ePort1, WanBackwardCompatibleDUnitTest.getServerHostName(this.wan2.getHost())});
        try {
            Thread.sleep(5000L);
            this.wan1.invoke(this.getClass(), "doPuts", new Object[]{totalPut - 30, totalPut - 20});
            this.wan2.invoke(this.getClass(), "doPuts", new Object[]{totalPut - 20, totalPut});
        }
        catch (InterruptedException e) {
            WanBackwardCompatibleDUnitTest.fail("Exception thrown ", e);
        }
        this.wan2.invoke(this.getClass(), "doGet", new Object[]{totalPut});
        this.wan1.invoke(this.getClass(), "doGet", new Object[]{totalPut});
        this.wan1.invoke(this.getClass(), "setHandshakeVersionForTesting", new Object[]{ConnectionProxy.VERSION.ordinal()});
    }

    public void testGatewayConnectivityWithOneUnsupportedVersionedWan() {
        int totalPut = 30;
        ePort2 = AvailablePort.getRandomAvailablePort((int)0);
        ePort1 = AvailablePort.getRandomAvailablePort((int)0);
        this.wan1.invoke(this.getClass(), "createServerCache", new Object[]{"EU", "1", ePort1, null, WanBackwardCompatibleDUnitTest.getServerHostName(this.wan1.getHost())});
        this.wan2.invoke(this.getClass(), "setHandshakeVersionForTesting", new Object[]{(short)59});
        this.wan2.invoke(this.getClass(), "createServerCache", new Object[]{"NY", "2", ePort2, ePort1, WanBackwardCompatibleDUnitTest.getServerHostName(this.wan2.getHost())});
        try {
            Thread.sleep(5000L);
            this.wan1.invoke(this.getClass(), "doPuts", new Object[]{0, 10});
            this.wan2.invoke(this.getClass(), "doPuts", new Object[]{10, totalPut});
        }
        catch (InterruptedException e) {
            WanBackwardCompatibleDUnitTest.fail("Exception thrown ", e);
        }
        this.wan1.invoke(this.getClass(), "doGet", new Object[]{10});
        this.wan2.invoke(this.getClass(), "doGet", new Object[]{20});
        this.wan2.invoke(this.getClass(), "setHandshakeVersionForTesting", new Object[]{ConnectionProxy.VERSION.ordinal()});
    }

    public static Object createServerCache(String site, String name, Integer ePort1, Integer ePort2, String host) throws Exception {
        Properties props = new Properties();
        int mcast_port = AvailablePort.getRandomAvailablePort((int)1);
        props.setProperty("mcast-port", mcast_port + "");
        props.setProperty("locators", "");
        cache = impl.createCache(props);
        WanBackwardCompatibleDUnitTest.addExceptions();
        AttributesFactory factory = impl.getServerCacheAttributesFactory();
        factory.setEnableGateway(true);
        factory.setCacheWriter((CacheWriter)new CacheWriterAdapter(){

            public void beforeCreate(EntryEvent event) throws CacheWriterException {
                cache.getLogger().fine("beforeCreate(): " + event);
            }

            public void beforeUpdate(EntryEvent event) throws CacheWriterException {
                cache.getLogger().fine("beforeUpdate(): " + event);
            }
        });
        RegionAttributes attrs = factory.create();
        cache.createRegion(REGION_NAME, attrs);
        GatewayHub hub1 = cache.addGatewayHub("GatewayHub " + name, ePort1.intValue());
        Gateway gateway1 = hub1.addGateway("Gateway_" + name + ePort1);
        if (ePort2 != null) {
            gateway1.addEndpoint(site, host, ePort2.intValue());
            cache.getLogger().info("site: " + site + ", endpoint port: " + ePort2);
        } else {
            gateway1.addEndpoint(site, host, AvailablePort.getRandomAvailablePort((int)0));
        }
        GatewayQueueAttributes queueAttributes = gateway1.getQueueAttributes();
        queueAttributes.setMaximumQueueMemory(1);
        queueAttributes.setBatchSize(1);
        WanBackwardCompatibleDUnitTest.setDiskStoreForGateway(cache, gateway1.getId(), queueAttributes);
        hub1.start();
        gateway1.start();
        return 0;
    }

    protected AttributesFactory getServerCacheAttributesFactory() {
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setDataPolicy(DataPolicy.REPLICATE);
        return factory;
    }

    private Cache createCache(Properties props) throws Exception {
        InternalDistributedSystem ds = this.getSystem(props);
        Cache cache = null;
        cache = CacheFactory.create((DistributedSystem)ds);
        if (cache == null) {
            throw new Exception("CacheFactory.create() returned null ");
        }
        return cache;
    }

    @Override
    public void tearDown2() throws Exception {
        this.wan1.invoke(this.getClass(), "closeCache");
        this.wan2.invoke(this.getClass(), "closeCache");
    }

    public static void closeCache() {
        if (cache != null && !cache.isClosed()) {
            WanBackwardCompatibleDUnitTest.removeExceptions();
            cache.close();
            cache.getDistributedSystem().disconnect();
        }
    }

    public static void doPuts(Integer min, Integer max) throws Exception {
        Region region = cache.getRegion("/WanBackwardCompatibleDUnitTest_region");
        for (int i = min.intValue(); i < max; ++i) {
            region.put((Object)(key + i), (Object)("newValue" + i));
        }
        cache.getLogger().fine("Completed puts from WAN_KEY" + min + " to " + key + (max - 1));
    }

    public static void doGet(final Integer n) throws Exception {
        final Region reg = cache.getRegion("/WanBackwardCompatibleDUnitTest_region");
        DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){
            String excuse;

            @Override
            public boolean done() {
                int curSize = reg.keySet().size();
                if (n == curSize) {
                    return true;
                }
                this.excuse = "Current size " + curSize + " not expected size " + n;
                return false;
            }

            @Override
            public String description() {
                return this.excuse;
            }
        };
        DistributedTestCase.waitForCriterion(wc, 120000L, 1000L, true);
    }

    public static void setHandshakeVersionForTesting(Short val) throws Exception {
        HandShake.setVersionForTesting((short)val);
        ServerHandShakeProcessor.setSeverVersionForTesting((short)val);
    }

    public static void addExceptions() throws Exception {
        if (cache != null && !cache.isClosed()) {
            cache.getLogger().info("<ExpectedException action=add>UnsupportedVersionException</ExpectedException>");
            cache.getLogger().info("<ExpectedException action=add>Unknown message type</ExpectedException>");
            cache.getLogger().info("<ExpectedException action=add>Unexpected message type</ExpectedException>");
        }
    }

    public static void removeExceptions() {
        if (cache != null && !cache.isClosed()) {
            cache.getLogger().info("<ExpectedException action=remove>UnsupportedVersionException</ExpectedException>");
            cache.getLogger().info("<ExpectedException action=remove>Unknown message type</ExpectedException>");
            cache.getLogger().info("<ExpectedException action=remove>Unexpected message type</ExpectedException>");
        }
    }
}

