/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.client.Pool;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache.client.internal.Connection;
import com.gemstone.gemfire.cache.client.internal.PoolImpl;
import com.gemstone.gemfire.cache.client.internal.ServerRegionProxy;
import com.gemstone.gemfire.cache.util.BridgeServer;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.cache.EventID;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheServerTestUtil;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import java.util.Properties;

public class VerifyUpdatesFromNonInterestEndPointDUnitTest
extends DistributedTestCase {
    VM vm0 = null;
    VM vm1 = null;
    VM vm2 = null;
    private static int PORT1;
    private static int PORT2;
    private static final String REGION_NAME = "VerifyUpdatesFromNonInterestEndPointDUnitTest_region";
    private static Cache cache;

    public VerifyUpdatesFromNonInterestEndPointDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        VerifyUpdatesFromNonInterestEndPointDUnitTest.disconnectAllFromDS();
        VerifyUpdatesFromNonInterestEndPointDUnitTest.pause(5000);
        Host host = Host.getHost(0);
        this.vm0 = host.getVM(0);
        this.vm1 = host.getVM(1);
        this.vm2 = host.getVM(2);
        PORT1 = (Integer)this.vm0.invoke(VerifyUpdatesFromNonInterestEndPointDUnitTest.class, "createServerCache");
        PORT2 = (Integer)this.vm1.invoke(VerifyUpdatesFromNonInterestEndPointDUnitTest.class, "createServerCache");
        this.vm2.invoke(VerifyUpdatesFromNonInterestEndPointDUnitTest.class, "createClientCache", new Object[]{VerifyUpdatesFromNonInterestEndPointDUnitTest.getServerHostName(this.vm0.getHost()), new Integer(PORT1), new Integer(PORT2)});
    }

    private Cache createCache(Properties props) throws Exception {
        InternalDistributedSystem ds = this.getSystem(props);
        Cache cache = null;
        cache = CacheFactory.create((DistributedSystem)ds);
        if (cache == null) {
            throw new Exception("CacheFactory.create() returned null ");
        }
        return cache;
    }

    public void testVerifyUpdatesFromNonInterestEndPoint() {
        this.vm2.invoke(VerifyUpdatesFromNonInterestEndPointDUnitTest.class, "createEntries");
        this.vm1.invoke(VerifyUpdatesFromNonInterestEndPointDUnitTest.class, "createEntries");
        this.vm0.invoke(VerifyUpdatesFromNonInterestEndPointDUnitTest.class, "createEntries");
        this.vm2.invoke(VerifyUpdatesFromNonInterestEndPointDUnitTest.class, "registerKey");
        this.vm2.invoke(VerifyUpdatesFromNonInterestEndPointDUnitTest.class, "acquireConnectionsAndPut", new Object[]{new Integer(PORT2)});
        VerifyUpdatesFromNonInterestEndPointDUnitTest.pause(30000);
        this.vm2.invoke(VerifyUpdatesFromNonInterestEndPointDUnitTest.class, "verifyPut");
    }

    public static void acquireConnectionsAndPut(Integer port) {
        try {
            Region r1 = cache.getRegion("/VerifyUpdatesFromNonInterestEndPointDUnitTest_region");
            String poolName = r1.getAttributes().getPoolName();
            VerifyUpdatesFromNonInterestEndPointDUnitTest.assertNotNull((Object)poolName);
            PoolImpl pool = (PoolImpl)PoolManager.find((String)poolName);
            VerifyUpdatesFromNonInterestEndPointDUnitTest.assertNotNull((Object)pool);
            Connection conn1 = pool.acquireConnection();
            Connection conn2 = pool.acquireConnection();
            ServerRegionProxy srp = new ServerRegionProxy("/VerifyUpdatesFromNonInterestEndPointDUnitTest_region", pool);
            if (conn1.getServer().getPort() == port.intValue()) {
                srp.putOnForTestsOnly(conn1, (Object)"key-1", (Object)"server-value1", new EventID(new byte[]{1}, 1L, 1L), null);
                srp.putOnForTestsOnly(conn1, (Object)"key-2", (Object)"server-value2", new EventID(new byte[]{1}, 1L, 2L), null);
            } else if (conn2.getServer().getPort() == port.intValue()) {
                srp.putOnForTestsOnly(conn2, (Object)"key-1", (Object)"server-value1", new EventID(new byte[]{1}, 1L, 1L), null);
                srp.putOnForTestsOnly(conn2, (Object)"key-2", (Object)"server-value2", new EventID(new byte[]{1}, 1L, 2L), null);
            }
        }
        catch (Exception ex) {
            VerifyUpdatesFromNonInterestEndPointDUnitTest.fail((String)("while setting acquireConnections  " + ex));
        }
    }

    public static void createEntries() {
        try {
            LocalRegion r1 = (LocalRegion)cache.getRegion("/VerifyUpdatesFromNonInterestEndPointDUnitTest_region");
            if (!r1.containsKey((Object)"key-1")) {
                r1.create((Object)"key-1", (Object)"key-1");
            }
            if (!r1.containsKey((Object)"key-2")) {
                r1.create((Object)"key-2", (Object)"key-2");
            }
            VerifyUpdatesFromNonInterestEndPointDUnitTest.assertEquals((Object)r1.getEntry((Object)"key-1").getValue(), (Object)"key-1");
            VerifyUpdatesFromNonInterestEndPointDUnitTest.assertEquals((Object)r1.getEntry((Object)"key-2").getValue(), (Object)"key-2");
        }
        catch (Exception ex) {
            VerifyUpdatesFromNonInterestEndPointDUnitTest.fail("failed while createEntries()", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createClientCache(String host, Integer port1, Integer port2) throws Exception {
        Pool p;
        VerifyUpdatesFromNonInterestEndPointDUnitTest test = new VerifyUpdatesFromNonInterestEndPointDUnitTest("temp");
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "");
        cache = test.createCache(props);
        try {
            p = PoolManager.createFactory().addServer(host, port1.intValue()).addServer(host, port2.intValue()).setSubscriptionEnabled(true).setSubscriptionRedundancy(-1).setMinConnections(6).setSocketBufferSize(32768).setReadTimeout(2000).create("UpdatePropagationDUnitTestPool");
        }
        finally {
            CacheServerTestUtil.enableShufflingOfEndpoints();
        }
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setPoolName(p.getName());
        RegionAttributes attrs = factory.create();
        cache.createRegion(REGION_NAME, attrs);
    }

    public static Integer createServerCache() throws Exception {
        cache = new VerifyUpdatesFromNonInterestEndPointDUnitTest("temp").createCache(new Properties());
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setDataPolicy(DataPolicy.REPLICATE);
        RegionAttributes attrs = factory.create();
        cache.createRegion(REGION_NAME, attrs);
        BridgeServer server1 = cache.addBridgeServer();
        int port = AvailablePort.getRandomAvailablePort((int)0);
        server1.setPort(port);
        server1.setNotifyBySubscription(true);
        server1.start();
        return new Integer(server1.getPort());
    }

    public static void registerKey() {
        try {
            Region r = cache.getRegion("/VerifyUpdatesFromNonInterestEndPointDUnitTest_region");
            VerifyUpdatesFromNonInterestEndPointDUnitTest.assertNotNull((Object)r);
            r.registerInterest((Object)"key-1");
        }
        catch (Exception ex) {
            VerifyUpdatesFromNonInterestEndPointDUnitTest.fail("failed while registerKey()", ex);
        }
    }

    public static void verifyPut() {
        try {
            Region r = cache.getRegion("/VerifyUpdatesFromNonInterestEndPointDUnitTest_region");
            VerifyUpdatesFromNonInterestEndPointDUnitTest.assertNotNull((Object)r);
            VerifyUpdatesFromNonInterestEndPointDUnitTest.assertEquals((Object)"key-1", (Object)r.getEntry((Object)"key-1").getValue());
            VerifyUpdatesFromNonInterestEndPointDUnitTest.assertEquals((Object)"key-2", (Object)r.getEntry((Object)"key-2").getValue());
        }
        catch (Exception ex) {
            VerifyUpdatesFromNonInterestEndPointDUnitTest.fail("failed while verifyPut()", ex);
        }
    }

    public static void closeCache() {
        if (cache != null && !cache.isClosed()) {
            cache.close();
            cache.getDistributedSystem().disconnect();
        }
    }

    @Override
    public void tearDown2() throws Exception {
        this.vm2.invoke(VerifyUpdatesFromNonInterestEndPointDUnitTest.class, "closeCache");
        this.vm0.invoke(VerifyUpdatesFromNonInterestEndPointDUnitTest.class, "closeCache");
        this.vm1.invoke(VerifyUpdatesFromNonInterestEndPointDUnitTest.class, "closeCache");
    }

    static {
        cache = null;
    }
}

