/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets;

import com.gemstone.gemfire.internal.cache.tier.sockets.RedundancyLevelTestBase;
import dunit.DistributedTestCase;
import dunit.Host;

public class RedundancyLevelPart2DUnitTest
extends RedundancyLevelTestBase {
    public RedundancyLevelPart2DUnitTest(String name) {
        super(name);
    }

    public static void caseSetUp() throws Exception {
        DistributedTestCase.disconnectAllFromDS();
    }

    private void waitConnectedServers(final int expected) {
        DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                return expected == RedundancyLevelTestBase.pool.getConnectedServerCount();
            }

            @Override
            public String description() {
                return "Connected server count (" + RedundancyLevelTestBase.pool.getConnectedServerCount() + ") never became " + expected;
            }
        };
        DistributedTestCase.waitForCriterion(wc, 120000L, 1000L, true);
    }

    public void testRedundancySpecifiedPrimaryEPFails() {
        try {
            RedundancyLevelPart2DUnitTest.createClientCache(RedundancyLevelPart2DUnitTest.getServerHostName(Host.getHost(0)), PORT1, PORT2, PORT3, PORT4, 1);
            this.waitConnectedServers(4);
            RedundancyLevelPart2DUnitTest.assertTrue((boolean)pool.getPrimaryName().equals(SERVER1));
            RedundancyLevelPart2DUnitTest.assertTrue((boolean)pool.getRedundantNames().contains(SERVER2));
            RedundancyLevelPart2DUnitTest.verifyOrderOfEndpoints();
            this.server0.invoke(RedundancyLevelTestBase.class, "stopServer");
            RedundancyLevelPart2DUnitTest.verifyDeadServers(1);
            RedundancyLevelPart2DUnitTest.verifyRedundantServersContain(SERVER3);
            RedundancyLevelPart2DUnitTest.verifyLiveAndRedundantServers(3, 1);
            RedundancyLevelPart2DUnitTest.verifyOrderOfEndpoints();
            RedundancyLevelPart2DUnitTest.assertTrue((boolean)pool.getPrimaryName().equals(SERVER2));
        }
        catch (Exception ex) {
            RedundancyLevelPart2DUnitTest.fail("test failed due to exception in test testRedundancySpecifiedPrimaryEPFails ", ex);
        }
    }

    public void testRedundancySpecifiedPrimaryEPFailsDetectionByCCU() {
        try {
            FailOverDetectionByCCU = true;
            RedundancyLevelPart2DUnitTest.createClientCache(RedundancyLevelPart2DUnitTest.getServerHostName(Host.getHost(0)), PORT1, PORT2, PORT3, PORT4, 1, 3000, 100);
            this.waitConnectedServers(4);
            RedundancyLevelPart2DUnitTest.assertTrue((boolean)pool.getPrimaryName().equals(SERVER1));
            RedundancyLevelPart2DUnitTest.assertTrue((boolean)pool.getRedundantNames().contains(SERVER2));
            RedundancyLevelPart2DUnitTest.verifyOrderOfEndpoints();
            this.server0.invoke(RedundancyLevelTestBase.class, "stopServer");
            RedundancyLevelPart2DUnitTest.verifyDeadServers(1);
            RedundancyLevelPart2DUnitTest.verifyRedundantServersContain(SERVER3);
            RedundancyLevelPart2DUnitTest.verifyLiveAndRedundantServers(3, 1);
            RedundancyLevelPart2DUnitTest.verifyOrderOfEndpoints();
            RedundancyLevelPart2DUnitTest.assertTrue((boolean)pool.getPrimaryName().equals(SERVER2));
        }
        catch (Exception ex) {
            RedundancyLevelPart2DUnitTest.fail("test failed due to exception in test testRedundancySpecifiedPrimaryEPFailsDetectionByCCU ", ex);
        }
    }

    public void testRedundancySpecifiedPrimaryEPFailsDetectionByRegisterInterest() {
        try {
            RedundancyLevelPart2DUnitTest.createClientCache(RedundancyLevelPart2DUnitTest.getServerHostName(Host.getHost(0)), PORT1, PORT2, PORT3, PORT4, 1, 3000, 100);
            this.waitConnectedServers(4);
            RedundancyLevelPart2DUnitTest.assertTrue((boolean)pool.getPrimaryName().equals(SERVER1));
            RedundancyLevelPart2DUnitTest.assertTrue((boolean)pool.getRedundantNames().contains(SERVER2));
            RedundancyLevelPart2DUnitTest.verifyOrderOfEndpoints();
            this.server0.invoke(RedundancyLevelTestBase.class, "stopServer");
            RedundancyLevelPart2DUnitTest.createEntriesK1andK2();
            RedundancyLevelPart2DUnitTest.registerK1AndK2();
            RedundancyLevelPart2DUnitTest.verifyDeadServers(1);
            RedundancyLevelPart2DUnitTest.verifyRedundantServersContain(SERVER3);
            RedundancyLevelPart2DUnitTest.verifyLiveAndRedundantServers(3, 1);
            RedundancyLevelPart2DUnitTest.verifyOrderOfEndpoints();
            RedundancyLevelPart2DUnitTest.assertTrue((boolean)pool.getPrimaryName().equals(SERVER2));
        }
        catch (Exception ex) {
            RedundancyLevelPart2DUnitTest.fail("test failed due to exception in test testRedundancySpecifiedPrimaryEPFailsDetectionByRegisterInterest ", ex);
        }
    }

    public void testRedundancySpecifiedPrimaryEPFailsDetectionByUnregisterInterest() {
        try {
            RedundancyLevelPart2DUnitTest.createClientCache(RedundancyLevelPart2DUnitTest.getServerHostName(Host.getHost(0)), PORT1, PORT2, PORT3, PORT4, 1, 3000, 100);
            this.waitConnectedServers(4);
            RedundancyLevelPart2DUnitTest.assertTrue((boolean)pool.getPrimaryName().equals(SERVER1));
            RedundancyLevelPart2DUnitTest.assertTrue((boolean)pool.getRedundantNames().contains(SERVER2));
            RedundancyLevelPart2DUnitTest.verifyOrderOfEndpoints();
            this.server0.invoke(RedundancyLevelTestBase.class, "stopServer");
            RedundancyLevelPart2DUnitTest.unregisterInterest();
            RedundancyLevelPart2DUnitTest.verifyDeadServers(1);
            RedundancyLevelPart2DUnitTest.verifyRedundantServersContain(SERVER3);
            RedundancyLevelPart2DUnitTest.verifyLiveAndRedundantServers(3, 1);
            RedundancyLevelPart2DUnitTest.verifyOrderOfEndpoints();
            RedundancyLevelPart2DUnitTest.assertTrue((boolean)pool.getPrimaryName().equals(SERVER2));
        }
        catch (Exception ex) {
            RedundancyLevelPart2DUnitTest.fail("test failed due to exception in test testRedundancySpecifiedPrimaryEPFailsDetectionByUnregisterInterest ", ex);
        }
    }

    public void testRedundancySpecifiedPrimaryEPFailsDetectionByPut() {
        try {
            RedundancyLevelPart2DUnitTest.createClientCache(RedundancyLevelPart2DUnitTest.getServerHostName(Host.getHost(0)), PORT1, PORT2, PORT3, PORT4, 1, 3000, 100);
            this.waitConnectedServers(4);
            RedundancyLevelPart2DUnitTest.assertTrue((boolean)pool.getPrimaryName().equals(SERVER1));
            RedundancyLevelPart2DUnitTest.assertTrue((boolean)pool.getRedundantNames().contains(SERVER2));
            RedundancyLevelPart2DUnitTest.verifyOrderOfEndpoints();
            this.server0.invoke(RedundancyLevelTestBase.class, "stopServer");
            RedundancyLevelPart2DUnitTest.doPuts();
            RedundancyLevelPart2DUnitTest.verifyDeadServers(1);
            RedundancyLevelPart2DUnitTest.verifyRedundantServersContain(SERVER3);
            RedundancyLevelPart2DUnitTest.verifyLiveAndRedundantServers(3, 1);
            RedundancyLevelPart2DUnitTest.verifyOrderOfEndpoints();
            RedundancyLevelPart2DUnitTest.assertTrue((boolean)pool.getPrimaryName().equals(SERVER2));
        }
        catch (Exception ex) {
            RedundancyLevelPart2DUnitTest.fail("test failed due to exception in test testRedundancySpecifiedPrimaryEPFailsDetectionByPut ", ex);
        }
    }

    public void testRedundancySpecifiedPrimarySecondaryEPFails() {
        try {
            RedundancyLevelPart2DUnitTest.createClientCache(RedundancyLevelPart2DUnitTest.getServerHostName(Host.getHost(0)), PORT1, PORT2, PORT3, PORT4, 1);
            this.waitConnectedServers(4);
            RedundancyLevelPart2DUnitTest.assertEquals((int)1, (int)pool.getRedundantNames().size());
            RedundancyLevelPart2DUnitTest.assertTrue((boolean)pool.getPrimaryName().equals(SERVER1));
            RedundancyLevelPart2DUnitTest.assertTrue((boolean)pool.getRedundantNames().contains(SERVER2));
            RedundancyLevelPart2DUnitTest.assertFalse((boolean)pool.getRedundantNames().contains(SERVER3));
            RedundancyLevelPart2DUnitTest.assertFalse((boolean)pool.getRedundantNames().contains(SERVER4));
            RedundancyLevelPart2DUnitTest.verifyOrderOfEndpoints();
            this.server0.invoke(RedundancyLevelTestBase.class, "stopServer");
            this.server1.invoke(RedundancyLevelTestBase.class, "stopServer");
            RedundancyLevelPart2DUnitTest.verifyLiveAndRedundantServers(2, 1);
            RedundancyLevelPart2DUnitTest.verifyOrderOfEndpoints();
            this.server2.invoke(RedundancyLevelTestBase.class, "verifyInterestRegistration");
            this.server3.invoke(RedundancyLevelTestBase.class, "verifyInterestRegistration");
        }
        catch (Exception ex) {
            RedundancyLevelPart2DUnitTest.fail("test failed due to exception in test testRedundancySpecifiedPrimarySecondaryEPFails ", ex);
        }
    }

    public void testRedundancySpecifiedEPFails() {
        try {
            RedundancyLevelPart2DUnitTest.createClientCache(RedundancyLevelPart2DUnitTest.getServerHostName(Host.getHost(0)), PORT1, PORT2, PORT3, PORT4, 2);
            this.waitConnectedServers(4);
            RedundancyLevelPart2DUnitTest.assertEquals((int)2, (int)pool.getRedundantNames().size());
            RedundancyLevelPart2DUnitTest.assertTrue((boolean)pool.getPrimaryName().equals(SERVER1));
            RedundancyLevelPart2DUnitTest.assertTrue((boolean)pool.getRedundantNames().contains(SERVER2));
            RedundancyLevelPart2DUnitTest.assertTrue((boolean)pool.getRedundantNames().contains(SERVER3));
            RedundancyLevelPart2DUnitTest.assertFalse((boolean)pool.getRedundantNames().contains(SERVER4));
            RedundancyLevelPart2DUnitTest.verifyOrderOfEndpoints();
            this.server1.invoke(RedundancyLevelTestBase.class, "stopServer");
            this.server2.invoke(RedundancyLevelTestBase.class, "stopServer");
            RedundancyLevelPart2DUnitTest.verifyDeadServers(2);
            RedundancyLevelPart2DUnitTest.verifyLiveAndRedundantServers(2, 1);
            RedundancyLevelPart2DUnitTest.verifyOrderOfEndpoints();
            this.server1.invoke(RedundancyLevelTestBase.class, "startServer");
            RedundancyLevelPart2DUnitTest.verifyLiveAndRedundantServers(3, 2);
            RedundancyLevelPart2DUnitTest.verifyOrderOfEndpoints();
            RedundancyLevelPart2DUnitTest.assertTrue((boolean)pool.getPrimaryName().equals(SERVER1));
            RedundancyLevelPart2DUnitTest.verifyRedundantServersContain(SERVER2);
            RedundancyLevelPart2DUnitTest.verifyRedundantServersContain(SERVER4);
            this.server1.invoke(RedundancyLevelTestBase.class, "verifyInterestRegistration");
            this.server2.invoke(RedundancyLevelTestBase.class, "startServer");
            RedundancyLevelPart2DUnitTest.pause(1000);
            RedundancyLevelPart2DUnitTest.verifyOrderOfEndpoints();
            this.server2.invoke(RedundancyLevelTestBase.class, "verifyNoCCP");
        }
        catch (Exception ex) {
            RedundancyLevelPart2DUnitTest.fail("test failed due to exception in test testRedundancySpecifiedEPFails ", ex);
        }
    }

    public void testRedundancyLevelSpecifiedButNotSatisfied() {
        try {
            this.server2.invoke(RedundancyLevelTestBase.class, "stopServer");
            this.server1.invoke(RedundancyLevelTestBase.class, "stopServer");
            RedundancyLevelPart2DUnitTest.createClientCache(RedundancyLevelPart2DUnitTest.getServerHostName(Host.getHost(0)), PORT1, PORT2, PORT3, PORT4, 2);
            RedundancyLevelPart2DUnitTest.verifyLiveAndRedundantServers(2, 1);
            RedundancyLevelPart2DUnitTest.verifyOrderOfEndpoints();
            RedundancyLevelPart2DUnitTest.assertTrue((boolean)pool.getRedundantNames().contains(SERVER4));
            RedundancyLevelPart2DUnitTest.assertTrue((boolean)pool.getPrimaryName().equals(SERVER1));
            RedundancyLevelPart2DUnitTest.assertFalse((boolean)pool.getRedundantNames().contains(SERVER3));
            RedundancyLevelPart2DUnitTest.assertFalse((boolean)pool.getRedundantNames().contains(SERVER2));
            this.server2.invoke(RedundancyLevelTestBase.class, "startServer");
            RedundancyLevelPart2DUnitTest.verifyLiveAndRedundantServers(3, 2);
            RedundancyLevelPart2DUnitTest.verifyOrderOfEndpoints();
            RedundancyLevelPart2DUnitTest.assertTrue((boolean)pool.getRedundantNames().contains(SERVER4));
            RedundancyLevelPart2DUnitTest.assertTrue((boolean)pool.getRedundantNames().contains(SERVER3));
            RedundancyLevelPart2DUnitTest.assertTrue((boolean)pool.getPrimaryName().equals(SERVER1));
            RedundancyLevelPart2DUnitTest.assertFalse((boolean)pool.getRedundantNames().contains(SERVER2));
            this.server2.invoke(RedundancyLevelTestBase.class, "verifyInterestRegistration");
            this.server1.invoke(RedundancyLevelTestBase.class, "startServer");
            RedundancyLevelPart2DUnitTest.pause(1000);
            RedundancyLevelPart2DUnitTest.verifyOrderOfEndpoints();
            RedundancyLevelPart2DUnitTest.assertTrue((boolean)pool.getRedundantNames().contains(SERVER4));
            RedundancyLevelPart2DUnitTest.assertTrue((boolean)pool.getRedundantNames().contains(SERVER3));
            RedundancyLevelPart2DUnitTest.assertTrue((boolean)pool.getPrimaryName().equals(SERVER1));
            RedundancyLevelPart2DUnitTest.assertFalse((boolean)pool.getRedundantNames().contains(SERVER2));
            this.server1.invoke(RedundancyLevelTestBase.class, "verifyNoCCP");
        }
        catch (Exception ex) {
            RedundancyLevelPart2DUnitTest.fail("test failed due to exception in test noRedundancyLevelServerFail ", ex);
        }
    }

    public void testRedundancyLevelSpecifiedAndSatisfied() {
        try {
            this.server1.invoke(RedundancyLevelTestBase.class, "stopServer");
            RedundancyLevelPart2DUnitTest.createClientCache(RedundancyLevelPart2DUnitTest.getServerHostName(Host.getHost(0)), PORT1, PORT2, PORT3, PORT4, 2);
            RedundancyLevelPart2DUnitTest.verifyLiveAndRedundantServers(3, 2);
            RedundancyLevelPart2DUnitTest.verifyOrderOfEndpoints();
            RedundancyLevelPart2DUnitTest.assertTrue((boolean)pool.getRedundantNames().contains(SERVER3));
            RedundancyLevelPart2DUnitTest.assertTrue((boolean)pool.getRedundantNames().contains(SERVER4));
            RedundancyLevelPart2DUnitTest.assertTrue((boolean)pool.getPrimaryName().equals(SERVER1));
            RedundancyLevelPart2DUnitTest.assertFalse((boolean)pool.getRedundantNames().contains(SERVER2));
            this.server1.invoke(RedundancyLevelTestBase.class, "startServer");
            RedundancyLevelPart2DUnitTest.pause(1000);
            RedundancyLevelPart2DUnitTest.verifyOrderOfEndpoints();
            RedundancyLevelPart2DUnitTest.assertTrue((boolean)pool.getRedundantNames().contains(SERVER3));
            RedundancyLevelPart2DUnitTest.assertTrue((boolean)pool.getRedundantNames().contains(SERVER4));
            RedundancyLevelPart2DUnitTest.assertTrue((boolean)pool.getPrimaryName().equals(SERVER1));
            RedundancyLevelPart2DUnitTest.assertFalse((boolean)pool.getRedundantNames().contains(SERVER2));
            this.server1.invoke(RedundancyLevelTestBase.class, "verifyNoCCP");
        }
        catch (Exception ex) {
            RedundancyLevelPart2DUnitTest.fail("test failed due to exception in test noRedundancyLevelServerFail ", ex);
        }
    }

    public void testRedundancyLevelNotSpecified() {
        try {
            this.server2.invoke(RedundancyLevelTestBase.class, "stopServer");
            RedundancyLevelPart2DUnitTest.createClientCache(RedundancyLevelPart2DUnitTest.getServerHostName(Host.getHost(0)), PORT1, PORT2, PORT3, PORT4, -1);
            RedundancyLevelPart2DUnitTest.verifyLiveAndRedundantServers(3, 2);
            RedundancyLevelPart2DUnitTest.verifyOrderOfEndpoints();
            RedundancyLevelPart2DUnitTest.assertFalse((boolean)pool.getRedundantNames().contains(SERVER1));
            RedundancyLevelPart2DUnitTest.assertFalse((boolean)pool.getRedundantNames().contains(SERVER3));
            RedundancyLevelPart2DUnitTest.assertTrue((boolean)pool.getRedundantNames().contains(SERVER2));
            RedundancyLevelPart2DUnitTest.assertTrue((boolean)pool.getPrimaryName().equals(SERVER1));
            RedundancyLevelPart2DUnitTest.assertTrue((boolean)pool.getRedundantNames().contains(SERVER4));
            this.server2.invoke(RedundancyLevelTestBase.class, "startServer");
            RedundancyLevelPart2DUnitTest.verifyLiveAndRedundantServers(4, 3);
            RedundancyLevelPart2DUnitTest.verifyOrderOfEndpoints();
            RedundancyLevelPart2DUnitTest.assertTrue((boolean)pool.getRedundantNames().contains(SERVER2));
            RedundancyLevelPart2DUnitTest.assertTrue((boolean)pool.getRedundantNames().contains(SERVER3));
            RedundancyLevelPart2DUnitTest.assertTrue((boolean)pool.getRedundantNames().contains(SERVER4));
            RedundancyLevelPart2DUnitTest.assertTrue((boolean)pool.getPrimaryName().equals(SERVER1));
            this.server2.invoke(RedundancyLevelTestBase.class, "verifyInterestRegistration");
        }
        catch (Exception ex) {
            RedundancyLevelPart2DUnitTest.fail("test failed due to exception in test noRedundancyLevelServerFail ", ex);
        }
    }

    public void testRedundancySpecifiedMoreThanEPs() {
        try {
            RedundancyLevelPart2DUnitTest.createClientCache(RedundancyLevelPart2DUnitTest.getServerHostName(Host.getHost(0)), PORT1, PORT2, PORT3, PORT4, 5);
            RedundancyLevelPart2DUnitTest.assertEquals((int)3, (int)pool.getRedundantNames().size());
            this.server0.invoke(RedundancyLevelTestBase.class, "verifyCCP");
            this.server1.invoke(RedundancyLevelTestBase.class, "verifyCCP");
            this.server2.invoke(RedundancyLevelTestBase.class, "verifyCCP");
            this.server3.invoke(RedundancyLevelTestBase.class, "verifyCCP");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            RedundancyLevelPart2DUnitTest.fail("test failed due to exception in test testRedundancySpecifiedMoreThanEPs ", ex);
        }
    }
}

