/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.InterestResultPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import java.util.ArrayList;
import java.util.Properties;

public class NewRegionAttributesDUnitTest
extends DistributedTestCase {
    VM vm0;
    VM vm1 = null;
    private static Cache cache = null;
    private static final int TOTAL_PUTS = 10;
    private static final String REGION_NAME = "NewRegionAttributesDUnitTest_region";

    public NewRegionAttributesDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        NewRegionAttributesDUnitTest.disconnectAllFromDS();
        NewRegionAttributesDUnitTest.pause(5000);
        Host host = Host.getHost(0);
        this.vm0 = host.getVM(0);
        this.vm1 = host.getVM(1);
        Object[] objArr = new Object[]{new Boolean(true), new Boolean(true), new Boolean(true), new Boolean(true)};
        this.vm0.invoke(NewRegionAttributesDUnitTest.class, "createServerCache", objArr);
        this.vm1.invoke(NewRegionAttributesDUnitTest.class, "createServerCache", objArr);
    }

    @Override
    public void tearDown2() throws Exception {
        this.vm0.invoke(NewRegionAttributesDUnitTest.class, "closeCache");
        this.vm1.invoke(NewRegionAttributesDUnitTest.class, "closeCache");
    }

    public static void createServerCache(Boolean enableWan, Boolean setPublisher, Boolean enableConflation, Boolean enableAsyncConflation) throws Exception {
        NewRegionAttributesDUnitTest test = new NewRegionAttributesDUnitTest("temp");
        cache = test.createCache(new Properties());
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setDataPolicy(DataPolicy.REPLICATE);
        factory.setEnableWAN(enableWan.booleanValue());
        factory.setEnableConflation(enableConflation.booleanValue());
        factory.setEnableAsyncConflation(enableAsyncConflation.booleanValue());
        RegionAttributes attrs = factory.create();
        cache.createRegion(REGION_NAME, attrs);
    }

    private Cache createCache(Properties props) throws Exception {
        InternalDistributedSystem ds = this.getSystem(props);
        Cache cache = null;
        cache = CacheFactory.create((DistributedSystem)ds);
        if (cache == null) {
            throw new Exception("CacheFactory.create() returned null ");
        }
        return cache;
    }

    public static void closeCache() {
        if (cache != null && !cache.isClosed()) {
            cache.close();
            cache.getDistributedSystem().disconnect();
        }
    }

    public void testEntryOperationsWithNewAttributesEnabled() {
        this.vm0.invoke(NewRegionAttributesDUnitTest.class, "checkAttributes");
        this.vm1.invoke(NewRegionAttributesDUnitTest.class, "checkAttributes");
        this.vm0.invoke(NewRegionAttributesDUnitTest.class, "doPuts");
        Integer cnt1 = (Integer)this.vm1.invoke(NewRegionAttributesDUnitTest.class, "getEntryCount");
        NewRegionAttributesDUnitTest.assertEquals((int)10, (int)cnt1);
        this.vm0.invoke(NewRegionAttributesDUnitTest.class, "doPuts");
        this.vm0.invoke(NewRegionAttributesDUnitTest.class, "doInvalidates");
        this.vm0.invoke(NewRegionAttributesDUnitTest.class, "doDestroy");
        Integer cnt2 = (Integer)this.vm1.invoke(NewRegionAttributesDUnitTest.class, "getEntryCount");
        NewRegionAttributesDUnitTest.assertEquals((int)0, (int)cnt2);
    }

    public void testRegisterInterestUseCases() {
        this.vm1.invoke(NewRegionAttributesDUnitTest.class, "registerInterest");
        this.vm1.invoke(NewRegionAttributesDUnitTest.class, "unregisterInterest");
        this.vm1.invoke(NewRegionAttributesDUnitTest.class, "getInterestForRegion");
    }

    public static void checkAttributes() {
        Region region1 = cache.getRegion("/NewRegionAttributesDUnitTest_region");
        NewRegionAttributesDUnitTest.assertTrue((boolean)region1.getAttributes().getEnableWAN());
        NewRegionAttributesDUnitTest.assertTrue((boolean)region1.getAttributes().getEnableConflation());
        NewRegionAttributesDUnitTest.assertTrue((boolean)region1.getAttributes().getEnableAsyncConflation());
    }

    public static void doPuts() {
        Region region1 = cache.getRegion("/NewRegionAttributesDUnitTest_region");
        for (int i = 0; i < 10; ++i) {
            try {
                region1.put((Object)("key-" + i), (Object)("val-" + i));
                continue;
            }
            catch (Exception e) {
                NewRegionAttributesDUnitTest.fail((String)("Test failed due to unexpected exception during PUTs : " + e));
            }
        }
    }

    public static void doInvalidates() {
        Region region1 = cache.getRegion("/NewRegionAttributesDUnitTest_region");
        for (int i = 0; i < 10; ++i) {
            try {
                region1.invalidate((Object)("key-" + i));
                continue;
            }
            catch (Exception e) {
                NewRegionAttributesDUnitTest.fail((String)("Test failed due to unexpected exception during INVALIDATESs : " + e));
            }
        }
    }

    public static void doDestroy() {
        Region region1 = cache.getRegion("/NewRegionAttributesDUnitTest_region");
        for (int i = 0; i < 10; ++i) {
            try {
                region1.destroy((Object)("key-" + i));
                continue;
            }
            catch (Exception e) {
                NewRegionAttributesDUnitTest.fail((String)("Test failed due to unexpected exception during DESTROYs : " + e));
            }
        }
    }

    public static Object getEntryCount() {
        Region region1 = cache.getRegion("/NewRegionAttributesDUnitTest_region");
        int keysSize = region1.entries(false).size();
        return new Integer(keysSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerInterest() {
        InterestResultPolicy policy = InterestResultPolicy.KEYS_VALUES;
        int totalKeys = 5;
        Region region1 = cache.getRegion("/NewRegionAttributesDUnitTest_region");
        ArrayList<String> keylist = new ArrayList<String>();
        for (int i = 0; i < totalKeys; ++i) {
            keylist.add("key-" + i);
        }
        boolean exceptionOccured = false;
        try {
            region1.registerInterest((Object)"DummyKey1");
        }
        catch (UnsupportedOperationException expected) {
            exceptionOccured = true;
        }
        finally {
            if (!exceptionOccured) {
                NewRegionAttributesDUnitTest.fail((String)"UnsupportedOperationException was not thrown as expected for registerInterest(key)");
            }
        }
        exceptionOccured = false;
        try {
            region1.registerInterest((Object)"DummyKey2", policy);
        }
        catch (UnsupportedOperationException expected) {
            exceptionOccured = true;
        }
        finally {
            if (!exceptionOccured) {
                NewRegionAttributesDUnitTest.fail((String)"UnsupportedOperationException was not thrown as expected for  registerInterest(key,policy)");
            }
        }
        exceptionOccured = false;
        try {
            region1.registerInterest(keylist);
        }
        catch (UnsupportedOperationException expected) {
            exceptionOccured = true;
        }
        finally {
            if (!exceptionOccured) {
                NewRegionAttributesDUnitTest.fail((String)"UnsupportedOperationException was not thrown as expected for registerInterest(keylist)");
            }
        }
        exceptionOccured = false;
        try {
            region1.registerInterest(keylist, policy);
        }
        catch (UnsupportedOperationException expected) {
            exceptionOccured = true;
        }
        finally {
            if (!exceptionOccured) {
                NewRegionAttributesDUnitTest.fail((String)"UnsupportedOperationException was not thrown as expected for registerInterest(keylist,policy)");
            }
        }
        exceptionOccured = false;
        try {
            region1.registerInterestRegex("ke?");
        }
        catch (UnsupportedOperationException expected) {
            exceptionOccured = true;
        }
        finally {
            if (!exceptionOccured) {
                NewRegionAttributesDUnitTest.fail((String)"UnsupportedOperationException was not thrown as expected for registerInterestRegex(expr)");
            }
        }
        exceptionOccured = false;
        try {
            region1.registerInterestRegex("ke?", InterestResultPolicy.KEYS_VALUES);
        }
        catch (UnsupportedOperationException expected) {
            exceptionOccured = true;
        }
        finally {
            if (!exceptionOccured) {
                NewRegionAttributesDUnitTest.fail((String)"UnsupportedOperationException was not thrown as expected for registerInterestRegex(expr,policy)");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterInterest() {
        int totalKeys = 5;
        Region region1 = cache.getRegion("/NewRegionAttributesDUnitTest_region");
        ArrayList<String> keylist = new ArrayList<String>();
        for (int i = 0; i < totalKeys; ++i) {
            keylist.add("key-" + i);
        }
        boolean exceptionOccured = false;
        try {
            region1.unregisterInterest((Object)"DummyKey1");
        }
        catch (UnsupportedOperationException expected) {
            exceptionOccured = true;
        }
        finally {
            if (!exceptionOccured) {
                NewRegionAttributesDUnitTest.fail((String)"UnsupportedOperationException was not thrown as expected for unregisterInterest(key)");
            }
        }
        exceptionOccured = false;
        try {
            region1.unregisterInterest(keylist);
        }
        catch (UnsupportedOperationException expected) {
            exceptionOccured = true;
        }
        finally {
            if (!exceptionOccured) {
                NewRegionAttributesDUnitTest.fail((String)"UnsupportedOperationException was not thrown as expected for unregisterInterest(keylist)");
            }
        }
        exceptionOccured = false;
        try {
            region1.unregisterInterestRegex("kp?");
        }
        catch (UnsupportedOperationException expected) {
            exceptionOccured = true;
        }
        finally {
            if (!exceptionOccured) {
                NewRegionAttributesDUnitTest.fail((String)"UnsupportedOperationException was not thrown as expected for unregisterInterestRegex(expr)");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getInterestForRegion() {
        Region region1 = cache.getRegion("/NewRegionAttributesDUnitTest_region");
        boolean exceptionOccured = false;
        try {
            region1.getInterestList();
        }
        catch (UnsupportedOperationException e) {
            exceptionOccured = true;
        }
        finally {
            if (!exceptionOccured) {
                NewRegionAttributesDUnitTest.fail((String)"UnsupportedOperationException was not thrown as expected for getInterestList()");
            }
        }
        exceptionOccured = false;
        try {
            region1.getInterestListRegex();
        }
        catch (UnsupportedOperationException e) {
            exceptionOccured = true;
        }
        finally {
            if (!exceptionOccured) {
                NewRegionAttributesDUnitTest.fail((String)"UnsupportedOperationException was not thrown as expected for getInterestListRegex()");
            }
        }
    }
}

