/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.InterestResultPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache.client.internal.PoolImpl;
import com.gemstone.gemfire.cache.util.BridgeServer;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.cache.BridgeServerImpl;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheClientProxy;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import java.io.EOFException;
import java.net.SocketException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;

public class InterestListRecoveryDUnitTest
extends DistributedTestCase {
    private static Cache cache = null;
    VM server1 = null;
    VM server2 = null;
    protected static PoolImpl pool = null;
    private static int PORT1;
    private static int PORT2;
    private static final String REGION_NAME = "InterestListRecoveryDUnitTest_region";

    public InterestListRecoveryDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        InterestListRecoveryDUnitTest.disconnectAllFromDS();
        InterestListRecoveryDUnitTest.pause(2000);
        super.setUp();
        Host host = Host.getHost(0);
        this.server1 = host.getVM(0);
        this.server2 = host.getVM(1);
        PORT1 = (Integer)this.server1.invoke(InterestListRecoveryDUnitTest.class, "createServerCache");
        PORT2 = (Integer)this.server2.invoke(InterestListRecoveryDUnitTest.class, "createServerCache");
        InterestListRecoveryDUnitTest.getLogWriter().info("server1 port is " + String.valueOf(PORT1));
        InterestListRecoveryDUnitTest.getLogWriter().info("server2 port is " + String.valueOf(PORT2));
        InterestListRecoveryDUnitTest.createClientCache(InterestListRecoveryDUnitTest.getServerHostName(host), new Integer(PORT1), new Integer(PORT2));
    }

    public void XtestKeyInterestRecoveryWhileServerFailover() throws Exception {
        InterestListRecoveryDUnitTest.createEntries();
        this.server1.invoke(InterestListRecoveryDUnitTest.class, "createEntries");
        InterestListRecoveryDUnitTest.registerK1toK5();
        InterestListRecoveryDUnitTest.setServerUnavailable("localhost" + PORT1);
        InterestListRecoveryDUnitTest.pause(20000);
        InterestListRecoveryDUnitTest.unregisterK1toK3();
        InterestListRecoveryDUnitTest.setServerAvailable("localhost" + PORT1);
        InterestListRecoveryDUnitTest.pause(20000);
        InterestListRecoveryDUnitTest.setServerUnavailable("localhost" + PORT2);
        InterestListRecoveryDUnitTest.pause(20000);
        this.server1.invoke(InterestListRecoveryDUnitTest.class, "verifyUnregisterK1toK3");
    }

    public void testKeyInterestRecoveryWhileProcessException() throws Exception {
        VM serverFirstRegistered = null;
        VM serverSecondRegistered = null;
        LogWriter logger = system.getLogWriter();
        InterestListRecoveryDUnitTest.createEntries();
        this.server2.invoke(InterestListRecoveryDUnitTest.class, "createEntries");
        this.server1.invoke(InterestListRecoveryDUnitTest.class, "createEntries");
        InterestListRecoveryDUnitTest.registerK1toK5();
        logger.fine("After registerK1toK5");
        if (this.isInterestListRegisteredToServer1()) {
            serverFirstRegistered = this.server1;
            serverSecondRegistered = this.server2;
            logger.fine("serverFirstRegistered is server1 and serverSecondRegistered is server2");
        } else {
            serverFirstRegistered = this.server2;
            serverSecondRegistered = this.server1;
            logger.fine("serverFirstRegistered is server2 and serverSecondRegistered is server1");
        }
        InterestListRecoveryDUnitTest.verifyDeadAndLiveServers(0, 2);
        serverFirstRegistered.invoke(InterestListRecoveryDUnitTest.class, "verifyRegionToProxyMapForFullRegistration");
        logger.fine("After verifyRegionToProxyMapForFullRegistration on serverFirstRegistered");
        logger.info("<ExpectedException action=add>" + SocketException.class.getName() + "</ExpectedException>");
        logger.info("<ExpectedException action=add>" + EOFException.class.getName() + "</ExpectedException>");
        InterestListRecoveryDUnitTest.killCurrentEndpoint();
        logger.fine("After killCurrentEndpoint1");
        serverSecondRegistered.invoke(InterestListRecoveryDUnitTest.class, "verifyRegionToProxyMapForFullRegistrationRetry");
        logger.fine("After verifyRegionToProxyMapForFullRegistration on serverSecondRegistered");
        InterestListRecoveryDUnitTest.unregisterK1toK3();
        serverSecondRegistered.invoke(InterestListRecoveryDUnitTest.class, "verifyRegisterK4toK5Retry");
        logger.fine("After verifyRegisterK4toK5Retry on serverSecondRegistered");
    }

    private boolean isInterestListRegisteredToServer1() {
        try {
            Region r1 = cache.getRegion("/InterestListRecoveryDUnitTest_region");
            String poolName = r1.getAttributes().getPoolName();
            InterestListRecoveryDUnitTest.assertNotNull((Object)poolName);
            pool = (PoolImpl)PoolManager.find((String)poolName);
            InterestListRecoveryDUnitTest.assertNotNull((Object)pool);
            return pool.getPrimaryPort() == PORT1;
        }
        catch (Exception ex) {
            InterestListRecoveryDUnitTest.fail("while isInterestListRegisteredToServer1", ex);
            return false;
        }
    }

    private Cache createCache(Properties props) throws Exception {
        InternalDistributedSystem ds = this.getSystem(props);
        Cache cache = null;
        cache = CacheFactory.create((DistributedSystem)ds);
        if (cache == null) {
            throw new Exception("CacheFactory.create() returned null ");
        }
        return cache;
    }

    public static void createClientCache(String host, Integer port1, Integer port2) throws Exception {
        InterestListRecoveryDUnitTest test = new InterestListRecoveryDUnitTest("temp");
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "");
        cache = test.createCache(props);
        PoolImpl p = (PoolImpl)PoolManager.createFactory().addServer(host, port1.intValue()).addServer(host, port2.intValue()).setSubscriptionEnabled(true).setSubscriptionRedundancy(-1).setReadTimeout(250).setThreadLocalConnections(true).setSocketBufferSize(32768).setMinConnections(4).create("InterestListRecoveryDUnitTestPool");
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setPoolName(p.getName());
        RegionAttributes attrs = factory.create();
        cache.createRegion(REGION_NAME, attrs);
        pool = p;
    }

    public static Integer createServerCache() throws Exception {
        InterestListRecoveryDUnitTest test = new InterestListRecoveryDUnitTest("temp");
        cache = test.createCache(new Properties());
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setDataPolicy(DataPolicy.REPLICATE);
        RegionAttributes attrs = factory.create();
        cache.createRegion(REGION_NAME, attrs);
        int port = AvailablePort.getRandomAvailablePort((int)0);
        BridgeServer server1 = cache.addBridgeServer();
        server1.setPort(port);
        server1.setNotifyBySubscription(true);
        server1.start();
        return new Integer(server1.getPort());
    }

    public static void createEntries() {
        try {
            LocalRegion r1 = (LocalRegion)cache.getRegion("/InterestListRecoveryDUnitTest_region");
            for (int i = 1; i < 6; ++i) {
                if (!r1.containsKey((Object)("key-" + i))) {
                    r1.create((Object)("key-" + i), (Object)("key-" + i));
                }
                InterestListRecoveryDUnitTest.assertEquals((Object)r1.getEntry((Object)("key-" + i)).getValue(), (Object)("key-" + i));
            }
        }
        catch (Exception ex) {
            InterestListRecoveryDUnitTest.fail("failed while createEntries()", ex);
        }
    }

    public static void registerK1toK5() {
        try {
            LocalRegion r = (LocalRegion)cache.getRegion("/InterestListRecoveryDUnitTest_region");
            for (int i = 1; i < 6; ++i) {
                r.registerInterest((Object)("key-" + i), InterestResultPolicy.KEYS);
            }
        }
        catch (Exception ex) {
            InterestListRecoveryDUnitTest.fail("failed while registering keys", ex);
        }
    }

    public static void unregisterK1toK3() {
        try {
            LocalRegion r = (LocalRegion)cache.getRegion("/InterestListRecoveryDUnitTest_region");
            for (int i = 1; i < 4; ++i) {
                r.unregisterInterest((Object)("key-" + i));
            }
        }
        catch (Exception ex) {
            InterestListRecoveryDUnitTest.fail("failed while un-registering keys", ex);
        }
    }

    public static void setServerUnavailable(String server) {
        try {
            throw new Exception("nyi");
        }
        catch (Exception ex) {
            InterestListRecoveryDUnitTest.fail("while setting server unavailable  " + server, ex);
            return;
        }
    }

    public static void setServerAvailable(String server) {
        try {
            throw new Exception("nyi");
        }
        catch (Exception ex) {
            InterestListRecoveryDUnitTest.fail("while setting server available  " + server, ex);
            return;
        }
    }

    public static void killCurrentEndpoint() {
        try {
            Region r1 = cache.getRegion("/InterestListRecoveryDUnitTest_region");
            String poolName = r1.getAttributes().getPoolName();
            InterestListRecoveryDUnitTest.assertNotNull((Object)poolName);
            pool = (PoolImpl)PoolManager.find((String)poolName);
            InterestListRecoveryDUnitTest.assertNotNull((Object)pool);
            pool.killPrimaryEndpoint();
        }
        catch (Exception ex) {
            InterestListRecoveryDUnitTest.fail((String)("while killCurrentEndpoint  " + ex));
        }
    }

    public static void put(String key) {
        try {
            Region r1 = cache.getRegion("/InterestListRecoveryDUnitTest_region");
            r1.put((Object)key, (Object)("server-" + key));
        }
        catch (Exception ex) {
            InterestListRecoveryDUnitTest.fail("failed while r.put()", ex);
        }
    }

    public static void verifyRegionToProxyMapForFullRegistrationRetry() {
        DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                try {
                    InterestListRecoveryDUnitTest.verifyRegionToProxyMapForFullRegistration();
                    return true;
                }
                catch (VirtualMachineError e) {
                    SystemFailure.initiateFailure((Error)e);
                    throw e;
                }
                catch (Error e) {
                    return false;
                }
                catch (RuntimeException re) {
                    return false;
                }
            }

            @Override
            public String description() {
                return null;
            }
        };
        DistributedTestCase.waitForCriterion(ev, 20000L, 200L, true);
    }

    public static void verifyRegionToProxyMapForFullRegistration() {
        Iterator iter = InterestListRecoveryDUnitTest.getCacheClientProxies().iterator();
        if (iter.hasNext()) {
            Set keys = InterestListRecoveryDUnitTest.getKeysOfInterestMap((CacheClientProxy)iter.next(), "/InterestListRecoveryDUnitTest_region");
            InterestListRecoveryDUnitTest.assertNotNull((Object)keys);
            InterestListRecoveryDUnitTest.assertTrue((boolean)keys.contains("key-1"));
            InterestListRecoveryDUnitTest.assertTrue((boolean)keys.contains("key-2"));
            InterestListRecoveryDUnitTest.assertTrue((boolean)keys.contains("key-3"));
            InterestListRecoveryDUnitTest.assertTrue((boolean)keys.contains("key-4"));
            InterestListRecoveryDUnitTest.assertTrue((boolean)keys.contains("key-5"));
        }
    }

    public static void verifyRegisterK4toK5Retry() {
        DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                try {
                    InterestListRecoveryDUnitTest.verifyRegisterK4toK5();
                    return true;
                }
                catch (VirtualMachineError e) {
                    SystemFailure.initiateFailure((Error)e);
                    throw e;
                }
                catch (Error e) {
                    return false;
                }
                catch (RuntimeException re) {
                    return false;
                }
            }

            @Override
            public String description() {
                return "verifyRegisterK4toK5Retry";
            }
        };
        DistributedTestCase.waitForCriterion(ev, 20000L, 200L, true);
    }

    public static void verifyRegisterK4toK5() {
        Iterator iter = InterestListRecoveryDUnitTest.getCacheClientProxies().iterator();
        if (iter.hasNext()) {
            Set keysMap = InterestListRecoveryDUnitTest.getKeysOfInterestMap((CacheClientProxy)iter.next(), "/InterestListRecoveryDUnitTest_region");
            InterestListRecoveryDUnitTest.assertNotNull((Object)keysMap);
            InterestListRecoveryDUnitTest.assertFalse((boolean)keysMap.contains("key-1"));
            InterestListRecoveryDUnitTest.assertFalse((boolean)keysMap.contains("key-2"));
            InterestListRecoveryDUnitTest.assertFalse((boolean)keysMap.contains("key-3"));
            InterestListRecoveryDUnitTest.assertTrue((boolean)keysMap.contains("key-4"));
            InterestListRecoveryDUnitTest.assertTrue((boolean)keysMap.contains("key-5"));
        }
    }

    public static void verifyRegionToProxyMapForNoRegistrationRetry() {
        DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                try {
                    InterestListRecoveryDUnitTest.verifyRegionToProxyMapForNoRegistration();
                    return true;
                }
                catch (VirtualMachineError e) {
                    SystemFailure.initiateFailure((Error)e);
                    throw e;
                }
                catch (Error e) {
                    return false;
                }
                catch (RuntimeException re) {
                    return false;
                }
            }

            @Override
            public String description() {
                return null;
            }
        };
        DistributedTestCase.waitForCriterion(ev, 20000L, 200L, true);
    }

    public static void verifyRegionToProxyMapForNoRegistration() {
        Set keysMap;
        Iterator iter = InterestListRecoveryDUnitTest.getCacheClientProxies().iterator();
        if (iter.hasNext() && (keysMap = InterestListRecoveryDUnitTest.getKeysOfInterestMap((CacheClientProxy)iter.next(), "/InterestListRecoveryDUnitTest_region")) != null) {
            InterestListRecoveryDUnitTest.assertFalse((boolean)keysMap.contains("key-1"));
            InterestListRecoveryDUnitTest.assertFalse((boolean)keysMap.contains("key-2"));
            InterestListRecoveryDUnitTest.assertFalse((boolean)keysMap.contains("key-3"));
            InterestListRecoveryDUnitTest.assertFalse((boolean)keysMap.contains("key-4"));
            InterestListRecoveryDUnitTest.assertFalse((boolean)keysMap.contains("key-5"));
        }
    }

    public static Set getCacheClientProxies() {
        Cache c = CacheFactory.getAnyInstance();
        InterestListRecoveryDUnitTest.assertEquals((String)"More than one BridgeServer", (int)1, (int)c.getBridgeServers().size());
        BridgeServerImpl bs = (BridgeServerImpl)c.getBridgeServers().iterator().next();
        InterestListRecoveryDUnitTest.assertNotNull((Object)bs);
        InterestListRecoveryDUnitTest.assertNotNull((Object)bs.getAcceptor());
        InterestListRecoveryDUnitTest.assertNotNull((Object)bs.getAcceptor().getCacheClientNotifier());
        return new HashSet(bs.getAcceptor().getCacheClientNotifier().getClientProxies());
    }

    public static Set getKeysOfInterestMap(CacheClientProxy proxy, String regionName) {
        return proxy.cils[0].getProfile(regionName).getKeysOfInterestFor((Object)proxy.getProxyID());
    }

    @Override
    public void tearDown2() throws Exception {
        this.server2.invoke(InterestListRecoveryDUnitTest.class, "closeCache");
        InterestListRecoveryDUnitTest.closeCache();
        this.server1.invoke(InterestListRecoveryDUnitTest.class, "closeCache");
    }

    public static void closeCache() {
        if (cache != null && !cache.isClosed()) {
            cache.close();
            cache.getDistributedSystem().disconnect();
        }
    }

    public static void verifyDeadAndLiveServers(int expectedDeadServers, final int expectedLiveServers) {
        DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){
            String excuse;

            @Override
            public boolean done() {
                int sz = pool.getConnectedServerCount();
                return sz == expectedLiveServers;
            }

            @Override
            public String description() {
                return this.excuse;
            }
        };
        DistributedTestCase.waitForCriterion(wc, 60000L, 1000L, true);
    }
}

