/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.NoSubscriptionServersAvailableException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache.client.internal.Connection;
import com.gemstone.gemfire.cache.client.internal.PoolImpl;
import com.gemstone.gemfire.cache.util.BridgeServer;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.ServerLocation;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.cache.BridgeObserver;
import com.gemstone.gemfire.internal.cache.BridgeObserverAdapter;
import com.gemstone.gemfire.internal.cache.BridgeObserverHolder;
import com.gemstone.gemfire.internal.cache.BridgeServerImpl;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheClientNotifier;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheClientProxy;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheServerTestUtil;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;

public class HAStartupAndFailoverDUnitTest
extends DistributedTestCase {
    protected static Cache cache = null;
    VM server1 = null;
    VM server2 = null;
    VM server3 = null;
    protected static PoolImpl pool = null;
    private static Connection conn = null;
    private static Integer PORT1;
    private static Integer PORT2;
    private static Integer PORT3;
    protected static boolean identifiedPrimary;
    private static final String REGION_NAME = "HAStartupAndFailoverDUnitTest_region";

    public HAStartupAndFailoverDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        Host host = Host.getHost(0);
        this.server1 = host.getVM(0);
        this.server2 = host.getVM(1);
        this.server3 = host.getVM(2);
        PORT1 = (Integer)this.server1.invoke(HAStartupAndFailoverDUnitTest.class, "createServerCache");
        PORT2 = (Integer)this.server2.invoke(HAStartupAndFailoverDUnitTest.class, "createServerCache");
        PORT3 = (Integer)this.server3.invoke(HAStartupAndFailoverDUnitTest.class, "createServerCache");
        CacheServerTestUtil.disableShufflingOfEndpoints();
    }

    public void testPrimaryFailover() throws Exception {
        HAStartupAndFailoverDUnitTest.createClientCache(this.getName(), HAStartupAndFailoverDUnitTest.getServerHostName(this.server1.getHost()));
        this.server1.invoke(HAStartupAndFailoverDUnitTest.class, "verifyDispatcherIsAlive");
        this.server2.invoke(HAStartupAndFailoverDUnitTest.class, "verifyDispatcherIsNotAlive");
        this.server3.invoke(HAStartupAndFailoverDUnitTest.class, "verifyDispatcherIsNotAlive");
        HAStartupAndFailoverDUnitTest.setBridgeObserver();
        this.server1.invoke(HAStartupAndFailoverDUnitTest.class, "stopServer");
        HAStartupAndFailoverDUnitTest.waitForPrimaryIdentification();
        this.server2.invoke(HAStartupAndFailoverDUnitTest.class, "verifyDispatcherIsAlive");
        HAStartupAndFailoverDUnitTest.unSetBridgeObserver();
        this.server3.invoke(HAStartupAndFailoverDUnitTest.class, "verifyDispatcherIsNotAlive");
        HAStartupAndFailoverDUnitTest.setBridgeObserver();
        this.server2.invoke(HAStartupAndFailoverDUnitTest.class, "stopServer");
        HAStartupAndFailoverDUnitTest.waitForPrimaryIdentification();
        this.server3.invoke(HAStartupAndFailoverDUnitTest.class, "verifyDispatcherIsAlive");
        HAStartupAndFailoverDUnitTest.unSetBridgeObserver();
        this.server3.invoke(HAStartupAndFailoverDUnitTest.class, "stopServer");
        HAStartupAndFailoverDUnitTest.verifyDeadAndLiveServers(3, 0);
        this.server3.invoke(HAStartupAndFailoverDUnitTest.class, "startServer");
        HAStartupAndFailoverDUnitTest.verifyDeadAndLiveServers(2, 1);
        this.server3.invoke(HAStartupAndFailoverDUnitTest.class, "verifyDispatcherIsAlive");
    }

    public void testExceptionWhileMakingPrimary() throws Exception {
        HAStartupAndFailoverDUnitTest.createClientCacheWithIncorrectPrimary(this.getName(), HAStartupAndFailoverDUnitTest.getServerHostName(this.server1.getHost()));
        this.server2.invoke(HAStartupAndFailoverDUnitTest.class, "verifyDispatcherIsAlive");
        this.server3.invoke(HAStartupAndFailoverDUnitTest.class, "verifyDispatcherIsNotAlive");
        HAStartupAndFailoverDUnitTest.setBridgeObserver();
        this.server2.invoke(HAStartupAndFailoverDUnitTest.class, "stopServer");
        HAStartupAndFailoverDUnitTest.waitForPrimaryIdentification();
        this.server3.invoke(HAStartupAndFailoverDUnitTest.class, "verifyDispatcherIsAlive");
        HAStartupAndFailoverDUnitTest.unSetBridgeObserver();
    }

    public void testTwoPrimaryFailedOneAfterTheAnother() throws Exception {
        HAStartupAndFailoverDUnitTest.createClientCacheWithLargeRetryInterval(this.getName(), HAStartupAndFailoverDUnitTest.getServerHostName(this.server1.getHost()));
        this.server1.invoke(HAStartupAndFailoverDUnitTest.class, "verifyDispatcherIsAlive");
        this.server2.invoke(HAStartupAndFailoverDUnitTest.class, "verifyDispatcherIsNotAlive");
        this.server3.invoke(HAStartupAndFailoverDUnitTest.class, "verifyDispatcherIsNotAlive");
        HAStartupAndFailoverDUnitTest.setBridgeObserver();
        this.server1.invoke(HAStartupAndFailoverDUnitTest.class, "stopServer");
        this.server2.invoke(HAStartupAndFailoverDUnitTest.class, "stopServer");
        HAStartupAndFailoverDUnitTest.waitForPrimaryIdentification();
        this.server3.invoke(HAStartupAndFailoverDUnitTest.class, "verifyDispatcherIsAlive");
        HAStartupAndFailoverDUnitTest.unSetBridgeObserver();
    }

    public void testPrimaryShouldBeNullAndEPListShouldBeEmptyWhenAllServersAreDead() throws Exception {
        HAStartupAndFailoverDUnitTest.createClientCache(this.getName(), HAStartupAndFailoverDUnitTest.getServerHostName(this.server1.getHost()));
        HAStartupAndFailoverDUnitTest.verifyPrimaryShouldNotBeNullAndEPListShouldNotBeEmpty();
        this.server1.invoke(HAStartupAndFailoverDUnitTest.class, "stopServer");
        this.server2.invoke(HAStartupAndFailoverDUnitTest.class, "stopServer");
        this.server3.invoke(HAStartupAndFailoverDUnitTest.class, "stopServer");
        HAStartupAndFailoverDUnitTest.verifyDeadAndLiveServers(3, 0);
        HAStartupAndFailoverDUnitTest.verifyPrimaryShouldBeNullAndEPListShouldBeEmpty();
    }

    public void testCacheClientUpdatersInitiatesFailoverOnPrimaryFailure() throws Exception {
        HAStartupAndFailoverDUnitTest.createClientCacheWithLargeRetryInterval(this.getName(), HAStartupAndFailoverDUnitTest.getServerHostName(this.server1.getHost()));
        this.server1.invoke(HAStartupAndFailoverDUnitTest.class, "verifyDispatcherIsAlive");
        this.server2.invoke(HAStartupAndFailoverDUnitTest.class, "verifyDispatcherIsNotAlive");
        this.server3.invoke(HAStartupAndFailoverDUnitTest.class, "verifyDispatcherIsNotAlive");
        HAStartupAndFailoverDUnitTest.setBridgeObserver();
        this.server1.invoke(HAStartupAndFailoverDUnitTest.class, "stopServer");
        HAStartupAndFailoverDUnitTest.waitForPrimaryIdentification();
        HAStartupAndFailoverDUnitTest.unSetBridgeObserver();
        HAStartupAndFailoverDUnitTest.verifyDeadAndLiveServers(1, 2);
        this.server2.invoke(HAStartupAndFailoverDUnitTest.class, "verifyDispatcherIsAlive");
    }

    public void testCacheClientUpdaterInitiatesFailoverOnSecondaryFailure() throws Exception {
        HAStartupAndFailoverDUnitTest.createClientCacheWithLargeRetryInterval(this.getName(), HAStartupAndFailoverDUnitTest.getServerHostName(this.server1.getHost()));
        this.server1.invoke(HAStartupAndFailoverDUnitTest.class, "verifyDispatcherIsAlive");
        this.server2.invoke(HAStartupAndFailoverDUnitTest.class, "verifyDispatcherIsNotAlive");
        this.server3.invoke(HAStartupAndFailoverDUnitTest.class, "verifyDispatcherIsNotAlive");
        this.server2.invoke(HAStartupAndFailoverDUnitTest.class, "stopServer");
        HAStartupAndFailoverDUnitTest.verifyDeadAndLiveServers(1, 2);
        this.server1.invoke(HAStartupAndFailoverDUnitTest.class, "verifyDispatcherIsAlive");
        this.server3.invoke(HAStartupAndFailoverDUnitTest.class, "verifyDispatcherIsNotAlive");
    }

    public void testCacheClientUpdaterInitiatesFailoverOnBothPrimaryAndSecondaryFailure() throws Exception {
        HAStartupAndFailoverDUnitTest.createClientCacheWithLargeRetryInterval(this.getName(), HAStartupAndFailoverDUnitTest.getServerHostName(this.server1.getHost()));
        this.server1.invoke(HAStartupAndFailoverDUnitTest.class, "verifyDispatcherIsAlive");
        this.server2.invoke(HAStartupAndFailoverDUnitTest.class, "verifyDispatcherIsNotAlive");
        this.server3.invoke(HAStartupAndFailoverDUnitTest.class, "verifyDispatcherIsNotAlive");
        this.server1.invoke(HAStartupAndFailoverDUnitTest.class, "stopServer");
        this.server2.invoke(HAStartupAndFailoverDUnitTest.class, "stopServer");
        HAStartupAndFailoverDUnitTest.verifyDeadAndLiveServers(2, 1);
        this.server3.invoke(HAStartupAndFailoverDUnitTest.class, "verifyDispatcherIsAlive");
    }

    public void testCacheClientUpdaterInitiatesFailoverOnBothPrimaryAndSecondaryFailureWithServerMonitors() throws Exception {
        HAStartupAndFailoverDUnitTest.createClientCache(this.getName(), HAStartupAndFailoverDUnitTest.getServerHostName(this.server1.getHost()));
        this.server1.invoke(HAStartupAndFailoverDUnitTest.class, "verifyDispatcherIsAlive");
        this.server2.invoke(HAStartupAndFailoverDUnitTest.class, "verifyDispatcherIsNotAlive");
        this.server3.invoke(HAStartupAndFailoverDUnitTest.class, "verifyDispatcherIsNotAlive");
        this.server1.invoke(HAStartupAndFailoverDUnitTest.class, "stopServer");
        this.server2.invoke(HAStartupAndFailoverDUnitTest.class, "stopServer");
        HAStartupAndFailoverDUnitTest.verifyDeadAndLiveServers(2, 1);
        this.server3.invoke(HAStartupAndFailoverDUnitTest.class, "verifyDispatcherIsAlive");
    }

    public void testInitiateFailoverByCacheOperationThreads_Secondary() throws Exception {
        HAStartupAndFailoverDUnitTest.createClientCacheWithLargeRetryIntervalAndWithoutCallbackConnection(this.getName(), HAStartupAndFailoverDUnitTest.getServerHostName(this.server1.getHost()));
        this.server2.invoke(HAStartupAndFailoverDUnitTest.class, "stopServer");
        HAStartupAndFailoverDUnitTest.put();
        HAStartupAndFailoverDUnitTest.verifyDeadAndLiveServers(1, 2);
    }

    public static void put() {
        try {
            Region r1 = cache.getRegion("/HAStartupAndFailoverDUnitTest_region");
            r1.put((Object)"key-1", (Object)"server-value-1");
            r1.put((Object)"key-2", (Object)"server-value-2");
            r1.put((Object)"key-3", (Object)"server-value-3");
        }
        catch (Exception ex) {
            HAStartupAndFailoverDUnitTest.fail("failed while r.put()", ex);
        }
    }

    public static void verifyDeadAndLiveServers(int expectedDeadServers, final int expectedLiveServers) {
        DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){
            String excuse;

            @Override
            public boolean done() {
                return pool.getConnectedServerCount() == expectedLiveServers;
            }

            @Override
            public String description() {
                return this.excuse;
            }
        };
        DistributedTestCase.waitForCriterion(wc, 60000L, 1000L, true);
    }

    public static void setBridgeObserver() {
        PoolImpl.AFTER_PRIMARY_IDENTIFICATION_FROM_BACKUP_CALLBACK_FLAG = true;
        BridgeObserverHolder.setInstance((BridgeObserver)new BridgeObserverAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void afterPrimaryIdentificationFromBackup(ServerLocation primaryEndpoint) {
                Class<HAStartupAndFailoverDUnitTest> clazz = HAStartupAndFailoverDUnitTest.class;
                synchronized (HAStartupAndFailoverDUnitTest.class) {
                    identifiedPrimary = true;
                    HAStartupAndFailoverDUnitTest.class.notify();
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unSetBridgeObserver() {
        Class<HAStartupAndFailoverDUnitTest> clazz = HAStartupAndFailoverDUnitTest.class;
        synchronized (HAStartupAndFailoverDUnitTest.class) {
            PoolImpl.AFTER_PRIMARY_IDENTIFICATION_FROM_BACKUP_CALLBACK_FLAG = false;
            identifiedPrimary = false;
            BridgeObserverHolder.setInstance((BridgeObserver)new BridgeObserverAdapter());
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static void stopServer() {
        try {
            HAStartupAndFailoverDUnitTest.assertEquals((String)"Expected exactly one BridgeServer", (int)1, (int)cache.getBridgeServers().size());
            BridgeServerImpl bs = (BridgeServerImpl)cache.getBridgeServers().iterator().next();
            HAStartupAndFailoverDUnitTest.assertNotNull((Object)bs);
            bs.stop();
        }
        catch (Exception ex) {
            HAStartupAndFailoverDUnitTest.fail((String)("while setting stopServer  " + ex));
        }
    }

    public static void verifyPrimaryShouldNotBeNullAndEPListShouldNotBeEmpty() {
        try {
            HAStartupAndFailoverDUnitTest.assertNotNull((String)" Primary endpoint should not be null", (Object)pool.getPrimaryName());
            HAStartupAndFailoverDUnitTest.assertTrue((String)"Endpoint List should not be Empty as all server are live", (pool.getConnectedServerCount() > 0 ? 1 : 0) != 0);
        }
        catch (Exception e) {
            HAStartupAndFailoverDUnitTest.fail("failed while verifyPrimaryShouldNotBeNullAndEPListShouldNotBeEmpty()", e);
        }
    }

    public static void verifyPrimaryShouldBeNullAndEPListShouldBeEmpty() {
        try {
            HAStartupAndFailoverDUnitTest.assertNull((String)"Primary endpoint should be null as all server are dead", (Object)pool.getPrimaryName());
            HAStartupAndFailoverDUnitTest.assertEquals((String)"Endpoint List should be Empty as all server are dead", (int)0, (int)pool.getConnectedServerCount());
        }
        catch (NoSubscriptionServersAvailableException noSubscriptionServersAvailableException) {
        }
        catch (Exception e) {
            HAStartupAndFailoverDUnitTest.fail("failed while verifyPrimaryShouldBeNullAndEPListShouldBeEmpty()", e);
        }
    }

    public static void startServer() {
        try {
            Cache c = CacheFactory.getAnyInstance();
            HAStartupAndFailoverDUnitTest.assertEquals((String)"Expected exactly one BridgeServer", (int)1, (int)c.getBridgeServers().size());
            BridgeServerImpl bs = (BridgeServerImpl)c.getBridgeServers().iterator().next();
            HAStartupAndFailoverDUnitTest.assertNotNull((Object)bs);
            bs.start();
        }
        catch (Exception ex) {
            HAStartupAndFailoverDUnitTest.fail((String)("while startServer()  " + ex));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void waitForPrimaryIdentification() {
        HAStartupAndFailoverDUnitTest.assertNotNull((Object)cache);
        if (identifiedPrimary) return;
        Class<HAStartupAndFailoverDUnitTest> clazz = HAStartupAndFailoverDUnitTest.class;
        synchronized (HAStartupAndFailoverDUnitTest.class) {
            if (identifiedPrimary) return;
            int MAX_WAIT = 60000;
            try {
                HAStartupAndFailoverDUnitTest.class.wait(60000L);
            }
            catch (InterruptedException e) {
                HAStartupAndFailoverDUnitTest.fail((String)"Test failed due to InterruptedException in waitForPrimaryIdentification()");
            }
            if (identifiedPrimary) return;
            HAStartupAndFailoverDUnitTest.fail((String)"timed out after waiting 60000 millisecs for primary to be identified");
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static void verifyDispatcherIsAlive() {
        try {
            DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){
                String excuse;

                @Override
                public boolean done() {
                    return cache.getBridgeServers().size() == 1;
                }

                @Override
                public String description() {
                    return this.excuse;
                }
            };
            DistributedTestCase.waitForCriterion(wc, 60000L, 1000L, true);
            BridgeServerImpl bs = (BridgeServerImpl)cache.getBridgeServers().iterator().next();
            HAStartupAndFailoverDUnitTest.assertNotNull((Object)bs);
            HAStartupAndFailoverDUnitTest.assertNotNull((Object)bs.getAcceptor());
            HAStartupAndFailoverDUnitTest.assertNotNull((Object)bs.getAcceptor().getCacheClientNotifier());
            final CacheClientNotifier ccn = bs.getAcceptor().getCacheClientNotifier();
            wc = new DistributedTestCase.WaitCriterion(){
                String excuse;

                @Override
                public boolean done() {
                    return ccn.getClientProxies().size() > 0;
                }

                @Override
                public String description() {
                    return this.excuse;
                }
            };
            DistributedTestCase.waitForCriterion(wc, 60000L, 1000L, true);
            Collection proxies = ccn.getClientProxies();
            Iterator iter_prox = proxies.iterator();
            if (iter_prox.hasNext()) {
                final CacheClientProxy proxy = (CacheClientProxy)iter_prox.next();
                wc = new DistributedTestCase.WaitCriterion(){
                    String excuse;

                    @Override
                    public boolean done() {
                        return proxy._messageDispatcher.isAlive();
                    }

                    @Override
                    public String description() {
                        return this.excuse;
                    }
                };
                DistributedTestCase.waitForCriterion(wc, 60000L, 1000L, true);
            }
        }
        catch (Exception ex) {
            HAStartupAndFailoverDUnitTest.fail((String)("while setting verifyDispatcherIsAlive  " + ex));
        }
    }

    public static void verifyDispatcherIsNotAlive() {
        try {
            Cache c = CacheFactory.getAnyInstance();
            DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){
                String excuse;

                @Override
                public boolean done() {
                    return cache.getBridgeServers().size() == 1;
                }

                @Override
                public String description() {
                    return this.excuse;
                }
            };
            DistributedTestCase.waitForCriterion(wc, 60000L, 1000L, true);
            BridgeServerImpl bs = (BridgeServerImpl)c.getBridgeServers().iterator().next();
            HAStartupAndFailoverDUnitTest.assertNotNull((Object)bs);
            HAStartupAndFailoverDUnitTest.assertNotNull((Object)bs.getAcceptor());
            HAStartupAndFailoverDUnitTest.assertNotNull((Object)bs.getAcceptor().getCacheClientNotifier());
            final CacheClientNotifier ccn = bs.getAcceptor().getCacheClientNotifier();
            wc = new DistributedTestCase.WaitCriterion(){
                String excuse;

                @Override
                public boolean done() {
                    return ccn.getClientProxies().size() > 0;
                }

                @Override
                public String description() {
                    return this.excuse;
                }
            };
            DistributedTestCase.waitForCriterion(wc, 60000L, 1000L, true);
            Iterator iter_prox = ccn.getClientProxies().iterator();
            if (iter_prox.hasNext()) {
                CacheClientProxy proxy = (CacheClientProxy)iter_prox.next();
                HAStartupAndFailoverDUnitTest.assertFalse((String)"Dispatcher on secondary should not be alive", (boolean)proxy._messageDispatcher.isAlive());
            }
        }
        catch (Exception ex) {
            HAStartupAndFailoverDUnitTest.fail((String)("while setting verifyDispatcherIsNotAlive  " + ex));
        }
    }

    private void createCache(Properties props) throws Exception {
        InternalDistributedSystem ds = this.getSystem(props);
        HAStartupAndFailoverDUnitTest.assertNotNull((Object)ds);
        ds.disconnect();
        ds = this.getSystem(props);
        cache = CacheFactory.create((DistributedSystem)ds);
        HAStartupAndFailoverDUnitTest.assertNotNull((Object)cache);
    }

    public static void createClientCache(String testName, String host) throws Exception {
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "");
        new HAStartupAndFailoverDUnitTest("temp").createCache(props);
        PoolImpl p = (PoolImpl)PoolManager.createFactory().addServer(host, PORT1.intValue()).addServer(host, PORT2.intValue()).addServer(host, PORT3.intValue()).setSubscriptionEnabled(true).setSubscriptionRedundancy(-1).setReadTimeout(10000).create("HAStartupAndFailoverDUnitTestPool");
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.LOCAL);
        factory.setPoolName(p.getName());
        RegionAttributes attrs = factory.create();
        cache.createRegion(REGION_NAME, attrs);
        pool = p;
        conn = pool.acquireConnection();
        HAStartupAndFailoverDUnitTest.assertNotNull((Object)conn);
    }

    public static void createClientCacheWithLargeRetryInterval(String testName, String host) throws Exception {
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "");
        new HAStartupAndFailoverDUnitTest("temp").createCache(props);
        PoolImpl p = (PoolImpl)PoolManager.createFactory().addServer(host, PORT1.intValue()).addServer(host, PORT2.intValue()).addServer(host, PORT3.intValue()).setSubscriptionEnabled(true).setSubscriptionRedundancy(-1).setReadTimeout(10000).create("HAStartupAndFailoverDUnitTestPool");
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.LOCAL);
        factory.setPoolName(p.getName());
        RegionAttributes attrs = factory.create();
        cache.createRegion(REGION_NAME, attrs);
        pool = p;
        conn = pool.acquireConnection();
        HAStartupAndFailoverDUnitTest.assertNotNull((Object)conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createClientCacheWithLargeRetryIntervalAndWithoutCallbackConnection(String testName, String host) throws Exception {
        PoolImpl p;
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "");
        new HAStartupAndFailoverDUnitTest("temp").createCache(props);
        CacheServerTestUtil.disableShufflingOfEndpoints();
        try {
            p = (PoolImpl)PoolManager.createFactory().addServer(host, PORT1.intValue()).addServer(host, PORT2.intValue()).addServer(host, PORT3.intValue()).setReadTimeout(10000).create("HAStartupAndFailoverDUnitTestPool");
        }
        finally {
            CacheServerTestUtil.enableShufflingOfEndpoints();
        }
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.LOCAL);
        factory.setPoolName(p.getName());
        RegionAttributes attrs = factory.create();
        cache.createRegion(REGION_NAME, attrs);
        pool = p;
        conn = pool.acquireConnection();
        HAStartupAndFailoverDUnitTest.assertNotNull((Object)conn);
    }

    public static void createClientCacheWithIncorrectPrimary(String testName, String host) throws Exception {
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "");
        new HAStartupAndFailoverDUnitTest("temp").createCache(props);
        boolean INCORRECT_PORT = true;
        PoolImpl p = (PoolImpl)PoolManager.createFactory().addServer(host, 1).addServer(host, PORT2.intValue()).addServer(host, PORT3.intValue()).setSubscriptionEnabled(true).setSubscriptionRedundancy(-1).setReadTimeout(10000).create("HAStartupAndFailoverDUnitTestPool");
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.LOCAL);
        factory.setPoolName(p.getName());
        RegionAttributes attrs = factory.create();
        cache.createRegion(REGION_NAME, attrs);
        pool = p;
        conn = pool.acquireConnection();
        HAStartupAndFailoverDUnitTest.assertNotNull((Object)conn);
    }

    public static Integer createServerCache() throws Exception {
        new HAStartupAndFailoverDUnitTest("temp").createCache(new Properties());
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setEnableBridgeConflation(true);
        factory.setDataPolicy(DataPolicy.REPLICATE);
        RegionAttributes attrs = factory.create();
        cache.createRegion(REGION_NAME, attrs);
        BridgeServer server1 = cache.addBridgeServer();
        int port = AvailablePort.getRandomAvailablePort((int)0);
        server1.setPort(port);
        server1.setNotifyBySubscription(true);
        server1.setMaximumTimeBetweenPings(180000);
        server1.start();
        return new Integer(server1.getPort());
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
        HAStartupAndFailoverDUnitTest.closeCache();
        this.server1.invoke(HAStartupAndFailoverDUnitTest.class, "closeCache");
        this.server2.invoke(HAStartupAndFailoverDUnitTest.class, "closeCache");
        this.server3.invoke(HAStartupAndFailoverDUnitTest.class, "closeCache");
        CacheServerTestUtil.resetDisableShufflingOfEndpointsFlag();
    }

    public static void closeCache() {
        if (cache != null && !cache.isClosed()) {
            PoolImpl.AFTER_PRIMARY_IDENTIFICATION_FROM_BACKUP_CALLBACK_FLAG = false;
            identifiedPrimary = false;
            cache.close();
            cache.getDistributedSystem().disconnect();
        }
    }

    static {
        identifiedPrimary = false;
    }
}

