/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.MirrorType;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.cache.EnumListenerEvent;
import com.gemstone.gemfire.internal.cache.EventID;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.HARegion;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.ha.HAHelper;
import com.gemstone.gemfire.internal.cache.ha.HARegionQueue;
import com.gemstone.gemfire.internal.cache.tier.sockets.ClientProxyMembershipID;
import com.gemstone.gemfire.internal.cache.tier.sockets.ClientUpdateMessage;
import com.gemstone.gemfire.internal.cache.tier.sockets.ClientUpdateMessageImpl;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import hydra.Log;
import java.util.Properties;

public class HABug36738DUnitTest
extends DistributedTestCase {
    static VM server1 = null;
    static VM server2 = null;
    private static int NO_OF_PUTS = 10;
    private static final String REGION_NAME = "HABug36738DUnitTest_Region";
    protected static Cache cache = null;
    protected static HARegionQueue messageQueue = null;
    static Region haRegion = null;
    static final String HAREGION_NAME = "haRegion";

    public HABug36738DUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        Host host = Host.getHost(0);
        server1 = host.getVM(0);
        server2 = host.getVM(1);
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
        server1.invoke(HABug36738DUnitTest.class, "closeCache");
        server2.invoke(HABug36738DUnitTest.class, "closeCache");
    }

    public void testBug36768() throws Exception {
        this.createServer1();
        HABug36738DUnitTest.pause(10000);
        server1.invoke(HABug36738DUnitTest.class, "checkRegionQueueSize");
        this.createServer2();
        server1.invoke(HABug36738DUnitTest.class, "checkRegionQueueSize");
        server2.invoke(HABug36738DUnitTest.class, "checkRegionQueueSize");
        server2.invoke(HABug36738DUnitTest.class, "printRecs");
    }

    public static void printRecs() {
        HARegion region = (HARegion)cache.getRegion("/" + HAHelper.getRegionQueueName(HAREGION_NAME));
        HABug36738DUnitTest.assertNotNull((Object)region);
        for (Object key : region.keys()) {
            ClientUpdateMessage value = (ClientUpdateMessage)region.get(key);
            Log.getLogWriter().info("key : " + key + "Value " + value.getValue());
        }
    }

    private void createServer1() throws Exception {
        server1.invoke(HABug36738DUnitTest.class, "createServerCache", new Object[]{new Boolean(true)});
    }

    private void createServer2() throws Exception {
        server2.invoke(HABug36738DUnitTest.class, "createServerCache", new Object[]{new Boolean(false)});
    }

    public static void createServerCache(Boolean isRegion) throws Exception {
        new HABug36738DUnitTest("temp").createCache(new Properties());
        if (isRegion.booleanValue()) {
            AttributesFactory factory = new AttributesFactory();
            factory.setScope(Scope.DISTRIBUTED_ACK);
            factory.setEnableConflation(true);
            factory.setDataPolicy(DataPolicy.REPLICATE);
            RegionAttributes attrs = factory.createRegionAttributes();
            cache.createVMRegion(REGION_NAME, attrs);
        }
        AttributesFactory factoryForHARegion = new AttributesFactory();
        factoryForHARegion.setMirrorType(MirrorType.KEYS_VALUES);
        factoryForHARegion.setScope(Scope.DISTRIBUTED_ACK);
        RegionAttributes ra = factoryForHARegion.createRegionAttributes();
        haRegion = HARegion.getInstance((String)HAREGION_NAME, (GemFireCacheImpl)((GemFireCacheImpl)cache), null, (RegionAttributes)ra);
        if (isRegion.booleanValue()) {
            for (int i = 0; i < NO_OF_PUTS; ++i) {
                ClientUpdateMessageImpl clientMessage = new ClientUpdateMessageImpl(EnumListenerEvent.AFTER_UPDATE, (LocalRegion)haRegion, null, (Object)("value" + i).getBytes(), 1, null, new ClientProxyMembershipID(), new EventID(("memberID" + i).getBytes(), (long)i, (long)i), null);
                haRegion.put((Object)new Long(i), (Object)clientMessage);
                Log.getLogWriter().info("Putting in the message Queue");
            }
        }
    }

    private void createCache(Properties props) throws Exception {
        InternalDistributedSystem ds = this.getSystem(props);
        HABug36738DUnitTest.assertNotNull((Object)ds);
        ds.disconnect();
        ds = this.getSystem(props);
        cache = CacheFactory.create((DistributedSystem)ds);
        HABug36738DUnitTest.assertNotNull((Object)cache);
    }

    public static void closeCache() {
        if (cache != null && !cache.isClosed()) {
            cache.close();
            cache.getDistributedSystem().disconnect();
        }
    }

    public static void checkRegionQueueSize() {
        HARegion region = (HARegion)cache.getRegion("/" + HAHelper.getRegionQueueName(HAREGION_NAME));
        HABug36738DUnitTest.assertNotNull((Object)region);
        Log.getLogWriter().info("Size of the Queue : " + region.size());
    }
}

