/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.InterestResultPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.client.Pool;
import com.gemstone.gemfire.cache.client.PoolFactory;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.cache.BridgeServerImpl;
import com.gemstone.gemfire.internal.cache.PoolFactoryImpl;
import com.gemstone.gemfire.internal.cache.tier.sockets.AcceptorImpl;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheClientNotifier;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheClientNotifierStats;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheServerTestUtil;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import java.util.ArrayList;
import java.util.Properties;
import java.util.concurrent.RejectedExecutionException;

public class DurableClientStatsDUnitTest
extends DistributedTestCase {
    private VM server1VM;
    private VM durableClientVM;
    private String regionName;
    private int PORT1;
    private final String K1 = "Key1";

    public DurableClientStatsDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        Host host = Host.getHost(0);
        this.server1VM = host.getVM(0);
        this.durableClientVM = host.getVM(1);
        this.regionName = DurableClientStatsDUnitTest.class.getName() + "_region";
        CacheServerTestUtil.disableShufflingOfEndpoints();
    }

    @Override
    public void tearDown2() throws Exception {
        this.server1VM.invoke(CacheServerTestUtil.class, "closeCache");
        CacheServerTestUtil.resetDisableShufflingOfEndpointsFlag();
    }

    public void testNonDurableClientStatistics() {
        int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
        this.PORT1 = (Integer)this.server1VM.invoke(CacheServerTestUtil.class, "createCacheServer", new Object[]{this.regionName, new Boolean(true), new Integer(mcastPort)});
        this.server1VM.invoke(DurableClientStatsDUnitTest.class, "checkStatistics");
        int durableClientTimeout = 600;
        this.startAndCloseNonDurableClientCache(600);
        this.startAndCloseNonDurableClientCache(1);
        DurableClientStatsDUnitTest.pause(1400);
        this.startAndCloseNonDurableClientCache(1);
        DurableClientStatsDUnitTest.pause(1400);
        this.startRegisterAndCloseNonDurableClientCache(600);
        DurableClientStatsDUnitTest.pause(500);
        this.server1VM.invoke(DurableClientStatsDUnitTest.class, "putValue", new Object[]{"Key1", "Value1"});
        DurableClientStatsDUnitTest.pause(500);
        this.startAndCloseNonDurableClientCache(1);
        DurableClientStatsDUnitTest.pause(1400);
        this.startAndCloseNonDurableClientCache(1);
        DurableClientStatsDUnitTest.pause(1400);
        this.startRegisterAndCloseNonDurableClientCache(600);
        DurableClientStatsDUnitTest.pause(500);
        this.server1VM.invoke(DurableClientStatsDUnitTest.class, "putValue", new Object[]{"Key1", "NewValue1"});
        this.startAndCloseNonDurableClientCache(600);
        this.server1VM.invoke(DurableClientStatsDUnitTest.class, "checkStatisticsWithExpectedValues", new Object[]{new Integer(0), new Integer(0), new Integer(0)});
    }

    public void testDurableClientStatistics() {
        int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
        this.PORT1 = (Integer)this.server1VM.invoke(CacheServerTestUtil.class, "createCacheServer", new Object[]{this.regionName, new Boolean(true), new Integer(mcastPort)});
        this.server1VM.invoke(DurableClientStatsDUnitTest.class, "checkStatistics");
        int durableClientTimeout = 600;
        this.startAndCloseDurableClientCache(600);
        this.startAndCloseDurableClientCache(1);
        DurableClientStatsDUnitTest.pause(1400);
        this.startAndCloseDurableClientCache(1);
        DurableClientStatsDUnitTest.pause(1400);
        this.startRegisterAndCloseDurableClientCache(600);
        DurableClientStatsDUnitTest.pause(500);
        this.server1VM.invoke(DurableClientStatsDUnitTest.class, "putValue", new Object[]{"Key1", "Value1"});
        DurableClientStatsDUnitTest.pause(500);
        this.startAndCloseDurableClientCache(1);
        DurableClientStatsDUnitTest.pause(1400);
        this.startAndCloseDurableClientCache(1);
        DurableClientStatsDUnitTest.pause(1400);
        this.startRegisterAndCloseDurableClientCache(600);
        DurableClientStatsDUnitTest.pause(500);
        this.server1VM.invoke(DurableClientStatsDUnitTest.class, "putValue", new Object[]{"Key1", "NewValue1"});
        this.startAndCloseDurableClientCache(600);
        this.server1VM.invoke(DurableClientStatsDUnitTest.class, "checkStatisticsWithExpectedValues", new Object[]{new Integer(3), new Integer(4), new Integer(2)});
    }

    public void startRegisterAndCloseDurableClientCache(int durableClientTimeout) {
        String durableClientId = this.getName() + "_client";
        this.durableClientVM.invoke(CacheServerTestUtil.class, "createCacheClient", new Object[]{this.getClientPool(DurableClientStatsDUnitTest.getServerHostName(this.durableClientVM.getHost()), this.PORT1, true, 0), this.regionName, this.getDurableClientDistributedSystemProperties(durableClientId, durableClientTimeout), Boolean.TRUE});
        this.durableClientVM.invoke(new CacheSerializableRunnable("Send clientReady"){

            @Override
            public void run2() throws CacheException {
                CacheServerTestUtil.getCache().readyForEvents();
            }
        });
        this.durableClientVM.invoke(DurableClientStatsDUnitTest.class, "registerKey", new Object[]{"Key1", new Boolean(true)});
        this.durableClientVM.invoke(DurableClientStatsDUnitTest.class, "closeCache");
    }

    public void startRegisterAndCloseNonDurableClientCache(int durableClientTimeout) {
        String durableClientId = this.getName() + "_client";
        this.durableClientVM.invoke(CacheServerTestUtil.class, "createCacheClient", new Object[]{this.getClientPool(DurableClientStatsDUnitTest.getServerHostName(this.durableClientVM.getHost()), this.PORT1, true, 0), this.regionName, this.getNonDurableClientDistributedSystemProperties(durableClientId, durableClientTimeout), Boolean.TRUE});
        this.durableClientVM.invoke(DurableClientStatsDUnitTest.class, "registerKey", new Object[]{"Key1", new Boolean(false)});
        this.durableClientVM.invoke(DurableClientStatsDUnitTest.class, "closeCache");
    }

    public void startAndCloseDurableClientCache(int durableClientTimeout) {
        String durableClientId = this.getName() + "_client";
        this.durableClientVM.invoke(CacheServerTestUtil.class, "createCacheClient", new Object[]{this.getClientPool(DurableClientStatsDUnitTest.getServerHostName(this.durableClientVM.getHost()), this.PORT1, true, 0), this.regionName, this.getDurableClientDistributedSystemProperties(durableClientId, durableClientTimeout), Boolean.TRUE});
        this.durableClientVM.invoke(new CacheSerializableRunnable("Send clientReady"){

            @Override
            public void run2() throws CacheException {
                CacheServerTestUtil.getCache().readyForEvents();
            }
        });
        this.durableClientVM.invoke(DurableClientStatsDUnitTest.class, "closeCache");
    }

    public void startAndCloseNonDurableClientCache(int durableClientTimeout) {
        String durableClientId = this.getName() + "_client";
        this.durableClientVM.invoke(CacheServerTestUtil.class, "createCacheClient", new Object[]{this.getClientPool(DurableClientStatsDUnitTest.getServerHostName(this.durableClientVM.getHost()), this.PORT1, true, 0), this.regionName, this.getNonDurableClientDistributedSystemProperties(durableClientId, durableClientTimeout), Boolean.TRUE});
        this.durableClientVM.invoke(DurableClientStatsDUnitTest.class, "closeCache");
    }

    public static void checkStatistics() {
        try {
            Cache cache = CacheServerTestUtil.getCache();
            LogWriter logger = cache.getLogger();
            BridgeServerImpl currentServer = (BridgeServerImpl)new ArrayList(cache.getBridgeServers()).get(0);
            AcceptorImpl ai = currentServer.getAcceptor();
            CacheClientNotifier notifier = ai.getCacheClientNotifier();
            CacheClientNotifierStats stats = notifier.getStats();
            logger.info("Stats:\nDurableReconnectionCount:" + stats.get_durableReconnectionCount() + "\nQueueDroppedCount" + stats.get_queueDroppedCount() + "\nEventsEnqueuedWhileClientAwayCount" + stats.get_eventEnqueuedWhileClientAwayCount());
        }
        catch (Exception e) {
            DurableClientStatsDUnitTest.fail((String)"Exception thrown while executing checkStatistics()");
        }
    }

    public static void checkStatisticsWithExpectedValues(int reconnectionCount, int queueDropCount, int enqueueCount) {
        try {
            Cache cache = CacheServerTestUtil.getCache();
            LogWriter logger = cache.getLogger();
            BridgeServerImpl currentServer = (BridgeServerImpl)new ArrayList(cache.getBridgeServers()).get(0);
            AcceptorImpl ai = currentServer.getAcceptor();
            CacheClientNotifier notifier = ai.getCacheClientNotifier();
            CacheClientNotifierStats stats = notifier.getStats();
            logger.info("Stats:\nDurableReconnectionCount:" + stats.get_durableReconnectionCount() + "\nQueueDroppedCount" + stats.get_queueDroppedCount() + "\nEventsEnqueuedWhileClientAwayCount" + stats.get_eventEnqueuedWhileClientAwayCount());
            DurableClientStatsDUnitTest.assertEquals((int)reconnectionCount, (int)stats.get_durableReconnectionCount());
            DurableClientStatsDUnitTest.assertEquals((int)queueDropCount, (int)stats.get_queueDroppedCount());
            DurableClientStatsDUnitTest.assertEquals((int)enqueueCount, (int)stats.get_eventEnqueuedWhileClientAwayCount());
        }
        catch (Exception e) {
            DurableClientStatsDUnitTest.fail((String)"Exception thrown while executing checkStatisticsWithExpectedValues()");
        }
    }

    public static void closeCache() {
        Cache cache = CacheServerTestUtil.getCache();
        if (cache != null && !cache.isClosed()) {
            cache.getLogger().info("<ExpectedException action=add>" + RejectedExecutionException.class.getName() + "</ExpectedException>");
            cache.close(true);
            cache.getDistributedSystem().disconnect();
        }
    }

    private static void registerKey(String key, boolean isDurable) throws Exception {
        try {
            Region region = CacheServerTestUtil.getCache().getRegion(DurableClientStatsDUnitTest.class.getName() + "_region");
            DurableClientStatsDUnitTest.assertNotNull((Object)region);
            region.registerInterest((Object)key, InterestResultPolicy.NONE, isDurable);
        }
        catch (Exception ex) {
            DurableClientStatsDUnitTest.fail("failed while registering interest in registerKey function", ex);
        }
    }

    private static void putValue(String key, String value) {
        try {
            Region r = CacheServerTestUtil.getCache().getRegion(DurableClientStatsDUnitTest.class.getName() + "_region");
            DurableClientStatsDUnitTest.assertNotNull((Object)r);
            if (r.getEntry((Object)key) != null) {
                r.put((Object)key, (Object)value);
            } else {
                r.create((Object)key, (Object)value);
            }
            DurableClientStatsDUnitTest.assertEquals((Object)value, (Object)r.getEntry((Object)key).getValue());
        }
        catch (Exception e) {
            DurableClientStatsDUnitTest.fail((String)"Put in Server has some fight");
        }
    }

    private Pool getClientPool(String host, int server1Port, boolean establishCallbackConnection, int redundancyLevel) {
        PoolFactory pf = PoolManager.createFactory();
        pf.addServer(host, server1Port).setSubscriptionEnabled(establishCallbackConnection).setSubscriptionRedundancy(redundancyLevel);
        return ((PoolFactoryImpl)pf).getPoolAttributes();
    }

    private Properties getDurableClientDistributedSystemProperties(String durableClientId, int durableClientTimeout) {
        Properties properties = new Properties();
        properties.setProperty("mcast-port", "0");
        properties.setProperty("locators", "");
        properties.setProperty("durable-client-id", durableClientId);
        properties.setProperty("durable-client-timeout", String.valueOf(durableClientTimeout));
        return properties;
    }

    private Properties getNonDurableClientDistributedSystemProperties(String durableClientId, int durableClientTimeout) {
        Properties properties = new Properties();
        properties.setProperty("mcast-port", "0");
        properties.setProperty("locators", "");
        return properties;
    }
}

