/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets;

import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.InterestResultPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.client.Pool;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache.client.ServerRefusedConnectionException;
import com.gemstone.gemfire.cache.client.internal.PoolImpl;
import com.gemstone.gemfire.cache.query.CqAttributes;
import com.gemstone.gemfire.cache.query.CqAttributesFactory;
import com.gemstone.gemfire.cache.query.CqException;
import com.gemstone.gemfire.cache.query.CqExistsException;
import com.gemstone.gemfire.cache.query.CqListener;
import com.gemstone.gemfire.cache.query.CqQuery;
import com.gemstone.gemfire.cache.query.QueryService;
import com.gemstone.gemfire.cache.query.RegionNotFoundException;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.internal.cache.PoolFactoryImpl;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheClientNotifier;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheClientProxy;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheServerTestUtil;
import com.gemstone.gemfire.internal.cache.tier.sockets.ClientProxyMembershipID;
import com.gemstone.gemfire.internal.cache.tier.sockets.DurableClientDUnitTest;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import dunit.AsyncInvocation;
import dunit.DistributedTestCase;
import dunit.VM;
import junit.framework.TestCase;

public class DurableClientSimpleDUnitTests
extends DurableClientDUnitTest {
    public DurableClientSimpleDUnitTests(String name) {
        super(name);
    }

    public void testSimpleDurableClientUpdate() {
        int serverPort = (Integer)this.server1VM.invoke(CacheServerTestUtil.class, "createCacheServer", new Object[]{this.regionName, new Boolean(true)});
        String durableClientId = this.getName() + "_client";
        this.durableClientVM.invoke(CacheServerTestUtil.class, "createCacheClient", new Object[]{this.getClientPool(DurableClientSimpleDUnitTests.getServerHostName(this.durableClientVM.getHost()), serverPort, true), this.regionName, this.getClientDistributedSystemProperties(durableClientId), Boolean.TRUE});
        this.durableClientVM.invoke(new CacheSerializableRunnable("Send clientReady"){

            @Override
            public void run2() throws CacheException {
                CacheServerTestUtil.getCache().readyForEvents();
            }
        });
        this.durableClientVM.invoke(new CacheSerializableRunnable("Register interest"){

            @Override
            public void run2() throws CacheException {
                Region region = CacheServerTestUtil.getCache().getRegion(DurableClientSimpleDUnitTests.this.regionName);
                TestCase.assertNotNull((Object)region);
                region.registerInterestRegex(".*", InterestResultPolicy.NONE, true);
            }
        });
        this.publisherClientVM.invoke(CacheServerTestUtil.class, "createCacheClient", new Object[]{this.getClientPool(DurableClientSimpleDUnitTests.getServerHostName(this.publisherClientVM.getHost()), serverPort, false), this.regionName});
        int numberOfEntries = 10;
        this.publisherClientVM.invoke(new CacheSerializableRunnable("Register interest"){

            @Override
            public void run2() throws CacheException {
                Region region = CacheServerTestUtil.getCache().getRegion(DurableClientSimpleDUnitTests.this.regionName);
                TestCase.assertNotNull((Object)region);
                for (int i = 0; i < 10; ++i) {
                    String keyAndValue = String.valueOf(i);
                    region.put((Object)keyAndValue, (Object)keyAndValue);
                }
            }
        });
        this.durableClientVM.invoke(new CacheSerializableRunnable("Verify updates"){

            @Override
            public void run2() throws CacheException {
                Region region = CacheServerTestUtil.getCache().getRegion(DurableClientSimpleDUnitTests.this.regionName);
                TestCase.assertNotNull((Object)region);
                CacheServerTestUtil.ControlListener listener = (CacheServerTestUtil.ControlListener)region.getAttributes().getCacheListeners()[0];
                listener.waitWhileNotEnoughEvents(30000L, 10);
                TestCase.assertEquals((int)10, (int)listener.events.size());
            }
        });
        this.durableClientVM.invoke(CacheServerTestUtil.class, "closeCache");
        this.publisherClientVM.invoke(CacheServerTestUtil.class, "closeCache");
        this.server1VM.invoke(CacheServerTestUtil.class, "closeCache");
    }

    @Override
    public void testMultipleBridgeClientsInSingleDurableVM() {
        int serverPort = (Integer)this.server1VM.invoke(CacheServerTestUtil.class, "createCacheServer", new Object[]{this.regionName, new Boolean(true)});
        final String durableClientId = this.getName() + "_client";
        String regionName1 = this.regionName + "1";
        String regionName2 = this.regionName + "2";
        this.durableClientVM.invoke(CacheServerTestUtil.class, "createCacheClients", new Object[]{this.getClientPool(DurableClientSimpleDUnitTests.getServerHostName(this.durableClientVM.getHost()), serverPort, true), regionName1, regionName2, this.getClientDistributedSystemProperties(durableClientId)});
        this.durableClientVM.invoke(new CacheSerializableRunnable("Send clientReady"){

            @Override
            public void run2() throws CacheException {
                TestCase.assertEquals((int)2, (int)PoolManager.getAll().size());
                CacheServerTestUtil.getCache().readyForEvents();
            }
        });
        this.server1VM.invoke(new CacheSerializableRunnable("Verify durable client"){

            @Override
            public void run2() throws CacheException {
                CacheClientNotifier notifier = DurableClientDUnitTest.getBridgeServer().getAcceptor().getCacheClientNotifier();
                DurableClientDUnitTest.checkNumberOfClientProxies(2);
                String firstProxyRegionName = null;
                for (CacheClientProxy proxy : notifier.getClientProxies()) {
                    TestCase.assertTrue((boolean)proxy.isDurable());
                    TestCase.assertEquals((String)durableClientId, (String)proxy.getDurableId());
                    TestCase.assertEquals((int)300, (int)proxy.getDurableTimeout());
                    if (firstProxyRegionName == null) {
                        firstProxyRegionName = proxy.getHARegionName();
                        continue;
                    }
                    TestCase.assertTrue((!firstProxyRegionName.equals(proxy.getHARegionName()) ? 1 : 0) != 0);
                }
            }
        });
        this.durableClientVM.invoke(CacheServerTestUtil.class, "closeCache");
        this.server1VM.invoke(new CacheSerializableRunnable("Verify durable client"){

            @Override
            public void run2() throws CacheException {
                DurableClientDUnitTest.checkNumberOfClientProxies(0);
            }
        });
        this.server1VM.invoke(CacheServerTestUtil.class, "closeCache");
    }

    @Override
    public void XtestMultipleVMsWithSameDurableId() {
        final int serverPort = (Integer)this.server1VM.invoke(CacheServerTestUtil.class, "createCacheServer", new Object[]{this.regionName, new Boolean(true)});
        final String durableClientId = this.getName() + "_client";
        this.durableClientVM.invoke(CacheServerTestUtil.class, "createCacheClient", new Object[]{this.getClientPool(DurableClientSimpleDUnitTests.getServerHostName(this.durableClientVM.getHost()), serverPort, true), this.regionName, this.getClientDistributedSystemProperties(durableClientId), Boolean.TRUE});
        this.durableClientVM.invoke(new CacheSerializableRunnable("Send clientReady"){

            @Override
            public void run2() throws CacheException {
                CacheServerTestUtil.getCache().readyForEvents();
            }
        });
        this.durableClientVM.invoke(new CacheSerializableRunnable("Register interest"){

            @Override
            public void run2() throws CacheException {
                Region region = CacheServerTestUtil.getCache().getRegion(DurableClientSimpleDUnitTests.this.regionName);
                TestCase.assertNotNull((Object)region);
                region.registerInterestRegex(".*", InterestResultPolicy.NONE);
            }
        });
        this.publisherClientVM.invoke(new CacheSerializableRunnable("Create another durable client"){

            @Override
            public void run2() throws CacheException {
                DurableClientSimpleDUnitTests.this.getSystem(DurableClientSimpleDUnitTests.this.getClientDistributedSystemProperties(durableClientId));
                PoolFactoryImpl pf = (PoolFactoryImpl)PoolManager.createFactory();
                pf.init(DurableClientSimpleDUnitTests.this.getClientPool(DistributedTestCase.getServerHostName(DurableClientSimpleDUnitTests.this.publisherClientVM.getHost()), serverPort, true));
                try {
                    pf.create("uncreatablePool");
                    TestCase.fail((String)"Should not have been able to create the pool");
                }
                catch (ServerRefusedConnectionException e) {
                    DistributedTestCase.disconnectFromDS();
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Should not have gotten here", e);
                }
            }
        });
        this.server1VM.invoke(new CacheSerializableRunnable("Verify durable client"){

            @Override
            public void run2() throws CacheException {
                DurableClientDUnitTest.checkNumberOfClientProxies(1);
                CacheClientProxy proxy = DurableClientDUnitTest.getClientProxy();
                TestCase.assertNotNull((Object)proxy);
                TestCase.assertTrue((boolean)proxy.isDurable());
                TestCase.assertEquals((String)durableClientId, (String)proxy.getDurableId());
                TestCase.assertEquals((int)300, (int)proxy.getDurableTimeout());
            }
        });
        this.publisherClientVM.invoke(CacheServerTestUtil.class, "createCacheClient", new Object[]{this.getClientPool(DurableClientSimpleDUnitTests.getServerHostName(this.publisherClientVM.getHost()), serverPort, false), this.regionName});
        int numberOfEntries = 10;
        this.publisherClientVM.invoke(new CacheSerializableRunnable("Register interest"){

            @Override
            public void run2() throws CacheException {
                Region region = CacheServerTestUtil.getCache().getRegion(DurableClientSimpleDUnitTests.this.regionName);
                TestCase.assertNotNull((Object)region);
                for (int i = 0; i < 10; ++i) {
                    String keyAndValue = String.valueOf(i);
                    region.put((Object)keyAndValue, (Object)keyAndValue);
                }
            }
        });
        this.durableClientVM.invoke(new CacheSerializableRunnable("Verify updates"){

            @Override
            public void run2() throws CacheException {
                Region region = CacheServerTestUtil.getCache().getRegion(DurableClientSimpleDUnitTests.this.regionName);
                TestCase.assertNotNull((Object)region);
                CacheServerTestUtil.ControlListener listener = (CacheServerTestUtil.ControlListener)region.getAttributes().getCacheListeners()[0];
                listener.waitWhileNotEnoughEvents(30000L, 10);
                TestCase.assertEquals((int)10, (int)listener.events.size());
            }
        });
        this.publisherClientVM.invoke(CacheServerTestUtil.class, "closeCache");
        this.durableClientVM.invoke(CacheServerTestUtil.class, "closeCache");
        this.server1VM.invoke(new CacheSerializableRunnable("Verify durable client"){

            @Override
            public void run2() throws CacheException {
                DurableClientDUnitTest.checkNumberOfClientProxies(0);
                CacheClientProxy proxy = DurableClientDUnitTest.getClientProxy();
                TestCase.assertNull((Object)proxy);
            }
        });
        this.server1VM.invoke(CacheServerTestUtil.class, "closeCache");
    }

    @Override
    public void testSimpleTwoDurableClients() {
        int serverPort = (Integer)this.server1VM.invoke(CacheServerTestUtil.class, "createCacheServer", new Object[]{this.regionName, new Boolean(true)});
        final String durableClientId = this.getName() + "_client";
        this.durableClientVM.invoke(CacheServerTestUtil.class, "createCacheClient", new Object[]{this.getClientPool(DurableClientSimpleDUnitTests.getServerHostName(this.durableClientVM.getHost()), serverPort, true), this.regionName, this.getClientDistributedSystemProperties(durableClientId)});
        this.durableClientVM.invoke(new CacheSerializableRunnable("Send clientReady"){

            @Override
            public void run2() throws CacheException {
                CacheServerTestUtil.getCache().readyForEvents();
            }
        });
        VM durableClient2VM = this.publisherClientVM;
        final String durableClientId2 = this.getName() + "_client2";
        durableClient2VM.invoke(CacheServerTestUtil.class, "createCacheClient", new Object[]{this.getClientPool(DurableClientSimpleDUnitTests.getServerHostName(durableClient2VM.getHost()), serverPort, true), this.regionName, this.getClientDistributedSystemProperties(durableClientId2)});
        durableClient2VM.invoke(new CacheSerializableRunnable("Send clientReady"){

            @Override
            public void run2() throws CacheException {
                CacheServerTestUtil.getCache().readyForEvents();
            }
        });
        this.server1VM.invoke(new CacheSerializableRunnable("Verify durable client"){

            @Override
            public void run2() throws CacheException {
                CacheClientNotifier notifier = DurableClientDUnitTest.getBridgeServer().getAcceptor().getCacheClientNotifier();
                DurableClientDUnitTest.checkNumberOfClientProxies(2);
                boolean durableClient1Found = false;
                boolean durableClient2Found = false;
                for (CacheClientProxy proxy : notifier.getClientProxies()) {
                    TestCase.assertTrue((boolean)proxy.isDurable());
                    if (proxy.getDurableId().equals(durableClientId)) {
                        durableClient1Found = true;
                    }
                    if (proxy.getDurableId().equals(durableClientId2)) {
                        durableClient2Found = true;
                    }
                    TestCase.assertEquals((int)300, (int)proxy.getDurableTimeout());
                }
                TestCase.assertTrue((boolean)durableClient1Found);
                TestCase.assertTrue((boolean)durableClient2Found);
            }
        });
        this.durableClientVM.invoke(CacheServerTestUtil.class, "closeCache");
        durableClient2VM.invoke(CacheServerTestUtil.class, "closeCache");
        this.server1VM.invoke(new CacheSerializableRunnable("Verify durable client"){

            @Override
            public void run2() throws CacheException {
                DurableClientDUnitTest.checkNumberOfClientProxies(0);
            }
        });
        this.server1VM.invoke(CacheServerTestUtil.class, "closeCache");
    }

    public void testDurableClientMultipleServersOneLive() {
        int server1Port = (Integer)this.server1VM.invoke(CacheServerTestUtil.class, "createCacheServer", new Object[]{this.regionName, new Boolean(true)});
        int server2Port = (Integer)this.server2VM.invoke(CacheServerTestUtil.class, "createCacheServer", new Object[]{this.regionName, new Boolean(true)});
        this.server2VM.invoke(CacheServerTestUtil.class, "closeCache");
        final String durableClientId = this.getName() + "_client";
        int durableClientTimeout = 60;
        this.durableClientVM.invoke(CacheServerTestUtil.class, "createCacheClient", new Object[]{this.getClientPool(DurableClientSimpleDUnitTests.getServerHostName(this.durableClientVM.getHost()), server1Port, server2Port, true), this.regionName, this.getClientDistributedSystemProperties(durableClientId, 60), Boolean.TRUE});
        this.durableClientVM.invoke(new CacheSerializableRunnable("Send clientReady"){

            @Override
            public void run2() throws CacheException {
                CacheServerTestUtil.getCache().readyForEvents();
            }
        });
        this.durableClientVM.invoke(new CacheSerializableRunnable("Register interest"){

            @Override
            public void run2() throws CacheException {
                Region region = CacheServerTestUtil.getCache().getRegion(DurableClientSimpleDUnitTests.this.regionName);
                TestCase.assertNotNull((Object)region);
                region.registerInterestRegex(".*", InterestResultPolicy.NONE, true);
            }
        });
        this.server1VM.invoke(new CacheSerializableRunnable("Verify durable client"){

            @Override
            public void run2() throws CacheException {
                DurableClientDUnitTest.checkNumberOfClientProxies(1);
                CacheClientProxy proxy = DurableClientDUnitTest.getClientProxy();
                TestCase.assertNotNull((Object)proxy);
                TestCase.assertTrue((boolean)proxy.isDurable());
                TestCase.assertEquals((String)durableClientId, (String)proxy.getDurableId());
                TestCase.assertEquals((int)60, (int)proxy.getDurableTimeout());
            }
        });
        this.publisherClientVM.invoke(CacheServerTestUtil.class, "createCacheClient", new Object[]{this.getClientPool(DurableClientSimpleDUnitTests.getServerHostName(this.publisherClientVM.getHost()), server1Port, server2Port, false), this.regionName});
        int numberOfEntries = 10;
        this.publisherClientVM.invoke(new CacheSerializableRunnable("Register interest"){

            @Override
            public void run2() throws CacheException {
                Region region = CacheServerTestUtil.getCache().getRegion(DurableClientSimpleDUnitTests.this.regionName);
                TestCase.assertNotNull((Object)region);
                for (int i = 0; i < 10; ++i) {
                    String keyAndValue = String.valueOf(i);
                    region.put((Object)keyAndValue, (Object)keyAndValue);
                }
            }
        });
        this.durableClientVM.invoke(new CacheSerializableRunnable("Verify updates"){

            @Override
            public void run2() throws CacheException {
                Region region = CacheServerTestUtil.getCache().getRegion(DurableClientSimpleDUnitTests.this.regionName);
                TestCase.assertNotNull((Object)region);
                CacheServerTestUtil.ControlListener listener = (CacheServerTestUtil.ControlListener)region.getAttributes().getCacheListeners()[0];
                listener.waitWhileNotEnoughEvents(30000L, 10);
                TestCase.assertEquals((int)10, (int)listener.events.size());
            }
        });
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException ex) {
            DurableClientSimpleDUnitTests.fail((String)"interrupted");
        }
        this.durableClientVM.invoke(CacheServerTestUtil.class, "closeCache", new Object[]{new Boolean(true)});
        this.server1VM.invoke(new CacheSerializableRunnable("Verify durable client"){

            @Override
            public void run2() throws CacheException {
                CacheClientProxy proxy = DurableClientDUnitTest.getClientProxy();
                TestCase.assertNotNull((Object)proxy);
            }
        });
        this.publisherClientVM.invoke(new CacheSerializableRunnable("Register interest"){

            @Override
            public void run2() throws CacheException {
                Region region = CacheServerTestUtil.getCache().getRegion(DurableClientSimpleDUnitTests.this.regionName);
                TestCase.assertNotNull((Object)region);
                for (int i = 0; i < 10; ++i) {
                    String keyAndValue = String.valueOf(i);
                    region.put((Object)keyAndValue, (Object)keyAndValue);
                }
            }
        });
        this.durableClientVM.invoke(CacheServerTestUtil.class, "createCacheClient", new Object[]{this.getClientPool(DurableClientSimpleDUnitTests.getServerHostName(this.durableClientVM.getHost()), server1Port, server2Port, true), this.regionName, this.getClientDistributedSystemProperties(durableClientId), Boolean.TRUE});
        this.durableClientVM.invoke(new CacheSerializableRunnable("Send clientReady"){

            @Override
            public void run2() throws CacheException {
                CacheServerTestUtil.getCache().readyForEvents();
            }
        });
        this.server1VM.invoke(new CacheSerializableRunnable("Verify durable client"){

            @Override
            public void run2() throws CacheException {
                DurableClientDUnitTest.checkNumberOfClientProxies(1);
                CacheClientProxy proxy = DurableClientDUnitTest.getClientProxy();
                TestCase.assertNotNull((Object)proxy);
                TestCase.assertTrue((boolean)proxy.isDurable());
                TestCase.assertEquals((String)durableClientId, (String)proxy.getDurableId());
            }
        });
        this.durableClientVM.invoke(new CacheSerializableRunnable("Verify updates"){

            @Override
            public void run2() throws CacheException {
                Region region = CacheServerTestUtil.getCache().getRegion(DurableClientSimpleDUnitTests.this.regionName);
                TestCase.assertNotNull((Object)region);
                CacheServerTestUtil.ControlListener listener = (CacheServerTestUtil.ControlListener)region.getAttributes().getCacheListeners()[0];
                listener.waitWhileNotEnoughEvents(30000L, 10);
                TestCase.assertEquals((int)10, (int)listener.events.size());
            }
        });
        this.durableClientVM.invoke(CacheServerTestUtil.class, "closeCache");
        this.publisherClientVM.invoke(CacheServerTestUtil.class, "closeCache");
        this.server1VM.invoke(CacheServerTestUtil.class, "closeCache");
    }

    public void testTwoDurableClientsStartStopUpdate() {
        int serverPort = (Integer)this.server1VM.invoke(CacheServerTestUtil.class, "createCacheServer", new Object[]{this.regionName, new Boolean(true)});
        final String durableClientId = this.getName() + "_client";
        int durableClientTimeout = 60;
        this.durableClientVM.invoke(CacheServerTestUtil.class, "createCacheClient", new Object[]{this.getClientPool(DurableClientSimpleDUnitTests.getServerHostName(this.durableClientVM.getHost()), serverPort, true), this.regionName, this.getClientDistributedSystemProperties(durableClientId, 60), Boolean.TRUE});
        this.durableClientVM.invoke(new CacheSerializableRunnable("Send clientReady"){

            @Override
            public void run2() throws CacheException {
                CacheServerTestUtil.getCache().readyForEvents();
            }
        });
        this.durableClientVM.invoke(new CacheSerializableRunnable("Register interest"){

            @Override
            public void run2() throws CacheException {
                Region region = CacheServerTestUtil.getCache().getRegion(DurableClientSimpleDUnitTests.this.regionName);
                TestCase.assertNotNull((Object)region);
                region.registerInterestRegex(".*", InterestResultPolicy.NONE, true);
            }
        });
        VM durableClient2VM = this.server2VM;
        final String durableClientId2 = this.getName() + "_client2";
        durableClient2VM.invoke(CacheServerTestUtil.class, "createCacheClient", new Object[]{this.getClientPool(DurableClientSimpleDUnitTests.getServerHostName(durableClient2VM.getHost()), serverPort, true), this.regionName, this.getClientDistributedSystemProperties(durableClientId2, 60), Boolean.TRUE});
        durableClient2VM.invoke(new CacheSerializableRunnable("Send clientReady"){

            @Override
            public void run2() throws CacheException {
                CacheServerTestUtil.getCache().readyForEvents();
            }
        });
        durableClient2VM.invoke(new CacheSerializableRunnable("Register interest"){

            @Override
            public void run2() throws CacheException {
                Region region = CacheServerTestUtil.getCache().getRegion(DurableClientSimpleDUnitTests.this.regionName);
                TestCase.assertNotNull((Object)region);
                region.registerInterestRegex(".*", InterestResultPolicy.NONE, true);
            }
        });
        this.server1VM.invoke(new CacheSerializableRunnable("Verify durable client"){

            @Override
            public void run2() throws CacheException {
                CacheClientNotifier notifier = DurableClientDUnitTest.getBridgeServer().getAcceptor().getCacheClientNotifier();
                DurableClientDUnitTest.checkNumberOfClientProxies(2);
                boolean durableClient1Found = false;
                boolean durableClient2Found = false;
                for (CacheClientProxy proxy : notifier.getClientProxies()) {
                    TestCase.assertTrue((boolean)proxy.isDurable());
                    if (proxy.getDurableId().equals(durableClientId)) {
                        durableClient1Found = true;
                    }
                    if (proxy.getDurableId().equals(durableClientId2)) {
                        durableClient2Found = true;
                    }
                    TestCase.assertEquals((int)60, (int)proxy.getDurableTimeout());
                }
                TestCase.assertTrue((boolean)durableClient1Found);
                TestCase.assertTrue((boolean)durableClient2Found);
            }
        });
        this.publisherClientVM.invoke(CacheServerTestUtil.class, "createCacheClient", new Object[]{this.getClientPool(DurableClientSimpleDUnitTests.getServerHostName(this.publisherClientVM.getHost()), serverPort, false), this.regionName});
        int numberOfEntries = 10;
        this.publisherClientVM.invoke(new CacheSerializableRunnable("Register interest"){

            @Override
            public void run2() throws CacheException {
                Region region = CacheServerTestUtil.getCache().getRegion(DurableClientSimpleDUnitTests.this.regionName);
                TestCase.assertNotNull((Object)region);
                for (int i = 0; i < 10; ++i) {
                    String keyAndValue = String.valueOf(i);
                    region.put((Object)keyAndValue, (Object)keyAndValue);
                }
            }
        });
        this.durableClientVM.invoke(new CacheSerializableRunnable("Verify updates"){

            @Override
            public void run2() throws CacheException {
                Region region = CacheServerTestUtil.getCache().getRegion(DurableClientSimpleDUnitTests.this.regionName);
                TestCase.assertNotNull((Object)region);
                CacheServerTestUtil.ControlListener listener = (CacheServerTestUtil.ControlListener)region.getAttributes().getCacheListeners()[0];
                listener.waitWhileNotEnoughEvents(30000L, 10);
                TestCase.assertEquals((int)10, (int)listener.events.size());
            }
        });
        durableClient2VM.invoke(new CacheSerializableRunnable("Verify updates"){

            @Override
            public void run2() throws CacheException {
                Region region = CacheServerTestUtil.getCache().getRegion(DurableClientSimpleDUnitTests.this.regionName);
                TestCase.assertNotNull((Object)region);
                CacheServerTestUtil.ControlListener listener = (CacheServerTestUtil.ControlListener)region.getAttributes().getCacheListeners()[0];
                listener.waitWhileNotEnoughEvents(30000L, 10);
                TestCase.assertEquals((int)10, (int)listener.events.size());
            }
        });
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException ex) {
            DurableClientSimpleDUnitTests.fail((String)"interrupted");
        }
        this.durableClientVM.invoke(CacheServerTestUtil.class, "closeCache", new Object[]{new Boolean(true)});
        durableClient2VM.invoke(CacheServerTestUtil.class, "closeCache", new Object[]{new Boolean(true)});
        this.server1VM.invoke(new CacheSerializableRunnable("Verify durable client"){

            @Override
            public void run2() throws CacheException {
                CacheClientNotifier notifier = DurableClientDUnitTest.getBridgeServer().getAcceptor().getCacheClientNotifier();
                DurableClientDUnitTest.checkNumberOfClientProxies(2);
                boolean durableClient1Found = false;
                boolean durableClient2Found = false;
                for (CacheClientProxy proxy : notifier.getClientProxies()) {
                    TestCase.assertTrue((boolean)proxy.isDurable());
                    if (proxy.getDurableId().equals(durableClientId)) {
                        durableClient1Found = true;
                    }
                    if (proxy.getDurableId().equals(durableClientId2)) {
                        durableClient2Found = true;
                    }
                    TestCase.assertEquals((int)60, (int)proxy.getDurableTimeout());
                }
                TestCase.assertTrue((boolean)durableClient1Found);
                TestCase.assertTrue((boolean)durableClient2Found);
            }
        });
        this.publisherClientVM.invoke(new CacheSerializableRunnable("Register interest"){

            @Override
            public void run2() throws CacheException {
                Region region = CacheServerTestUtil.getCache().getRegion(DurableClientSimpleDUnitTests.this.regionName);
                TestCase.assertNotNull((Object)region);
                for (int i = 0; i < 10; ++i) {
                    String keyAndValue = String.valueOf(i);
                    region.put((Object)keyAndValue, (Object)keyAndValue);
                }
            }
        });
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException ex) {
            DurableClientSimpleDUnitTests.fail((String)"interrupted");
        }
        this.server1VM.invoke(new CacheSerializableRunnable("Verify durable client"){

            @Override
            public void run2() throws CacheException {
                CacheClientNotifier notifier = DurableClientDUnitTest.getBridgeServer().getAcceptor().getCacheClientNotifier();
                DurableClientDUnitTest.checkNumberOfClientProxies(2);
                for (CacheClientProxy proxy : notifier.getClientProxies()) {
                    TestCase.assertEquals((int)10, (int)proxy.getQueueSize());
                }
            }
        });
        this.durableClientVM.invoke(CacheServerTestUtil.class, "createCacheClient", new Object[]{this.getClientPool(DurableClientSimpleDUnitTests.getServerHostName(this.durableClientVM.getHost()), serverPort, true), this.regionName, this.getClientDistributedSystemProperties(durableClientId), Boolean.TRUE});
        this.durableClientVM.invoke(new CacheSerializableRunnable("Send clientReady"){

            @Override
            public void run2() throws CacheException {
                CacheServerTestUtil.getCache().readyForEvents();
            }
        });
        durableClient2VM.invoke(CacheServerTestUtil.class, "createCacheClient", new Object[]{this.getClientPool(DurableClientSimpleDUnitTests.getServerHostName(durableClient2VM.getHost()), serverPort, true), this.regionName, this.getClientDistributedSystemProperties(durableClientId2), Boolean.TRUE});
        durableClient2VM.invoke(new CacheSerializableRunnable("Send clientReady"){

            @Override
            public void run2() throws CacheException {
                CacheServerTestUtil.getCache().readyForEvents();
            }
        });
        this.durableClientVM.invoke(new CacheSerializableRunnable("Verify updates"){

            @Override
            public void run2() throws CacheException {
                Region region = CacheServerTestUtil.getCache().getRegion(DurableClientSimpleDUnitTests.this.regionName);
                TestCase.assertNotNull((Object)region);
                CacheServerTestUtil.ControlListener listener = (CacheServerTestUtil.ControlListener)region.getAttributes().getCacheListeners()[0];
                listener.waitWhileNotEnoughEvents(30000L, 10);
                TestCase.assertEquals((int)10, (int)listener.events.size());
            }
        });
        durableClient2VM.invoke(new CacheSerializableRunnable("Verify updates"){

            @Override
            public void run2() throws CacheException {
                Region region = CacheServerTestUtil.getCache().getRegion(DurableClientSimpleDUnitTests.this.regionName);
                TestCase.assertNotNull((Object)region);
                CacheServerTestUtil.ControlListener listener = (CacheServerTestUtil.ControlListener)region.getAttributes().getCacheListeners()[0];
                listener.waitWhileNotEnoughEvents(30000L, 10);
                TestCase.assertEquals((int)10, (int)listener.events.size());
            }
        });
        this.durableClientVM.invoke(CacheServerTestUtil.class, "closeCache");
        durableClient2VM.invoke(CacheServerTestUtil.class, "closeCache");
        this.publisherClientVM.invoke(CacheServerTestUtil.class, "closeCache");
        this.server1VM.invoke(CacheServerTestUtil.class, "closeCache");
    }

    public void testDurableClientReconnectTwoServers() {
        Integer[] ports = (Integer[])this.server1VM.invoke(CacheServerTestUtil.class, "createCacheServerReturnPorts", new Object[]{this.regionName, new Boolean(true)});
        this.server1VM.invoke(DurableClientDUnitTest.class, "setTestFlagToVerifyActForMarker", new Object[]{new Boolean(true)});
        int server1Port = ports[0];
        int mcastPort = ports[1];
        int server2Port = (Integer)this.server2VM.invoke(CacheServerTestUtil.class, "createCacheServer", new Object[]{this.regionName, new Boolean(true), new Integer(mcastPort)});
        this.server2VM.invoke(CacheServerTestUtil.class, "closeCache");
        final String durableClientId = this.getName() + "_client";
        int durableClientTimeout = 60;
        this.durableClientVM.invoke(CacheServerTestUtil.class, "createCacheClient", new Object[]{this.getClientPool(DurableClientSimpleDUnitTests.getServerHostName(this.durableClientVM.getHost()), server1Port, server2Port, true), this.regionName, this.getClientDistributedSystemProperties(durableClientId, 60), Boolean.TRUE});
        this.durableClientVM.invoke(new CacheSerializableRunnable("Send clientReady"){

            @Override
            public void run2() throws CacheException {
                CacheServerTestUtil.getCache().readyForEvents();
            }
        });
        this.durableClientVM.invoke(new CacheSerializableRunnable("Register interest"){

            @Override
            public void run2() throws CacheException {
                Region region = CacheServerTestUtil.getCache().getRegion(DurableClientSimpleDUnitTests.this.regionName);
                TestCase.assertNotNull((Object)region);
                region.registerInterestRegex(".*", InterestResultPolicy.NONE, true);
            }
        });
        this.server1VM.invoke(new CacheSerializableRunnable("Verify durable client"){

            @Override
            public void run2() throws CacheException {
                DurableClientDUnitTest.checkNumberOfClientProxies(1);
                CacheClientProxy proxy = DurableClientDUnitTest.getClientProxy();
                TestCase.assertNotNull((Object)proxy);
                TestCase.assertTrue((boolean)proxy.isDurable());
                TestCase.assertEquals((String)durableClientId, (String)proxy.getDurableId());
                TestCase.assertEquals((int)60, (int)proxy.getDurableTimeout());
                DurableClientDUnitTest.verifyReceivedMarkerAck(proxy);
            }
        });
        DurableClientSimpleDUnitTests.pause(5000);
        this.durableClientVM.invoke(CacheServerTestUtil.class, "closeCache", new Object[]{new Boolean(true)});
        this.server1VM.invoke(new CacheSerializableRunnable("Verify durable client"){

            @Override
            public void run2() throws CacheException {
                DurableClientDUnitTest.checkNumberOfClientProxies(1);
                CacheClientProxy proxy = DurableClientDUnitTest.getClientProxy();
                TestCase.assertNotNull((Object)proxy);
            }
        });
        this.server2VM.invoke(CacheServerTestUtil.class, "createCacheServer", new Object[]{this.regionName, new Boolean(true), new Integer(mcastPort), new Integer(server2Port)});
        this.publisherClientVM.invoke(CacheServerTestUtil.class, "createCacheClient", new Object[]{this.getClientPool(DurableClientSimpleDUnitTests.getServerHostName(this.publisherClientVM.getHost()), server1Port, server2Port, false), this.regionName});
        int numberOfEntries = 10;
        this.publisherClientVM.invoke(new CacheSerializableRunnable("Register interest"){

            @Override
            public void run2() throws CacheException {
                Region region = CacheServerTestUtil.getCache().getRegion(DurableClientSimpleDUnitTests.this.regionName);
                TestCase.assertNotNull((Object)region);
                for (int i = 0; i < 10; ++i) {
                    String keyAndValue = String.valueOf(i);
                    region.put((Object)keyAndValue, (Object)keyAndValue);
                }
            }
        });
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException ex) {
            DurableClientSimpleDUnitTests.fail((String)"interrupted");
        }
        this.server1VM.invoke(new CacheSerializableRunnable("Verify durable client"){

            @Override
            public void run2() throws CacheException {
                CacheClientProxy proxy = DurableClientDUnitTest.getClientProxy();
                TestCase.assertNotNull((Object)proxy);
                TestCase.assertEquals((int)10, (int)proxy.getQueueSize());
            }
        });
        this.durableClientVM.invoke(CacheServerTestUtil.class, "createCacheClient", new Object[]{this.getClientPool(DurableClientSimpleDUnitTests.getServerHostName(this.durableClientVM.getHost()), server1Port, server2Port, true), this.regionName, this.getClientDistributedSystemProperties(durableClientId, 60), Boolean.TRUE});
        this.durableClientVM.invoke(new CacheSerializableRunnable("Send clientReady"){

            @Override
            public void run2() throws CacheException {
                CacheServerTestUtil.getCache().readyForEvents();
            }
        });
        this.server1VM.invoke(new CacheSerializableRunnable("Verify durable client"){

            @Override
            public void run2() throws CacheException {
                DurableClientDUnitTest.checkNumberOfClientProxies(1);
                CacheClientProxy proxy = DurableClientDUnitTest.getClientProxy();
                TestCase.assertNotNull((Object)proxy);
                TestCase.assertTrue((boolean)proxy.isDurable());
                TestCase.assertEquals((String)durableClientId, (String)proxy.getDurableId());
                TestCase.assertEquals((int)60, (int)proxy.getDurableTimeout());
            }
        });
        this.server2VM.invoke(new CacheSerializableRunnable("Verify durable client"){

            @Override
            public void run2() throws CacheException {
                DurableClientDUnitTest.checkNumberOfClientProxies(1);
                CacheClientProxy proxy = DurableClientDUnitTest.getClientProxy();
                TestCase.assertNotNull((Object)proxy);
                TestCase.assertTrue((boolean)proxy.isDurable());
                TestCase.assertEquals((String)durableClientId, (String)proxy.getDurableId());
                TestCase.assertEquals((int)60, (int)proxy.getDurableTimeout());
            }
        });
        String server1HARegionQueueName = (String)this.server1VM.invoke(DurableClientDUnitTest.class, "getHARegionQueueName");
        String server2HARegionQueueName = (String)this.server2VM.invoke(DurableClientDUnitTest.class, "getHARegionQueueName");
        DurableClientSimpleDUnitTests.assertEquals((String)server1HARegionQueueName, (String)server2HARegionQueueName);
        this.durableClientVM.invoke(new CacheSerializableRunnable("Verify updates"){

            @Override
            public void run2() throws CacheException {
                Region region = CacheServerTestUtil.getCache().getRegion(DurableClientSimpleDUnitTests.this.regionName);
                TestCase.assertNotNull((Object)region);
                CacheServerTestUtil.ControlListener listener = (CacheServerTestUtil.ControlListener)region.getAttributes().getCacheListeners()[0];
                listener.waitWhileNotEnoughEvents(30000L, 10);
                TestCase.assertEquals((int)10, (int)listener.events.size());
            }
        });
        this.durableClientVM.invoke(CacheServerTestUtil.class, "closeCache");
        this.publisherClientVM.invoke(CacheServerTestUtil.class, "closeCache");
        this.server1VM.invoke(DurableClientDUnitTest.class, "setTestFlagToVerifyActForMarker", new Object[]{new Boolean(false)});
        this.server1VM.invoke(CacheServerTestUtil.class, "closeCache");
        this.server2VM.invoke(CacheServerTestUtil.class, "closeCache");
    }

    @Override
    public void testReadyForEventsNotCalledImplicitly() {
        int serverPort = (Integer)this.server1VM.invoke(CacheServerTestUtil.class, "createCacheServer", new Object[]{this.regionName, new Boolean(true)});
        final String durableClientId = this.getName() + "_client";
        this.durableClientVM.invoke(CacheServerTestUtil.class, "createClientCache", new Object[]{this.getClientPool(DurableClientSimpleDUnitTests.getServerHostName(this.durableClientVM.getHost()), serverPort, true), this.regionName, this.getClientDistributedSystemProperties(durableClientId)});
        this.durableClientVM.invoke(new CacheSerializableRunnable("check readyForEvents not called"){

            @Override
            public void run2() throws CacheException {
                for (Pool p : PoolManager.getAll().values()) {
                    TestCase.assertEquals((boolean)false, (boolean)((PoolImpl)p).getReadyForEventsCalled());
                }
            }
        });
        this.durableClientVM.invoke(new CacheSerializableRunnable("Send clientReady"){

            @Override
            public void run2() throws CacheException {
                CacheServerTestUtil.getCache().readyForEvents();
            }
        });
        this.server1VM.invoke(new CacheSerializableRunnable("Verify durable client"){

            @Override
            public void run2() throws CacheException {
                CacheClientNotifier notifier = DurableClientDUnitTest.getBridgeServer().getAcceptor().getCacheClientNotifier();
                DurableClientDUnitTest.checkNumberOfClientProxies(1);
                boolean durableClient1Found = false;
                boolean durableClient2Found = false;
                for (CacheClientProxy proxy : notifier.getClientProxies()) {
                    TestCase.assertTrue((boolean)proxy.isDurable());
                    if (proxy.getDurableId().equals(durableClientId)) {
                        durableClient1Found = true;
                    }
                    TestCase.assertEquals((int)300, (int)proxy.getDurableTimeout());
                }
                TestCase.assertTrue((boolean)durableClient1Found);
            }
        });
        this.durableClientVM.invoke(CacheServerTestUtil.class, "closeCache");
        this.server1VM.invoke(new CacheSerializableRunnable("Verify durable client"){

            @Override
            public void run2() throws CacheException {
                DurableClientDUnitTest.checkNumberOfClientProxies(0);
            }
        });
        this.server1VM.invoke(CacheServerTestUtil.class, "closeCache");
    }

    public void DISABLED_testReadyForEventsNotCalledImplicitlyWithCacheXML() {
        String cqName = "cqTest";
        int serverPort = (Integer)this.server1VM.invoke(CacheServerTestUtil.class, "createCacheServerFromXml", new Object[]{DurableClientDUnitTest.class.getResource("durablecq-server-cache.xml")});
        final String durableClientId = this.getName() + "_client";
        this.durableClientVM.invoke(CacheServerTestUtil.class, "createCacheClientFromXml", new Object[]{DurableClientDUnitTest.class.getResource("durablecq-client-cache.xml"), "client", durableClientId, 300, Boolean.FALSE});
        this.durableClientVM.invoke(new CacheSerializableRunnable("check readyForEvents not called"){

            @Override
            public void run2() throws CacheException {
                for (Pool p : PoolManager.getAll().values()) {
                    TestCase.assertEquals((boolean)false, (boolean)((PoolImpl)p).getReadyForEventsCalled());
                }
            }
        });
        this.durableClientVM.invoke(new CacheSerializableRunnable("Send clientReady"){

            @Override
            public void run2() throws CacheException {
                CacheServerTestUtil.getCache().readyForEvents();
            }
        });
        this.durableClientVM.invoke(new CacheSerializableRunnable("Register Cq"){

            @Override
            public void run2() throws CacheException {
                Region region = CacheServerTestUtil.getCache().getRegion(DurableClientSimpleDUnitTests.this.regionName);
                TestCase.assertNotNull((Object)region);
                CqAttributesFactory cqAf = new CqAttributesFactory();
                CqListener[] cqListeners = new CqListener[]{new CacheServerTestUtil.ControlCqListener()};
                cqAf.initCqListeners(cqListeners);
                CqAttributes cqa = cqAf.create();
                QueryService queryService = CacheServerTestUtil.getPool().getQueryService();
                try {
                    CqQuery query = queryService.newCq("cqTest", "Select * from /" + DurableClientSimpleDUnitTests.this.regionName, cqa, true);
                    query.execute();
                }
                catch (CqExistsException e) {
                    TestCase.fail((String)("Failed due to " + (Object)((Object)e)));
                }
                catch (CqException e) {
                    TestCase.fail((String)("Failed due to " + (Object)((Object)e)));
                }
                catch (RegionNotFoundException e) {
                    TestCase.fail((String)("Could not find specified region:" + DurableClientSimpleDUnitTests.this.regionName + ":" + (Object)((Object)e)));
                }
            }
        });
        this.server1VM.invoke(new CacheSerializableRunnable("Verify durable client"){

            @Override
            public void run2() throws CacheException {
                DurableClientDUnitTest.checkNumberOfClientProxies(1);
                CacheClientProxy proxy = DurableClientDUnitTest.getClientProxy();
                TestCase.assertNotNull((Object)proxy);
                TestCase.assertTrue((boolean)proxy.isDurable());
                TestCase.assertEquals((String)durableClientId, (String)proxy.getDurableId());
            }
        });
        this.publisherClientVM.invoke(CacheServerTestUtil.class, "createCacheClient", new Object[]{this.getClientPool(DurableClientSimpleDUnitTests.getServerHostName(this.publisherClientVM.getHost()), serverPort, false), this.regionName});
        int numberOfEntries = 10;
        this.publisherClientVM.invoke(new CacheSerializableRunnable("publish updates"){

            @Override
            public void run2() throws CacheException {
                Region region = CacheServerTestUtil.getCache().getRegion(DurableClientSimpleDUnitTests.this.regionName);
                TestCase.assertNotNull((Object)region);
                for (int i = 0; i < 10; ++i) {
                    String keyAndValue = String.valueOf(i);
                    region.put((Object)keyAndValue, (Object)keyAndValue);
                }
            }
        });
        this.durableClientVM.invoke(new CacheSerializableRunnable("Verify updates"){

            @Override
            public void run2() throws CacheException {
                Region region = CacheServerTestUtil.getCache().getRegion(DurableClientSimpleDUnitTests.this.regionName);
                TestCase.assertNotNull((Object)region);
                QueryService queryService = CacheServerTestUtil.getPool().getQueryService();
                CqQuery cqQuery = queryService.getCq("cqTest");
                CacheServerTestUtil.ControlCqListener cqlistener = (CacheServerTestUtil.ControlCqListener)cqQuery.getCqAttributes().getCqListener();
                cqlistener.waitWhileNotEnoughEvents(30000L, 10);
                TestCase.assertEquals((int)10, (int)cqlistener.events.size());
            }
        });
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException e) {
            DurableClientSimpleDUnitTests.fail((String)("interrupted" + e));
        }
        this.durableClientVM.invoke(CacheServerTestUtil.class, "closeCache", new Object[]{new Boolean(true)});
        this.server1VM.invoke(new CacheSerializableRunnable("Verify durable client"){

            @Override
            public void run2() throws CacheException {
                CacheClientProxy proxy = DurableClientDUnitTest.getClientProxy();
                TestCase.assertNotNull((Object)proxy);
            }
        });
        this.publisherClientVM.invoke(new CacheSerializableRunnable("Publish additional updates"){

            @Override
            public void run2() throws CacheException {
                Region region = CacheServerTestUtil.getCache().getRegion(DurableClientSimpleDUnitTests.this.regionName);
                TestCase.assertNotNull((Object)region);
                for (int i = 0; i < 10; ++i) {
                    String keyAndValue = String.valueOf(i);
                    region.put((Object)keyAndValue, (Object)(keyAndValue + "lkj"));
                }
            }
        });
        this.publisherClientVM.invoke(CacheServerTestUtil.class, "closeCache");
        this.durableClientVM.invoke(CacheServerTestUtil.class, "createCacheClientFromXml", new Object[]{DurableClientDUnitTest.class.getResource("durablecq-client-cache.xml"), "client", durableClientId, 300, Boolean.FALSE});
        this.durableClientVM.invoke(new CacheSerializableRunnable("Register cq"){

            @Override
            public void run2() throws CacheException {
                Region region = CacheServerTestUtil.getCache().getRegion(DurableClientSimpleDUnitTests.this.regionName);
                TestCase.assertNotNull((Object)region);
                CqAttributesFactory cqAf = new CqAttributesFactory();
                CqListener[] cqListeners = new CqListener[]{new CacheServerTestUtil.ControlCqListener()};
                cqAf.initCqListeners(cqListeners);
                CqAttributes cqa = cqAf.create();
                QueryService queryService = CacheServerTestUtil.getPool().getQueryService();
                try {
                    CqQuery query = queryService.newCq("cqTest", "Select * from /" + DurableClientSimpleDUnitTests.this.regionName, cqa, true);
                    query.execute();
                }
                catch (CqExistsException e) {
                    TestCase.fail((String)("Failed due to " + (Object)((Object)e)));
                }
                catch (CqException e) {
                    TestCase.fail((String)("Failed due to " + (Object)((Object)e)));
                }
                catch (RegionNotFoundException e) {
                    TestCase.fail((String)("Could not find specified region:" + DurableClientSimpleDUnitTests.this.regionName + ":" + (Object)((Object)e)));
                }
            }
        });
        this.durableClientVM.invoke(new CacheSerializableRunnable("Send clientReady"){

            @Override
            public void run2() throws CacheException {
                CacheServerTestUtil.getCache().readyForEvents();
            }
        });
        this.server1VM.invoke(new CacheSerializableRunnable("Verify durable client"){

            @Override
            public void run2() throws CacheException {
                DurableClientDUnitTest.checkNumberOfClientProxies(1);
                CacheClientProxy proxy = DurableClientDUnitTest.getClientProxy();
                TestCase.assertNotNull((Object)proxy);
                TestCase.assertTrue((boolean)proxy.isDurable());
                TestCase.assertEquals((String)durableClientId, (String)proxy.getDurableId());
            }
        });
        this.durableClientVM.invoke(new CacheSerializableRunnable("Verify updates"){

            @Override
            public void run2() throws CacheException {
                Region region = CacheServerTestUtil.getCache().getRegion(DurableClientSimpleDUnitTests.this.regionName);
                TestCase.assertNotNull((Object)region);
                QueryService queryService = CacheServerTestUtil.getPool().getQueryService();
                CqQuery cqQuery = queryService.getCq("cqTest");
                CacheServerTestUtil.ControlCqListener cqlistener = (CacheServerTestUtil.ControlCqListener)cqQuery.getCqAttributes().getCqListener();
                cqlistener.waitWhileNotEnoughEvents(30000L, 10);
                TestCase.assertEquals((int)10, (int)cqlistener.events.size());
            }
        });
        this.durableClientVM.invoke(CacheServerTestUtil.class, "closeCache");
        this.server1VM.invoke(new CacheSerializableRunnable("Verify durable client"){

            @Override
            public void run2() throws CacheException {
                DurableClientDUnitTest.checkNumberOfClientProxies(0);
            }
        });
        this.server1VM.invoke(CacheServerTestUtil.class, "closeCache");
    }

    @Override
    public void testReadyForEventsNotCalledImplicitlyForRegisterInterestWithCacheXML() {
        String cqName = "cqTest";
        this.regionName = "testReadyForEventsNotCalledImplicitlyWithCacheXML_region";
        int serverPort = (Integer)this.server1VM.invoke(CacheServerTestUtil.class, "createCacheServerFromXmlN", new Object[]{DurableClientDUnitTest.class.getResource("durablecq-server-cache.xml")});
        final String durableClientId = this.getName() + "_client";
        this.durableClientVM.invoke(CacheServerTestUtil.class, "createCacheClientFromXmlN", new Object[]{DurableClientDUnitTest.class.getResource("durablecq-client-cache.xml"), "client", durableClientId, 300, Boolean.TRUE});
        this.durableClientVM.invoke(new CacheSerializableRunnable("check readyForEvents not called"){

            @Override
            public void run2() throws CacheException {
                for (Pool p : PoolManager.getAll().values()) {
                    TestCase.assertEquals((boolean)false, (boolean)((PoolImpl)p).getReadyForEventsCalled());
                }
            }
        });
        this.durableClientVM.invoke(new CacheSerializableRunnable("Send clientReady"){

            @Override
            public void run2() throws CacheException {
                CacheServerTestUtil.getCache().readyForEvents();
            }
        });
        this.durableClientVM.invoke(new CacheSerializableRunnable("Register Interest"){

            @Override
            public void run2() throws CacheException {
                Region region = CacheServerTestUtil.getCache().getRegion(DurableClientSimpleDUnitTests.this.regionName);
                TestCase.assertNotNull((Object)region);
                region.registerInterestRegex(".*", InterestResultPolicy.KEYS_VALUES, true);
            }
        });
        this.server1VM.invoke(new CacheSerializableRunnable("Verify durable client"){

            @Override
            public void run2() throws CacheException {
                DurableClientDUnitTest.checkNumberOfClientProxies(1);
                CacheClientProxy proxy = DurableClientDUnitTest.getClientProxy();
                TestCase.assertNotNull((Object)proxy);
                TestCase.assertTrue((boolean)proxy.isDurable());
                TestCase.assertEquals((String)durableClientId, (String)proxy.getDurableId());
            }
        });
        this.publisherClientVM.invoke(CacheServerTestUtil.class, "createCacheClient", new Object[]{this.getClientPool(DurableClientSimpleDUnitTests.getServerHostName(this.publisherClientVM.getHost()), serverPort, false), this.regionName});
        int numberOfEntries = 10;
        this.publisherClientVM.invoke(new CacheSerializableRunnable("publish updates"){

            @Override
            public void run2() throws CacheException {
                Region region = CacheServerTestUtil.getCache().getRegion(DurableClientSimpleDUnitTests.this.regionName);
                TestCase.assertNotNull((Object)region);
                for (int i = 0; i < 10; ++i) {
                    String keyAndValue = String.valueOf(i);
                    region.put((Object)keyAndValue, (Object)keyAndValue);
                }
            }
        });
        this.durableClientVM.invoke(new CacheSerializableRunnable("Verify updates"){

            @Override
            public void run2() throws CacheException {
                Region region = CacheServerTestUtil.getCache().getRegion(DurableClientSimpleDUnitTests.this.regionName);
                TestCase.assertNotNull((Object)region);
                CacheServerTestUtil.ControlListener listener = (CacheServerTestUtil.ControlListener)region.getAttributes().getCacheListeners()[0];
                listener.waitWhileNotEnoughEvents(30000L, 10);
                TestCase.assertEquals((int)10, (int)listener.events.size());
            }
        });
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException e) {
            DurableClientSimpleDUnitTests.fail((String)("interrupted" + e));
        }
        this.durableClientVM.invoke(CacheServerTestUtil.class, "closeCache", new Object[]{new Boolean(true)});
        this.server1VM.invoke(new CacheSerializableRunnable("Verify durable client"){

            @Override
            public void run2() throws CacheException {
                CacheClientProxy proxy = DurableClientDUnitTest.getClientProxy();
                TestCase.assertNotNull((Object)proxy);
            }
        });
        this.publisherClientVM.invoke(new CacheSerializableRunnable("Publish additional updates"){

            @Override
            public void run2() throws CacheException {
                Region region = CacheServerTestUtil.getCache().getRegion(DurableClientSimpleDUnitTests.this.regionName);
                TestCase.assertNotNull((Object)region);
                for (int i = 0; i < 10; ++i) {
                    String keyAndValue = String.valueOf(i);
                    region.put((Object)keyAndValue, (Object)(keyAndValue + "lkj"));
                }
            }
        });
        this.publisherClientVM.invoke(CacheServerTestUtil.class, "closeCache");
        this.durableClientVM.invoke(CacheServerTestUtil.class, "createCacheClientFromXmlN", new Object[]{DurableClientDUnitTest.class.getResource("durablecq-client-cache.xml"), "client", durableClientId, 300, Boolean.TRUE});
        this.durableClientVM.invoke(new CacheSerializableRunnable("Register interest"){

            @Override
            public void run2() throws CacheException {
                Region region = CacheServerTestUtil.getCache().getRegion(DurableClientSimpleDUnitTests.this.regionName);
                TestCase.assertNotNull((Object)region);
                region.registerInterestRegex(".*", InterestResultPolicy.KEYS_VALUES, true);
            }
        });
        this.durableClientVM.invoke(new CacheSerializableRunnable("Send clientReady"){

            @Override
            public void run2() throws CacheException {
                CacheServerTestUtil.getCache().readyForEvents();
            }
        });
        this.server1VM.invoke(new CacheSerializableRunnable("Verify durable client"){

            @Override
            public void run2() throws CacheException {
                DurableClientDUnitTest.checkNumberOfClientProxies(1);
                CacheClientProxy proxy = DurableClientDUnitTest.getClientProxy();
                TestCase.assertNotNull((Object)proxy);
                TestCase.assertTrue((boolean)proxy.isDurable());
                TestCase.assertEquals((String)durableClientId, (String)proxy.getDurableId());
            }
        });
        this.durableClientVM.invoke(new CacheSerializableRunnable("Verify updates"){

            @Override
            public void run2() throws CacheException {
                Region region = CacheServerTestUtil.getCache().getRegion(DurableClientSimpleDUnitTests.this.regionName);
                TestCase.assertNotNull((Object)region);
                CacheServerTestUtil.ControlListener listener = (CacheServerTestUtil.ControlListener)region.getAttributes().getCacheListeners()[0];
                listener.waitWhileNotEnoughEvents(30000L, 10);
                TestCase.assertEquals((int)10, (int)listener.events.size());
            }
        });
        this.durableClientVM.invoke(CacheServerTestUtil.class, "closeCache");
        this.server1VM.invoke(new CacheSerializableRunnable("Verify durable client"){

            @Override
            public void run2() throws CacheException {
                DurableClientDUnitTest.checkNumberOfClientProxies(0);
            }
        });
        this.server1VM.invoke(CacheServerTestUtil.class, "closeCache");
    }

    public void testHAQueueSizeStat() throws Exception {
        String greaterThan5Query = "select * from /" + this.regionName + " p where p.ID > 5";
        String allQuery = "select * from /" + this.regionName + " p where p.ID > -1";
        String lessThan5Query = "select * from /" + this.regionName + " p where p.ID < 5";
        Integer[] ports = (Integer[])this.server1VM.invoke(CacheServerTestUtil.class, "createCacheServerReturnPorts", new Object[]{this.regionName, new Boolean(true)});
        int serverPort = ports[0];
        int mcastPort = ports[1];
        String durableClientId = this.getName() + "_client";
        this.startDurableClient(this.durableClientVM, durableClientId, serverPort, this.regionName);
        this.createCq(this.durableClientVM, "GreaterThan5", greaterThan5Query, true);
        this.createCq(this.durableClientVM, "All", allQuery, true);
        this.createCq(this.durableClientVM, "LessThan5", lessThan5Query, true);
        this.sendClientReady(this.durableClientVM);
        this.verifyDurableClientOnServer(this.server1VM, durableClientId);
        this.disconnectDurableClient(true);
        this.startClient(this.publisherClientVM, serverPort, this.regionName);
        this.publishEntries(this.publisherClientVM, this.regionName, 10);
        this.checkNumDurableCqs(this.server1VM, durableClientId, 3);
        this.checkHAQueueSize(this.server1VM, durableClientId, 10, 11);
        this.startDurableClient(this.durableClientVM, durableClientId, serverPort, this.regionName);
        this.createCq(this.durableClientVM, "GreaterThan5", "select * from /" + this.regionName + " p where p.ID > 5", true);
        this.createCq(this.durableClientVM, "All", "select * from /" + this.regionName + " p where p.ID > -1", true);
        this.createCq(this.durableClientVM, "LessThan5", "select * from /" + this.regionName + " p where p.ID < 5", true);
        this.sendClientReady(this.durableClientVM);
        this.checkCqListenerEvents(this.durableClientVM, "GreaterThan5", 4, 4, 15);
        this.checkCqListenerEvents(this.durableClientVM, "LessThan5", 5, 5, 15);
        this.checkCqListenerEvents(this.durableClientVM, "All", 10, 10, 15);
        this.flushEntries(this.server1VM, this.durableClientVM, this.regionName);
        this.checkHAQueueSize(this.server1VM, durableClientId, 0, 1);
        this.durableClientVM.invoke(CacheServerTestUtil.class, "closeCache");
        this.publisherClientVM.invoke(CacheServerTestUtil.class, "closeCache");
        this.server1VM.invoke(CacheServerTestUtil.class, "closeCache");
    }

    public void testHAQueueSizeStatExpired() throws Exception {
        int timeoutInSeconds = 20;
        String greaterThan5Query = "select * from /" + this.regionName + " p where p.ID > 5";
        String allQuery = "select * from /" + this.regionName + " p where p.ID > -1";
        String lessThan5Query = "select * from /" + this.regionName + " p where p.ID < 5";
        Integer[] ports = (Integer[])this.server1VM.invoke(CacheServerTestUtil.class, "createCacheServerReturnPorts", new Object[]{this.regionName, new Boolean(true)});
        int serverPort = ports[0];
        int mcastPort = ports[1];
        String durableClientId = this.getName() + "_client";
        this.startDurableClient(this.durableClientVM, durableClientId, serverPort, this.regionName, timeoutInSeconds);
        this.createCq(this.durableClientVM, "GreaterThan5", greaterThan5Query, true);
        this.createCq(this.durableClientVM, "All", allQuery, true);
        this.createCq(this.durableClientVM, "LessThan5", lessThan5Query, true);
        this.sendClientReady(this.durableClientVM);
        this.verifyDurableClientOnServer(this.server1VM, durableClientId);
        this.disconnectDurableClient(true);
        this.startClient(this.publisherClientVM, serverPort, this.regionName);
        this.publishEntries(this.publisherClientVM, this.regionName, 10);
        this.checkNumDurableCqs(this.server1VM, durableClientId, 3);
        this.checkHAQueueSize(this.server1VM, durableClientId, 10, 11);
        try {
            Thread.sleep((timeoutInSeconds + 2) * 1000);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
        }
        this.startDurableClient(this.durableClientVM, durableClientId, serverPort, this.regionName);
        this.createCq(this.durableClientVM, "GreaterThan5", "select * from /" + this.regionName + " p where p.ID > 5", true);
        this.createCq(this.durableClientVM, "All", "select * from /" + this.regionName + " p where p.ID > -1", true);
        this.createCq(this.durableClientVM, "LessThan5", "select * from /" + this.regionName + " p where p.ID < 5", true);
        this.sendClientReady(this.durableClientVM);
        this.checkCqListenerEvents(this.durableClientVM, "GreaterThan5", 0, 1, 5);
        this.checkCqListenerEvents(this.durableClientVM, "LessThan5", 0, 1, 5);
        this.checkCqListenerEvents(this.durableClientVM, "All", 0, 1, 5);
        this.flushEntries(this.server1VM, this.durableClientVM, this.regionName);
        this.checkHAQueueSize(this.server1VM, durableClientId, 0, 1);
        this.durableClientVM.invoke(CacheServerTestUtil.class, "closeCache");
        this.publisherClientVM.invoke(CacheServerTestUtil.class, "closeCache");
        this.server1VM.invoke(CacheServerTestUtil.class, "closeCache");
    }

    public void testHAQueueSizeStatForGII() throws Exception {
        String greaterThan5Query = "select * from /" + this.regionName + " p where p.ID > 5";
        String allQuery = "select * from /" + this.regionName + " p where p.ID > -1";
        String lessThan5Query = "select * from /" + this.regionName + " p where p.ID < 5";
        Integer[] ports = (Integer[])this.server1VM.invoke(CacheServerTestUtil.class, "createCacheServerReturnPorts", new Object[]{this.regionName, new Boolean(true)});
        int serverPort = ports[0];
        int mcastPort = ports[1];
        int serverPort2 = (Integer)this.server2VM.invoke(CacheServerTestUtil.class, "createCacheServer", new Object[]{this.regionName, new Boolean(true), new Integer(mcastPort)});
        this.closeCache(this.server2VM);
        String durableClientId = this.getName() + "_client";
        this.durableClientVM.invoke(CacheServerTestUtil.class, "disableShufflingOfEndpoints");
        this.startDurableClient(this.durableClientVM, durableClientId, serverPort, serverPort2, this.regionName);
        this.createCq(this.durableClientVM, "GreaterThan5", greaterThan5Query, true);
        this.createCq(this.durableClientVM, "All", allQuery, true);
        this.createCq(this.durableClientVM, "LessThan5", lessThan5Query, true);
        this.sendClientReady(this.durableClientVM);
        this.verifyDurableClientOnServer(this.server1VM, durableClientId);
        this.checkNumDurableCqs(this.server1VM, durableClientId, 3);
        this.disconnectDurableClient(true);
        this.startClient(this.publisherClientVM, serverPort, this.regionName);
        this.publishEntries(this.publisherClientVM, this.regionName, 10);
        this.startDurableClient(this.durableClientVM, durableClientId, serverPort, serverPort2, this.regionName);
        this.server2VM.invoke(CacheServerTestUtil.class, "createCacheServer", new Object[]{this.regionName, new Boolean(true), new Integer(mcastPort), new Integer(serverPort2)});
        this.verifyDurableClientOnServer(this.server2VM, durableClientId);
        this.checkNumDurableCqs(this.server2VM, durableClientId, 3);
        this.checkHAQueueSize(this.server2VM, durableClientId, 10, 11);
        this.closeCache(this.server1VM);
        this.createCq(this.durableClientVM, "GreaterThan5", "select * from /" + this.regionName + " p where p.ID > 5", true);
        this.createCq(this.durableClientVM, "All", "select * from /" + this.regionName + " p where p.ID > -1", true);
        this.createCq(this.durableClientVM, "LessThan5", "select * from /" + this.regionName + " p where p.ID < 5", true);
        this.sendClientReady(this.durableClientVM);
        this.checkCqListenerEvents(this.durableClientVM, "GreaterThan5", 4, 4, 15);
        this.checkCqListenerEvents(this.durableClientVM, "LessThan5", 5, 5, 15);
        this.checkCqListenerEvents(this.durableClientVM, "All", 10, 10, 15);
        this.flushEntries(this.server2VM, this.durableClientVM, this.regionName);
        this.checkHAQueueSize(this.server2VM, durableClientId, 0, 1);
        this.checkCqStatOnServer(this.server2VM, durableClientId, "LessThan5", 0);
        this.checkCqStatOnServer(this.server2VM, durableClientId, "GreaterThan5", 0);
        this.checkCqStatOnServer(this.server2VM, durableClientId, "All", 0);
        this.durableClientVM.invoke(CacheServerTestUtil.class, "closeCache");
        this.publisherClientVM.invoke(CacheServerTestUtil.class, "closeCache");
        this.server1VM.invoke(CacheServerTestUtil.class, "closeCache");
        this.server2VM.invoke(CacheServerTestUtil.class, "closeCache");
    }

    public void testHAQueuedCqStat() throws Exception {
        String greaterThan5Query = "select * from /" + this.regionName + " p where p.ID > 5";
        String allQuery = "select * from /" + this.regionName + " p where p.ID > -1";
        String lessThan5Query = "select * from /" + this.regionName + " p where p.ID < 5";
        Integer[] ports = (Integer[])this.server1VM.invoke(CacheServerTestUtil.class, "createCacheServerReturnPorts", new Object[]{this.regionName, new Boolean(true)});
        int serverPort = ports[0];
        int mcastPort = ports[1];
        String durableClientId = this.getName() + "_client";
        this.startDurableClient(this.durableClientVM, durableClientId, serverPort, this.regionName);
        this.createCq(this.durableClientVM, "GreaterThan5", greaterThan5Query, true);
        this.createCq(this.durableClientVM, "All", allQuery, true);
        this.createCq(this.durableClientVM, "LessThan5", lessThan5Query, true);
        this.sendClientReady(this.durableClientVM);
        this.verifyDurableClientOnServer(this.server1VM, durableClientId);
        this.disconnectDurableClient(true);
        this.startClient(this.publisherClientVM, serverPort, this.regionName);
        this.publishEntries(this.publisherClientVM, this.regionName, 10);
        this.checkNumDurableCqs(this.server1VM, durableClientId, 3);
        this.checkCqStatOnServer(this.server1VM, durableClientId, "All", 10);
        this.checkCqStatOnServer(this.server1VM, durableClientId, "GreaterThan5", 4);
        this.checkCqStatOnServer(this.server1VM, durableClientId, "LessThan5", 5);
        this.startDurableClient(this.durableClientVM, durableClientId, serverPort, this.regionName);
        this.createCq(this.durableClientVM, "GreaterThan5", "select * from /" + this.regionName + " p where p.ID > 5", true);
        this.createCq(this.durableClientVM, "All", "select * from /" + this.regionName + " p where p.ID > -1", true);
        this.createCq(this.durableClientVM, "LessThan5", "select * from /" + this.regionName + " p where p.ID < 5", true);
        this.sendClientReady(this.durableClientVM);
        this.checkCqListenerEvents(this.durableClientVM, "GreaterThan5", 4, 4, 15);
        this.checkCqListenerEvents(this.durableClientVM, "LessThan5", 5, 5, 15);
        this.checkCqListenerEvents(this.durableClientVM, "All", 10, 10, 15);
        this.flushEntries(this.server1VM, this.durableClientVM, this.regionName);
        this.checkCqStatOnServer(this.server1VM, durableClientId, "LessThan5", 0);
        this.checkCqStatOnServer(this.server1VM, durableClientId, "GreaterThan5", 0);
        this.checkCqStatOnServer(this.server1VM, durableClientId, "All", 0);
        this.durableClientVM.invoke(CacheServerTestUtil.class, "closeCache");
        this.publisherClientVM.invoke(CacheServerTestUtil.class, "closeCache");
        this.server1VM.invoke(CacheServerTestUtil.class, "closeCache");
    }

    public void testHAQueuedCqStatOnSecondary() throws Exception {
        String greaterThan5Query = "select * from /" + this.regionName + " p where p.ID > 5";
        String allQuery = "select * from /" + this.regionName + " p where p.ID > -1";
        String lessThan5Query = "select * from /" + this.regionName + " p where p.ID < 5";
        Integer[] ports = (Integer[])this.server1VM.invoke(CacheServerTestUtil.class, "createCacheServerReturnPorts", new Object[]{this.regionName, new Boolean(true)});
        int serverPort = ports[0];
        int mcastPort = ports[1];
        int serverPort2 = (Integer)this.server2VM.invoke(CacheServerTestUtil.class, "createCacheServer", new Object[]{this.regionName, new Boolean(true), new Integer(mcastPort)});
        String durableClientId = this.getName() + "_client";
        this.durableClientVM.invoke(CacheServerTestUtil.class, "disableShufflingOfEndpoints");
        this.startDurableClient(this.durableClientVM, durableClientId, serverPort, serverPort2, this.regionName);
        this.createCq(this.durableClientVM, "GreaterThan5", greaterThan5Query, true);
        this.createCq(this.durableClientVM, "All", allQuery, true);
        this.createCq(this.durableClientVM, "LessThan5", lessThan5Query, true);
        this.sendClientReady(this.durableClientVM);
        this.verifyDurableClientOnServer(this.server2VM, durableClientId);
        this.verifyDurableClientOnServer(this.server1VM, durableClientId);
        this.disconnectDurableClient(true);
        this.startClient(this.publisherClientVM, serverPort, this.regionName);
        this.publishEntries(this.publisherClientVM, this.regionName, 10);
        this.checkNumDurableCqs(this.server1VM, durableClientId, 3);
        this.checkCqStatOnServer(this.server1VM, durableClientId, "All", 10);
        this.checkCqStatOnServer(this.server1VM, durableClientId, "GreaterThan5", 4);
        this.checkCqStatOnServer(this.server1VM, durableClientId, "LessThan5", 5);
        this.checkNumDurableCqs(this.server2VM, durableClientId, 3);
        this.checkCqStatOnServer(this.server2VM, durableClientId, "All", 10);
        this.checkCqStatOnServer(this.server2VM, durableClientId, "GreaterThan5", 4);
        this.checkCqStatOnServer(this.server2VM, durableClientId, "LessThan5", 5);
        this.startDurableClient(this.durableClientVM, durableClientId, serverPort, serverPort2, this.regionName);
        this.createCq(this.durableClientVM, "GreaterThan5", "select * from /" + this.regionName + " p where p.ID > 5", true);
        this.createCq(this.durableClientVM, "All", "select * from /" + this.regionName + " p where p.ID > -1", true);
        this.createCq(this.durableClientVM, "LessThan5", "select * from /" + this.regionName + " p where p.ID < 5", true);
        this.sendClientReady(this.durableClientVM);
        this.checkCqListenerEvents(this.durableClientVM, "GreaterThan5", 4, 4, 15);
        this.checkCqListenerEvents(this.durableClientVM, "LessThan5", 5, 5, 15);
        this.checkCqListenerEvents(this.durableClientVM, "All", 10, 10, 15);
        this.flushEntries(this.server1VM, this.durableClientVM, this.regionName);
        this.checkCqStatOnServer(this.server1VM, durableClientId, "LessThan5", 0);
        this.checkCqStatOnServer(this.server1VM, durableClientId, "GreaterThan5", 0);
        this.checkCqStatOnServer(this.server1VM, durableClientId, "All", 0);
        this.checkCqStatOnServer(this.server2VM, durableClientId, "LessThan5", 0);
        this.checkCqStatOnServer(this.server2VM, durableClientId, "GreaterThan5", 0);
        this.checkCqStatOnServer(this.server2VM, durableClientId, "All", 0);
        this.durableClientVM.invoke(CacheServerTestUtil.class, "closeCache");
        this.publisherClientVM.invoke(CacheServerTestUtil.class, "closeCache");
        this.server1VM.invoke(CacheServerTestUtil.class, "closeCache");
    }

    public void testHAQueuedCqStatForGII() throws Exception {
        String greaterThan5Query = "select * from /" + this.regionName + " p where p.ID > 5";
        String allQuery = "select * from /" + this.regionName + " p where p.ID > -1";
        String lessThan5Query = "select * from /" + this.regionName + " p where p.ID < 5";
        Integer[] ports = (Integer[])this.server1VM.invoke(CacheServerTestUtil.class, "createCacheServerReturnPorts", new Object[]{this.regionName, new Boolean(true)});
        int serverPort = ports[0];
        int mcastPort = ports[1];
        int serverPort2 = (Integer)this.server2VM.invoke(CacheServerTestUtil.class, "createCacheServer", new Object[]{this.regionName, new Boolean(true), new Integer(mcastPort)});
        String durableClientId = this.getName() + "_client";
        this.durableClientVM.invoke(CacheServerTestUtil.class, "disableShufflingOfEndpoints");
        this.startDurableClient(this.durableClientVM, durableClientId, serverPort, serverPort2, this.regionName);
        this.createCq(this.durableClientVM, "GreaterThan5", greaterThan5Query, true);
        this.createCq(this.durableClientVM, "All", allQuery, true);
        this.createCq(this.durableClientVM, "LessThan5", lessThan5Query, true);
        this.sendClientReady(this.durableClientVM);
        this.verifyDurableClientOnServer(this.server2VM, durableClientId);
        this.verifyDurableClientOnServer(this.server1VM, durableClientId);
        this.checkNumDurableCqs(this.server1VM, durableClientId, 3);
        this.checkNumDurableCqs(this.server2VM, durableClientId, 3);
        this.closeCache(this.server2VM);
        this.disconnectDurableClient(true);
        this.startClient(this.publisherClientVM, serverPort, this.regionName);
        this.publishEntries(this.publisherClientVM, this.regionName, 10);
        this.server2VM.invoke(CacheServerTestUtil.class, "createCacheServer", new Object[]{this.regionName, new Boolean(true), new Integer(mcastPort), new Integer(serverPort2)});
        this.startDurableClient(this.durableClientVM, durableClientId, serverPort, serverPort2, this.regionName);
        this.checkNumDurableCqs(this.server2VM, durableClientId, 3);
        this.checkCqStatOnServer(this.server2VM, durableClientId, "All", 10);
        this.checkCqStatOnServer(this.server2VM, durableClientId, "GreaterThan5", 4);
        this.checkCqStatOnServer(this.server2VM, durableClientId, "LessThan5", 5);
        this.closeCache(this.server1VM);
        this.createCq(this.durableClientVM, "GreaterThan5", "select * from /" + this.regionName + " p where p.ID > 5", true);
        this.createCq(this.durableClientVM, "All", "select * from /" + this.regionName + " p where p.ID > -1", true);
        this.createCq(this.durableClientVM, "LessThan5", "select * from /" + this.regionName + " p where p.ID < 5", true);
        this.sendClientReady(this.durableClientVM);
        this.checkCqListenerEvents(this.durableClientVM, "GreaterThan5", 4, 4, 15);
        this.checkCqListenerEvents(this.durableClientVM, "LessThan5", 5, 5, 15);
        this.checkCqListenerEvents(this.durableClientVM, "All", 10, 10, 15);
        this.flushEntries(this.server2VM, this.durableClientVM, this.regionName);
        this.checkCqStatOnServer(this.server2VM, durableClientId, "LessThan5", 0);
        this.checkCqStatOnServer(this.server2VM, durableClientId, "GreaterThan5", 0);
        this.checkCqStatOnServer(this.server2VM, durableClientId, "All", 0);
        this.durableClientVM.invoke(CacheServerTestUtil.class, "closeCache");
        this.publisherClientVM.invoke(CacheServerTestUtil.class, "closeCache");
        this.server2VM.invoke(CacheServerTestUtil.class, "closeCache");
    }

    public void testHAQueuedCqStatForGII2() throws Exception {
        String greaterThan5Query = "select * from /" + this.regionName + " p where p.ID > 5";
        String allQuery = "select * from /" + this.regionName + " p where p.ID > -1";
        String lessThan5Query = "select * from /" + this.regionName + " p where p.ID < 5";
        Integer[] ports = (Integer[])this.server1VM.invoke(CacheServerTestUtil.class, "createCacheServerReturnPorts", new Object[]{this.regionName, new Boolean(true)});
        int serverPort = ports[0];
        int mcastPort = ports[1];
        int serverPort2 = (Integer)this.server2VM.invoke(CacheServerTestUtil.class, "createCacheServer", new Object[]{this.regionName, new Boolean(true), new Integer(mcastPort)});
        this.closeCache(this.server2VM);
        String durableClientId = this.getName() + "_client";
        this.durableClientVM.invoke(CacheServerTestUtil.class, "disableShufflingOfEndpoints");
        this.startDurableClient(this.durableClientVM, durableClientId, serverPort, serverPort2, this.regionName);
        this.createCq(this.durableClientVM, "GreaterThan5", greaterThan5Query, true);
        this.createCq(this.durableClientVM, "All", allQuery, true);
        this.createCq(this.durableClientVM, "LessThan5", lessThan5Query, true);
        this.sendClientReady(this.durableClientVM);
        this.verifyDurableClientOnServer(this.server1VM, durableClientId);
        this.checkNumDurableCqs(this.server1VM, durableClientId, 3);
        this.disconnectDurableClient(true);
        this.startClient(this.publisherClientVM, serverPort, this.regionName);
        this.publishEntries(this.publisherClientVM, this.regionName, 10);
        this.startDurableClient(this.durableClientVM, durableClientId, serverPort, serverPort2, this.regionName);
        this.server2VM.invoke(CacheServerTestUtil.class, "createCacheServer", new Object[]{this.regionName, new Boolean(true), new Integer(mcastPort), new Integer(serverPort2)});
        this.verifyDurableClientOnServer(this.server2VM, durableClientId);
        this.checkNumDurableCqs(this.server2VM, durableClientId, 3);
        this.checkCqStatOnServer(this.server2VM, durableClientId, "All", 10);
        this.checkCqStatOnServer(this.server2VM, durableClientId, "GreaterThan5", 4);
        this.checkCqStatOnServer(this.server2VM, durableClientId, "LessThan5", 5);
        this.closeCache(this.server1VM);
        this.createCq(this.durableClientVM, "GreaterThan5", "select * from /" + this.regionName + " p where p.ID > 5", true);
        this.createCq(this.durableClientVM, "All", "select * from /" + this.regionName + " p where p.ID > -1", true);
        this.createCq(this.durableClientVM, "LessThan5", "select * from /" + this.regionName + " p where p.ID < 5", true);
        this.sendClientReady(this.durableClientVM);
        this.checkCqListenerEvents(this.durableClientVM, "GreaterThan5", 4, 4, 15);
        this.checkCqListenerEvents(this.durableClientVM, "LessThan5", 5, 5, 15);
        this.checkCqListenerEvents(this.durableClientVM, "All", 10, 10, 15);
        this.flushEntries(this.server2VM, this.durableClientVM, this.regionName);
        this.checkCqStatOnServer(this.server2VM, durableClientId, "LessThan5", 0);
        this.checkCqStatOnServer(this.server2VM, durableClientId, "GreaterThan5", 0);
        this.checkCqStatOnServer(this.server2VM, durableClientId, "All", 0);
        this.durableClientVM.invoke(CacheServerTestUtil.class, "closeCache");
        this.publisherClientVM.invoke(CacheServerTestUtil.class, "closeCache");
        this.server1VM.invoke(CacheServerTestUtil.class, "closeCache");
        this.server2VM.invoke(CacheServerTestUtil.class, "closeCache");
    }

    public void testHAQueuedCqStatForGIINoFailover() throws Exception {
        String greaterThan5Query = "select * from /" + this.regionName + " p where p.ID > 5";
        String allQuery = "select * from /" + this.regionName + " p where p.ID > -1";
        String lessThan5Query = "select * from /" + this.regionName + " p where p.ID < 5";
        Integer[] ports = (Integer[])this.server1VM.invoke(CacheServerTestUtil.class, "createCacheServerReturnPorts", new Object[]{this.regionName, new Boolean(true)});
        int serverPort = ports[0];
        int mcastPort = ports[1];
        int serverPort2 = (Integer)this.server2VM.invoke(CacheServerTestUtil.class, "createCacheServer", new Object[]{this.regionName, new Boolean(true), new Integer(mcastPort)});
        String durableClientId = this.getName() + "_client";
        this.durableClientVM.invoke(CacheServerTestUtil.class, "disableShufflingOfEndpoints");
        this.startDurableClient(this.durableClientVM, durableClientId, serverPort, serverPort2, this.regionName);
        this.createCq(this.durableClientVM, "GreaterThan5", greaterThan5Query, true);
        this.createCq(this.durableClientVM, "All", allQuery, true);
        this.createCq(this.durableClientVM, "LessThan5", lessThan5Query, true);
        this.sendClientReady(this.durableClientVM);
        this.verifyDurableClientOnServer(this.server2VM, durableClientId);
        this.verifyDurableClientOnServer(this.server1VM, durableClientId);
        this.checkNumDurableCqs(this.server1VM, durableClientId, 3);
        this.checkNumDurableCqs(this.server2VM, durableClientId, 3);
        this.closeCache(this.server2VM);
        this.disconnectDurableClient(true);
        this.startClient(this.publisherClientVM, serverPort, this.regionName);
        this.publishEntries(this.publisherClientVM, this.regionName, 10);
        this.server2VM.invoke(CacheServerTestUtil.class, "createCacheServer", new Object[]{this.regionName, new Boolean(true), new Integer(mcastPort), new Integer(serverPort2)});
        this.startDurableClient(this.durableClientVM, durableClientId, serverPort, serverPort2, this.regionName);
        this.checkNumDurableCqs(this.server2VM, durableClientId, 3);
        this.checkCqStatOnServer(this.server2VM, durableClientId, "All", 10);
        this.checkCqStatOnServer(this.server2VM, durableClientId, "GreaterThan5", 4);
        this.checkCqStatOnServer(this.server2VM, durableClientId, "LessThan5", 5);
        this.createCq(this.durableClientVM, "GreaterThan5", "select * from /" + this.regionName + " p where p.ID > 5", true);
        this.createCq(this.durableClientVM, "All", "select * from /" + this.regionName + " p where p.ID > -1", true);
        this.createCq(this.durableClientVM, "LessThan5", "select * from /" + this.regionName + " p where p.ID < 5", true);
        this.sendClientReady(this.durableClientVM);
        this.checkCqListenerEvents(this.durableClientVM, "GreaterThan5", 4, 4, 15);
        this.checkCqListenerEvents(this.durableClientVM, "LessThan5", 5, 5, 15);
        this.checkCqListenerEvents(this.durableClientVM, "All", 10, 10, 15);
        this.flushEntries(this.server2VM, this.durableClientVM, this.regionName);
        this.checkCqStatOnServer(this.server2VM, durableClientId, "LessThan5", 0);
        this.checkCqStatOnServer(this.server2VM, durableClientId, "GreaterThan5", 0);
        this.checkCqStatOnServer(this.server2VM, durableClientId, "All", 0);
        this.checkCqStatOnServer(this.server1VM, durableClientId, "LessThan5", 0);
        this.checkCqStatOnServer(this.server1VM, durableClientId, "GreaterThan5", 0);
        this.checkCqStatOnServer(this.server1VM, durableClientId, "All", 0);
        this.durableClientVM.invoke(CacheServerTestUtil.class, "closeCache");
        this.publisherClientVM.invoke(CacheServerTestUtil.class, "closeCache");
        this.server1VM.invoke(CacheServerTestUtil.class, "closeCache");
        this.server2VM.invoke(CacheServerTestUtil.class, "closeCache");
    }

    public void testHAQueuedCqStatForFailover() throws Exception {
        String greaterThan5Query = "select * from /" + this.regionName + " p where p.ID > 5";
        String allQuery = "select * from /" + this.regionName + " p where p.ID > -1";
        String lessThan5Query = "select * from /" + this.regionName + " p where p.ID < 5";
        Integer[] ports = (Integer[])this.server1VM.invoke(CacheServerTestUtil.class, "createCacheServerReturnPorts", new Object[]{this.regionName, new Boolean(true)});
        int serverPort = ports[0];
        int mcastPort = ports[1];
        int serverPort2 = (Integer)this.server2VM.invoke(CacheServerTestUtil.class, "createCacheServer", new Object[]{this.regionName, new Boolean(true), new Integer(mcastPort)});
        String durableClientId = this.getName() + "_client";
        this.durableClientVM.invoke(CacheServerTestUtil.class, "disableShufflingOfEndpoints");
        this.startDurableClient(this.durableClientVM, durableClientId, serverPort, serverPort2, this.regionName);
        this.createCq(this.durableClientVM, "GreaterThan5", greaterThan5Query, true);
        this.createCq(this.durableClientVM, "All", allQuery, true);
        this.createCq(this.durableClientVM, "LessThan5", lessThan5Query, true);
        this.sendClientReady(this.durableClientVM);
        this.verifyDurableClientOnServer(this.server2VM, durableClientId);
        this.verifyDurableClientOnServer(this.server1VM, durableClientId);
        this.checkNumDurableCqs(this.server1VM, durableClientId, 3);
        this.checkNumDurableCqs(this.server2VM, durableClientId, 3);
        this.disconnectDurableClient(true);
        this.startClient(this.publisherClientVM, serverPort, this.regionName);
        this.publishEntries(this.publisherClientVM, this.regionName, 10);
        this.closeCache(this.server1VM);
        this.checkNumDurableCqs(this.server2VM, durableClientId, 3);
        this.checkCqStatOnServer(this.server2VM, durableClientId, "All", 10);
        this.checkCqStatOnServer(this.server2VM, durableClientId, "GreaterThan5", 4);
        this.checkCqStatOnServer(this.server2VM, durableClientId, "LessThan5", 5);
        this.startDurableClient(this.durableClientVM, durableClientId, serverPort, serverPort2, this.regionName);
        this.createCq(this.durableClientVM, "GreaterThan5", "select * from /" + this.regionName + " p where p.ID > 5", true);
        this.createCq(this.durableClientVM, "All", "select * from /" + this.regionName + " p where p.ID > -1", true);
        this.createCq(this.durableClientVM, "LessThan5", "select * from /" + this.regionName + " p where p.ID < 5", true);
        this.sendClientReady(this.durableClientVM);
        this.checkCqListenerEvents(this.durableClientVM, "GreaterThan5", 4, 4, 15);
        this.checkCqListenerEvents(this.durableClientVM, "LessThan5", 5, 5, 15);
        this.checkCqListenerEvents(this.durableClientVM, "All", 10, 10, 15);
        this.flushEntries(this.server2VM, this.durableClientVM, this.regionName);
        this.checkCqStatOnServer(this.server2VM, durableClientId, "LessThan5", 0);
        this.checkCqStatOnServer(this.server2VM, durableClientId, "GreaterThan5", 0);
        this.checkCqStatOnServer(this.server2VM, durableClientId, "All", 0);
        this.durableClientVM.invoke(CacheServerTestUtil.class, "closeCache");
        this.publisherClientVM.invoke(CacheServerTestUtil.class, "closeCache");
        this.server2VM.invoke(CacheServerTestUtil.class, "closeCache");
    }

    public void testHAQueuedCqStatWithTimeOut() throws Exception {
        String greaterThan5Query = "select * from /" + this.regionName + " p where p.ID > 5";
        String allQuery = "select * from /" + this.regionName + " p where p.ID > -1";
        String lessThan5Query = "select * from /" + this.regionName + " p where p.ID < 5";
        int timeoutInSeconds = 20;
        Integer[] ports = (Integer[])this.server1VM.invoke(CacheServerTestUtil.class, "createCacheServerReturnPorts", new Object[]{this.regionName, new Boolean(true)});
        int serverPort = ports[0];
        int mcastPort = ports[1];
        String durableClientId = this.getName() + "_client";
        this.startDurableClient(this.durableClientVM, durableClientId, serverPort, this.regionName, timeoutInSeconds);
        this.createCq(this.durableClientVM, "GreaterThan5", greaterThan5Query, true);
        this.createCq(this.durableClientVM, "All", allQuery, true);
        this.createCq(this.durableClientVM, "LessThan5", lessThan5Query, true);
        this.sendClientReady(this.durableClientVM);
        this.verifyDurableClientOnServer(this.server1VM, durableClientId);
        this.disconnectDurableClient(true);
        this.startClient(this.publisherClientVM, serverPort, this.regionName);
        this.publishEntries(this.publisherClientVM, this.regionName, 10);
        this.checkNumDurableCqs(this.server1VM, durableClientId, 3);
        this.checkCqStatOnServer(this.server1VM, durableClientId, "All", 10);
        this.checkCqStatOnServer(this.server1VM, durableClientId, "GreaterThan5", 4);
        this.checkCqStatOnServer(this.server1VM, durableClientId, "LessThan5", 5);
        try {
            Thread.sleep((timeoutInSeconds + 5) * 1000);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        this.startDurableClient(this.durableClientVM, durableClientId, serverPort, this.regionName);
        this.createCq(this.durableClientVM, "GreaterThan5", "select * from /" + this.regionName + " p where p.ID > 5", true);
        this.createCq(this.durableClientVM, "All", "select * from /" + this.regionName + " p where p.ID > -1", true);
        this.createCq(this.durableClientVM, "LessThan5", "select * from /" + this.regionName + " p where p.ID < 5", true);
        this.sendClientReady(this.durableClientVM);
        this.checkCqListenerEvents(this.durableClientVM, "GreaterThan5", 0, 1, 5);
        this.checkCqListenerEvents(this.durableClientVM, "LessThan5", 0, 1, 5);
        this.checkCqListenerEvents(this.durableClientVM, "All", 0, 1, 5);
        this.flushEntries(this.server1VM, this.durableClientVM, this.regionName);
        this.checkCqStatOnServer(this.server1VM, durableClientId, "LessThan5", 0);
        this.checkCqStatOnServer(this.server1VM, durableClientId, "GreaterThan5", 0);
        this.checkCqStatOnServer(this.server1VM, durableClientId, "All", 0);
        this.durableClientVM.invoke(CacheServerTestUtil.class, "closeCache");
        this.publisherClientVM.invoke(CacheServerTestUtil.class, "closeCache");
        this.server1VM.invoke(CacheServerTestUtil.class, "closeCache");
    }

    public void testCloseCqAndDrainEvents() throws Exception {
        String greaterThan5Query = "select * from /" + this.regionName + " p where p.ID > 5";
        String allQuery = "select * from /" + this.regionName + " p where p.ID > -1";
        String lessThan5Query = "select * from /" + this.regionName + " p where p.ID < 5";
        int serverPort = (Integer)this.server1VM.invoke(CacheServerTestUtil.class, "createCacheServer", new Object[]{this.regionName, new Boolean(true)});
        final String durableClientId = this.getName() + "_client";
        this.startDurableClient(this.durableClientVM, durableClientId, serverPort, this.regionName);
        this.createCq(this.durableClientVM, "GreaterThan5", greaterThan5Query, true);
        this.createCq(this.durableClientVM, "All", allQuery, true);
        this.createCq(this.durableClientVM, "LessThan5", lessThan5Query, true);
        this.sendClientReady(this.durableClientVM);
        this.verifyDurableClientOnServer(this.server1VM, durableClientId);
        this.disconnectDurableClient(true);
        this.startClient(this.publisherClientVM, serverPort, this.regionName);
        this.publishEntries(this.publisherClientVM, this.regionName, 10);
        this.server1VM.invoke(new CacheSerializableRunnable("Close cq for durable client"){

            @Override
            public void run2() throws CacheException {
                CacheClientNotifier ccnInstance = CacheClientNotifier.getInstance();
                CacheClientProxy clientProxy = ccnInstance.getClientProxy(durableClientId);
                ClientProxyMembershipID proxyId = clientProxy.getProxyID();
                try {
                    ccnInstance.closeClientCq(durableClientId, "All");
                }
                catch (CqException e) {
                    throw new CacheException(e){};
                }
            }
        });
        this.startDurableClient(this.durableClientVM, durableClientId, serverPort, this.regionName);
        this.createCq(this.durableClientVM, "GreaterThan5", "select * from /" + this.regionName + " p where p.ID > 5", true);
        this.createCq(this.durableClientVM, "All", "select * from /" + this.regionName + " p where p.ID > -1", true);
        this.createCq(this.durableClientVM, "LessThan5", "select * from /" + this.regionName + " p where p.ID < 5", true);
        this.sendClientReady(this.durableClientVM);
        this.checkCqListenerEvents(this.durableClientVM, "GreaterThan5", 4, 4, 15);
        this.checkCqListenerEvents(this.durableClientVM, "LessThan5", 5, 5, 15);
        this.checkCqListenerEvents(this.durableClientVM, "All", 0, 1, 5);
        this.durableClientVM.invoke(CacheServerTestUtil.class, "closeCache");
        this.publisherClientVM.invoke(CacheServerTestUtil.class, "closeCache");
        this.server1VM.invoke(CacheServerTestUtil.class, "closeCache");
    }

    public void testCloseAllCqsAndDrainEvents() throws Exception {
        String greaterThan5Query = "select * from /" + this.regionName + " p where p.ID > 5";
        String allQuery = "select * from /" + this.regionName + " p where p.ID > -1";
        String lessThan5Query = "select * from /" + this.regionName + " p where p.ID < 5";
        Integer[] ports = (Integer[])this.server1VM.invoke(CacheServerTestUtil.class, "createCacheServerReturnPorts", new Object[]{this.regionName, new Boolean(true)});
        int serverPort = ports[0];
        int mcastPort = ports[1];
        final String durableClientId = this.getName() + "_client";
        this.startDurableClient(this.durableClientVM, durableClientId, serverPort, this.regionName);
        this.registerInterest(this.durableClientVM, this.regionName, true);
        this.createCq(this.durableClientVM, "GreaterThan5", greaterThan5Query, true);
        this.createCq(this.durableClientVM, "All", allQuery, true);
        this.createCq(this.durableClientVM, "LessThan5", lessThan5Query, true);
        this.sendClientReady(this.durableClientVM);
        this.verifyDurableClientOnServer(this.server1VM, durableClientId);
        this.disconnectDurableClient(true);
        this.startClient(this.publisherClientVM, serverPort, this.regionName);
        this.publishEntries(this.publisherClientVM, this.regionName, 10);
        this.server1VM.invoke(new CacheSerializableRunnable("Close cq for durable client"){

            @Override
            public void run2() throws CacheException {
                CacheClientNotifier ccnInstance = CacheClientNotifier.getInstance();
                CacheClientProxy clientProxy = ccnInstance.getClientProxy(durableClientId);
                ClientProxyMembershipID proxyId = clientProxy.getProxyID();
                try {
                    ccnInstance.closeClientCq(durableClientId, "All");
                    ccnInstance.closeClientCq(durableClientId, "GreaterThan5");
                    ccnInstance.closeClientCq(durableClientId, "LessThan5");
                }
                catch (CqException e) {
                    throw new CacheException(e){};
                }
            }
        });
        this.startDurableClient(this.durableClientVM, durableClientId, serverPort, this.regionName);
        this.registerInterest(this.durableClientVM, this.regionName, true);
        this.createCq(this.durableClientVM, "GreaterThan5", "select * from /" + this.regionName + " p where p.ID > 5", true);
        this.createCq(this.durableClientVM, "All", "select * from /" + this.regionName + " p where p.ID > -1", true);
        this.createCq(this.durableClientVM, "LessThan5", "select * from /" + this.regionName + " p where p.ID < 5", true);
        this.sendClientReady(this.durableClientVM);
        this.checkCqListenerEvents(this.durableClientVM, "GreaterThan5", 0, 1, 5);
        this.checkCqListenerEvents(this.durableClientVM, "LessThan5", 0, 1, 5);
        this.checkCqListenerEvents(this.durableClientVM, "All", 0, 1, 5);
        this.checkInterestEvents(this.durableClientVM, this.regionName, 10);
        this.durableClientVM.invoke(CacheServerTestUtil.class, "closeCache");
        this.publisherClientVM.invoke(CacheServerTestUtil.class, "closeCache");
        this.server1VM.invoke(CacheServerTestUtil.class, "closeCache");
    }

    public void testCloseAllCqsAndDrainEventsNoInterestRegistered() throws Exception {
        String greaterThan5Query = "select * from /" + this.regionName + " p where p.ID > 5";
        String allQuery = "select * from /" + this.regionName + " p where p.ID > -1";
        String lessThan5Query = "select * from /" + this.regionName + " p where p.ID < 5";
        Integer[] ports = (Integer[])this.server1VM.invoke(CacheServerTestUtil.class, "createCacheServerReturnPorts", new Object[]{this.regionName, new Boolean(true)});
        int serverPort = ports[0];
        int mcastPort = ports[1];
        final String durableClientId = this.getName() + "_client";
        this.startDurableClient(this.durableClientVM, durableClientId, serverPort, this.regionName);
        this.createCq(this.durableClientVM, "GreaterThan5", greaterThan5Query, true);
        this.createCq(this.durableClientVM, "All", allQuery, true);
        this.createCq(this.durableClientVM, "LessThan5", lessThan5Query, true);
        this.sendClientReady(this.durableClientVM);
        this.verifyDurableClientOnServer(this.server1VM, durableClientId);
        this.disconnectDurableClient(true);
        this.startClient(this.publisherClientVM, serverPort, this.regionName);
        this.publishEntries(this.publisherClientVM, this.regionName, 10);
        this.server1VM.invoke(new CacheSerializableRunnable("Close cq for durable client"){

            @Override
            public void run2() throws CacheException {
                CacheClientNotifier ccnInstance = CacheClientNotifier.getInstance();
                CacheClientProxy clientProxy = ccnInstance.getClientProxy(durableClientId);
                ClientProxyMembershipID proxyId = clientProxy.getProxyID();
                try {
                    ccnInstance.closeClientCq(durableClientId, "All");
                    ccnInstance.closeClientCq(durableClientId, "GreaterThan5");
                    ccnInstance.closeClientCq(durableClientId, "LessThan5");
                }
                catch (CqException e) {
                    throw new CacheException(e){};
                }
            }
        });
        this.startDurableClient(this.durableClientVM, durableClientId, serverPort, this.regionName);
        this.createCq(this.durableClientVM, "GreaterThan5", "select * from /" + this.regionName + " p where p.ID > 5", true);
        this.createCq(this.durableClientVM, "All", "select * from /" + this.regionName + " p where p.ID > -1", true);
        this.createCq(this.durableClientVM, "LessThan5", "select * from /" + this.regionName + " p where p.ID < 5", true);
        this.sendClientReady(this.durableClientVM);
        this.checkCqListenerEvents(this.durableClientVM, "GreaterThan5", 0, 1, 5);
        this.checkCqListenerEvents(this.durableClientVM, "LessThan5", 0, 1, 5);
        this.checkCqListenerEvents(this.durableClientVM, "All", 0, 1, 5);
        this.flushEntries(this.server1VM, this.durableClientVM, this.regionName);
        this.checkHAQueueSize(this.server1VM, durableClientId, 0, 1);
        this.publishEntries(this.publisherClientVM, this.regionName, 10);
        this.checkCqListenerEvents(this.durableClientVM, "GreaterThan5", 4, 4, 10);
        this.checkCqListenerEvents(this.durableClientVM, "LessThan5", 5, 5, 10);
        this.checkCqListenerEvents(this.durableClientVM, "All", 10, 10, 10);
        this.flushEntries(this.server1VM, this.durableClientVM, this.regionName);
        this.checkHAQueueSize(this.server1VM, durableClientId, 0, 1);
        this.durableClientVM.invoke(CacheServerTestUtil.class, "closeCache");
        this.publisherClientVM.invoke(CacheServerTestUtil.class, "closeCache");
        this.server1VM.invoke(CacheServerTestUtil.class, "closeCache");
    }

    public void testCloseCqAndDrainEvents2Client() throws Exception {
        String greaterThan5Query = "select * from /" + this.regionName + " p where p.ID > 5";
        String allQuery = "select * from /" + this.regionName + " p where p.ID > -1";
        String lessThan5Query = "select * from /" + this.regionName + " p where p.ID < 5";
        Integer[] ports = (Integer[])this.server1VM.invoke(CacheServerTestUtil.class, "createCacheServerReturnPorts", new Object[]{this.regionName, new Boolean(true)});
        int serverPort = ports[0];
        int mcastPort = ports[1];
        final String durableClientId = this.getName() + "_client";
        String durableClientId2 = this.getName() + "_client2";
        this.startDurableClient(this.durableClientVM, durableClientId, serverPort, this.regionName);
        this.createCq(this.durableClientVM, "GreaterThan5", greaterThan5Query, true);
        this.createCq(this.durableClientVM, "All", allQuery, true);
        this.createCq(this.durableClientVM, "LessThan5", lessThan5Query, true);
        this.sendClientReady(this.durableClientVM);
        this.verifyDurableClientOnServer(this.server1VM, durableClientId);
        this.disconnectDurableClient(true);
        this.startDurableClient(this.durableClientVM, durableClientId2, serverPort, this.regionName);
        this.createCq(this.durableClientVM, "GreaterThan5", greaterThan5Query, true);
        this.createCq(this.durableClientVM, "All", allQuery, true);
        this.createCq(this.durableClientVM, "LessThan5", lessThan5Query, true);
        this.sendClientReady(this.durableClientVM);
        this.server1VM.invoke(new CacheSerializableRunnable("Verify 2nd durable client"){

            @Override
            public void run2() throws CacheException {
                DurableClientDUnitTest.checkNumberOfClientProxies(2);
            }
        });
        this.disconnectDurableClient(true);
        this.startClient(this.publisherClientVM, serverPort, this.regionName);
        this.publishEntries(this.publisherClientVM, this.regionName, 10);
        this.server1VM.invoke(new CacheSerializableRunnable("Close cq for durable client 1"){

            @Override
            public void run2() throws CacheException {
                CacheClientNotifier ccnInstance = CacheClientNotifier.getInstance();
                CacheClientProxy clientProxy = ccnInstance.getClientProxy(durableClientId);
                ClientProxyMembershipID proxyId = clientProxy.getProxyID();
                try {
                    ccnInstance.closeClientCq(durableClientId, "All");
                }
                catch (CqException e) {
                    throw new CacheException(e){};
                }
            }
        });
        this.startDurableClient(this.durableClientVM, durableClientId, serverPort, this.regionName);
        this.createCq(this.durableClientVM, "GreaterThan5", "select * from /" + this.regionName + " p where p.ID > 5", true);
        this.createCq(this.durableClientVM, "All", "select * from /" + this.regionName + " p where p.ID > -1", true);
        this.createCq(this.durableClientVM, "LessThan5", "select * from /" + this.regionName + " p where p.ID < 5", true);
        this.sendClientReady(this.durableClientVM);
        this.checkCqListenerEvents(this.durableClientVM, "GreaterThan5", 4, 4, 15);
        this.checkCqListenerEvents(this.durableClientVM, "LessThan5", 5, 5, 15);
        this.checkCqListenerEvents(this.durableClientVM, "All", 0, 1, 5);
        this.disconnectDurableClient(false);
        this.startDurableClient(this.durableClientVM, durableClientId2, serverPort, this.regionName);
        this.createCq(this.durableClientVM, "GreaterThan5", "select * from /" + this.regionName + " p where p.ID > 5", true);
        this.createCq(this.durableClientVM, "All", "select * from /" + this.regionName + " p where p.ID > -1", true);
        this.createCq(this.durableClientVM, "LessThan5", "select * from /" + this.regionName + " p where p.ID < 5", true);
        this.sendClientReady(this.durableClientVM);
        this.checkCqListenerEvents(this.durableClientVM, "GreaterThan5", 4, 4, 15);
        this.checkCqListenerEvents(this.durableClientVM, "LessThan5", 5, 5, 15);
        this.checkCqListenerEvents(this.durableClientVM, "All", 10, 10, 15);
        this.durableClientVM.invoke(CacheServerTestUtil.class, "closeCache");
        this.publisherClientVM.invoke(CacheServerTestUtil.class, "closeCache");
        this.server1VM.invoke(CacheServerTestUtil.class, "closeCache");
    }

    public void testRejectClientWhenDrainingCq() throws Exception {
        DistributedTestCase.addExpectedException(LocalizedStrings.CacheClientNotifier_COULD_NOT_CONNECT_DUE_TO_CQ_BEING_DRAINED.toLocalizedString());
        DistributedTestCase.addExpectedException("Could not initialize a primary queue on startup. No queue servers available.");
        String greaterThan5Query = "select * from /" + this.regionName + " p where p.ID > 5";
        String allQuery = "select * from /" + this.regionName + " p where p.ID > -1";
        String lessThan5Query = "select * from /" + this.regionName + " p where p.ID < 5";
        Integer[] ports = (Integer[])this.server1VM.invoke(CacheServerTestUtil.class, "createCacheServerReturnPorts", new Object[]{this.regionName, new Boolean(true)});
        int serverPort = ports[0];
        int mcastPort = ports[1];
        final String durableClientId = this.getName() + "_client";
        this.durableClientVM.invoke(CacheServerTestUtil.class, "disableShufflingOfEndpoints");
        this.startDurableClient(this.durableClientVM, durableClientId, serverPort, this.regionName);
        this.createCq(this.durableClientVM, "GreaterThan5", greaterThan5Query, true);
        this.createCq(this.durableClientVM, "All", allQuery, true);
        this.createCq(this.durableClientVM, "LessThan5", lessThan5Query, true);
        this.sendClientReady(this.durableClientVM);
        this.verifyDurableClientOnServer(this.server1VM, durableClientId);
        this.disconnectDurableClient(true);
        this.startClient(this.publisherClientVM, serverPort, this.regionName);
        this.publishEntries(this.publisherClientVM, this.regionName, 10);
        this.server1VM.invokeAsync(new CacheSerializableRunnable("Close cq for durable client"){

            @Override
            public void run2() throws CacheException {
                CacheClientProxy.testHook = new DurableClientDUnitTest.RejectClientReconnectTestHook();
                CacheClientNotifier ccnInstance = CacheClientNotifier.getInstance();
                CacheClientProxy clientProxy = ccnInstance.getClientProxy(durableClientId);
                ClientProxyMembershipID proxyId = clientProxy.getProxyID();
                try {
                    ccnInstance.closeClientCq(durableClientId, "All");
                }
                catch (CqException e) {
                    throw new CacheException(e){};
                }
            }
        });
        this.startDurableClient(this.durableClientVM, durableClientId, serverPort, this.regionName);
        this.server1VM.invoke(new CacheSerializableRunnable("verify was rejected at least once"){

            @Override
            public void run2() throws CacheException {
                DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

                    @Override
                    public boolean done() {
                        return ((DurableClientDUnitTest.RejectClientReconnectTestHook)CacheClientProxy.testHook).wasClientRejected();
                    }

                    @Override
                    public String description() {
                        return null;
                    }
                };
                DistributedTestCase.waitForCriterion(ev, 10000L, 200L, true);
                TestCase.assertTrue((boolean)((DurableClientDUnitTest.RejectClientReconnectTestHook)CacheClientProxy.testHook).wasClientRejected());
            }
        });
        this.checkPrimaryUpdater(this.durableClientVM);
        this.verifyDurableClientOnServer(this.server1VM, durableClientId);
        this.createCq(this.durableClientVM, "GreaterThan5", "select * from /" + this.regionName + " p where p.ID > 5", true);
        this.createCq(this.durableClientVM, "All", "select * from /" + this.regionName + " p where p.ID > -1", true);
        this.createCq(this.durableClientVM, "LessThan5", "select * from /" + this.regionName + " p where p.ID < 5", true);
        this.sendClientReady(this.durableClientVM);
        this.checkCqListenerEvents(this.durableClientVM, "GreaterThan5", 4, 4, 15);
        this.checkCqListenerEvents(this.durableClientVM, "LessThan5", 5, 5, 15);
        this.checkCqListenerEvents(this.durableClientVM, "All", 0, 1, 5);
        this.server1VM.invoke(new CacheSerializableRunnable("unset test hook"){

            @Override
            public void run2() throws CacheException {
                CacheClientProxy.testHook = null;
            }
        });
        this.durableClientVM.invoke(CacheServerTestUtil.class, "closeCache");
        this.publisherClientVM.invoke(CacheServerTestUtil.class, "closeCache");
        this.server1VM.invoke(CacheServerTestUtil.class, "closeCache");
    }

    public void testCqCloseExceptionDueToActivatingClient() throws Exception {
        String greaterThan5Query = "select * from /" + this.regionName + " p where p.ID > 5";
        String allQuery = "select * from /" + this.regionName + " p where p.ID > -1";
        String lessThan5Query = "select * from /" + this.regionName + " p where p.ID < 5";
        Integer[] ports = (Integer[])this.server1VM.invoke(CacheServerTestUtil.class, "createCacheServerReturnPorts", new Object[]{this.regionName, new Boolean(true)});
        int serverPort = ports[0];
        int mcastPort = ports[1];
        final String durableClientId = this.getName() + "_client";
        this.startDurableClient(this.durableClientVM, durableClientId, serverPort, this.regionName);
        this.createCq(this.durableClientVM, "GreaterThan5", greaterThan5Query, true);
        this.createCq(this.durableClientVM, "All", allQuery, true);
        this.createCq(this.durableClientVM, "LessThan5", lessThan5Query, true);
        this.sendClientReady(this.durableClientVM);
        this.verifyDurableClientOnServer(this.server1VM, durableClientId);
        this.disconnectDurableClient(true);
        this.startClient(this.publisherClientVM, serverPort, this.regionName);
        this.publishEntries(this.publisherClientVM, this.regionName, 10);
        AsyncInvocation async = this.server1VM.invokeAsync(new CacheSerializableRunnable("Close cq for durable client"){

            @Override
            public void run2() throws CacheException {
                block2: {
                    CacheClientProxy.testHook = new DurableClientDUnitTest.CqExceptionDueToActivatingClientTestHook();
                    CacheClientNotifier ccnInstance = CacheClientNotifier.getInstance();
                    CacheClientProxy clientProxy = ccnInstance.getClientProxy(durableClientId);
                    ClientProxyMembershipID proxyId = clientProxy.getProxyID();
                    try {
                        ccnInstance.closeClientCq(durableClientId, "All");
                        TestCase.fail((String)"Should have thrown an exception due to activating client");
                    }
                    catch (CqException e) {
                        String expected = LocalizedStrings.CacheClientProxy_COULD_NOT_DRAIN_CQ_DUE_TO_RESTARTING_DURABLE_CLIENT.toLocalizedString(new Object[]{"All", proxyId.getDurableId()});
                        if (e.getMessage().equals(expected)) break block2;
                        TestCase.fail((String)("Not the expected exception, was expecting " + LocalizedStrings.CacheClientProxy_COULD_NOT_DRAIN_CQ_DUE_TO_RESTARTING_DURABLE_CLIENT.toLocalizedString(new Object[]{"All", proxyId.getDurableId()}) + " instead of exception: " + e.getMessage()));
                    }
                }
            }
        });
        this.startDurableClient(this.durableClientVM, durableClientId, serverPort, this.regionName);
        this.createCq(this.durableClientVM, "GreaterThan5", "select * from /" + this.regionName + " p where p.ID > 5", true);
        this.createCq(this.durableClientVM, "All", "select * from /" + this.regionName + " p where p.ID > -1", true);
        this.createCq(this.durableClientVM, "LessThan5", "select * from /" + this.regionName + " p where p.ID < 5", true);
        this.sendClientReady(this.durableClientVM);
        async.join();
        DurableClientSimpleDUnitTests.assertEquals((String)(async.getException() != null ? async.getException().toString() : "No error"), (boolean)false, (boolean)async.exceptionOccurred());
        this.checkCqListenerEvents(this.durableClientVM, "GreaterThan5", 4, 4, 15);
        this.checkCqListenerEvents(this.durableClientVM, "LessThan5", 5, 5, 15);
        this.checkCqListenerEvents(this.durableClientVM, "All", 10, 10, 15);
        this.server1VM.invoke(new CacheSerializableRunnable("unset test hook"){

            @Override
            public void run2() throws CacheException {
                CacheClientProxy.testHook = null;
            }
        });
        this.durableClientVM.invoke(CacheServerTestUtil.class, "closeCache");
        this.publisherClientVM.invoke(CacheServerTestUtil.class, "closeCache");
        this.server1VM.invoke(CacheServerTestUtil.class, "closeCache");
    }

    public void testCqCloseExceptionDueToActiveConnection() throws Exception {
        String greaterThan5Query = "select * from /" + this.regionName + " p where p.ID > 5";
        String allQuery = "select * from /" + this.regionName + " p where p.ID > -1";
        String lessThan5Query = "select * from /" + this.regionName + " p where p.ID < 5";
        int serverPort = (Integer)this.server1VM.invoke(CacheServerTestUtil.class, "createCacheServer", new Object[]{this.regionName, new Boolean(true)});
        final String durableClientId = this.getName() + "_client";
        this.startDurableClient(this.durableClientVM, durableClientId, serverPort, this.regionName);
        this.sendClientReady(this.durableClientVM);
        this.createCq(this.durableClientVM, "GreaterThan5", greaterThan5Query, true);
        this.createCq(this.durableClientVM, "All", allQuery, true);
        this.createCq(this.durableClientVM, "LessThan5", lessThan5Query, true);
        this.verifyDurableClientOnServer(this.server1VM, durableClientId);
        this.startClient(this.publisherClientVM, serverPort, this.regionName);
        this.publishEntries(this.publisherClientVM, this.regionName, 10);
        this.server1VM.invoke(new CacheSerializableRunnable("Close cq for durable client"){

            @Override
            public void run2() throws CacheException {
                block2: {
                    CacheClientNotifier ccnInstance = CacheClientNotifier.getInstance();
                    CacheClientProxy clientProxy = ccnInstance.getClientProxy(durableClientId);
                    ClientProxyMembershipID proxyId = clientProxy.getProxyID();
                    try {
                        ccnInstance.closeClientCq(durableClientId, "All");
                        TestCase.fail((String)"expected a cq exception.  We have an active client proxy, the close cq command should have failed");
                    }
                    catch (CqException e) {
                        String expected = LocalizedStrings.CacheClientProxy_COULD_NOT_DRAIN_CQ_DUE_TO_ACTIVE_DURABLE_CLIENT.toLocalizedString(new Object[]{"All", proxyId.getDurableId()});
                        if (e.getMessage().equals(expected)) break block2;
                        TestCase.fail((String)("Not the expected exception, was expecting " + LocalizedStrings.CacheClientProxy_COULD_NOT_DRAIN_CQ_DUE_TO_ACTIVE_DURABLE_CLIENT.toLocalizedString(new Object[]{"All", proxyId.getDurableId()}) + " instead of exception: " + e.getMessage()));
                    }
                }
            }
        });
        this.checkCqListenerEvents(this.durableClientVM, "GreaterThan5", 4, 4, 15);
        this.checkCqListenerEvents(this.durableClientVM, "LessThan5", 5, 5, 15);
        this.checkCqListenerEvents(this.durableClientVM, "All", 10, 10, 15);
        this.durableClientVM.invoke(CacheServerTestUtil.class, "closeCache");
        this.publisherClientVM.invoke(CacheServerTestUtil.class, "closeCache");
        this.server1VM.invoke(CacheServerTestUtil.class, "closeCache");
    }

    public void testCloseCacheProxy() throws Exception {
        String greaterThan5Query = "select * from /" + this.regionName + " p where p.ID > 5";
        String allQuery = "select * from /" + this.regionName + " p where p.ID > -1";
        String lessThan5Query = "select * from /" + this.regionName + " p where p.ID < 5";
        int serverPort = (Integer)this.server1VM.invoke(CacheServerTestUtil.class, "createCacheServer", new Object[]{this.regionName, new Boolean(true)});
        final String durableClientId = this.getName() + "_client";
        this.startDurableClient(this.durableClientVM, durableClientId, serverPort, this.regionName);
        this.createCq(this.durableClientVM, "GreaterThan5", greaterThan5Query, true);
        this.createCq(this.durableClientVM, "All", allQuery, true);
        this.createCq(this.durableClientVM, "LessThan5", lessThan5Query, true);
        this.sendClientReady(this.durableClientVM);
        this.verifyDurableClientOnServer(this.server1VM, durableClientId);
        this.disconnectDurableClient(true);
        this.startClient(this.publisherClientVM, serverPort, this.regionName);
        this.publishEntries(this.publisherClientVM, this.regionName, 10);
        this.checkNumDurableCqs(this.server1VM, durableClientId, 3);
        this.checkCqStatOnServer(this.server1VM, durableClientId, "All", 10);
        this.checkCqStatOnServer(this.server1VM, durableClientId, "GreaterThan5", 4);
        this.checkCqStatOnServer(this.server1VM, durableClientId, "LessThan5", 5);
        this.server1VM.invoke(new CacheSerializableRunnable("Close client proxy on server for client" + durableClientId){

            @Override
            public void run2() throws CacheException {
                CacheClientNotifier ccnInstance = CacheClientNotifier.getInstance();
                CacheClientProxy clientProxy = ccnInstance.getClientProxy(durableClientId);
                ClientProxyMembershipID proxyId = clientProxy.getProxyID();
                ccnInstance.closeDurableClientProxy(durableClientId);
            }
        });
        this.startDurableClient(this.durableClientVM, durableClientId, serverPort, this.regionName);
        this.checkNumDurableCqs(this.server1VM, durableClientId, 0);
        this.createCq(this.durableClientVM, "GreaterThan5", "select * from /" + this.regionName + " p where p.ID > 5", true);
        this.createCq(this.durableClientVM, "All", "select * from /" + this.regionName + " p where p.ID > -1", true);
        this.createCq(this.durableClientVM, "LessThan5", "select * from /" + this.regionName + " p where p.ID < 5", true);
        this.checkCqStatOnServer(this.server1VM, durableClientId, "LessThan5", 0);
        this.checkCqStatOnServer(this.server1VM, durableClientId, "GreaterThan5", 0);
        this.checkCqStatOnServer(this.server1VM, durableClientId, "All", 0);
        this.sendClientReady(this.durableClientVM);
        this.checkCqListenerEvents(this.durableClientVM, "GreaterThan5", 0, 1, 5);
        this.checkCqListenerEvents(this.durableClientVM, "LessThan5", 0, 1, 5);
        this.checkCqListenerEvents(this.durableClientVM, "All", 0, 1, 5);
        this.durableClientVM.invoke(CacheServerTestUtil.class, "closeCache");
        this.publisherClientVM.invoke(CacheServerTestUtil.class, "closeCache");
        this.server1VM.invoke(CacheServerTestUtil.class, "closeCache");
    }

    @Override
    public void testSimpleDurableClientMultipleServers() {
        Integer[] ports = (Integer[])this.server1VM.invoke(CacheServerTestUtil.class, "createCacheServerReturnPorts", new Object[]{this.regionName, new Boolean(true)});
        int server1Port = ports[0];
        int mcastPort = ports[1];
        int server2Port = (Integer)this.server2VM.invoke(CacheServerTestUtil.class, "createCacheServer", new Object[]{this.regionName, new Boolean(true), new Integer(mcastPort)});
        int durableClientTimeout = 60;
        final String durableClientId = this.getName() + "_client";
        this.durableClientVM.invoke(CacheServerTestUtil.class, "createCacheClient", new Object[]{this.getClientPool(DurableClientSimpleDUnitTests.getServerHostName(this.durableClientVM.getHost()), server1Port, server2Port, true), this.regionName, this.getClientDistributedSystemProperties(durableClientId, 60), Boolean.TRUE});
        this.durableClientVM.invoke(new CacheSerializableRunnable("Send clientReady"){

            @Override
            public void run2() throws CacheException {
                CacheServerTestUtil.getCache().readyForEvents();
            }
        });
        this.server1VM.invoke(new CacheSerializableRunnable("Verify durable client"){

            @Override
            public void run2() throws CacheException {
                DurableClientDUnitTest.checkNumberOfClientProxies(1);
                CacheClientProxy proxy = DurableClientDUnitTest.getClientProxy();
                TestCase.assertNotNull((Object)proxy);
                TestCase.assertTrue((boolean)proxy.isDurable());
                TestCase.assertEquals((String)durableClientId, (String)proxy.getDurableId());
                TestCase.assertEquals((int)60, (int)proxy.getDurableTimeout());
            }
        });
        this.server2VM.invoke(new CacheSerializableRunnable("Verify durable client"){

            @Override
            public void run2() throws CacheException {
                DurableClientDUnitTest.checkNumberOfClientProxies(1);
                CacheClientProxy proxy = DurableClientDUnitTest.getClientProxy();
                TestCase.assertNotNull((Object)proxy);
                TestCase.assertTrue((boolean)proxy.isDurable());
                TestCase.assertEquals((String)durableClientId, (String)proxy.getDurableId());
                TestCase.assertEquals((int)60, (int)proxy.getDurableTimeout());
            }
        });
        this.durableClientVM.invoke(CacheServerTestUtil.class, "closeCache", new Object[]{new Boolean(true)});
        this.server1VM.invoke(new CacheSerializableRunnable("Verify durable client"){

            @Override
            public void run2() throws CacheException {
                DurableClientDUnitTest.checkNumberOfClientProxies(1);
                CacheClientProxy proxy = DurableClientDUnitTest.getClientProxy();
                TestCase.assertNotNull((Object)proxy);
            }
        });
        this.server2VM.invoke(new CacheSerializableRunnable("Verify durable client"){

            @Override
            public void run2() throws CacheException {
                DurableClientDUnitTest.checkNumberOfClientProxies(1);
                CacheClientProxy proxy = DurableClientDUnitTest.getClientProxy();
                TestCase.assertNotNull((Object)proxy);
            }
        });
        this.durableClientVM.invoke(CacheServerTestUtil.class, "createCacheClient", new Object[]{this.getClientPool(DurableClientSimpleDUnitTests.getServerHostName(this.durableClientVM.getHost()), server1Port, server2Port, true), this.regionName, this.getClientDistributedSystemProperties(durableClientId), Boolean.TRUE});
        this.durableClientVM.invoke(new CacheSerializableRunnable("Send clientReady"){

            @Override
            public void run2() throws CacheException {
                CacheServerTestUtil.getCache().readyForEvents();
            }
        });
        this.server1VM.invoke(new CacheSerializableRunnable("Verify durable client"){

            @Override
            public void run2() throws CacheException {
                DurableClientDUnitTest.checkNumberOfClientProxies(1);
                CacheClientProxy proxy = DurableClientDUnitTest.getClientProxy();
                TestCase.assertNotNull((Object)proxy);
                TestCase.assertTrue((boolean)proxy.isDurable());
                TestCase.assertEquals((String)durableClientId, (String)proxy.getDurableId());
                TestCase.assertEquals((int)300, (int)proxy.getDurableTimeout());
            }
        });
        this.server2VM.invoke(new CacheSerializableRunnable("Verify durable client"){

            @Override
            public void run2() throws CacheException {
                DurableClientDUnitTest.checkNumberOfClientProxies(1);
                CacheClientProxy proxy = DurableClientDUnitTest.getClientProxy();
                TestCase.assertNotNull((Object)proxy);
                DurableClientDUnitTest.checkProxyIsAlive(proxy);
                TestCase.assertTrue((boolean)proxy.isDurable());
                TestCase.assertEquals((String)durableClientId, (String)proxy.getDurableId());
                TestCase.assertEquals((int)300, (int)proxy.getDurableTimeout());
            }
        });
        this.durableClientVM.invoke(CacheServerTestUtil.class, "closeCache");
        this.verifySimpleDurableClientMultipleServers();
        this.server1VM.invoke(CacheServerTestUtil.class, "closeCache");
        this.server2VM.invoke(CacheServerTestUtil.class, "closeCache");
    }
}

