/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.InvalidDeltaException;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.tier.sockets.FaultyDelta;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class DeltaEOFException
extends FaultyDelta {
    @Override
    public void fromDelta(DataInput in) throws IOException, InvalidDeltaException {
        try {
            byte deltaBits = DataSerializer.readByte((DataInput)in);
            GemFireCacheImpl.getInstance().getLogger().fine("Applying delta on " + this.toString());
            if (deltaBits != 0) {
                if ((deltaBits & 1) == 1) {
                    this.intVal = DataSerializer.readPrimitiveInt((DataInput)in);
                    GemFireCacheImpl.getInstance().getLogger().fine(" Applied delta on DeltaImpl's field 'intVal' = " + this.intVal);
                }
                if ((deltaBits & 2) == 2) {
                    this.bigObj = DataSerializer.readByteArray((DataInput)in);
                    GemFireCacheImpl.getInstance().getLogger().fine(" Applied delta on DeltaImpl's field 'bigObj' = {" + this.bigObj[0] + " " + this.bigObj[1] + "}");
                }
                if ((deltaBits | 3) != 3) {
                    GemFireCacheImpl.getInstance().getLogger().fine(" <unknown field code>");
                    throw new IllegalArgumentException("DeltaImpl.fromDelta(): Unknown field code, " + deltaBits);
                }
            }
            DataSerializer.readByte((DataInput)in);
            GemFireCacheImpl.getInstance().getLogger().fine(" Reading extra DeltaObj's field 'byte' ");
        }
        catch (IOException ioe) {
            GemFireCacheImpl.getInstance().getLogger().warning("DeltaObj.fromDelta(): " + ioe);
            throw ioe;
        }
        catch (IllegalArgumentException iae) {
            GemFireCacheImpl.getInstance().getLogger().warning("DeltaObj.fromDelta(): " + iae);
            throw new InvalidDeltaException((Throwable)iae);
        }
    }

    @Override
    public void toDelta(DataOutput out) throws IOException {
        try {
            DataSerializer.writeByte((Byte)this.deltaBits, (DataOutput)out);
            GemFireCacheImpl.getInstance().getLogger().fine("Extracting delta from " + this.toString());
            if ((this.deltaBits & 1) == 1) {
                GemFireCacheImpl.getInstance().getLogger().fine(" Extracted delta from DeltaObj's field 'intVal' = " + this.intVal);
                DataSerializer.writePrimitiveInt((int)this.intVal, (DataOutput)out);
            }
            if ((this.deltaBits & 2) == 2) {
                GemFireCacheImpl.getInstance().getLogger().fine(" Extracted delta from DeltaObj's field 'bigObj' = {" + this.bigObj[0] + " " + this.bigObj[1] + "}");
                DataSerializer.writeByteArray((byte[])this.bigObj, (DataOutput)out);
            }
            if ((this.deltaBits | 3) != 3) {
                GemFireCacheImpl.getInstance().getLogger().fine(" <unknown field code>");
                throw new IllegalArgumentException("DeltaImpl.toDelta(): Unknown field code, " + this.deltaBits);
            }
            GemFireCacheImpl.getInstance().getLogger().fine("-----------");
            this.resetDeltaStatus();
        }
        catch (IOException ioe) {
            GemFireCacheImpl.getInstance().getLogger().warning("DeltaObj.toDelta(): " + ioe);
            throw ioe;
        }
        catch (IllegalArgumentException iae) {
            GemFireCacheImpl.getInstance().getLogger().warning("DeltaObj.toDelta(): " + iae);
            throw new InvalidDeltaException((Throwable)iae);
        }
    }
}

