/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.MirrorType;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache.client.internal.Connection;
import com.gemstone.gemfire.cache.client.internal.PoolImpl;
import com.gemstone.gemfire.cache.client.internal.ServerRegionProxy;
import com.gemstone.gemfire.cache.util.BridgeServer;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.ServerLocation;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.cache.EventID;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheServerTestUtil;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import java.util.Properties;

public class Bug36269DUnitTest
extends DistributedTestCase {
    VM server1 = null;
    VM server2 = null;
    private static int PORT1;
    private static int PORT2;
    private static final String REGION_NAME = "Bug36269DUnitTest_region";
    protected static Cache cache;
    private static PoolImpl pool;

    public Bug36269DUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        Bug36269DUnitTest.disconnectAllFromDS();
        Host host = Host.getHost(0);
        this.server1 = host.getVM(0);
        this.server2 = host.getVM(1);
        PORT1 = (Integer)this.server1.invoke(Bug36269DUnitTest.class, "createServerCache");
        PORT2 = (Integer)this.server2.invoke(Bug36269DUnitTest.class, "createServerCache");
    }

    private void createCache(Properties props) throws Exception {
        InternalDistributedSystem ds = this.getSystem(props);
        cache = CacheFactory.create((DistributedSystem)ds);
        Bug36269DUnitTest.assertNotNull((Object)cache);
    }

    public void testRegionDestroyNotReceivedBySender() throws Exception {
        try {
            Bug36269DUnitTest.createClientCache();
            Bug36269DUnitTest.acquireConnectionsAndDestroyRegion(Bug36269DUnitTest.getServerHostName(Host.getHost(0)));
            this.server1.invoke(Bug36269DUnitTest.class, "verifyRegionDestroy");
            this.server2.invoke(Bug36269DUnitTest.class, "verifyRegionDestroy");
            Bug36269DUnitTest.pause(5000);
            Bug36269DUnitTest.verifyNoRegionDestroyOnOriginator();
        }
        catch (Exception ex) {
            Bug36269DUnitTest.fail((String)("failed gggg testRegionDestroyNotReceivedBySender  " + ex));
        }
    }

    public static void acquireConnectionsAndDestroyRegion(String host) {
        try {
            Connection desCon = pool.acquireConnection(new ServerLocation(host, PORT2));
            ServerRegionProxy srp = new ServerRegionProxy("/Bug36269DUnitTest_region", pool);
            srp.destroyRegionOnForTestsOnly(desCon, new EventID(new byte[]{1}, 1L, 1L), null);
        }
        catch (Exception ex) {
            Bug36269DUnitTest.fail("while setting acquireConnections", ex);
        }
    }

    public static void createClientCache() throws Exception {
        PoolImpl p;
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "");
        new Bug36269DUnitTest("temp").createCache(props);
        CacheServerTestUtil.disableShufflingOfEndpoints();
        String host = Bug36269DUnitTest.getServerHostName(Host.getHost(0));
        try {
            p = (PoolImpl)PoolManager.createFactory().addServer(host, PORT1).addServer(host, PORT2).setSubscriptionEnabled(true).setReadTimeout(2000).setSocketBufferSize(1000).setMinConnections(4).create("Bug36269DUnitTestPool");
        }
        finally {
            CacheServerTestUtil.enableShufflingOfEndpoints();
        }
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setPoolName(p.getName());
        pool = p;
        Bug36269DUnitTest.assertNotNull((Object)pool);
        cache.createRegion(REGION_NAME, factory.create());
    }

    public static Integer createServerCache() throws Exception {
        new Bug36269DUnitTest("temp").createCache(new Properties());
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setMirrorType(MirrorType.KEYS_VALUES);
        cache.createRegion(REGION_NAME, factory.create());
        BridgeServer server = cache.addBridgeServer();
        Bug36269DUnitTest.assertNotNull((Object)server);
        int port = AvailablePort.getRandomAvailablePort((int)0);
        server.setPort(port);
        server.setNotifyBySubscription(true);
        server.start();
        return new Integer(server.getPort());
    }

    public static void verifyNoRegionDestroyOnOriginator() {
        try {
            Region r = cache.getRegion("/Bug36269DUnitTest_region");
            Bug36269DUnitTest.assertNotNull((Object)r);
        }
        catch (Exception ex) {
            Bug36269DUnitTest.fail("failed while verifyNoRegionDestroyOnOriginator()", ex);
        }
    }

    public static void verifyRegionDestroy() {
        try {
            DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

                @Override
                public boolean done() {
                    return cache.getRegion("/Bug36269DUnitTest_region") == null;
                }

                @Override
                public String description() {
                    return null;
                }
            };
            DistributedTestCase.waitForCriterion(ev, 40000L, 200L, true);
        }
        catch (Exception ex) {
            Bug36269DUnitTest.fail("failed while verifyRegionDestroy", ex);
        }
    }

    public static void closeCache() {
        if (cache != null && !cache.isClosed()) {
            cache.close();
            cache.getDistributedSystem().disconnect();
        }
    }

    @Override
    public void tearDown2() throws Exception {
        Bug36269DUnitTest.closeCache();
        this.server1.invoke(Bug36269DUnitTest.class, "closeCache");
        this.server2.invoke(Bug36269DUnitTest.class, "closeCache");
    }

    static {
        cache = null;
        pool = null;
    }
}

