/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.rollingupgrade;

import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;

public class ChildFirstClassLoader
extends ClassLoader {
    private ExposeFindClassURLClassLoader childClassLoader;

    public ChildFirstClassLoader(URL[] urls, ClassLoader parentLoader) {
        super(parentLoader);
        this.childClassLoader = new ExposeFindClassURLClassLoader(urls, parentLoader);
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        return this.childClassLoader.findClass(name);
    }

    @Override
    public URL getResource(String name) {
        return this.childClassLoader.getResource(name);
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        return this.childClassLoader.getResourceAsStream(name);
    }

    private class ExposeFindClassURLClassLoader
    extends URLClassLoader {
        private ClassLoader parentLoader;

        public ExposeFindClassURLClassLoader(URL[] urls, ClassLoader parentLoader) {
            super(urls, (ClassLoader)null);
            this.parentLoader = parentLoader;
        }

        @Override
        public Class<?> findClass(String name) throws ClassNotFoundException {
            ExposeFindClassURLClassLoader exposeFindClassURLClassLoader = this;
            synchronized (exposeFindClassURLClassLoader) {
                Class<?> c = this.findLoadedClass(name);
                if (c != null) {
                    return c;
                }
                try {
                    c = super.findClass(name);
                    return c;
                }
                catch (ClassNotFoundException e) {
                    if (this.parentLoader != null) {
                        return this.parentLoader.loadClass(name);
                    }
                    throw e;
                }
            }
        }
    }
}

