/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.partitioned;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.CacheLoader;
import com.gemstone.gemfire.cache.CacheLoaderException;
import com.gemstone.gemfire.cache.CacheWriter;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.LoaderHelper;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.util.CacheWriterAdapter;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import dunit.Host;
import dunit.VM;
import java.io.Serializable;
import java.util.Properties;

public class PartitionedRegionLoaderWriterDUnitTest
extends CacheTestCase {
    private static final String PartitionedRegionName = "PartitionedRegionTest";
    Host host;
    VM accessor;
    VM datastore1;
    VM datastore2;
    private static Cache cache;

    public PartitionedRegionLoaderWriterDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
    }

    public void testLoader_OnAccessor_NotOnDataStore() {
        this.host = Host.getHost(0);
        this.accessor = this.host.getVM(0);
        this.datastore1 = this.host.getVM(1);
        this.accessor.invoke(PartitionedRegionLoaderWriterDUnitTest.class, "createRegion", new Object[]{new CacheLoader2(), null, 0});
        this.datastore1.invoke(PartitionedRegionLoaderWriterDUnitTest.class, "createRegion", new Object[]{null, null, 10});
    }

    public void testWriter_NotOnAccessor_OnDataStore() {
        this.host = Host.getHost(0);
        this.accessor = this.host.getVM(1);
        this.datastore1 = this.host.getVM(2);
        this.accessor.invoke(PartitionedRegionLoaderWriterDUnitTest.class, "createRegion", new Object[]{null, null, 0});
        this.datastore1.invoke(PartitionedRegionLoaderWriterDUnitTest.class, "createRegion", new Object[]{null, new CacheWriter2(), 10});
    }

    public void testWriter_OnDataStore_NotOnAccessor() {
        this.host = Host.getHost(0);
        this.accessor = this.host.getVM(1);
        this.datastore1 = this.host.getVM(2);
        this.datastore1.invoke(PartitionedRegionLoaderWriterDUnitTest.class, "createRegion", new Object[]{null, new CacheWriter2(), 10});
        this.accessor.invoke(PartitionedRegionLoaderWriterDUnitTest.class, "createRegion", new Object[]{null, null, 0});
    }

    public void testLoader_OnAccessor_NotOnFirstDataStore_OnSecondDataStore() {
        this.host = Host.getHost(0);
        this.accessor = this.host.getVM(1);
        this.datastore1 = this.host.getVM(2);
        this.datastore2 = this.host.getVM(3);
        this.accessor.invoke(PartitionedRegionLoaderWriterDUnitTest.class, "createRegion", new Object[]{new CacheLoader2(), null, 0});
        this.datastore1.invoke(PartitionedRegionLoaderWriterDUnitTest.class, "createRegion", new Object[]{null, null, 10});
        this.datastore2.invoke(PartitionedRegionLoaderWriterDUnitTest.class, "createRegionWithPossibleFail", new Object[]{new CacheLoader2(), null, 10});
    }

    public void testLoader_NotOnFirstDataStore_OnAccessor_OnSecondDataStore() {
        this.host = Host.getHost(0);
        this.accessor = this.host.getVM(1);
        this.datastore1 = this.host.getVM(2);
        this.datastore2 = this.host.getVM(3);
        this.datastore1.invoke(PartitionedRegionLoaderWriterDUnitTest.class, "createRegion", new Object[]{null, null, 10});
        this.accessor.invoke(PartitionedRegionLoaderWriterDUnitTest.class, "createRegion", new Object[]{new CacheLoader2(), null, 0});
        this.datastore2.invoke(PartitionedRegionLoaderWriterDUnitTest.class, "createRegionWithPossibleFail", new Object[]{new CacheLoader2(), null, 10});
    }

    public void testLoader_OnFirstDataStore_OnSecondDataStore_OnAccessor() {
        this.host = Host.getHost(0);
        this.accessor = this.host.getVM(1);
        this.datastore1 = this.host.getVM(2);
        this.datastore2 = this.host.getVM(3);
        this.datastore1.invoke(PartitionedRegionLoaderWriterDUnitTest.class, "createRegion", new Object[]{new CacheLoader2(), null, 10});
        this.datastore2.invoke(PartitionedRegionLoaderWriterDUnitTest.class, "createRegion", new Object[]{new CacheLoader2(), null, 10});
        this.accessor.invoke(PartitionedRegionLoaderWriterDUnitTest.class, "createRegion", new Object[]{new CacheLoader2(), null, 0});
    }

    public void testLoader_OnFirstDataStore_OnSecondDataStore_NotOnAccessor() {
        this.host = Host.getHost(0);
        this.accessor = this.host.getVM(1);
        this.datastore1 = this.host.getVM(2);
        this.datastore2 = this.host.getVM(3);
        this.datastore1.invoke(PartitionedRegionLoaderWriterDUnitTest.class, "createRegion", new Object[]{new CacheLoader2(), null, 10});
        this.datastore2.invoke(PartitionedRegionLoaderWriterDUnitTest.class, "createRegion", new Object[]{new CacheLoader2(), null, 10});
        this.accessor.invoke(PartitionedRegionLoaderWriterDUnitTest.class, "createRegion", new Object[]{null, null, 0});
    }

    public static void createRegion(CacheLoader cacheLoader, CacheWriter cacheWriter, Integer localMaxMemory) {
        try {
            new PartitionedRegionLoaderWriterDUnitTest("DUnitTests").createCache(new Properties());
            AttributesFactory factory = new AttributesFactory();
            factory.setCacheLoader(cacheLoader);
            factory.setCacheWriter(cacheWriter);
            PartitionAttributesFactory paf = new PartitionAttributesFactory();
            paf.setLocalMaxMemory(localMaxMemory.intValue());
            factory.setDataPolicy(DataPolicy.PARTITION);
            factory.setPartitionAttributes(paf.create());
            RegionAttributes attrs = factory.create();
            cache.createRegion(PartitionedRegionName, attrs);
        }
        catch (Exception e) {
            PartitionedRegionLoaderWriterDUnitTest.fail("Not Expected : ", e);
        }
    }

    public static void createRegionWithPossibleFail(CacheLoader cacheLoader, CacheWriter cacheWriter, Integer localMaxMemory) {
        PartitionedRegionLoaderWriterDUnitTest test = new PartitionedRegionLoaderWriterDUnitTest("DUnitTests");
        test.createCache(new Properties());
        cache.getLogger().info("<ExpectedException action=add>" + IllegalStateException.class.getName() + "</ExpectedException>");
        try {
            AttributesFactory factory = new AttributesFactory();
            factory.setCacheLoader(cacheLoader);
            factory.setCacheWriter(cacheWriter);
            PartitionAttributesFactory paf = new PartitionAttributesFactory();
            paf.setLocalMaxMemory(localMaxMemory.intValue());
            factory.setDataPolicy(DataPolicy.PARTITION);
            factory.setPartitionAttributes(paf.create());
            RegionAttributes attrs = factory.create();
            cache.createRegion(PartitionedRegionName, attrs);
            PartitionedRegionLoaderWriterDUnitTest.fail((String)"Expected Exception ");
        }
        catch (IllegalStateException e) {
            PartitionedRegionLoaderWriterDUnitTest.assertTrue((boolean)e.getMessage().startsWith("Incompatible"));
        }
        cache.getLogger().info("<ExpectedException action=remove>" + IllegalStateException.class.getName() + "</ExpectedException>");
    }

    private void createCache(Properties props) {
        try {
            InternalDistributedSystem ds = this.getSystem(props);
            PartitionedRegionLoaderWriterDUnitTest.assertNotNull((Object)ds);
            ds.disconnect();
            ds = this.getSystem(props);
            cache = CacheFactory.create((DistributedSystem)ds);
            PartitionedRegionLoaderWriterDUnitTest.assertNotNull((Object)cache);
        }
        catch (Exception e) {
            PartitionedRegionLoaderWriterDUnitTest.fail("Failed while creating the cache", e);
        }
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
    }

    static class CacheWriter2
    extends CacheWriterAdapter
    implements Serializable {
    }

    static class CacheLoader2
    implements CacheLoader,
    Serializable {
        public Object load(LoaderHelper helper) throws CacheLoaderException {
            return null;
        }

        public void close() {
        }
    }
}

