/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.partitioned;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.DistributionMessage;
import com.gemstone.gemfire.distributed.internal.DistributionMessageObserver;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.cache.ForceReattemptException;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegionDataStore;
import com.gemstone.gemfire.internal.cache.partitioned.ManageBucketMessage;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableCallable;
import dunit.SerializableRunnable;
import dunit.VM;
import hydra.Log;
import java.io.Serializable;
import java.util.List;
import java.util.Set;
import junit.framework.Assert;
import junit.framework.TestCase;

public class Bug39356DUnitTest
extends CacheTestCase {
    protected static final String REGION_NAME = "myregion";

    public Bug39356DUnitTest(String name) {
        super(name);
    }

    public void testCrashWhileCreatingABucket() {
        Host host = Host.getHost(0);
        final VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        SerializableRunnable createParReg = new SerializableRunnable("Create parReg"){

            @Override
            public void run() {
                DistributionMessageObserver.setInstance((DistributionMessageObserver)new MyRegionObserver(vm0));
                Cache cache = Bug39356DUnitTest.this.getCache();
                AttributesFactory af = new AttributesFactory();
                PartitionAttributesFactory pf = new PartitionAttributesFactory();
                pf.setRedundantCopies(1);
                pf.setRecoveryDelay(0L);
                af.setDataPolicy(DataPolicy.PARTITION);
                af.setPartitionAttributes(pf.create());
                cache.createRegion(Bug39356DUnitTest.REGION_NAME, af.create());
            }
        };
        vm1.invoke(createParReg);
        vm2.invoke(createParReg);
        SerializableRunnable createParRegAccessor = new SerializableRunnable("Create parReg"){

            @Override
            public void run() {
                Cache cache = Bug39356DUnitTest.this.getCache();
                AttributesFactory af = new AttributesFactory();
                PartitionAttributesFactory pf = new PartitionAttributesFactory();
                pf.setRedundantCopies(1);
                pf.setLocalMaxMemory(0);
                af.setDataPolicy(DataPolicy.PARTITION);
                af.setPartitionAttributes(pf.create());
                Region r = cache.createRegion(Bug39356DUnitTest.REGION_NAME, af.create());
                try {
                    r.put((Object)"ping", (Object)"pong");
                    TestCase.fail((String)"Should have gotten a CancelException");
                }
                catch (CancelException cancelException) {
                    // empty catch block
                }
            }
        };
        vm0.invoke(createParRegAccessor);
        SerializableRunnable verifyBuckets = new SerializableRunnable("Verify buckets"){

            @Override
            public void run() {
                LogWriter log = Log.getLogWriter();
                Cache cache = Bug39356DUnitTest.this.getCache();
                PartitionedRegion r = (PartitionedRegion)cache.getRegion(Bug39356DUnitTest.REGION_NAME);
                for (int i = 0; i < r.getAttributes().getPartitionAttributes().getTotalNumBuckets(); ++i) {
                    List owners = null;
                    while (owners == null) {
                        try {
                            owners = r.getBucketOwnersForValidation(i);
                        }
                        catch (ForceReattemptException e) {
                            log.info(Bug39356DUnitTest.class + " verify buckets Caught a ForceReattemptException");
                            DistributedTestCase.pause(1000);
                        }
                    }
                    if (owners.isEmpty()) {
                        log.info("skipping bucket " + i + " because it has no data");
                        continue;
                    }
                    Assert.assertEquals((String)("Expecting bucket " + i + " to have two copies"), (int)2, (int)owners.size());
                    log.info("bucket " + i + " had two copies");
                }
            }
        };
        vm1.invoke(verifyBuckets);
        vm2.invoke(verifyBuckets);
    }

    public void testMoveBucketToHostThatHasTheBucketAlready() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        SerializableRunnable createPrRegion = new SerializableRunnable("createRegion"){

            @Override
            public void run() {
                Cache cache = Bug39356DUnitTest.this.getCache();
                AttributesFactory attr = new AttributesFactory();
                PartitionAttributesFactory paf = new PartitionAttributesFactory();
                paf.setRedundantCopies(1);
                paf.setRecoveryDelay(-1L);
                paf.setStartupRecoveryDelay(-1L);
                PartitionAttributes prAttr = paf.create();
                attr.setPartitionAttributes(prAttr);
                cache.createRegion("region1", attr.create());
            }
        };
        vm0.invoke(createPrRegion);
        vm1.invoke(createPrRegion);
        vm0.invoke(new SerializableRunnable("createSomeBuckets"){

            @Override
            public void run() {
                Cache cache = Bug39356DUnitTest.this.getCache();
                Region region = cache.getRegion("region1");
                region.put((Object)0, (Object)"A");
            }
        });
        final InternalDistributedMember vm1MemberId = (InternalDistributedMember)vm1.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                return InternalDistributedSystem.getAnyInstance().getDistributedMember();
            }
        });
        vm0.invoke(new SerializableRunnable("moveBucket"){

            @Override
            public void run() {
                Cache cache = Bug39356DUnitTest.this.getCache();
                PartitionedRegion region = (PartitionedRegion)cache.getRegion("region1");
                Set owners = region.getRegionAdvisor().getBucketOwners(0);
                TestCase.assertEquals((int)2, (int)owners.size());
                PartitionedRegionDataStore ds = region.getDataStore();
                TestCase.assertTrue((boolean)ds.isManagingBucket(0));
                TestCase.assertFalse((boolean)ds.moveBucket(0, vm1MemberId, true));
                TestCase.assertEquals((Object)owners, (Object)region.getRegionAdvisor().getBucketOwners(0));
            }
        });
    }

    protected final class MyRegionObserver
    extends DistributionMessageObserver
    implements Serializable {
        private final VM vm0;

        MyRegionObserver(VM vm0) {
            this.vm0 = vm0;
        }

        public void afterProcessMessage(DistributionManager dm, DistributionMessage message) {
        }

        public void beforeProcessMessage(DistributionManager dm, DistributionMessage message) {
            if (message instanceof ManageBucketMessage) {
                this.vm0.invoke(new SerializableRunnable("Disconnect VM 0"){

                    @Override
                    public void run() {
                        CacheTestCase.disconnectFromDS();
                        try {
                            Thread.sleep(10000L);
                        }
                        catch (InterruptedException e) {
                            TestCase.fail((String)"interrupted");
                        }
                    }
                });
            }
        }
    }
}

