/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.ha;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.CacheWriter;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.DiskStoreFactory;
import com.gemstone.gemfire.cache.ExpirationAttributes;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.query.CqAttributes;
import com.gemstone.gemfire.cache.query.CqAttributesFactory;
import com.gemstone.gemfire.cache.query.CqListener;
import com.gemstone.gemfire.cache.query.CqQuery;
import com.gemstone.gemfire.cache.query.CqResults;
import com.gemstone.gemfire.cache.query.QueryService;
import com.gemstone.gemfire.cache.query.cq.dunit.CqQueryTestListener;
import com.gemstone.gemfire.cache.query.data.Portfolio;
import com.gemstone.gemfire.cache.util.BridgeServer;
import com.gemstone.gemfire.cache.util.BridgeWriter;
import com.gemstone.gemfire.cache30.CertifiableTestCacheListener;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.cache.BridgeServerImpl;
import com.gemstone.gemfire.internal.cache.LocalRegionHelper;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheServerTestUtil;
import com.gemstone.gemfire.internal.cache.tier.sockets.ClientUpdateMessageImpl;
import com.gemstone.gemfire.internal.cache.tier.sockets.ConflationDUnitTest;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class CQListGIIDUnitTest
extends DistributedTestCase {
    private static final int CREATE = 0;
    private static final int UPDATE = 1;
    private static final int DESTROY = 2;
    private static final int INVALIDATE = 3;
    private static final int CLOSE = 4;
    private static final int REGION_CLEAR = 5;
    private static final int REGION_INVALIDATE = 6;
    protected static Cache cache = null;
    protected static VM serverVM0 = null;
    private static VM serverVM1 = null;
    protected static VM clientVM1 = null;
    protected static VM clientVM2 = null;
    private static int PORT1;
    private static int PORT2;
    private static final String regionName = "CQListGIIDUnitTest";
    private static final Map map;
    private static LogWriter logger;
    public static final String[] regions;
    public static final String KEY = "key-";
    public String[] cqs = new String[]{"SELECT ALL * FROM /root/" + regions[0] + " p where p.ID > 0", "SELECT ALL * FROM /root/" + regions[0] + " p where p.ID = 2 and p.status='active'", "SELECT ALL * FROM /root/" + regions[1] + " p where p.ID < 5 and p.status='active'", "SELECT * FROM /root/" + regions[0] + " ;", "SELECT ALL * FROM /root/" + regions[0], "import com.gemstone.gemfire.cache.\"query\".data.Portfolio; SELECT ALL * FROM /root/" + regions[0] + " TYPE Portfolio", "import com.gemstone.gemfire.cache.\"query\".data.Portfolio; SELECT ALL * FROM /root/" + regions[0] + " p TYPE Portfolio", "SELECT ALL * FROM /root/" + regions[1] + " p where p.ID < 5 and p.status='active';", "SELECT ALL * FROM /root/" + regions[0] + "  ;", "SELECT ALL * FROM /root/" + regions[0] + " p where p.description = NULL", "SELECT ALL * FROM /root/" + regions[0] + " p where p.ID > 0 and p.status='active'"};

    public CQListGIIDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        Host host = Host.getHost(0);
        serverVM0 = host.getVM(0);
        serverVM1 = host.getVM(1);
        clientVM1 = host.getVM(2);
        clientVM2 = host.getVM(3);
        PORT1 = (Integer)serverVM0.invoke(CQListGIIDUnitTest.class, "createServerCache", new Object[]{"mem"});
        PORT2 = (Integer)serverVM1.invoke(CQListGIIDUnitTest.class, "createServerCache", new Object[]{"entry"});
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
        serverVM0.invoke(ConflationDUnitTest.class, "unsetIsSlowStart");
        serverVM1.invoke(ConflationDUnitTest.class, "unsetIsSlowStart");
        CQListGIIDUnitTest.closeCache();
        clientVM1.invoke(CQListGIIDUnitTest.class, "closeCache");
        clientVM2.invoke(CQListGIIDUnitTest.class, "closeCache");
        serverVM0.invoke(CQListGIIDUnitTest.class, "closeCache");
        serverVM1.invoke(CQListGIIDUnitTest.class, "closeCache");
        CQListGIIDUnitTest.disconnectAllFromDS();
    }

    private void createCache(Properties props) throws Exception {
        InternalDistributedSystem ds = this.getSystem(props);
        ds.disconnect();
        ds = this.getSystem(props);
        CQListGIIDUnitTest.assertNotNull((Object)ds);
        cache = CacheFactory.create((DistributedSystem)ds);
        CQListGIIDUnitTest.assertNotNull((Object)cache);
    }

    public static Integer createServerCache() throws Exception {
        return CQListGIIDUnitTest.createServerCache(null);
    }

    public static Integer createServerCache(String ePolicy) throws Exception {
        return CQListGIIDUnitTest.createServerCache(ePolicy, 1);
    }

    public static Integer createServerCache(String ePolicy, Integer cap) throws Exception {
        new CQListGIIDUnitTest("temp").createCache(new Properties());
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setDataPolicy(DataPolicy.REPLICATE);
        RegionAttributes attrs = factory.create();
        CQListGIIDUnitTest.createRegion(regions[0], "root", attrs);
        CQListGIIDUnitTest.createRegion(regions[1], "root", attrs);
        Thread.sleep(2000L);
        logger = cache.getLogger();
        int port = AvailablePort.getRandomAvailablePort((int)0);
        BridgeServer server1 = cache.addBridgeServer();
        server1.setPort(port);
        server1.setNotifyBySubscription(true);
        if (ePolicy != null) {
            File overflowDirectory = new File("bsi_overflow_" + port);
            overflowDirectory.mkdir();
            DiskStoreFactory dsf = cache.createDiskStoreFactory();
            File[] dirs1 = new File[]{overflowDirectory};
            server1.getClientSubscriptionConfig().setEvictionPolicy(ePolicy);
            server1.getClientSubscriptionConfig().setCapacity(cap.intValue());
            server1.getClientSubscriptionConfig().setDiskStoreName(dsf.setDiskDirs(dirs1).create("bsi").getName());
        }
        server1.start();
        Thread.sleep(2000L);
        return server1.getPort();
    }

    public static Integer createOneMoreBridgeServer(Boolean notifyBySubscription) throws Exception {
        int port = AvailablePort.getRandomAvailablePort((int)0);
        BridgeServer server1 = cache.addBridgeServer();
        server1.setPort(port);
        server1.setNotifyBySubscription(notifyBySubscription.booleanValue());
        server1.getClientSubscriptionConfig().setEvictionPolicy("mem");
        server1.start();
        return server1.getPort();
    }

    public static final Region createRegion(String name, String rootName, RegionAttributes attrs) throws CacheException {
        Region root = cache.getRegion(rootName);
        if (root == null) {
            RegionAttributes rootAttrs = attrs;
            AttributesFactory fac = new AttributesFactory(attrs);
            ExpirationAttributes expiration = ExpirationAttributes.DEFAULT;
            fac.setCacheLoader(null);
            fac.setCacheWriter(null);
            fac.setPartitionAttributes(null);
            fac.setRegionTimeToLive(expiration);
            fac.setEntryTimeToLive(expiration);
            fac.setRegionIdleTimeout(expiration);
            fac.setEntryIdleTimeout(expiration);
            rootAttrs = fac.create();
            root = cache.createRegion(rootName, rootAttrs);
        }
        return LocalRegionHelper.createSubregion(root, name, attrs, null);
    }

    public static void createClientCache(Integer port1, Integer port2, String rLevel) throws Exception {
        CQListGIIDUnitTest.createClientCache(port1, port2, -1, rLevel, Boolean.FALSE);
    }

    public static void createClientCache(Integer port1, Integer port2, String rLevel, Boolean addListener) throws Exception {
        CQListGIIDUnitTest.createClientCache(port1, port2, -1, rLevel, addListener);
    }

    public static void createClientCache(Integer port1, Integer port2, Integer port3, String rLevel) throws Exception {
        CQListGIIDUnitTest.createClientCache(port1, port2, port3, rLevel, Boolean.FALSE);
    }

    public static void createClientCache(Integer port1, Integer port2, Integer port3, String rLevel, Boolean addListener) throws Exception {
        CacheServerTestUtil.disableShufflingOfEndpoints();
        String host = DistributedTestCase.getIPLiteral();
        String epList = "ep1=" + host + ":" + port1 + (port2 != -1 ? ",ep2=" + host + ":" + port2 : "") + (port3 != -1 ? ",ep3=" + host + ":" + port3 : "");
        BridgeWriter writer = new BridgeWriter();
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "");
        new CQListGIIDUnitTest("temp").createCache(props);
        try {
            cache.getQueryService();
        }
        catch (Exception cqe) {
            CQListGIIDUnitTest.fail("Failed to getCQService.", cqe);
        }
        props.setProperty("retryAttempts", "5");
        props.setProperty("endpoints", epList);
        props.setProperty("redundancyLevel", rLevel);
        props.setProperty("establishCallbackConnection", "true");
        props.setProperty("LBPolicy", "RoundRobin");
        props.setProperty("readTimeout", "2500");
        props.setProperty("socketBufferSize", "32768");
        props.setProperty("retryInterval", "1000");
        props.setProperty("connectionsPerServer", "2");
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.LOCAL);
        factory.setCacheWriter((CacheWriter)writer);
        writer.init(props);
        RegionAttributes attrs = factory.create();
        CQListGIIDUnitTest.createRegion(regions[0], "root", attrs);
        CQListGIIDUnitTest.createRegion(regions[1], "root", attrs);
        logger = cache.getLogger();
    }

    public static void createCQ(String cqName, String queryStr) {
        CQListGIIDUnitTest.getLogWriter().info("### Create CQ. ###" + cqName);
        QueryService cqService = null;
        try {
            cqService = cache.getQueryService();
        }
        catch (Exception cqe) {
            CQListGIIDUnitTest.fail("Failed to getCQService.", cqe);
        }
        CqAttributesFactory cqf = new CqAttributesFactory();
        CqListener[] cqListeners = new CqListener[]{new CqQueryTestListener(CQListGIIDUnitTest.getLogWriter())};
        ((CqQueryTestListener)cqListeners[0]).cqName = cqName;
        cqf.initCqListeners(cqListeners);
        CqAttributes cqa = cqf.create();
        try {
            CqQuery cq1 = cqService.newCq(cqName, queryStr, cqa);
            CQListGIIDUnitTest.assertTrue((String)"newCq() state mismatch", (boolean)cq1.getState().isStopped());
        }
        catch (Exception ex) {
            CQListGIIDUnitTest.getLogWriter().info("CqService is :" + cqService);
            ex.printStackTrace();
            AssertionError err = new AssertionError((Object)("Failed to create CQ " + cqName + " . "));
            ((Throwable)((Object)err)).initCause(ex);
            throw err;
        }
    }

    public static void executeCQ(String cqName, Boolean initialResults) {
        CQListGIIDUnitTest.getLogWriter().info("### DEBUG EXECUTE CQ START ####");
        QueryService cqService = null;
        CqQuery cq1 = null;
        cqService = cache.getQueryService();
        try {
            cq1 = cqService.getCq(cqName);
            if (cq1 == null) {
                CQListGIIDUnitTest.getLogWriter().info("Failed to get CqQuery object for CQ name: " + cqName);
                CQListGIIDUnitTest.fail("Failed to get CQ " + cqName, new Exception("Failed to get CQ " + cqName));
            } else {
                CQListGIIDUnitTest.getLogWriter().info("Obtained CQ, CQ name: " + cq1.getName());
                CQListGIIDUnitTest.assertTrue((String)"newCq() state mismatch", (boolean)cq1.getState().isStopped());
            }
        }
        catch (Exception ex) {
            CQListGIIDUnitTest.getLogWriter().info("CqService is :" + cqService);
            CQListGIIDUnitTest.getLogWriter().error((Throwable)ex);
            AssertionError err = new AssertionError((Object)("Failed to execute  CQ " + cqName));
            ((Throwable)((Object)err)).initCause(ex);
            throw err;
        }
        if (initialResults.booleanValue()) {
            CqResults cqResults = null;
            try {
                cqResults = cq1.executeWithInitialResults();
            }
            catch (Exception ex) {
                CQListGIIDUnitTest.getLogWriter().info("CqService is :" + cqService);
                ex.printStackTrace();
                AssertionError err = new AssertionError((Object)("Failed to execute  CQ " + cqName));
                ((Throwable)((Object)err)).initCause(ex);
                throw err;
            }
            CQListGIIDUnitTest.getLogWriter().info("initial result size = " + cqResults.size());
            CQListGIIDUnitTest.assertTrue((String)"executeWithInitialResults() state mismatch", (boolean)cq1.getState().isRunning());
        } else {
            try {
                cq1.execute();
            }
            catch (Exception ex) {
                CQListGIIDUnitTest.getLogWriter().info("CqService is :" + cqService);
                ex.printStackTrace();
                AssertionError err = new AssertionError((Object)("Failed to execute  CQ " + cqName));
                ((Throwable)((Object)err)).initCause(ex);
                throw err;
            }
            CQListGIIDUnitTest.assertTrue((String)"execute() state mismatch", (boolean)cq1.getState().isRunning());
        }
    }

    public static void registerInterestListCQ(String regionName, int keySize) {
        Region region = null;
        try {
            region = cache.getRegion("root").getSubregion(regionName);
            region.getAttributesMutator().setCacheListener((CacheListener)new CertifiableTestCacheListener(CQListGIIDUnitTest.getLogWriter()));
        }
        catch (Exception cqe) {
            AssertionError err = new AssertionError((Object)"Failed to get Region.");
            ((Throwable)((Object)err)).initCause(cqe);
            throw err;
        }
        try {
            ArrayList<String> list = new ArrayList<String>();
            for (int i = 1; i <= keySize; ++i) {
                list.add(KEY + i);
            }
            region.registerInterest(list);
        }
        catch (Exception ex) {
            AssertionError err = new AssertionError((Object)"Failed to Register InterestList");
            ((Throwable)((Object)err)).initCause(ex);
            throw err;
        }
    }

    public static void waitForCreated(String cqName, String key) {
        CQListGIIDUnitTest.waitForEvent(0, cqName, key);
    }

    public static void waitForEvent(int event, String cqName, String key) {
        QueryService cqService = null;
        try {
            cqService = cache.getQueryService();
        }
        catch (Exception cqe) {
            cqe.printStackTrace();
            CQListGIIDUnitTest.fail("Failed to getCQService.", cqe);
        }
        CqQuery cQuery = cqService.getCq(cqName);
        if (cQuery == null) {
            CQListGIIDUnitTest.fail("Failed to get CqQuery for CQ : " + cqName, new Exception("Failed to get CqQuery for CQ : " + cqName));
        }
        CqAttributes cqAttr = cQuery.getCqAttributes();
        CqListener[] cqListener = cqAttr.getCqListeners();
        CqQueryTestListener listener = (CqQueryTestListener)cqListener[0];
        switch (event) {
            case 0: {
                listener.waitForCreated(key);
                break;
            }
            case 1: {
                listener.waitForUpdated(key);
                break;
            }
            case 2: {
                listener.waitForDestroyed(key);
                break;
            }
            case 3: {
                listener.waitForInvalidated(key);
                break;
            }
            case 4: {
                listener.waitForClose();
                break;
            }
            case 5: {
                listener.waitForRegionClear();
                break;
            }
            case 6: {
                listener.waitForRegionInvalidate();
            }
        }
    }

    public static void registerInterestListAll() {
        try {
            Region r = cache.getRegion("/CQListGIIDUnitTest");
            CQListGIIDUnitTest.assertNotNull((Object)r);
            r.registerInterest((Object)"ALL_KEYS");
        }
        catch (Exception ex) {
            CQListGIIDUnitTest.fail("failed in registerInterestListAll", ex);
        }
    }

    public static void registerInterestList() {
        try {
            Region r = cache.getRegion("/CQListGIIDUnitTest");
            CQListGIIDUnitTest.assertNotNull((Object)r);
            r.registerInterest((Object)"k1");
            r.registerInterest((Object)"k3");
            r.registerInterest((Object)"k5");
        }
        catch (Exception ex) {
            CQListGIIDUnitTest.fail("failed while registering keys", ex);
        }
    }

    public static void putEntries(String rName, Integer num) {
        try {
            Region r = cache.getRegion("root").getSubregion(rName);
            CQListGIIDUnitTest.assertNotNull((Object)r);
            int i = 0;
            while ((long)i < num.longValue()) {
                r.put((Object)(KEY + i), (Object)new Portfolio(i + 1));
                ++i;
            }
            CQListGIIDUnitTest.getLogWriter().info("### Number of Entries in Region " + rName + ": " + r.keys().size());
        }
        catch (Exception ex) {
            CQListGIIDUnitTest.fail("failed in putEntries()", ex);
        }
    }

    public void _testSpecificClientCQIsGIIedPart1() throws Exception {
        Integer size = 10;
        serverVM0.invoke(ConflationDUnitTest.class, "setIsSlowStart", new Object[]{"30000"});
        serverVM1.invoke(ConflationDUnitTest.class, "setIsSlowStart", new Object[]{"30000"});
        clientVM1.invoke(CQListGIIDUnitTest.class, "createClientCache", new Object[]{PORT1, PORT2, "1"});
        clientVM2.invoke(CQListGIIDUnitTest.class, "createClientCache", new Object[]{PORT1, PORT2, "0"});
        clientVM1.invoke(CQListGIIDUnitTest.class, "createCQ", new Object[]{"testSpecificClientCQIsGIIed_0", this.cqs[0]});
        clientVM1.invoke(CQListGIIDUnitTest.class, "executeCQ", new Object[]{"testSpecificClientCQIsGIIed_0", Boolean.FALSE});
        clientVM2.invoke(CQListGIIDUnitTest.class, "createCQ", new Object[]{"testSpecificClientCQIsGIIed_0", this.cqs[0]});
        clientVM2.invoke(CQListGIIDUnitTest.class, "executeCQ", new Object[]{"testSpecificClientCQIsGIIed_0", Boolean.FALSE});
        serverVM1.invoke(CQListGIIDUnitTest.class, "stopServer");
        serverVM0.invoke(CQListGIIDUnitTest.class, "putEntries", new Object[]{regions[0], size});
        serverVM1.invoke(CQListGIIDUnitTest.class, "startServer");
        Thread.sleep(3000L);
        serverVM0.invoke(CQListGIIDUnitTest.class, "VerifyCUMCQList", new Object[]{size, 2});
        serverVM1.invoke(CQListGIIDUnitTest.class, "VerifyCUMCQList", new Object[]{size, 1});
        serverVM0.invoke(ConflationDUnitTest.class, "unsetIsSlowStart");
        serverVM1.invoke(ConflationDUnitTest.class, "unsetIsSlowStart");
    }

    public void testClientCQNotLostAtGIIReceiver() throws Exception {
        Integer size = 10;
        VM serverVM2 = clientVM2;
        int port3 = (Integer)serverVM2.invoke(CQListGIIDUnitTest.class, "createServerCache", new Object[]{"mem"});
        serverVM0.invoke(ConflationDUnitTest.class, "setIsSlowStart", new Object[]{"45000"});
        CQListGIIDUnitTest.createClientCache((Integer)PORT1, (Integer)PORT2, port3, "1");
        clientVM1.invoke(CQListGIIDUnitTest.class, "createClientCache", new Object[]{PORT1, port3, PORT2, "1"});
        CQListGIIDUnitTest.createCQ("testSpecificClientCQIsGIIed_0", this.cqs[0]);
        CQListGIIDUnitTest.executeCQ("testSpecificClientCQIsGIIed_0", Boolean.FALSE);
        clientVM1.invoke(CQListGIIDUnitTest.class, "createCQ", new Object[]{"testSpecificClientCQIsGIIed_0", this.cqs[0]});
        clientVM1.invoke(CQListGIIDUnitTest.class, "executeCQ", new Object[]{"testSpecificClientCQIsGIIed_0", Boolean.FALSE});
        serverVM0.invoke(CQListGIIDUnitTest.class, "putEntries", new Object[]{regions[0], size});
        serverVM1.invoke(CQListGIIDUnitTest.class, "VerifyCUMCQList", new Object[]{size, 1});
        serverVM2.invoke(CQListGIIDUnitTest.class, "stopServer");
        Thread.sleep(3000L);
        serverVM0.invoke(CQListGIIDUnitTest.class, "VerifyCUMCQList", new Object[]{size, 2});
        serverVM1.invoke(CQListGIIDUnitTest.class, "VerifyCUMCQList", new Object[]{size, 2});
    }

    public static void VerifyCUMCQList(Integer numOfKeys, Integer numOfClients) {
        try {
            Iterator iter = cache.getBridgeServers().iterator();
            if (iter.hasNext()) {
                BridgeServerImpl server = (BridgeServerImpl)iter.next();
                Map haContainer = server.getAcceptor().getCacheClientNotifier().getHaContainer();
                Object[] keys = haContainer.keySet().toArray();
                logger.fine("### numOfKeys :" + numOfKeys + " keys.length : " + keys.length + " haContainer size : " + haContainer.size());
                CQListGIIDUnitTest.assertEquals((int)numOfKeys, (int)keys.length);
                for (int i = 0; i < numOfKeys; ++i) {
                    logger.fine("i=: " + i);
                    ClientUpdateMessageImpl cum = (ClientUpdateMessageImpl)haContainer.get(keys[i]);
                    CQListGIIDUnitTest.assertNotNull((Object)cum);
                    CQListGIIDUnitTest.assertNotNull((Object)cum.getClientCqs());
                    CQListGIIDUnitTest.assertEquals((String)"This test may fail if the image provider gets an ack from client before providing image", (int)numOfClients, (int)cum.getClientCqs().size());
                }
            }
        }
        catch (Exception e) {
            CQListGIIDUnitTest.fail("failed in VerifyCUMCQList()" + e, e);
        }
    }

    private static void stopOneBridgeServer(Integer port) {
        try {
            BridgeServer server;
            Iterator iter = cache.getBridgeServers().iterator();
            if (iter.hasNext() && (server = (BridgeServer)iter.next()).getPort() == port.intValue()) {
                server.stop();
            }
        }
        catch (Exception e) {
            CQListGIIDUnitTest.fail((String)("failed in stopOneBridgeServer()" + e));
        }
    }

    public static void stopServer() {
        try {
            Iterator iter = cache.getBridgeServers().iterator();
            if (iter.hasNext()) {
                BridgeServer server = (BridgeServer)iter.next();
                server.stop();
            }
        }
        catch (Exception e) {
            CQListGIIDUnitTest.fail((String)("failed in stopServer()" + e));
        }
    }

    public static void startServer() {
        try {
            Iterator iter = cache.getBridgeServers().iterator();
            if (iter.hasNext()) {
                BridgeServer server = (BridgeServer)iter.next();
                server.start();
            }
        }
        catch (Exception e) {
            CQListGIIDUnitTest.fail((String)("failed in startServer()" + e));
        }
    }

    public static void waitTillMessagesAreDispatched(Integer port, Long waitLimit) {
        try {
            boolean dispatched = false;
            Object haContainer = null;
            haContainer = cache.getRegion("/" + BridgeServerImpl.generateNameForClientMsgsRegion((int)port));
            if (haContainer == null) {
                Object[] servers = cache.getBridgeServers().toArray();
                for (int i = 0; i < servers.length; ++i) {
                    if (port.intValue() != ((BridgeServerImpl)servers[i]).getPort()) continue;
                    haContainer = ((BridgeServerImpl)servers[i]).getAcceptor().getCacheClientNotifier().getHaContainer();
                    break;
                }
            }
            long startTime = System.currentTimeMillis();
            while (waitLimit > System.currentTimeMillis() - startTime) {
                if (haContainer.size() == 0) {
                    dispatched = true;
                    break;
                }
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException ie) {
                    CQListGIIDUnitTest.fail((String)"interrupted");
                }
            }
            logger.fine("Exiting sleep, time elapsed was: " + (System.currentTimeMillis() - startTime));
            if (!dispatched) {
                throw new Exception("Test tuning issue: The HARegionQueue is not fully drained, so cannot continue the test.");
            }
        }
        catch (Exception e) {
            CQListGIIDUnitTest.fail((String)("failed in waitTillMessagesAreDispatched()" + e));
        }
    }

    public static void closeCache() {
        if (cache != null && !cache.isClosed()) {
            cache.close();
            cache.getDistributedSystem().disconnect();
        }
    }

    static {
        map = new HashMap();
        logger = null;
        regions = new String[]{"regionA", "regionB"};
    }
}

