/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.execute;

import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.CacheTransactionManager;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.execute.Execution;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionService;
import com.gemstone.gemfire.cache.util.CacheListenerAdapter;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.internal.NanoTimer;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.TXManagerImpl;
import com.gemstone.gemfire.internal.cache.execute.MyTransactionFunction;
import com.gemstone.gemfire.internal.cache.execute.PRColocationDUnitTest;
import com.gemstone.gemfire.internal.cache.execute.PerfFunction;
import com.gemstone.gemfire.internal.cache.execute.PerfTxFunction;
import com.gemstone.gemfire.internal.cache.execute.data.CustId;
import com.gemstone.gemfire.internal.cache.execute.data.Customer;
import com.gemstone.gemfire.internal.cache.execute.data.Order;
import com.gemstone.gemfire.internal.cache.execute.data.OrderId;
import com.gemstone.gemfire.internal.cache.execute.data.Shipment;
import com.gemstone.gemfire.internal.cache.execute.data.ShipmentId;
import dunit.DistributedTestCase;
import dunit.SerializableCallable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import junit.framework.TestCase;

public class PRTransactionDUnitTest
extends PRColocationDUnitTest {
    public static final int VERIFY_TX = 0;
    public static final int VERIFY_ROLLBACK = 1;
    public static final int VERIFY_NON_COLOCATION = 2;
    public static final int VERIFY_DESTROY = 4;
    public static final int VERIFY_LISTENER_CALLBACK = 5;
    public static final int VERIFY_INVALIDATE = 6;
    public static final int VERIFY_TXSTATE_CONFLICT = 7;
    public static final int VERIFY_REP_READ = 8;
    final int totalIterations = 250;
    final int warmupIterations = 50;
    final int perfOrderShipmentPairs = 10;
    private final SerializableCallable runGetCache = new SerializableCallable("runGetCache"){

        public Object call() throws Exception {
            PRTransactionDUnitTest.this.getCache();
            return null;
        }
    };
    SerializableCallable verifyNoTxState = new SerializableCallable(){

        public Object call() throws Exception {
            TXManagerImpl mgr = PRTransactionDUnitTest.this.getGemfireCache().getTxManager();
            TestCase.assertEquals((int)0, (int)mgr.hostedTransactionsInProgressForTest());
            return null;
        }
    };

    public PRTransactionDUnitTest(String name) {
        super(name);
    }

    public void testBasicPRTransactionRedundancy0() {
        this.basicPRTXInFunction(0, true);
    }

    public void testBasicPRTransactionRedundancy1() {
        this.basicPRTXInFunction(1, true);
    }

    public void testBasicPRTransactionRedundancy2() {
        this.basicPRTXInFunction(2, true);
    }

    public void testBasicPRTransactionNoDataRedundancy0() {
        this.basicPRTXInFunction(0, false);
    }

    public void testBasicPRTransactionNoDataRedundancy1() {
        this.basicPRTXInFunction(1, false);
    }

    public void testBasicPRTransactionNoDataRedundancy2() {
        this.basicPRTXInFunction(2, false);
    }

    protected void basicPRTXInFunction(int redundantBuckets, boolean populateData) {
        if (populateData) {
            this.createPopulateAndVerifyCoLocatedPRs(redundantBuckets);
        } else {
            this.createColocatedPRs(redundantBuckets);
        }
        SerializableCallable registerFunction = new SerializableCallable("register Fn"){

            public Object call() throws Exception {
                MyTransactionFunction txFunction = new MyTransactionFunction();
                FunctionService.registerFunction((Function)txFunction);
                return Boolean.TRUE;
            }
        };
        this.dataStore1.invoke(registerFunction);
        this.dataStore2.invoke(registerFunction);
        this.dataStore3.invoke(registerFunction);
        this.accessor.invoke(new SerializableCallable("run function"){

            public Object call() throws Exception {
                PartitionedRegion pr = (PartitionedRegion)CacheTestCase.basicGetCache().getRegion("/CustomerPartitionedRegion");
                PartitionedRegion orderpr = (PartitionedRegion)CacheTestCase.basicGetCache().getRegion("/OrderPartitionedRegion");
                CustId custId = new CustId(2);
                Customer newCus = new Customer("foo", "bar");
                Order order = new Order("fooOrder");
                OrderId orderId = new OrderId(22, custId);
                ArrayList<Object> args = new ArrayList<Object>();
                MyTransactionFunction txFunction = new MyTransactionFunction();
                FunctionService.registerFunction((Function)txFunction);
                Execution e = FunctionService.onRegion((Region)pr);
                HashSet<CustId> filter = new HashSet<CustId>();
                filter.clear();
                args.clear();
                args.add(new Integer(2));
                DistributedTestCase.getLogWriter().info("VERIFY_NON_COLOCATION");
                args.add(custId);
                args.add(newCus);
                args.add(orderId);
                args.add(order);
                filter.add(custId);
                e.withFilter(filter).withArgs(args).execute(txFunction.getId()).getResult();
                TestCase.assertEquals((String)"Unexpected customer value after commit", (Object)newCus, (Object)pr.get((Object)custId));
                TestCase.assertEquals((String)"Unexpected customer value after commit", (Object)"foo4", (Object)pr.get((Object)new CustId(4)));
                TestCase.assertEquals((String)"Unexpected customer value after commit", (Object)"foo5", (Object)pr.get((Object)new CustId(5)));
                TestCase.assertEquals((String)"Unexpected customer value after commit", (Object)"foo6", (Object)pr.get((Object)new CustId(6)));
                args.set(0, new Integer(0));
                DistributedTestCase.getLogWriter().info("VERIFY_TX");
                orderpr.put((Object)orderId, (Object)order);
                TestCase.assertNotNull((Object)orderpr.get((Object)orderId));
                e.withFilter(filter).withArgs(args).execute(txFunction.getId()).getResult();
                TestCase.assertTrue((String)"Unexpected customer value after commit", (boolean)newCus.equals(pr.get((Object)custId)));
                Order commitedOrder = (Order)orderpr.get((Object)orderId);
                TestCase.assertTrue((String)("Unexpected order value after commit. Expected:" + order + " Found:" + commitedOrder), (boolean)order.equals(commitedOrder));
                args.set(0, new Integer(7));
                e.withFilter(filter).withArgs(args).execute(txFunction.getId()).getResult();
                args.set(0, new Integer(1));
                DistributedTestCase.getLogWriter().info("VERIFY_ROLLBACK");
                e.withFilter(filter).withArgs(args).execute(txFunction.getId()).getResult();
                args.set(0, new Integer(4));
                DistributedTestCase.getLogWriter().info("VERIFY_DESTROY");
                e.withFilter(filter).withArgs(args).execute(txFunction.getId()).getResult();
                args.set(0, new Integer(6));
                DistributedTestCase.getLogWriter().info("VERIFY_INVALIDATE");
                e.withFilter(filter).withArgs(args).execute(txFunction.getId()).getResult();
                return Boolean.TRUE;
            }
        });
    }

    protected void createColocatedPRs(int redundantBuckets) {
        this.createCacheInAllVms();
        this.redundancy = new Integer(redundantBuckets);
        this.localMaxmemory = new Integer(50);
        this.totalNumBuckets = new Integer(11);
        this.createPRWithCoLocation("CustomerPartitionedRegion", null);
        this.createPRWithCoLocation("OrderPartitionedRegion", "CustomerPartitionedRegion");
        this.createPRWithCoLocation("ShipmentPartitionedRegion", "OrderPartitionedRegion");
        this.accessor.invoke(PRColocationDUnitTest.class, "validateBeforePutCustomerPartitionedRegion", new Object[]{"CustomerPartitionedRegion"});
    }

    @Override
    protected void createCacheInAllVms() {
        this.dataStore1.invoke(this.runGetCache);
        this.dataStore2.invoke(this.runGetCache);
        this.dataStore3.invoke(this.runGetCache);
        this.accessor.invoke(this.runGetCache);
    }

    protected void populateAndVerifyColocatedPRs(int redundantBuckets) {
        this.accessor.invoke(PRColocationDUnitTest.class, "putCustomerPartitionedRegion", new Object[]{"CustomerPartitionedRegion"});
        this.accessor.invoke(PRColocationDUnitTest.class, "putOrderPartitionedRegion", new Object[]{"OrderPartitionedRegion"});
        this.accessor.invoke(PRColocationDUnitTest.class, "putShipmentPartitionedRegion", new Object[]{"ShipmentPartitionedRegion"});
        Integer totalBucketsInDataStore1 = (Integer)this.dataStore1.invoke(PRColocationDUnitTest.class, "validateDataStore", new Object[]{"CustomerPartitionedRegion", "OrderPartitionedRegion", "ShipmentPartitionedRegion"});
        Integer totalBucketsInDataStore2 = (Integer)this.dataStore2.invoke(PRColocationDUnitTest.class, "validateDataStore", new Object[]{"CustomerPartitionedRegion", "OrderPartitionedRegion", "ShipmentPartitionedRegion"});
        Integer totalBucketsInDataStore3 = (Integer)this.dataStore3.invoke(PRColocationDUnitTest.class, "validateDataStore", new Object[]{"CustomerPartitionedRegion", "OrderPartitionedRegion", "ShipmentPartitionedRegion"});
        totalNumBucketsInTest = totalBucketsInDataStore1 + totalBucketsInDataStore2 + totalBucketsInDataStore3;
        PRTransactionDUnitTest.assertEquals((int)(30 + redundantBuckets * 30), (int)totalNumBucketsInTest);
        this.accessor.invoke(PRColocationDUnitTest.class, "validateAfterPutPartitionedRegion", new Object[]{"CustomerPartitionedRegion", "OrderPartitionedRegion", "ShipmentPartitionedRegion"});
    }

    protected void createPopulateAndVerifyCoLocatedPRs(int redundantBuckets) {
        this.createColocatedPRs(redundantBuckets);
        this.populateAndVerifyColocatedPRs(redundantBuckets);
    }

    protected void createPRWithCoLocation(String prName, String coLocatedWith) {
        this.regionName = prName;
        this.colocatedWith = coLocatedWith;
        this.isPartitionResolver = new Boolean(true);
        this.attributeObjects = new Object[]{this.regionName, this.redundancy, this.localMaxmemory, this.totalNumBuckets, this.colocatedWith, this.isPartitionResolver, this.getEnableConcurrency()};
        this.createPartitionedRegion(this.attributeObjects);
    }

    protected boolean getEnableConcurrency() {
        return false;
    }

    public void testPRTXInCacheListenerRedundancy0() {
        this.basicPRTXInCacheListener(0);
    }

    public void testPRTXInCacheListenerRedundancy1() {
        this.basicPRTXInCacheListener(1);
    }

    public void testPRTXInCacheListenerRedundancy2() {
        this.basicPRTXInCacheListener(2);
    }

    protected void basicPRTXInCacheListener(int bucketRedundancy) {
        this.createCacheInAllVms();
        this.redundancy = new Integer(bucketRedundancy);
        this.localMaxmemory = new Integer(50);
        this.totalNumBuckets = new Integer(11);
        this.createPRWithCoLocation("CustomerPartitionedRegion", null);
        this.createPRWithCoLocation("OrderPartitionedRegion", "CustomerPartitionedRegion");
        SerializableCallable registerListeners = new SerializableCallable(){

            public Object call() throws Exception {
                Region custRegion = CacheTestCase.basicGetCache().getRegion("/CustomerPartitionedRegion");
                custRegion.getAttributesMutator().addCacheListener((CacheListener)new TransactionListener());
                return null;
            }
        };
        this.dataStore1.invoke(registerListeners);
        this.dataStore2.invoke(registerListeners);
        this.dataStore3.invoke(registerListeners);
        this.accessor.invoke(PRColocationDUnitTest.class, "putCustomerPartitionedRegion", new Object[]{"CustomerPartitionedRegion"});
        this.dataStore1.invoke(PRTransactionDUnitTest.class, "validatePRTXInCacheListener");
        this.dataStore2.invoke(PRTransactionDUnitTest.class, "validatePRTXInCacheListener");
        this.dataStore3.invoke(PRTransactionDUnitTest.class, "validatePRTXInCacheListener");
    }

    public static void validatePRTXInCacheListener() throws ClassNotFoundException {
        PartitionedRegion customerPartitionedregion = null;
        PartitionedRegion orderPartitionedregion = null;
        try {
            customerPartitionedregion = (PartitionedRegion)PRTransactionDUnitTest.basicGetCache().getRegion("/CustomerPartitionedRegion");
            orderPartitionedregion = (PartitionedRegion)PRTransactionDUnitTest.basicGetCache().getRegion("/OrderPartitionedRegion");
        }
        catch (Exception e) {
            PRTransactionDUnitTest.fail("validateAfterPutPartitionedRegion : failed while getting the region", e);
        }
        PRTransactionDUnitTest.assertNotNull((Object)customerPartitionedregion);
        PRTransactionDUnitTest.assertNotNull(orderPartitionedregion);
        customerPartitionedregion.getDataStore().dumpEntries(false, PRTransactionDUnitTest.getLogWriter().convertToLogWriterI18n());
        orderPartitionedregion.getDataStore().dumpEntries(false, PRTransactionDUnitTest.getLogWriter().convertToLogWriterI18n());
        Iterator custIterator = customerPartitionedregion.getDataStore().getEntries().iterator();
        PRTransactionDUnitTest.getLogWriter().info("Found " + customerPartitionedregion.getDataStore().getEntries().size() + " Customer entries in the partition");
        Region.Entry custEntry = null;
        while (custIterator.hasNext()) {
            custEntry = (Region.Entry)custIterator.next();
            CustId custid = (CustId)custEntry.getKey();
            custEntry.getValue();
            Iterator orderIterator = orderPartitionedregion.getDataStore().getEntries().iterator();
            PRTransactionDUnitTest.getLogWriter().info("Found " + orderPartitionedregion.getDataStore().getEntries().size() + " Order entries in the partition");
            int orderPerCustomer = 0;
            Region.Entry orderEntry = null;
            while (orderIterator.hasNext()) {
                orderEntry = (Region.Entry)orderIterator.next();
                OrderId orderId = (OrderId)orderEntry.getKey();
                orderEntry.getValue();
                if (!custid.equals(orderId.getCustId())) continue;
                ++orderPerCustomer;
            }
            PRTransactionDUnitTest.assertEquals((int)10, (int)orderPerCustomer);
        }
    }

    public void BUG46661DISABLEtestCacheListenerCallbacks() {
        this.createPopulateAndVerifyCoLocatedPRs(1);
        SerializableCallable registerListeners = new SerializableCallable(){

            public Object call() throws Exception {
                Region custRegion = CacheTestCase.basicGetCache().getRegion("/CustomerPartitionedRegion");
                custRegion.getAttributesMutator().addCacheListener((CacheListener)new TransactionListener2());
                return null;
            }
        };
        this.accessor.invoke(registerListeners);
        this.dataStore1.invoke(registerListeners);
        this.dataStore2.invoke(registerListeners);
        this.dataStore3.invoke(registerListeners);
        this.accessor.invoke(new SerializableCallable("run function"){

            public Object call() throws Exception {
                PartitionedRegion pr = (PartitionedRegion)CacheTestCase.basicGetCache().getRegion("/CustomerPartitionedRegion");
                CacheTestCase.basicGetCache().getRegion("/OrderPartitionedRegion");
                CustId custId = new CustId(2);
                Customer newCus = new Customer("foo", "bar");
                Order order = new Order("fooOrder");
                OrderId orderId = new OrderId(22, custId);
                ArrayList<Object> args = new ArrayList<Object>();
                MyTransactionFunction txFunction = new MyTransactionFunction();
                FunctionService.registerFunction((Function)txFunction);
                Execution e = FunctionService.onRegion((Region)pr);
                HashSet<CustId> filter = new HashSet<CustId>();
                filter.clear();
                args.clear();
                args.add(new Integer(5));
                DistributedTestCase.getLogWriter().info("VERIFY_LISTENER_CALLBACK");
                args.add(custId);
                args.add(newCus);
                args.add(orderId);
                args.add(order);
                filter.add(custId);
                e.withFilter(filter).withArgs(args).execute(txFunction.getId()).getResult();
                return null;
            }
        });
    }

    public void DISABLED_TILL_NEW_TX_IMPL_COMPLETE_testRepeatableRead() throws Exception {
        this.createColocatedPRs(1);
        SerializableCallable registerFunction = new SerializableCallable("register Fn"){

            public Object call() throws Exception {
                MyTransactionFunction txFunction = new MyTransactionFunction();
                FunctionService.registerFunction((Function)txFunction);
                return Boolean.TRUE;
            }
        };
        this.dataStore1.invoke(registerFunction);
        this.dataStore2.invoke(registerFunction);
        this.dataStore3.invoke(registerFunction);
        this.accessor.invoke(new SerializableCallable("run function"){

            public Object call() throws Exception {
                PartitionedRegion pr = (PartitionedRegion)CacheTestCase.basicGetCache().getRegion("/CustomerPartitionedRegion");
                CacheTestCase.basicGetCache().getRegion("/OrderPartitionedRegion");
                CustId custId = new CustId(2);
                Customer newCus = new Customer("foo", "bar");
                Order order = new Order("fooOrder");
                OrderId orderId = new OrderId(22, custId);
                ArrayList<Object> args = new ArrayList<Object>();
                MyTransactionFunction txFunction = new MyTransactionFunction();
                FunctionService.registerFunction((Function)txFunction);
                Execution e = FunctionService.onRegion((Region)pr);
                HashSet<CustId> filter = new HashSet<CustId>();
                filter.clear();
                args.clear();
                args.add(new Integer(8));
                DistributedTestCase.getLogWriter().info("VERIFY_REP_READ");
                args.add(custId);
                args.add(newCus);
                args.add(orderId);
                args.add(order);
                filter.add(custId);
                e.withFilter(filter).withArgs(args).execute(txFunction.getId()).getResult();
                return null;
            }
        });
    }

    public void testPRTXPerformance() throws Exception {
        defaultStringSize = 1024;
        this.createPopulateAndVerifyCoLocatedPRs(2);
        SerializableCallable registerPerfFunctions = new SerializableCallable("register Fn"){

            public Object call() throws Exception {
                PerfFunction perfFunction = new PerfFunction();
                FunctionService.registerFunction((Function)perfFunction);
                PerfTxFunction perfTxFunction = new PerfTxFunction();
                FunctionService.registerFunction((Function)perfTxFunction);
                return Boolean.TRUE;
            }
        };
        this.dataStore1.invoke(registerPerfFunctions);
        this.dataStore2.invoke(registerPerfFunctions);
        this.dataStore3.invoke(registerPerfFunctions);
        this.accessor.invoke(registerPerfFunctions);
        SerializableCallable runPerfFunction = new SerializableCallable("runPerfFunction"){

            public Object call() throws Exception {
                long perfTime = 0L;
                Region customerPR = CacheTestCase.basicGetCache().getRegion("CustomerPartitionedRegion");
                Execution e = FunctionService.onRegion((Region)customerPR);
                for (int iterations = 1; iterations <= 250; ++iterations) {
                    DistributedTestCase.getLogWriter().info("running perfFunction");
                    long startTime = 0L;
                    ArrayList<Object> args = new ArrayList<Object>();
                    CustId custId = new CustId(iterations % 10);
                    for (int i = 1; i <= 10; ++i) {
                        OrderId orderId = new OrderId(custId.getCustId() * 10 + i, custId);
                        Order order = new Order("NewOrder" + i + iterations);
                        ShipmentId shipmentId = new ShipmentId(orderId.getOrderId() * 10 + i, orderId);
                        Shipment shipment = new Shipment("newShipment" + i + iterations);
                        args.add(orderId);
                        args.add(order);
                        args.add(shipmentId);
                        args.add(shipment);
                    }
                    HashSet<CustId> filter = new HashSet<CustId>();
                    filter.add(custId);
                    if (iterations > 50) {
                        startTime = NanoTimer.getTime();
                    }
                    e.withFilter(filter).withArgs(args).execute("perfFunction").getResult();
                    if (startTime <= 0L) continue;
                    perfTime += NanoTimer.getTime() - startTime;
                }
                return new Long(perfTime);
            }
        };
        Long perfTime = (Long)this.accessor.invoke(runPerfFunction);
        SerializableCallable runPerfTxFunction = new SerializableCallable("runPerfTxFunction"){

            public Object call() throws Exception {
                long perfTime = 0L;
                Region customerPR = CacheTestCase.basicGetCache().getRegion("CustomerPartitionedRegion");
                Execution e = FunctionService.onRegion((Region)customerPR);
                for (int iterations = 1; iterations <= 250; ++iterations) {
                    DistributedTestCase.getLogWriter().info("Running perfFunction");
                    long startTime = 0L;
                    ArrayList<Object> args = new ArrayList<Object>();
                    CustId custId = new CustId(iterations % 10);
                    for (int i = 1; i <= 10; ++i) {
                        OrderId orderId = new OrderId(custId.getCustId() * 10 + i, custId);
                        Order order = new Order("NewOrder" + i + iterations);
                        ShipmentId shipmentId = new ShipmentId(orderId.getOrderId() * 10 + i, orderId);
                        Shipment shipment = new Shipment("newShipment" + i + iterations);
                        args.add(orderId);
                        args.add(order);
                        args.add(shipmentId);
                        args.add(shipment);
                    }
                    HashSet<CustId> filter = new HashSet<CustId>();
                    filter.add(custId);
                    if (iterations > 50) {
                        startTime = NanoTimer.getTime();
                    }
                    e.withFilter(filter).withArgs(args).execute("perfTxFunction").getResult();
                    if (startTime <= 0L) continue;
                    perfTime += NanoTimer.getTime() - startTime;
                }
                return new Long(perfTime);
            }
        };
        Long perfTxTime = (Long)this.accessor.invoke(runPerfTxFunction);
        double diff = (double)(perfTime - perfTxTime) * 1.0;
        double percentDiff = diff / (double)perfTxTime.longValue() * 100.0;
        PRTransactionDUnitTest.getLogWriter().info("200 iterations of function took: " + perfTime + " Nanos, and transaction function took: " + perfTxTime + " Nanos, difference: " + diff + " Nanos, percentDifference: " + percentDiff);
    }

    @Override
    public void testColocatedPartitionedRegion() throws Throwable {
    }

    @Override
    public void testColocationPartitionedRegion() throws Throwable {
    }

    @Override
    public void testColocationPartitionedRegionWithRedundancy() throws Throwable {
    }

    @Override
    public void testPartitionResolverPartitionedRegion() throws Throwable {
    }

    @Override
    public void testColocationPartitionedRegionWithNullColocationSpecifiedOnOneNode() {
    }

    @Override
    public void testColocatedPRRedundancyRecovery() throws Throwable {
    }

    @Override
    public void testColocatedPRWithAccessorOnDifferentNode1() throws Throwable {
    }

    @Override
    public void testColocatedPRWithAccessorOnDifferentNode2() throws Throwable {
    }

    @Override
    public void testColocatedPRWithDestroy() throws Throwable {
    }

    @Override
    public void testColocatedPRWithLocalDestroy() throws Throwable {
    }

    @Override
    public void testColocatedPRWithPROnDifferentNode1() throws Throwable {
    }

    @Override
    public void tearDown2() throws Exception {
        PRTransactionDUnitTest.invokeInEveryVM(this.verifyNoTxState);
        super.tearDown2();
    }

    static class TransactionListener2
    extends CacheListenerAdapter {
        private int numberOfPutCallbacks = 0;
        private int numberOfDestroyCallbacks = 0;
        private int numberOfInvalidateCallbacks = 0;

        TransactionListener2() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void afterCreate(EntryEvent event) {
            TransactionListener2 transactionListener2 = this;
            synchronized (transactionListener2) {
                ++this.numberOfPutCallbacks;
            }
        }

        public void afterUpdate(EntryEvent event) {
            this.afterCreate(event);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void afterDestroy(EntryEvent event) {
            TransactionListener2 transactionListener2 = this;
            synchronized (transactionListener2) {
                ++this.numberOfDestroyCallbacks;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void afterInvalidate(EntryEvent event) {
            TransactionListener2 transactionListener2 = this;
            synchronized (transactionListener2) {
                ++this.numberOfInvalidateCallbacks;
            }
        }

        public synchronized int getNumberOfPutCallbacks() {
            return this.numberOfPutCallbacks;
        }

        public synchronized int getNumberOfDestroyCallbacks() {
            return this.numberOfDestroyCallbacks;
        }

        public synchronized int getNumberOfInvalidateCallbacks() {
            return this.numberOfInvalidateCallbacks;
        }
    }

    class TransactionListener
    extends CacheListenerAdapter {
        TransactionListener() {
        }

        public void afterCreate(EntryEvent event) {
            Region custPR = event.getRegion();
            Region orderPR = custPR.getCache().getRegion("/OrderPartitionedRegion");
            CacheTransactionManager mgr = custPR.getCache().getCacheTransactionManager();
            mgr.begin();
            CustId custId = (CustId)event.getKey();
            for (int j = 1; j <= 10; ++j) {
                int oid = custId.getCustId() * 10 + j;
                OrderId orderId = new OrderId(oid, custId);
                Order order = new Order("OREDR" + oid);
                try {
                    TestCase.assertNotNull((Object)orderPR);
                    orderPR.put((Object)orderId, (Object)order);
                    continue;
                }
                catch (Exception e) {
                    DistributedTestCase.fail(" failed while doing put operation in CacheListener ", e);
                }
            }
            mgr.commit();
            TXManagerImpl.waitForPendingCommitForTest();
            DistributedTestCase.getLogWriter().info("COMMIT completed");
        }
    }
}

