/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.execute;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.EntryOperation;
import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.PartitionResolver;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.ReplyException;
import com.gemstone.gemfire.internal.cache.EntryOperationImpl;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegionDUnitTestCase;
import com.gemstone.gemfire.internal.cache.PartitionedRegionDataStore;
import com.gemstone.gemfire.internal.cache.execute.MonthBasedPartitionResolver;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableRunnable;
import dunit.VM;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import junit.framework.TestCase;

public class PRCustomPartitioningDUnitTest
extends PartitionedRegionDUnitTestCase {
    protected static Cache cache = null;
    Properties props = new Properties();
    VM vm0 = null;
    VM vm1 = null;
    VM vm2 = null;
    VM vm3 = null;
    static final int totalNumBuckets = 7;
    static ArrayList listOfKeys1 = new ArrayList();
    static ArrayList listOfKeys2 = new ArrayList();
    static ArrayList listOfKeys3 = new ArrayList();
    static ArrayList listOfKeys4 = new ArrayList();
    SerializableRunnable createPrRegionWithPartitionResolver = new CacheSerializableRunnable("createPrRegionWithDS"){

        @Override
        public void run2() throws CacheException {
            AttributesFactory attr = new AttributesFactory();
            MonthBasedPartitionResolver resolver = MonthBasedPartitionResolver.getInstance();
            PartitionAttributesFactory paf = new PartitionAttributesFactory();
            paf.setTotalNumBuckets(7);
            paf.setPartitionResolver((PartitionResolver)resolver);
            paf.setRedundantCopies(0);
            PartitionAttributes prAttr = paf.create();
            attr.setPartitionAttributes(prAttr);
            RegionAttributes regionAttribs = attr.create();
            cache.createRegion("PR1", regionAttribs);
        }
    };
    SerializableRunnable createPrRegionOnlyAccessorWithPartitionResolver = new CacheSerializableRunnable("createPrRegionOnlyAccessor"){

        @Override
        public void run2() throws CacheException {
            AttributesFactory attr = new AttributesFactory();
            PartitionAttributesFactory paf = new PartitionAttributesFactory();
            MonthBasedPartitionResolver resolver = MonthBasedPartitionResolver.getInstance();
            PartitionAttributes prAttr = paf.setLocalMaxMemory(0).setTotalNumBuckets(7).setPartitionResolver((PartitionResolver)resolver).setRedundantCopies(0).create();
            attr.setPartitionAttributes(prAttr);
            RegionAttributes regionAttribs = attr.create();
            cache.createRegion("PR1", regionAttribs);
        }
    };

    public PRCustomPartitioningDUnitTest(String name) {
        super(name);
    }

    public static void createCacheInVm() throws Exception {
        Properties props = new Properties();
        new PRCustomPartitioningDUnitTest("temp").createCache(props);
    }

    private void createCache(Properties props) throws Exception {
        InternalDistributedSystem ds = this.getSystem(props);
        PRCustomPartitioningDUnitTest.assertNotNull((Object)ds);
        ds.disconnect();
        ds = this.getSystem(props);
        cache = CacheFactory.create((DistributedSystem)ds);
        PRCustomPartitioningDUnitTest.assertNotNull((Object)cache);
    }

    public static boolean searchForKey(PartitionedRegion par, Date key) {
        boolean foundIt = false;
        int numBucks = par.getTotalNumberOfBuckets();
        for (int b = 0; b < numBucks; ++b) {
            if (!par.getBucketKeys(b).contains(key)) continue;
            foundIt = true;
            PRCustomPartitioningDUnitTest.getLogWriter().info("Key " + key + " found in bucket " + b);
            break;
        }
        if (!foundIt) {
            PRCustomPartitioningDUnitTest.getLogWriter().severe("Key " + key + " not found in any bucket");
        }
        return foundIt;
    }

    public void partitionedRegionTest(final String prName) {
        this.vm0.invoke(new CacheSerializableRunnable("doPutCreateInvalidateOperations1"){

            @Override
            public void run2() throws CacheException {
                Calendar cal = Calendar.getInstance();
                Region pr = cache.getRegion(prName);
                if (pr == null) {
                    TestCase.fail((String)(prName + " not created"));
                }
                int size = 0;
                size = pr.size();
                TestCase.assertEquals((String)"Size doesnt return expected value", (int)0, (int)size);
                TestCase.assertEquals((String)"isEmpty doesnt return proper state of the PartitionedRegion", (boolean)true, (boolean)pr.isEmpty());
                TestCase.assertEquals((int)0, (int)pr.keySet().size());
                for (int i = 0; i <= 11; ++i) {
                    int yr = new Integer((int)(Math.random() * 2100.0));
                    int month = i;
                    int date = new Integer((int)(Math.random() * 30.0));
                    cal.set(yr, month, date);
                    Date key = cal.getTime();
                    listOfKeys1.add(key);
                    TestCase.assertNotNull((Object)pr);
                    pr.put((Object)key, (Object)Integer.toString(i));
                    TestCase.assertEquals((Object)Integer.toString(i), (Object)pr.get((Object)key));
                }
                PartitionedRegion ppr = (PartitionedRegion)pr;
            }
        });
        this.vm1.invoke(new CacheSerializableRunnable("doPutCreateInvalidateOperations2"){

            @Override
            public void run2() throws CacheException {
                Calendar cal = Calendar.getInstance();
                Region pr = cache.getRegion(prName);
                if (pr == null) {
                    TestCase.fail((String)(prName + " not created"));
                }
                for (int i = 0; i <= 11; ++i) {
                    int yr = new Integer((int)(Math.random() * 2200.0));
                    int month = i;
                    int date = new Integer((int)(Math.random() * 30.0));
                    cal.set(yr, month, date);
                    Date key = cal.getTime();
                    listOfKeys2.add(key);
                    TestCase.assertNotNull((Object)pr);
                    pr.put((Object)key, (Object)Integer.toString(i));
                    TestCase.assertEquals((Object)Integer.toString(i), (Object)pr.get((Object)key));
                }
                PartitionedRegion ppr = (PartitionedRegion)pr;
                try {
                    ppr.dumpAllBuckets(false, DistributedTestCase.getLogWriter().convertToLogWriterI18n());
                }
                catch (ReplyException re) {
                    DistributedTestCase.fail("dumpAllBuckets", re);
                }
            }
        });
        this.vm2.invoke(new CacheSerializableRunnable("doPutCreateInvalidateOperations2"){

            @Override
            public void run2() throws CacheException {
                Calendar cal = Calendar.getInstance();
                Region pr = cache.getRegion(prName);
                if (pr == null) {
                    TestCase.fail((String)(prName + " not created"));
                }
                for (int i = 0; i <= 11; ++i) {
                    int yr = new Integer((int)(Math.random() * 2300.0));
                    int month = i;
                    int date = new Integer((int)(Math.random() * 30.0));
                    cal.set(yr, month, date);
                    Date key = cal.getTime();
                    listOfKeys3.add(key);
                    TestCase.assertNotNull((Object)pr);
                    pr.put((Object)key, (Object)Integer.toString(i));
                    TestCase.assertEquals((Object)Integer.toString(i), (Object)pr.get((Object)key));
                }
                PartitionedRegion ppr = (PartitionedRegion)pr;
                try {
                    ppr.dumpAllBuckets(false, DistributedTestCase.getLogWriter().convertToLogWriterI18n());
                }
                catch (ReplyException re) {
                    DistributedTestCase.fail("dumpAllBuckets", re);
                }
            }
        });
        this.vm3.invoke(new CacheSerializableRunnable("doPutCreateInvalidateOperations3"){

            @Override
            public void run2() throws CacheException {
                Calendar cal = Calendar.getInstance();
                Region pr = cache.getRegion(prName);
                if (pr == null) {
                    TestCase.fail((String)(prName + " not created"));
                }
                for (int i = 0; i <= 11; ++i) {
                    int yr = new Integer((int)(Math.random() * 2400.0));
                    int month = i;
                    int date = new Integer((int)(Math.random() * 30.0));
                    cal.set(yr, month, date);
                    Date key = cal.getTime();
                    listOfKeys4.add(key);
                    TestCase.assertNotNull((Object)pr);
                    pr.put((Object)key, (Object)Integer.toString(i));
                    TestCase.assertEquals((Object)Integer.toString(i), (Object)pr.get((Object)key));
                }
                PartitionedRegion ppr = (PartitionedRegion)pr;
                try {
                    ppr.dumpAllBuckets(false, DistributedTestCase.getLogWriter().convertToLogWriterI18n());
                }
                catch (ReplyException re) {
                    DistributedTestCase.fail("dumpAllBuckets", re);
                }
            }
        });
        this.vm0.invoke(new CacheSerializableRunnable("verifyKeysonVM0"){

            @Override
            public void run2() throws CacheException {
                final PartitionedRegion pr = (PartitionedRegion)cache.getRegion(prName);
                if (pr == null) {
                    TestCase.fail((String)(prName + " not created"));
                }
                Iterator itr = listOfKeys1.iterator();
                while (itr.hasNext()) {
                    TestCase.assertTrue((boolean)PRCustomPartitioningDUnitTest.searchForKey(pr, (Date)itr.next()));
                }
                pr.getDataStore().visitBuckets(new PartitionedRegionDataStore.BucketVisitor(){

                    public void visit(Integer bucketId, Region r) {
                        Set s = pr.getBucketKeys(bucketId.intValue());
                        Iterator it = s.iterator();
                        while (it.hasNext()) {
                            EntryOperationImpl eo = new EntryOperationImpl((Region)pr, null, it.next(), null, null);
                            PartitionResolver rr = pr.getPartitionResolver();
                            Object o = rr.getRoutingObject((EntryOperation)eo);
                            Integer i = new Integer(o.hashCode() % 7);
                            TestCase.assertEquals((Object)bucketId, (Object)i);
                        }
                    }
                });
            }
        });
        this.vm1.invoke(new CacheSerializableRunnable("verifyKeysonVM1"){

            @Override
            public void run2() throws CacheException {
                final PartitionedRegion pr = (PartitionedRegion)cache.getRegion(prName);
                if (pr == null) {
                    TestCase.fail((String)(prName + " not created"));
                }
                Iterator itr = listOfKeys2.iterator();
                while (itr.hasNext()) {
                    TestCase.assertTrue((boolean)PRCustomPartitioningDUnitTest.searchForKey(pr, (Date)itr.next()));
                }
                pr.getDataStore().visitBuckets(new PartitionedRegionDataStore.BucketVisitor(){

                    public void visit(Integer bucketId, Region r) {
                        Set s = pr.getBucketKeys(bucketId.intValue());
                        Iterator it = s.iterator();
                        while (it.hasNext()) {
                            EntryOperationImpl eo = new EntryOperationImpl((Region)pr, null, it.next(), null, null);
                            PartitionResolver rr = pr.getPartitionResolver();
                            Object o = rr.getRoutingObject((EntryOperation)eo);
                            Integer i = new Integer(o.hashCode() % 7);
                            TestCase.assertEquals((Object)bucketId, (Object)i);
                        }
                    }
                });
            }
        });
        this.vm2.invoke(new CacheSerializableRunnable("verifyKeysonVM2"){

            @Override
            public void run2() throws CacheException {
                final PartitionedRegion pr = (PartitionedRegion)cache.getRegion(prName);
                if (pr == null) {
                    TestCase.fail((String)(prName + " not created"));
                }
                Iterator itr = listOfKeys3.iterator();
                itr = listOfKeys3.iterator();
                while (itr.hasNext()) {
                    TestCase.assertTrue((boolean)PRCustomPartitioningDUnitTest.searchForKey(pr, (Date)itr.next()));
                }
                pr.getDataStore().visitBuckets(new PartitionedRegionDataStore.BucketVisitor(){

                    public void visit(Integer bucketId, Region r) {
                        Set s = pr.getBucketKeys(bucketId.intValue());
                        Iterator it = s.iterator();
                        while (it.hasNext()) {
                            EntryOperationImpl eo = new EntryOperationImpl((Region)pr, null, it.next(), null, null);
                            PartitionResolver rr = pr.getPartitionResolver();
                            Object o = rr.getRoutingObject((EntryOperation)eo);
                            Integer i = new Integer(o.hashCode() % 7);
                            TestCase.assertEquals((Object)bucketId, (Object)i);
                        }
                    }
                });
            }
        });
        this.vm3.invoke(new CacheSerializableRunnable("verifyKeysonVM3"){

            @Override
            public void run2() throws CacheException {
                PartitionedRegion pr = (PartitionedRegion)cache.getRegion(prName);
                if (pr == null) {
                    TestCase.fail((String)(prName + " not created"));
                }
                Iterator itr = listOfKeys4.iterator();
                itr = listOfKeys4.iterator();
                while (itr.hasNext()) {
                    TestCase.assertTrue((boolean)PRCustomPartitioningDUnitTest.searchForKey(pr, (Date)itr.next()));
                }
                TestCase.assertEquals((Object)pr.getDataStore(), null);
            }
        });
    }

    public void testPartitionedRegionOperationsCustomPartitioning() throws Exception {
        Host host = Host.getHost(0);
        this.vm0 = host.getVM(0);
        this.vm1 = host.getVM(1);
        this.vm2 = host.getVM(2);
        VM accessor = this.vm3 = host.getVM(3);
        this.vm0.invoke(PRCustomPartitioningDUnitTest.class, "createCacheInVm");
        this.vm1.invoke(PRCustomPartitioningDUnitTest.class, "createCacheInVm");
        this.vm2.invoke(PRCustomPartitioningDUnitTest.class, "createCacheInVm");
        accessor.invoke(PRCustomPartitioningDUnitTest.class, "createCacheInVm");
        this.vm0.invoke(this.createPrRegionWithPartitionResolver);
        this.vm1.invoke(this.createPrRegionWithPartitionResolver);
        this.vm2.invoke(this.createPrRegionWithPartitionResolver);
        accessor.invoke(this.createPrRegionOnlyAccessorWithPartitionResolver);
        this.partitionedRegionTest("/PR1");
        this.destroyTheRegion("/PR1");
    }

    public void destroyTheRegion(final String name) {
        this.vm0.invoke(new CacheSerializableRunnable("destroyRegionOp"){

            @Override
            public void run2() throws CacheException {
                Region pr = cache.getRegion(name);
                if (pr == null) {
                    TestCase.fail((String)(name + " not created"));
                }
                pr.destroyRegion();
            }
        });
    }
}

