/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.execute;

import com.gemstone.gemfire.cache.client.Pool;
import com.gemstone.gemfire.cache.execute.Execution;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionService;
import com.gemstone.gemfire.cache.execute.ResultCollector;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.internal.cache.execute.PRClientServerTestBase;
import com.gemstone.gemfire.internal.cache.execute.TimeKeeper;
import com.gemstone.gemfire.internal.cache.functions.TestFunction;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;

public class PRClientServerFunctionExecutionNoAckDUnitTest
extends PRClientServerTestBase {
    private static final String TEST_FUNCTION1 = "TestFunction1";
    static Boolean isByName = null;
    static Function functionNoAck = null;
    static Function functionAck = null;
    static Boolean toRegister = null;
    private static final int NUM_ITERATION = 1;

    public PRClientServerFunctionExecutionNoAckDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
    }

    public void testServerFunctionExecution_NoAck() {
        this.createScenario();
        functionNoAck = new TestFunction(false, TEST_FUNCTION1, true);
        functionAck = new TestFunction(true, TEST_FUNCTION1, true);
        this.registerFunctionAtServer(functionNoAck);
        this.registerFunctionAtServer(functionAck);
        isByName = new Boolean(true);
        toRegister = new Boolean(true);
        PRClientServerFunctionExecutionNoAckDUnitTest.getLogWriter().info("PRClientServerFunctionExecutionNoAckDUnitTest#testServerFunctionExecution_NoAck : Starting test");
        client.invoke(PRClientServerFunctionExecutionNoAckDUnitTest.class, "serverExecution", new Object[]{isByName, functionNoAck, functionAck, toRegister});
        client.invoke(PRClientServerFunctionExecutionNoAckDUnitTest.class, "allServerExecution", new Object[]{isByName, functionNoAck, toRegister});
    }

    public void testServerFunctionExecution_NoAck_WithoutRegister() {
        this.createScenario();
        functionNoAck = new TestFunction(false, TEST_FUNCTION1, true);
        functionAck = new TestFunction(true, TEST_FUNCTION1, true);
        this.registerFunctionAtServer(functionNoAck);
        this.registerFunctionAtServer(functionAck);
        toRegister = new Boolean(false);
        isByName = new Boolean(true);
        PRClientServerFunctionExecutionNoAckDUnitTest.getLogWriter().info("PRClientServerFunctionExecutionNoAckDUnitTest#testServerFunctionExecution_NoAck : Starting test");
        client.invoke(PRClientServerFunctionExecutionNoAckDUnitTest.class, "serverExecution", new Object[]{isByName, functionNoAck, functionAck, toRegister});
        client.invoke(PRClientServerFunctionExecutionNoAckDUnitTest.class, "allServerExecution", new Object[]{isByName, functionNoAck, toRegister});
    }

    private void createScenario() {
        PRClientServerFunctionExecutionNoAckDUnitTest.getLogWriter().info("PRClientServerFFunctionExecutionDUnitTest#createScenario : creating scenario");
        this.createClientServerScenarionWithoutRegion();
    }

    public static void serverExecution(Boolean isByName, Function functionNoAck, Function functionAck, Boolean toRegister) {
        HashSet<String> testKeysSet;
        int i;
        TimeKeeper t;
        DistributedSystem.setThreadsSocketPolicy((boolean)false);
        if (toRegister.booleanValue()) {
            FunctionService.registerFunction((Function)functionNoAck);
        } else {
            PRClientServerFunctionExecutionNoAckDUnitTest.assertNull((Object)FunctionService.getFunction((String)functionNoAck.getId()));
        }
        Execution member = FunctionService.onServer((Pool)pool);
        try {
            t = new TimeKeeper();
            t.start();
            for (i = 0; i < 1; ++i) {
                PRClientServerFunctionExecutionNoAckDUnitTest.execute(member, Boolean.TRUE, functionNoAck, isByName, toRegister);
            }
            t.stop();
            PRClientServerFunctionExecutionNoAckDUnitTest.getLogWriter().info("Time taken to execute boolean based1NoAck functions :" + t.getTimeInMs());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            PRClientServerFunctionExecutionNoAckDUnitTest.getLogWriter().info("Exception : ", (Throwable)ex);
            PRClientServerFunctionExecutionNoAckDUnitTest.fail((String)"Test failed after the execute operation");
        }
        try {
            testKeysSet = new HashSet<String>();
            for (i = 0; i < 2; ++i) {
                testKeysSet.add("execKey-" + i);
            }
            TimeKeeper t2 = new TimeKeeper();
            t2.start();
            for (int i2 = 0; i2 < 1; ++i2) {
                PRClientServerFunctionExecutionNoAckDUnitTest.execute(member, testKeysSet, functionNoAck, isByName, toRegister);
            }
            t2.stop();
            PRClientServerFunctionExecutionNoAckDUnitTest.getLogWriter().info("Time taken to execute setbased1NoAck functions :" + t2.getTimeInMs());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            PRClientServerFunctionExecutionNoAckDUnitTest.getLogWriter().info("Exception : ", (Throwable)ex);
            PRClientServerFunctionExecutionNoAckDUnitTest.fail((String)"Test failed after the execute operationssssss");
        }
        if (toRegister.booleanValue()) {
            FunctionService.registerFunction((Function)functionAck);
        } else {
            PRClientServerFunctionExecutionNoAckDUnitTest.assertNull((Object)FunctionService.getFunction((String)functionAck.getId()));
        }
        try {
            t = new TimeKeeper();
            long timeinms = 0L;
            t.start();
            for (int i3 = 0; i3 < 1; ++i3) {
                ResultCollector rc = PRClientServerFunctionExecutionNoAckDUnitTest.execute(member, Boolean.TRUE, functionAck, isByName, toRegister);
                t.stop();
                timeinms += t.getTimeInMs();
                PRClientServerFunctionExecutionNoAckDUnitTest.assertEquals((Object)Boolean.TRUE, ((List)rc.getResult()).get(0));
            }
            PRClientServerFunctionExecutionNoAckDUnitTest.getLogWriter().info("Time taken to execute boolean based1haveResults functions :" + timeinms);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            PRClientServerFunctionExecutionNoAckDUnitTest.getLogWriter().info("Exception : ", (Throwable)ex);
            PRClientServerFunctionExecutionNoAckDUnitTest.fail((String)"Test failed after the execute operation");
        }
        try {
            testKeysSet = new HashSet();
            for (int i4 = 0; i4 < 20; ++i4) {
                testKeysSet.add("execKey-" + i4);
            }
            TimeKeeper t3 = new TimeKeeper();
            long timeinms = 0L;
            t3.start();
            for (int i5 = 0; i5 < 1; ++i5) {
                ResultCollector rc = PRClientServerFunctionExecutionNoAckDUnitTest.execute(member, testKeysSet, functionAck, isByName, toRegister);
                t3.stop();
                timeinms += t3.getTimeInMs();
                List resultList = (List)rc.getResult();
                for (int j = 0; j < 20; ++j) {
                    PRClientServerFunctionExecutionNoAckDUnitTest.assertEquals((boolean)true, (boolean)((List)resultList.get(0)).contains("execKey-" + j));
                }
            }
            PRClientServerFunctionExecutionNoAckDUnitTest.getLogWriter().info("Time taken to execute setbased1haveResults functions :" + timeinms);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            PRClientServerFunctionExecutionNoAckDUnitTest.getLogWriter().info("Exception : ", (Throwable)ex);
            PRClientServerFunctionExecutionNoAckDUnitTest.fail((String)"Test failed after the execute operationssssss");
        }
    }

    public static void allServerExecution(Boolean isByName, Function function, Boolean toRegister) {
        DistributedSystem.setThreadsSocketPolicy((boolean)false);
        if (toRegister.booleanValue()) {
            FunctionService.registerFunction((Function)function);
        } else {
            FunctionService.unregisterFunction((String)function.getId());
            PRClientServerFunctionExecutionNoAckDUnitTest.assertNull((Object)FunctionService.getFunction((String)function.getId()));
        }
        Execution member = FunctionService.onServers((Pool)pool);
        try {
            PRClientServerFunctionExecutionNoAckDUnitTest.execute(member, Boolean.TRUE, function, isByName, toRegister);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            PRClientServerFunctionExecutionNoAckDUnitTest.getLogWriter().info("Exception : ", (Throwable)ex);
            PRClientServerFunctionExecutionNoAckDUnitTest.fail((String)"Test failed after the execute operation allserver   ");
        }
        try {
            HashSet<String> testKeysSet = new HashSet<String>();
            for (int i = 0; i < 20; ++i) {
                testKeysSet.add("execKey-" + i);
            }
            PRClientServerFunctionExecutionNoAckDUnitTest.execute(member, testKeysSet, function, isByName, toRegister);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            PRClientServerFunctionExecutionNoAckDUnitTest.getLogWriter().info("Exception : ", (Throwable)ex);
            PRClientServerFunctionExecutionNoAckDUnitTest.fail((String)"Test failed after the execute operation");
        }
    }

    private static ResultCollector execute(Execution member, Serializable args, Function function, Boolean isByName, Boolean toRegister) throws Exception {
        if (isByName.booleanValue()) {
            if (toRegister.booleanValue()) {
                PRClientServerFunctionExecutionNoAckDUnitTest.getLogWriter().info("The function name to execute : " + function.getId());
                Execution me = member.withArgs((Object)args);
                PRClientServerFunctionExecutionNoAckDUnitTest.getLogWriter().info("The args passed  : " + args);
                return me.execute(function.getId());
            }
            PRClientServerFunctionExecutionNoAckDUnitTest.getLogWriter().info("The function name to execute : (without Register) " + function.getId());
            Execution me = member.withArgs((Object)args);
            PRClientServerFunctionExecutionNoAckDUnitTest.getLogWriter().info("The args passed  : " + args);
            return me.execute(function.getId(), function.hasResult(), function.isHA(), function.optimizeForWrite());
        }
        return member.withArgs((Object)args).execute(function);
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
    }
}

