/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.StatisticsFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.DiskStoreFactory;
import com.gemstone.gemfire.cache.util.CacheListenerAdapter;
import com.gemstone.gemfire.cache.util.GatewayQueueAttributes;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.cache.Conflatable;
import com.gemstone.gemfire.internal.cache.EventID;
import com.gemstone.gemfire.internal.cache.GatewayStats;
import com.gemstone.gemfire.internal.cache.SingleWriteSingleReadRegionQueue;
import dunit.Host;
import dunit.SerializableRunnable;
import dunit.VM;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import junit.framework.TestCase;

public class SingleWriteSingleReadRegionQueueDUnitTest
extends CacheTestCase {
    private static SingleWriteSingleReadRegionQueue remoteQueue = null;
    private static final long serialVersionUID = 7024693896871107318L;

    public SingleWriteSingleReadRegionQueueDUnitTest(String name) {
        super(name);
    }

    public void testPutTake() {
        SingleWriteSingleReadRegionQueue queue = this.initQueue();
        SingleWriteSingleReadRegionQueueDUnitTest.assertNull((Object)queue.take());
        queue.put((Object)"A");
        queue.put((Object)"B");
        queue.put((Object)"C");
        SingleWriteSingleReadRegionQueueDUnitTest.assertEquals((int)3, (int)queue.size());
        SingleWriteSingleReadRegionQueueDUnitTest.assertEquals((Object)"A", (Object)queue.take());
        SingleWriteSingleReadRegionQueueDUnitTest.assertEquals((Object)"B", (Object)queue.take());
        SingleWriteSingleReadRegionQueueDUnitTest.assertEquals((Object)"C", (Object)queue.take());
        SingleWriteSingleReadRegionQueueDUnitTest.assertEquals(null, (Object)queue.take());
        queue.put((Object)"D");
        SingleWriteSingleReadRegionQueueDUnitTest.assertEquals((Object)"D", (Object)queue.take());
        SingleWriteSingleReadRegionQueueDUnitTest.assertEquals(null, (Object)queue.take());
    }

    public void testPutPeekRemove() {
        SingleWriteSingleReadRegionQueue queue = this.initQueue();
        SingleWriteSingleReadRegionQueueDUnitTest.assertNull((Object)queue.peek());
        queue.put((Object)"A");
        queue.put((Object)"B");
        queue.put((Object)"C");
        SingleWriteSingleReadRegionQueueDUnitTest.assertEquals((Object)"A", (Object)queue.peek());
        SingleWriteSingleReadRegionQueueDUnitTest.assertEquals((Object)"A", (Object)queue.peek());
        queue.remove();
        queue.remove();
        SingleWriteSingleReadRegionQueueDUnitTest.assertEquals((Object)"B", (Object)queue.peek());
        queue.remove();
        SingleWriteSingleReadRegionQueueDUnitTest.assertEquals((Object)"C", (Object)queue.peek());
        queue.remove();
        SingleWriteSingleReadRegionQueueDUnitTest.assertEquals(null, (Object)queue.peek());
        queue.remove();
        SingleWriteSingleReadRegionQueueDUnitTest.assertEquals(null, (Object)queue.peek());
        queue.put((Object)"D");
        SingleWriteSingleReadRegionQueueDUnitTest.assertEquals((Object)"D", (Object)queue.peek());
        queue.remove();
        SingleWriteSingleReadRegionQueueDUnitTest.assertEquals(null, (Object)queue.peek());
    }

    public void testPeekBatch() {
        SingleWriteSingleReadRegionQueue queue = this.initQueue();
        queue.put((Object)"A");
        queue.put((Object)"B");
        queue.put((Object)"C");
        SingleWriteSingleReadRegionQueueDUnitTest.assertEquals(Arrays.asList("A", "B", "C"), (Object)queue.peek(20));
        SingleWriteSingleReadRegionQueueDUnitTest.assertEquals(Arrays.asList("A", "B", "C"), (Object)queue.peek(20));
        queue.remove();
        queue.remove();
        queue.remove();
        queue.remove();
        SingleWriteSingleReadRegionQueueDUnitTest.assertEquals((Object)Collections.EMPTY_LIST, (Object)queue.peek(20));
        queue.put((Object)"D");
        queue.remove();
        queue.put((Object)"E");
        queue.put((Object)"F");
        SingleWriteSingleReadRegionQueueDUnitTest.assertEquals(Arrays.asList("D", "E", "F"), (Object)queue.peek(20));
        queue.remove(20);
        SingleWriteSingleReadRegionQueueDUnitTest.assertNull((Object)queue.peek());
    }

    public void testPeekBatchBlocking() {
        final SingleWriteSingleReadRegionQueue queue = this.initQueue();
        queue.put((Object)"A");
        queue.put((Object)"B");
        queue.put((Object)"C");
        long start = System.currentTimeMillis();
        SingleWriteSingleReadRegionQueueDUnitTest.assertEquals(Arrays.asList("A", "B", "C"), (Object)queue.peek(20, 1000));
        SingleWriteSingleReadRegionQueueDUnitTest.assertEquals(Arrays.asList("A", "B", "C"), (Object)queue.peek(20, 1000));
        SingleWriteSingleReadRegionQueueDUnitTest.assertTrue((String)"Should have blocked for 2 seconds waiting for new data", (System.currentTimeMillis() - start > 1500L ? 1 : 0) != 0);
        queue.remove();
        queue.remove();
        queue.remove();
        start = System.currentTimeMillis();
        SingleWriteSingleReadRegionQueueDUnitTest.assertEquals((Object)Collections.EMPTY_LIST, (Object)queue.peek(20, 1000));
        SingleWriteSingleReadRegionQueueDUnitTest.assertTrue((String)"Should have blocked for 1 seconds waiting for new data", (System.currentTimeMillis() - start > 500L ? 1 : 0) != 0);
        Thread putter = new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(5000L);
                    queue.put((Object)"D");
                    Thread.sleep(100L);
                    queue.put((Object)"E");
                    Thread.sleep(100L);
                    queue.put((Object)"F");
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        };
        putter.start();
        start = System.currentTimeMillis();
        SingleWriteSingleReadRegionQueueDUnitTest.assertEquals(Arrays.asList("D", "E", "F"), (Object)queue.peek(3, 30000));
        SingleWriteSingleReadRegionQueueDUnitTest.assertTrue((String)"Should have blocked for less than 15 seconds waiting for new data", (System.currentTimeMillis() - start < 15000L ? 1 : 0) != 0);
    }

    public void testConflation() {
        SingleWriteSingleReadRegionQueue queue = this.initQueue(true);
        queue.put((Object)new MyConflatable("A", "A"));
        queue.put((Object)new MyConflatable("B", "B"));
        queue.put((Object)new MyConflatable("C", "C"));
        queue.put((Object)new MyConflatable("A", "D"));
        queue.put((Object)new MyConflatable("B", "E"));
        queue.put((Object)new MyConflatable("A", "F"));
        SingleWriteSingleReadRegionQueueDUnitTest.assertEquals((int)3, (int)queue.size());
        SingleWriteSingleReadRegionQueueDUnitTest.assertEquals((Object)new MyConflatable("C", "C"), (Object)queue.take());
        SingleWriteSingleReadRegionQueueDUnitTest.assertEquals((Object)new MyConflatable("B", "E"), (Object)queue.take());
        SingleWriteSingleReadRegionQueueDUnitTest.assertEquals((Object)new MyConflatable("A", "F"), (Object)queue.take());
        SingleWriteSingleReadRegionQueueDUnitTest.assertEquals(null, (Object)queue.take());
        queue.put((Object)new MyConflatable("A", "G"));
        queue.put((Object)new MyConflatable("A", "H"));
        SingleWriteSingleReadRegionQueueDUnitTest.assertEquals((Object)new MyConflatable("A", "H"), (Object)queue.take());
        SingleWriteSingleReadRegionQueueDUnitTest.assertEquals(null, (Object)queue.take());
    }

    public void testFailover() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        vm0.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                remoteQueue = SingleWriteSingleReadRegionQueueDUnitTest.this.initQueue();
            }
        });
        SingleWriteSingleReadRegionQueue queue = this.initQueue();
        queue.put((Object)"A");
        queue.put((Object)"B");
        queue.put((Object)"C");
        vm0.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                TestCase.assertEquals((int)3, (int)remoteQueue.size());
                TestCase.assertEquals(Arrays.asList("A", "B", "C"), (Object)remoteQueue.peek(20));
                TestCase.assertEquals(Arrays.asList("A", "B", "C"), (Object)remoteQueue.peek(20));
                remoteQueue.remove();
                remoteQueue.remove();
                remoteQueue.remove();
                remoteQueue.remove();
                TestCase.assertEquals((Object)Collections.EMPTY_LIST, (Object)remoteQueue.peek(20));
                remoteQueue.put((Object)"D");
                remoteQueue.remove();
                remoteQueue.put((Object)"E");
                remoteQueue.put((Object)"F");
                TestCase.assertEquals(Arrays.asList("D", "E", "F"), (Object)remoteQueue.peek(20));
                remoteQueue.remove(20);
                TestCase.assertNull((Object)remoteQueue.peek());
            }
        });
    }

    public void testFailoverWithConflation() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        vm0.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                remoteQueue = SingleWriteSingleReadRegionQueueDUnitTest.this.initQueue(true);
            }
        });
        SingleWriteSingleReadRegionQueue queue = this.initQueue(true);
        queue.put((Object)new MyConflatable("A", "A"));
        queue.put((Object)new MyConflatable("B", "B"));
        queue.put((Object)new MyConflatable("C", "C"));
        queue.put((Object)new MyConflatable("A", "D"));
        queue.put((Object)new MyConflatable("B", "E"));
        queue.put((Object)new MyConflatable("A", "F"));
        queue.destroy();
        vm0.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                TestCase.assertEquals((Object)new MyConflatable("C", "C"), (Object)remoteQueue.take());
                TestCase.assertEquals((Object)new MyConflatable("B", "E"), (Object)remoteQueue.take());
                TestCase.assertEquals((Object)new MyConflatable("A", "F"), (Object)remoteQueue.peek());
                remoteQueue.put((Object)new MyConflatable("A", "G"));
                remoteQueue.put((Object)new MyConflatable("A", "H"));
                TestCase.assertEquals((Object)new MyConflatable("A", "F"), (Object)remoteQueue.take());
                TestCase.assertEquals((Object)new MyConflatable("A", "H"), (Object)remoteQueue.take());
                TestCase.assertEquals(null, (Object)remoteQueue.take());
            }
        });
    }

    public void testFailoverWithConflationAndGII() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        SingleWriteSingleReadRegionQueue queue = this.initQueue(true);
        queue.put((Object)new MyConflatable("A", "A"));
        queue.put((Object)new MyConflatable("B", "B"));
        queue.put((Object)new MyConflatable("C", "C"));
        queue.put((Object)new MyConflatable("A", "D"));
        queue.put((Object)new MyConflatable("B", "E"));
        queue.put((Object)new MyConflatable("A", "F"));
        vm0.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                remoteQueue = SingleWriteSingleReadRegionQueueDUnitTest.this.initQueue(true);
            }
        });
        queue.destroy();
        vm0.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                TestCase.assertEquals((Object)new MyConflatable("C", "C"), (Object)remoteQueue.take());
                TestCase.assertEquals((Object)new MyConflatable("B", "E"), (Object)remoteQueue.take());
                TestCase.assertEquals((Object)new MyConflatable("A", "F"), (Object)remoteQueue.peek());
                remoteQueue.put((Object)new MyConflatable("A", "G"));
                remoteQueue.put((Object)new MyConflatable("A", "H"));
                TestCase.assertEquals((Object)new MyConflatable("A", "F"), (Object)remoteQueue.take());
                TestCase.assertEquals((Object)new MyConflatable("A", "H"), (Object)remoteQueue.take());
                TestCase.assertEquals(null, (Object)remoteQueue.take());
            }
        });
    }

    public void testBoundaryWrapping() {
        SingleWriteSingleReadRegionQueue queue = this.initQueue();
        queue.getRegion().put((Object)new Long(0x7FFFFFFFFFFFFFFDL), (Object)"A");
        queue.put((Object)"B");
        queue.put((Object)"C");
        queue.put((Object)"D");
        queue.put((Object)"E");
        SingleWriteSingleReadRegionQueueDUnitTest.assertEquals((Object)"B", (Object)queue.getRegion().get((Object)new Long(0x7FFFFFFFFFFFFFFEL)));
        SingleWriteSingleReadRegionQueueDUnitTest.assertEquals((Object)"C", (Object)queue.getRegion().get((Object)new Long(0L)));
        SingleWriteSingleReadRegionQueueDUnitTest.assertEquals((Object)"A", (Object)queue.take());
        SingleWriteSingleReadRegionQueueDUnitTest.assertEquals((Object)"B", (Object)queue.take());
        SingleWriteSingleReadRegionQueueDUnitTest.assertEquals((Object)"C", (Object)queue.take());
        SingleWriteSingleReadRegionQueueDUnitTest.assertEquals((Object)"D", (Object)queue.take());
        SingleWriteSingleReadRegionQueueDUnitTest.assertEquals((Object)"E", (Object)queue.take());
        SingleWriteSingleReadRegionQueueDUnitTest.assertEquals(null, (Object)queue.take());
    }

    public void testBoundaryFailover() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        SingleWriteSingleReadRegionQueue queue = this.initQueue();
        queue.getRegion().put((Object)new Long(0x7FFFFFFFFFFFFFFDL), (Object)"A");
        queue.put((Object)"B");
        queue.put((Object)"C");
        queue.put((Object)"D");
        queue.put((Object)"E");
        SingleWriteSingleReadRegionQueueDUnitTest.assertEquals((Object)"B", (Object)queue.getRegion().get((Object)new Long(0x7FFFFFFFFFFFFFFEL)));
        SingleWriteSingleReadRegionQueueDUnitTest.assertEquals((Object)"C", (Object)queue.getRegion().get((Object)new Long(0L)));
        vm0.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                remoteQueue = SingleWriteSingleReadRegionQueueDUnitTest.this.initQueue(true);
            }
        });
        queue.destroy();
        vm0.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                TestCase.assertEquals((Object)"A", (Object)remoteQueue.take());
                TestCase.assertEquals((Object)"B", (Object)remoteQueue.take());
                TestCase.assertEquals((Object)"C", (Object)remoteQueue.take());
                TestCase.assertEquals((Object)"D", (Object)remoteQueue.take());
                TestCase.assertEquals((Object)"E", (Object)remoteQueue.take());
                TestCase.assertEquals(null, (Object)remoteQueue.take());
            }
        });
    }

    private SingleWriteSingleReadRegionQueue initQueue() {
        return this.initQueue(false);
    }

    private SingleWriteSingleReadRegionQueue initQueue(boolean conflate) {
        Cache cache = this.getCache();
        GatewayQueueAttributes queueAttrs = new GatewayQueueAttributes();
        queueAttrs.setBatchConflation(true);
        DiskStoreFactory dsf = cache.createDiskStoreFactory();
        File overflowDir = new File(this.getUniqueName() + InternalDistributedSystem.getAnyInstance().getId());
        if (!overflowDir.exists()) {
            overflowDir.mkdir();
        }
        SingleWriteSingleReadRegionQueueDUnitTest.assertTrue((boolean)overflowDir.isDirectory());
        File[] dirs1 = new File[]{overflowDir.getAbsoluteFile()};
        dsf.setDiskDirs(dirs1).create(this.getUniqueName());
        queueAttrs.setDiskStoreName(this.getUniqueName());
        CacheListenerAdapter listener = new CacheListenerAdapter(){};
        GatewayStats stats = new GatewayStats((StatisticsFactory)cache.getDistributedSystem(), "g1", "h1", null);
        SingleWriteSingleReadRegionQueue queue = new SingleWriteSingleReadRegionQueue(cache, "region", queueAttrs, (CacheListener)listener, stats);
        return queue;
    }

    private static class MyConflatable
    implements Conflatable {
        private final Object conflationKey;
        private final Object value;

        public MyConflatable(Object conflationKey, Object value) {
            this.conflationKey = conflationKey;
            this.value = value;
        }

        public EventID getEventId() {
            return null;
        }

        public Object getKeyToConflate() {
            return this.conflationKey;
        }

        public String getRegionToConflate() {
            return "A";
        }

        public Object getValueToConflate() {
            return this.value;
        }

        public void setLatestValue(Object value) {
            throw new UnsupportedOperationException();
        }

        public boolean shouldBeConflated() {
            return true;
        }

        public boolean shouldBeMerged() {
            return false;
        }

        public boolean merge(Conflatable existing) {
            throw new AssertionError((Object)"not expected to be invoked");
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.conflationKey == null ? 0 : this.conflationKey.hashCode());
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MyConflatable other = (MyConflatable)obj;
            if (this.conflationKey == null ? other.conflationKey != null : !this.conflationKey.equals(other.conflationKey)) {
                return false;
            }
            return !(this.value == null ? other.value != null : !this.value.equals(other.value));
        }

        public String toString() {
            return "MyConflatable(" + this.conflationKey + "," + this.value.toString() + ")";
        }
    }
}

